/*
 * Decompiled with CFR 0.152.
 */
package com.choculaterie.gui;

import com.choculaterie.config.SettingsManager;
import com.choculaterie.gui.ToastManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;

@Environment(value=EnvType.CLIENT)
public class SettingsScreen
extends class_437 {
    private final class_437 parentScreen;
    private final Consumer<Boolean> onSettingsChanged;
    private class_342 pathField;
    private class_342 tokenField;
    private class_342 imagePathField;
    private class_4185 toggleButton;
    private class_4185 browseButton;
    private class_4185 resetButton;
    private class_4185 toggleImagePathButton;
    private class_4185 browseImageButton;
    private class_4185 resetImageButton;
    private final SettingsManager.Settings settings;
    private boolean tokenVisible = false;
    private String actualToken = "";
    private String currentPathFieldText = "";
    private String currentImagePathFieldText = "";
    private String currentTokenFieldText = "";
    private int scrollOffset = 0;
    private final int itemHeight = 25;
    private int scrollAreaX;
    private int scrollAreaY;
    private int scrollAreaWidth;
    private int scrollAreaHeight;
    private int scrollBarX;
    private int scrollBarY;
    private int scrollBarHeight;
    private int totalContentHeight;
    private boolean isScrolling = false;
    private int lastMouseY;

    public SettingsScreen(class_437 parentScreen, Consumer<Boolean> onSettingsChanged) {
        this(parentScreen, onSettingsChanged, false);
    }

    public SettingsScreen(class_437 parentScreen, Consumer<Boolean> onSettingsChanged, boolean showLinkAccountMessage) {
        super((class_2561)class_2561.method_43470((String)"Settings"));
        this.parentScreen = parentScreen;
        this.onSettingsChanged = onSettingsChanged;
        this.settings = SettingsManager.getSettings();
        if (showLinkAccountMessage && !SettingsManager.hasApiToken()) {
            ToastManager.addToast("Please link your account to publish schematics", true);
        }
    }

    protected void method_25426() {
        int baseY;
        this.updateScrollbarDimensions();
        this.saveCurrentTextFieldValues();
        this.method_37067();
        int centerX = this.field_22789 / 2;
        int currentY = baseY = this.scrollAreaY - this.scrollOffset;
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"\u2190"), button -> class_310.method_1551().method_1507(this.parentScreen)).method_46434(10, 10, 20, 20).method_46431());
        this.pathField = new class_342(this.field_22793, centerX - 200, currentY += 20, 400, 20, (class_2561)class_2561.method_43470((String)""));
        this.pathField.method_1880(500);
        if (!this.currentPathFieldText.isEmpty()) {
            this.pathField.method_1852(this.currentPathFieldText);
        } else {
            this.pathField.method_1852(this.settings.useCustomPath ? this.settings.customSchematicsPath : SettingsManager.getDefaultSchematicsPath());
        }
        this.pathField.method_1888(this.settings.useCustomPath);
        this.method_25429((class_364)this.pathField);
        this.toggleButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.settings.useCustomPath ? "Use Custom Path" : "Use Default Path")), button -> {
            this.settings.useCustomPath = !this.settings.useCustomPath;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.settings.useCustomPath ? "Use Custom Path" : "Use Default Path")));
            this.pathField.method_1888(this.settings.useCustomPath);
            if (!this.settings.useCustomPath) {
                this.pathField.method_1852(SettingsManager.getDefaultSchematicsPath());
            }
            this.updateButtonStates();
        }).method_46434(centerX - 100, currentY += 30, 200, 20).method_46431();
        this.method_37063((class_364)this.toggleButton);
        this.browseButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Browse..."), button -> this.openFolderDialog()).method_46434(centerX - 100, currentY += 30, 95, 20).method_46431();
        this.method_37063((class_364)this.browseButton);
        this.resetButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), button -> {
            this.settings.useCustomPath = false;
            this.pathField.method_1852(SettingsManager.getDefaultSchematicsPath());
            this.pathField.method_1888(false);
            this.toggleButton.method_25355((class_2561)class_2561.method_43470((String)"Use Default Path"));
            this.updateButtonStates();
        }).method_46434(centerX + 5, currentY, 95, 20).method_46431();
        this.method_37063((class_364)this.resetButton);
        this.imagePathField = new class_342(this.field_22793, centerX - 200, currentY += 50, 400, 20, (class_2561)class_2561.method_43470((String)""));
        this.imagePathField.method_1880(500);
        if (!this.currentImagePathFieldText.isEmpty()) {
            this.imagePathField.method_1852(this.currentImagePathFieldText);
        } else {
            this.imagePathField.method_1852(this.settings.useCustomImagesPath ? this.settings.customImagesPath : SettingsManager.getDefaultImagesPath());
        }
        this.imagePathField.method_1888(this.settings.useCustomImagesPath);
        this.method_25429((class_364)this.imagePathField);
        this.toggleImagePathButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.settings.useCustomImagesPath ? "Use Custom Image Path" : "Use Default Image Path")), button -> {
            this.settings.useCustomImagesPath = !this.settings.useCustomImagesPath;
            button.method_25355((class_2561)class_2561.method_43470((String)(this.settings.useCustomImagesPath ? "Use Custom Image Path" : "Use Default Image Path")));
            this.imagePathField.method_1888(this.settings.useCustomImagesPath);
            if (!this.settings.useCustomImagesPath) {
                this.imagePathField.method_1852(SettingsManager.getDefaultImagesPath());
            }
            this.updateImageButtonStates();
        }).method_46434(centerX - 100, currentY += 30, 200, 20).method_46431();
        this.method_37063((class_364)this.toggleImagePathButton);
        this.browseImageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Browse..."), button -> this.openImageFolderDialog()).method_46434(centerX - 100, currentY += 30, 95, 20).method_46431();
        this.method_37063((class_364)this.browseImageButton);
        this.resetImageButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), button -> {
            this.settings.useCustomImagesPath = false;
            this.imagePathField.method_1852(SettingsManager.getDefaultImagesPath());
            this.imagePathField.method_1888(false);
            this.toggleImagePathButton.method_25355((class_2561)class_2561.method_43470((String)"Use Default Image Path"));
            this.updateImageButtonStates();
        }).method_46434(centerX + 5, currentY, 95, 20).method_46431();
        this.method_37063((class_364)this.resetImageButton);
        class_4185 linkAccountButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Link Account"), button -> this.openTokenGenerationPage()).method_46434(centerX - 100, currentY += 50, 200, 20).method_46431();
        this.method_37063((class_364)linkAccountButton);
        this.tokenField = new class_342(this.field_22793, centerX - 200, currentY += 40, 340, 20, (class_2561)class_2561.method_43470((String)""));
        this.tokenField.method_1880(500);
        this.actualToken = SettingsManager.getApiToken();
        if (!this.currentTokenFieldText.isEmpty()) {
            if (this.tokenVisible) {
                this.actualToken = this.currentTokenFieldText;
                this.tokenField.method_1852(this.currentTokenFieldText);
            } else {
                this.tokenField.method_1852(this.currentTokenFieldText);
            }
        } else {
            this.updateTokenFieldDisplay();
        }
        this.tokenField.method_1863(text -> {
            this.currentTokenFieldText = text;
            if (this.tokenVisible) {
                this.actualToken = text;
            } else if (!text.equals(this.getMaskedToken(this.actualToken))) {
                this.actualToken = text;
                this.updateTokenFieldDisplay();
            }
        });
        this.method_25429((class_364)this.tokenField);
        class_4185 toggleTokenVisibilityButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"\ud83d\udc41"), button -> {
            this.tokenVisible = !this.tokenVisible;
            this.updateTokenFieldDisplay();
        }).method_46434(centerX + 145, currentY, 25, 20).method_46431();
        this.method_37063((class_364)toggleTokenVisibilityButton);
        class_4185 resetTokenButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Reset"), button -> {
            this.actualToken = "";
            this.updateTokenFieldDisplay();
            this.openTokenGenerationPage();
        }).method_46434(centerX + 175, currentY, 50, 20).method_46431();
        this.method_37063((class_364)resetTokenButton);
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Save"), button -> {
            String path = this.pathField.method_1882().trim();
            if (this.settings.useCustomPath) {
                boolean created;
                if (path.isEmpty()) {
                    ToastManager.addToast("Path cannot be empty when using custom path", true);
                    return;
                }
                File pathFile = new File(path);
                if (!pathFile.exists() && !(created = pathFile.mkdirs())) {
                    ToastManager.addToast("Failed to create directory", true);
                    return;
                }
                if (!pathFile.isDirectory()) {
                    ToastManager.addToast("Invalid directory path", true);
                    return;
                }
                this.settings.customSchematicsPath = path;
            }
            SettingsManager.setApiToken(this.actualToken);
            String imagePath = this.imagePathField.method_1882().trim();
            if (this.settings.useCustomImagesPath) {
                boolean created;
                if (imagePath.isEmpty()) {
                    ToastManager.addToast("Image path cannot be empty when using custom image path", true);
                    return;
                }
                File imagePathFile = new File(imagePath);
                if (!imagePathFile.exists() && !(created = imagePathFile.mkdirs())) {
                    ToastManager.addToast("Failed to create image directory", true);
                    return;
                }
                if (!imagePathFile.isDirectory()) {
                    ToastManager.addToast("Invalid image directory path", true);
                    return;
                }
                this.settings.customImagesPath = imagePath;
            }
            SettingsManager.saveSettings();
            this.onSettingsChanged.accept(true);
            ToastManager.addToast("Settings saved successfully", false);
            class_310.method_1551().method_1507(this.parentScreen);
        }).method_46434(centerX - 100, currentY += 50, 95, 20).method_46431());
        this.method_37063((class_364)class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> class_310.method_1551().method_1507(this.parentScreen)).method_46434(centerX + 5, currentY, 95, 20).method_46431());
        this.totalContentHeight = currentY + 50 - baseY;
        this.updateButtonStates();
        this.updateImageButtonStates();
    }

    private void updateScrollbarDimensions() {
        this.scrollAreaX = 50;
        this.scrollAreaY = 50;
        this.scrollAreaWidth = this.field_22789 - 100;
        this.scrollAreaHeight = this.field_22790 - 100;
        this.totalContentHeight = 400;
        this.scrollOffset = this.totalContentHeight <= this.scrollAreaHeight ? 0 : Math.min(this.scrollOffset, this.totalContentHeight - this.scrollAreaHeight);
    }

    private void updateButtonStates() {
        this.browseButton.field_22763 = this.settings.useCustomPath;
        this.resetButton.field_22763 = this.settings.useCustomPath;
    }

    private void updateImageButtonStates() {
        this.browseImageButton.field_22763 = this.settings.useCustomImagesPath;
        this.resetImageButton.field_22763 = this.settings.useCustomImagesPath;
    }

    private void updateTokenFieldDisplay() {
        if (this.tokenVisible) {
            this.tokenField.method_1852(this.actualToken);
        } else {
            this.tokenField.method_1852(this.getMaskedToken(this.actualToken));
        }
    }

    private String getMaskedToken(String token) {
        if (token == null || token.isEmpty()) {
            return "";
        }
        return "*".repeat(Math.min(token.length(), 32));
    }

    private void openTokenGenerationPage() {
        try {
            String url = "https://choculaterie.com/api/LitematicDownloaderModAPI/GenerateApiToken";
            class_156.method_668().method_673(URI.create(url));
            ToastManager.addToast("Token generation page opened in browser", false);
        }
        catch (Exception e) {
            System.err.println("Failed to open browser: " + e.getMessage());
            ToastManager.addToast("Failed to open browser: " + e.getMessage(), true);
        }
    }

    private void openFolderDialog() {
        try {
            if (this.tryNativeFileChooser()) {
                return;
            }
            ToastManager.addToast("Cannot open file browser in this environment. Please type the path manually.", true);
        }
        catch (Exception e) {
            System.err.println("Failed to open file browser: " + e.getMessage());
            ToastManager.addToast("Failed to open file browser: " + e.getMessage(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryNativeFileChooser() {
        try {
            boolean bl;
            ProcessBuilder pb;
            String os = System.getProperty("os.name").toLowerCase();
            String currentPath = this.pathField.method_1882().trim();
            if (currentPath.isEmpty()) {
                File gameDir = class_310.method_1551().field_1697;
                currentPath = gameDir != null ? gameDir.getAbsolutePath() : SettingsManager.getDefaultSchematicsPath();
            }
            Process process = null;
            if (os.contains("win")) {
                script = String.format("Add-Type -AssemblyName System.Windows.Forms; $f = New-Object System.Windows.Forms.FolderBrowserDialog; $f.Description = 'Select Schematics Folder'; $f.SelectedPath = '%s'; $f.ShowNewFolderButton = $true; if ($f.ShowDialog() -eq 'OK') { Write-Output $f.SelectedPath }", currentPath.replace("'", "''"));
                pb = new ProcessBuilder("powershell.exe", "-Command", script);
            } else if (os.contains("mac") || os.contains("darwin")) {
                script = String.format("choose folder with prompt \"Select Schematics Folder\" default location POSIX file \"%s\"", currentPath.replace("\"", "\\\""));
                pb = new ProcessBuilder("osascript", "-e", script);
            } else {
                String tool;
                if (!os.contains("nix")) {
                    if (!os.contains("nux")) return false;
                }
                String[] tools = new String[]{"zenity", "kdialog", "yad"};
                pb = null;
                String[] stringArray = tools;
                boolean bl2 = stringArray.length;
                for (bl = false; !(bl >= bl2 || this.isCommandAvailable(tool = stringArray[bl]) && (pb = this.createLinuxDialog(tool, currentPath)) != null); bl += 1) {
                }
                if (pb == null) {
                    return false;
                }
            }
            try {
                process = pb.start();
                boolean finished = process.waitFor(30L, TimeUnit.SECONDS);
                if (!finished) {
                    process.destroyForcibly();
                    boolean bl3 = false;
                    return bl3;
                }
                String selectedPath = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    selectedPath = reader.readLine();
                }
                int exitCode = process.exitValue();
                if (exitCode == 0 && selectedPath != null && !selectedPath.trim().isEmpty()) {
                    if (os.contains("mac") && selectedPath.startsWith("alias ")) {
                        selectedPath = selectedPath.substring(6);
                    }
                    this.pathField.method_1852(selectedPath.trim());
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            finally {
                if (process != null && process.isAlive()) {
                    try {
                        process.destroyForcibly();
                        process.waitFor(5L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        System.err.println("Error cleaning up file dialog process: " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Native file chooser error: " + e.getMessage());
            return false;
        }
    }

    private ProcessBuilder createLinuxDialog(String tool, String currentPath) {
        return switch (tool) {
            case "zenity" -> new ProcessBuilder("zenity", "--file-selection", "--directory", "--title=Select Schematics Folder", "--filename=" + currentPath);
            case "kdialog" -> new ProcessBuilder("kdialog", "--getexistingdirectory", currentPath, "--title", "Select Schematics Folder");
            case "yad" -> new ProcessBuilder("yad", "--file", "--directory", "--title=Select Schematics Folder", "--filename=" + currentPath);
            default -> null;
        };
    }

    private void openImageFolderDialog() {
        try {
            if (this.tryNativeImageFileChooser()) {
                return;
            }
            ToastManager.addToast("Cannot open file browser in this environment. Please type the path manually.", true);
        }
        catch (Exception e) {
            System.err.println("Failed to open file browser: " + e.getMessage());
            ToastManager.addToast("Failed to open file browser: " + e.getMessage(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean tryNativeImageFileChooser() {
        try {
            boolean bl;
            ProcessBuilder pb;
            String os = System.getProperty("os.name").toLowerCase();
            String currentPath = this.imagePathField.method_1882().trim();
            if (currentPath.isEmpty()) {
                currentPath = SettingsManager.getDefaultImagesPath();
            }
            Process process = null;
            if (os.contains("win")) {
                script = String.format("Add-Type -AssemblyName System.Windows.Forms; $f = New-Object System.Windows.Forms.FolderBrowserDialog; $f.Description = 'Select Images Folder'; $f.SelectedPath = '%s'; $f.ShowNewFolderButton = $true; if ($f.ShowDialog() -eq 'OK') { Write-Output $f.SelectedPath }", currentPath.replace("'", "''"));
                pb = new ProcessBuilder("powershell.exe", "-Command", script);
            } else if (os.contains("mac") || os.contains("darwin")) {
                script = String.format("choose folder with prompt \"Select Images Folder\" default location POSIX file \"%s\"", currentPath.replace("\"", "\\\""));
                pb = new ProcessBuilder("osascript", "-e", script);
            } else {
                String tool;
                if (!os.contains("nix")) {
                    if (!os.contains("nux")) return false;
                }
                String[] tools = new String[]{"zenity", "kdialog", "yad"};
                pb = null;
                String[] stringArray = tools;
                boolean bl2 = stringArray.length;
                for (bl = false; !(bl >= bl2 || this.isCommandAvailable(tool = stringArray[bl]) && (pb = this.createLinuxImageDialog(tool, currentPath)) != null); bl += 1) {
                }
                if (pb == null) {
                    return false;
                }
            }
            try {
                process = pb.start();
                boolean finished = process.waitFor(30L, TimeUnit.SECONDS);
                if (!finished) {
                    process.destroyForcibly();
                    boolean bl3 = false;
                    return bl3;
                }
                String selectedPath = null;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                    selectedPath = reader.readLine();
                }
                int exitCode = process.exitValue();
                if (exitCode == 0 && selectedPath != null && !selectedPath.trim().isEmpty()) {
                    if (os.contains("mac") && selectedPath.startsWith("alias ")) {
                        selectedPath = selectedPath.substring(6);
                    }
                    this.imagePathField.method_1852(selectedPath.trim());
                    bl = true;
                    return bl;
                }
                bl = false;
                return bl;
            }
            finally {
                if (process != null && process.isAlive()) {
                    try {
                        process.destroyForcibly();
                        process.waitFor(5L, TimeUnit.SECONDS);
                    }
                    catch (Exception e) {
                        System.err.println("Error cleaning up file dialog process: " + e.getMessage());
                    }
                }
            }
        }
        catch (Exception e) {
            System.err.println("Native image file chooser error: " + e.getMessage());
            return false;
        }
    }

    private ProcessBuilder createLinuxImageDialog(String tool, String currentPath) {
        return switch (tool) {
            case "zenity" -> new ProcessBuilder("zenity", "--file-selection", "--directory", "--title=Select Images Folder", "--filename=" + currentPath);
            case "kdialog" -> new ProcessBuilder("kdialog", "--getexistingdirectory", currentPath, "--title", "Select Images Folder");
            case "yad" -> new ProcessBuilder("yad", "--file", "--directory", "--title=Select Images Folder", "--filename=" + currentPath);
            default -> null;
        };
    }

    private boolean isCommandAvailable(String command) {
        try {
            ProcessBuilder pb = new ProcessBuilder("which", command);
            Process process = pb.start();
            return process.waitFor() == 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        int baseY;
        super.method_25394(context, mouseX, mouseY, delta);
        context.method_44379(this.scrollAreaX, this.scrollAreaY, this.scrollAreaX + this.scrollAreaWidth, this.scrollAreaY + this.scrollAreaHeight);
        int centerX = this.field_22789 / 2;
        int currentY = baseY = this.scrollAreaY - this.scrollOffset;
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Litematic Path"), centerX, currentY += 10, -256);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"Image Path"), centerX, currentY += 110, -256);
        context.method_27534(this.field_22793, (class_2561)class_2561.method_43470((String)"API Token"), centerX, currentY += 150, -256);
        context.method_44380();
        if (this.totalContentHeight > this.scrollAreaHeight) {
            int scrollBarWidth = 6;
            this.scrollBarHeight = Math.max(20, this.scrollAreaHeight * this.scrollAreaHeight / this.totalContentHeight);
            this.scrollBarX = this.scrollAreaX + this.scrollAreaWidth;
            this.scrollBarY = this.scrollAreaY + (int)((float)this.scrollOffset / (float)(this.totalContentHeight - this.scrollAreaHeight) * (float)(this.scrollAreaHeight - this.scrollBarHeight));
            context.method_25294(this.scrollBarX, this.scrollAreaY, this.scrollBarX + scrollBarWidth, this.scrollAreaY + this.scrollAreaHeight, 0x33FFFFFF);
            boolean isHovering = mouseX >= this.scrollBarX && mouseX <= this.scrollBarX + scrollBarWidth && mouseY >= this.scrollBarY && mouseY <= this.scrollBarY + this.scrollBarHeight;
            int scrollBarColor = isHovering || this.isScrolling ? -1 : -1426063361;
            context.method_25294(this.scrollBarX, this.scrollBarY, this.scrollBarX + scrollBarWidth, this.scrollBarY + this.scrollBarHeight, scrollBarColor);
        }
        this.pathField.method_25394(context, mouseX, mouseY, delta);
        this.imagePathField.method_25394(context, mouseX, mouseY, delta);
        this.tokenField.method_25394(context, mouseX, mouseY, delta);
        ToastManager.render(context, this.field_22789);
    }

    public boolean method_25402(class_11909 click, boolean doubled) {
        double mouseX = click.comp_4798();
        double mouseY = click.comp_4799();
        int button = click.method_74245();
        if (button == 0 && this.totalContentHeight > this.scrollAreaHeight) {
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollBarY && mouseY <= (double)(this.scrollBarY + this.scrollBarHeight)) {
                this.isScrolling = true;
                this.lastMouseY = (int)mouseY;
                return true;
            }
            if (mouseX >= (double)this.scrollBarX && mouseX <= (double)(this.scrollBarX + 6) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight)) {
                float clickPercent = ((float)mouseY - (float)this.scrollAreaY) / (float)this.scrollAreaHeight;
                this.scrollOffset = (int)(clickPercent * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset));
                this.method_25426();
                return true;
            }
        }
        return super.method_25402(click, doubled);
    }

    public boolean method_25403(class_11909 click, double offsetX, double offsetY) {
        double mouseY = click.comp_4799();
        if (this.isScrolling) {
            int currentMouseY = (int)mouseY;
            if (currentMouseY != this.lastMouseY) {
                float denom = Math.max(1, this.scrollAreaHeight - this.scrollBarHeight);
                float dragPercentage = (float)(currentMouseY - this.lastMouseY) / denom;
                int scrollAmount = (int)(dragPercentage * (float)(this.totalContentHeight - this.scrollAreaHeight));
                this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset + scrollAmount));
                this.lastMouseY = currentMouseY;
                this.method_25426();
            }
            return true;
        }
        return super.method_25403(click, offsetX, offsetY);
    }

    public boolean method_25406(class_11909 click) {
        if (click.method_74245() == 0 && this.isScrolling) {
            this.isScrolling = false;
            return true;
        }
        return super.method_25406(click);
    }

    public boolean method_25401(double mouseX, double mouseY, double horizontalAmount, double verticalAmount) {
        if (mouseX >= (double)this.scrollAreaX && mouseX <= (double)(this.scrollAreaX + this.scrollAreaWidth) && mouseY >= (double)this.scrollAreaY && mouseY <= (double)(this.scrollAreaY + this.scrollAreaHeight) && this.totalContentHeight > this.scrollAreaHeight) {
            int scrollAmount = (int)(verticalAmount * 3.0 * 25.0);
            this.scrollOffset = Math.max(0, Math.min(this.totalContentHeight - this.scrollAreaHeight, this.scrollOffset - scrollAmount));
            this.method_25426();
            return true;
        }
        return super.method_25401(mouseX, mouseY, horizontalAmount, verticalAmount);
    }

    private void saveCurrentTextFieldValues() {
        if (this.pathField != null) {
            this.currentPathFieldText = this.pathField.method_1882();
        }
        if (this.imagePathField != null) {
            this.currentImagePathFieldText = this.imagePathField.method_1882();
        }
        if (this.tokenField != null) {
            this.currentTokenFieldText = this.tokenField.method_1882();
        }
    }
}

