/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.UI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.network.PacketMountListRequest;
import fr.mod.epicka.network.PacketMountListResponse;
import fr.mod.epicka.network.PacketUiMountRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class UIMenu
extends Screen {
    private static final int MIN_BUTTON_WIDTH = 60;
    private static final int MIN_BUTTON_HEIGHT = 20;
    private static final int MIN_SLOT_HEIGHT = 60;
    private static final int SLOT_GAP = 8;
    private static final int MAX_SLOT_WIDTH = 400;
    private static ResourceLocation BACKGROUND_TEXTURE = null;
    private static ResourceLocation CLOSE_BUTTON_TEXTURE = null;
    private static ResourceLocation CLOSE_BUTTON_TEXTURE_HOVERED = null;
    private final List<PacketMountListResponse.MountInfo> originalMountInfos = new ArrayList<PacketMountListResponse.MountInfo>();
    private final List<PacketMountListResponse.MountInfo> displayedMountInfos = new ArrayList<PacketMountListResponse.MountInfo>();
    private final Map<String, Entity> entityCache = new HashMap<String, Entity>();
    private final List<AbstractWidget> mountWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> filterWidgets = new ArrayList<AbstractWidget>();
    private AbstractWidget filterButton;
    private Button filterGroundButton;
    private Button filterAquaticButton;
    private Button filterFlyingButton;
    private Button sortButton;
    private int scrollOffset = 0;
    private int buttonWidth;
    private int buttonHeight;
    private int slotWidth;
    private int slotHeight;
    private int visibleSlots;
    private int filterPanelX;
    private int filterPanelY;
    private int filterPanelWidth;
    private int filterPanelHeight;
    private boolean showFilterMenu = false;
    private boolean filterGround = true;
    private boolean filterAquatic = true;
    private boolean filterFlying = true;
    private SortType sortType = SortType.BY_NAME;
    private float targetRotY = 0.0f;
    private float currentRotY = 0.0f;
    private float targetRotX = 0.0f;
    private float currentRotX = 0.0f;

    public UIMenu() {
        super((Component)Component.m_237119_());
        BACKGROUND_TEXTURE = ResourceLocation.m_135820_((String)Config.setGuiMenuTextureBackground);
        CLOSE_BUTTON_TEXTURE = ResourceLocation.m_135820_((String)Config.setGuiMenuTextureCloseButton);
        CLOSE_BUTTON_TEXTURE_HOVERED = ResourceLocation.m_135820_((String)Config.setGuiMenuTextureCloseButtonHovered);
    }

    public void drawEntityOnScreen(GuiGraphics guiGraphics, int x, int y, int scale, float mouseX, float mouseY, Entity entity) {
        if (entity == null) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        this.targetRotY = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        this.targetRotX = (float)Math.atan(mouseY / 40.0f) * 20.0f;
        this.currentRotY += (this.targetRotY - this.currentRotY) * 0.1f;
        this.currentRotX += (this.targetRotX - this.currentRotX) * 0.1f;
        PoseStack pose = guiGraphics.m_280168_();
        pose.m_85836_();
        pose.m_252880_((float)x, (float)y, 100.0f);
        pose.m_85841_((float)scale, (float)scale, (float)scale);
        pose.m_252781_(Axis.f_252403_.m_252977_(180.0f));
        entity.m_146922_(this.currentRotY);
        entity.m_146926_(this.currentRotX);
        EntityRenderDispatcher disp = mc.m_91290_();
        disp.m_114468_(false);
        MultiBufferSource.BufferSource buf = mc.m_91269_().m_110104_();
        disp.m_114384_(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pose, (MultiBufferSource)buf, 0xF000F0);
        buf.m_109911_();
        pose.m_85849_();
        disp.m_114468_(true);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.originalMountInfos.clear();
        this.displayedMountInfos.clear();
        this.entityCache.clear();
        this.mountWidgets.clear();
        this.filterWidgets.clear();
        this.scrollOffset = 0;
        this.showFilterMenu = false;
        this.calculateLayout();
        this.createStaticWidgets();
        if (Config.guiShowFilterButton) {
            this.createFilterWidgets();
        }
        PacketMountListRequest.send();
    }

    private void calculateLayout() {
        this.slotWidth = Math.min((int)((double)this.f_96543_ * 0.6), 400);
        this.buttonWidth = Math.max(60, (int)((double)this.slotWidth * 0.25));
        this.buttonHeight = 20;
        this.slotHeight = 60;
        int startY = 40;
        int availableHeight = this.f_96544_ - startY - 100;
        int slotFullHeight = this.slotHeight + 8;
        this.visibleSlots = Math.max(3, availableHeight / slotFullHeight);
    }

    public void onReceiveMountList(List<PacketMountListResponse.MountInfo> infos) {
        this.originalMountInfos.clear();
        this.originalMountInfos.addAll(infos);
        this.entityCache.clear();
        this.applyFiltersAndSort();
    }

    private void applyFiltersAndSort() {
        Stream<Object> stream = Config.guiShowFilterButton ? this.originalMountInfos.stream().filter(info -> {
            String type;
            String string = type = info.mountType() != null ? info.mountType().toUpperCase() : "GROUND";
            if (this.filterGround && "GROUND".equals(type)) {
                return true;
            }
            if (this.filterAquatic && "AQUATIC".equals(type)) {
                return true;
            }
            if (this.filterFlying && "FLYING".equals(type)) {
                return true;
            }
            return !type.equals("GROUND") && !type.equals("AQUATIC") && !type.equals("FLYING");
        }) : this.originalMountInfos.stream();
        stream = !Config.guiShowFilterButton || this.sortType == SortType.BY_NAME ? stream.sorted(Comparator.comparing(PacketMountListResponse.MountInfo::customName)) : stream.sorted(Comparator.comparingDouble(PacketMountListResponse.MountInfo::speedModifier).reversed());
        this.displayedMountInfos.clear();
        stream.forEach(this.displayedMountInfos::add);
        this.clearMountWidgets();
        this.createMountWidgets();
        this.scrollOffset = 0;
        this.updateMountWidgetPositions();
    }

    private void createStaticWidgets() {
        int closeButtonSize = 20;
        int closeX = this.f_96543_ - closeButtonSize - Config.guiCloseButtonXOffsetRight;
        int closeY = Config.guiCloseButtonYOffsetTop;
        this.m_142416_((GuiEventListener)new AbstractButton(closeX, closeY, closeButtonSize, closeButtonSize, (Component)Component.m_237119_()){

            public void m_5691_() {
                if (UIMenu.this.f_96541_ != null) {
                    UIMenu.this.f_96541_.m_91152_(null);
                }
            }

            protected void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                ResourceLocation texture;
                RenderSystem.enableBlend();
                ResourceLocation resourceLocation = texture = this.m_198029_() ? CLOSE_BUTTON_TEXTURE_HOVERED : CLOSE_BUTTON_TEXTURE;
                if (texture == null) {
                    texture = CLOSE_BUTTON_TEXTURE;
                }
                if (texture != null) {
                    pGuiGraphics.m_280163_(texture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
                }
                RenderSystem.disableBlend();
            }

            protected void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
                this.m_168802_(pNarrationElementOutput);
            }
        });
        if (Config.guiShowFilterButton) {
            int filterButtonWidth = 100;
            int filterButtonHeight = 20;
            int filterButtonX = Config.guiFilterButtonX == -1 ? (this.f_96543_ - filterButtonWidth) / 2 : Config.guiFilterButtonX;
            int filterButtonY = Config.guiFilterButtonY;
            MutableComponent msg = Component.m_237113_((String)Config.guiFilterButtonText);
            Button.OnPress onFilterPress = btn -> {
                this.showFilterMenu = !this.showFilterMenu;
                this.updateFilterWidgetsVisibility();
            };
            this.filterButton = Config.enableGuiCustomFilterButton ? new ImageButton(filterButtonX, filterButtonY, filterButtonWidth, filterButtonHeight, (Component)msg, Config.enableTextOnCustomButtons, ResourceLocation.m_135820_((String)Config.guiFilterButtonTextureNormal), ResourceLocation.m_135820_((String)Config.guiFilterButtonTextureHovered), ResourceLocation.m_135820_((String)Config.guiFilterButtonTextureClicked), onFilterPress) : Button.m_253074_((Component)msg, (Button.OnPress)onFilterPress).m_252987_(filterButtonX, filterButtonY, filterButtonWidth, filterButtonHeight).m_253136_();
            this.m_142416_((GuiEventListener)this.filterButton);
        }
    }

    private void createFilterWidgets() {
        int filterWidgetWidth = 100;
        int filterWidgetHeight = 20;
        this.filterPanelX = this.filterButton.m_252754_();
        int currentY = this.filterPanelY = this.filterButton.m_252907_() + this.filterButton.m_93694_() + 2;
        MutableComponent groundMsg = Component.m_237113_((String)"Ground: ON");
        Button.OnPress groundPress = btn -> {
            this.filterGround = !this.filterGround;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.filterGroundButton = Config.enableGuiCustomFilterSubButton ? new ImageButton(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight, (Component)groundMsg, true, ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureNormal), ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureHovered), ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureClicked), groundPress) : Button.m_253074_((Component)groundMsg, (Button.OnPress)groundPress).m_252987_(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight).m_253136_();
        this.filterWidgets.add((AbstractWidget)this.filterGroundButton);
        MutableComponent aquaticMsg = Component.m_237113_((String)"Aquatic: ON");
        Button.OnPress aquaticPress = btn -> {
            this.filterAquatic = !this.filterAquatic;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.filterAquaticButton = Config.enableGuiCustomFilterSubButton ? new ImageButton(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight, (Component)aquaticMsg, true, ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureNormal), ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureHovered), ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureClicked), aquaticPress) : Button.m_253074_((Component)aquaticMsg, (Button.OnPress)aquaticPress).m_252987_(this.filterPanelX, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight).m_253136_();
        this.filterWidgets.add((AbstractWidget)this.filterAquaticButton);
        MutableComponent flyingMsg = Component.m_237113_((String)"Flying: ON");
        Button.OnPress flyingPress = btn -> {
            this.filterFlying = !this.filterFlying;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.filterFlyingButton = Config.enableGuiCustomFilterSubButton ? new ImageButton(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight, (Component)flyingMsg, true, ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureNormal), ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureHovered), ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureClicked), flyingPress) : Button.m_253074_((Component)flyingMsg, (Button.OnPress)flyingPress).m_252987_(this.filterPanelX, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight).m_253136_();
        this.filterWidgets.add((AbstractWidget)this.filterFlyingButton);
        MutableComponent sortMsg = Component.m_237113_((String)"Sort: Name");
        Button.OnPress sortPress = btn -> {
            this.sortType = this.sortType == SortType.BY_NAME ? SortType.BY_SPEED : SortType.BY_NAME;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.sortButton = Config.enableGuiCustomFilterSubButton ? new ImageButton(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight, (Component)sortMsg, true, ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureNormal), ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureHovered), ResourceLocation.m_135820_((String)Config.guiFilterSubButtonTextureClicked), sortPress) : Button.m_253074_((Component)sortMsg, (Button.OnPress)sortPress).m_252987_(this.filterPanelX, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight).m_253136_();
        this.filterWidgets.add((AbstractWidget)this.sortButton);
        this.filterPanelWidth = filterWidgetWidth;
        this.filterPanelHeight = currentY + filterWidgetHeight - this.filterPanelY;
        this.filterWidgets.forEach(w -> {
            w.f_93624_ = false;
            this.m_142416_((GuiEventListener)w);
        });
    }

    private void updateFilterWidgetsVisibility() {
        if (!Config.guiShowFilterButton) {
            return;
        }
        this.filterWidgets.forEach(w -> {
            w.f_93624_ = this.showFilterMenu;
        });
    }

    private void updateFilterButtonText() {
        if (!Config.guiShowFilterButton) {
            return;
        }
        this.filterGroundButton.m_93666_((Component)Component.m_237113_((String)("Ground: " + (this.filterGround ? "ON" : "OFF"))));
        this.filterAquaticButton.m_93666_((Component)Component.m_237113_((String)("Aquatic: " + (this.filterAquatic ? "ON" : "OFF"))));
        this.filterFlyingButton.m_93666_((Component)Component.m_237113_((String)("Flying: " + (this.filterFlying ? "ON" : "OFF"))));
        this.sortButton.m_93666_((Component)Component.m_237113_((String)("Sort: " + (this.sortType == SortType.BY_NAME ? "Name" : "Speed"))));
    }

    private void clearMountWidgets() {
        this.f_169369_.removeAll(this.mountWidgets);
        this.m_6702_().removeAll(this.mountWidgets);
        this.mountWidgets.clear();
    }

    private void createMountWidgets() {
        for (PacketMountListResponse.MountInfo info : this.displayedMountInfos) {
            Button.OnPress onPress = btn -> {
                PacketUiMountRequest.send(info.customName());
                Minecraft.m_91087_().m_91152_(null);
            };
            MutableComponent rideMsg = Component.m_237113_((String)Config.guiRideButtonText).m_130948_(Style.f_131099_.m_178520_(Config.guiRideButtonTextColor));
            Button button = Config.enableGuiCustomRideButton ? new ImageButton(0, 0, this.buttonWidth, this.buttonHeight, (Component)rideMsg, Config.enableTextOnCustomButtons, ResourceLocation.m_135820_((String)Config.guiRideButtonTextureNormal), ResourceLocation.m_135820_((String)Config.guiRideButtonTextureHovered), ResourceLocation.m_135820_((String)Config.guiRideButtonTextureClicked), onPress) : Button.m_253074_((Component)rideMsg, (Button.OnPress)onPress).m_252987_(0, 0, this.buttonWidth, this.buttonHeight).m_253136_();
            button.f_93624_ = false;
            this.m_142416_((GuiEventListener)button);
            this.mountWidgets.add((AbstractWidget)button);
        }
    }

    private void updateMountWidgetPositions() {
        int startX = (this.f_96543_ - this.slotWidth) / 2;
        int startY = 40;
        for (int i = 0; i < this.mountWidgets.size(); ++i) {
            AbstractWidget widget = this.mountWidgets.get(i);
            int slotIndex = i - this.scrollOffset;
            if (slotIndex >= 0 && slotIndex < this.visibleSlots) {
                widget.m_252865_(startX + this.slotWidth - this.buttonWidth);
                widget.m_253211_(startY + slotIndex * (this.slotHeight + 8) + (this.slotHeight - this.buttonHeight) / 2);
                widget.f_93624_ = true;
                continue;
            }
            widget.f_93624_ = false;
        }
    }

    public boolean m_6050_(double pMouseX, double pMouseY, double pDelta) {
        if (Config.guiShowFilterButton && this.showFilterMenu) {
            return false;
        }
        int maxScroll = Math.max(0, this.displayedMountInfos.size() - this.visibleSlots);
        if (pDelta < 0.0 && this.scrollOffset < maxScroll) {
            ++this.scrollOffset;
            this.updateMountWidgetPositions();
        } else if (pDelta > 0.0 && this.scrollOffset > 0) {
            --this.scrollOffset;
            this.updateMountWidgetPositions();
        }
        return true;
    }

    public boolean m_6375_(double pMouseX, double pMouseY, int pButton) {
        if (super.m_6375_(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (Config.guiShowFilterButton && this.showFilterMenu && (pMouseX < (double)this.filterPanelX || pMouseX > (double)(this.filterPanelX + this.filterPanelWidth) || pMouseY < (double)this.filterPanelY || pMouseY > (double)(this.filterPanelY + this.filterPanelHeight))) {
            this.showFilterMenu = false;
            this.updateFilterWidgetsVisibility();
            return true;
        }
        return false;
    }

    public void m_280273_(@NotNull GuiGraphics gui) {
        if (BACKGROUND_TEXTURE != null) {
            gui.m_280163_(BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, this.f_96543_, this.f_96544_, this.f_96543_, this.f_96544_);
        } else {
            super.m_280273_(gui);
        }
    }

    private Entity getOrCreateCachedEntity(PacketMountListResponse.MountInfo info) {
        Entity cachedEntity = this.entityCache.get(info.customName());
        if (cachedEntity != null) {
            return cachedEntity;
        }
        if (this.f_96541_ == null || this.f_96541_.f_91073_ == null) {
            return null;
        }
        EntityType type = EntityType.m_20632_((String)info.entityId()).orElse(null);
        if (type != null) {
            Entity e = type.m_20615_((Level)this.f_96541_.f_91073_);
            if (e != null) {
                if (info.nbtData() != null && !info.nbtData().isEmpty()) {
                    try {
                        CompoundTag tag = TagParser.m_129359_((String)info.nbtData());
                        e.m_20258_(tag);
                    }
                    catch (Exception ex) {
                        Epicka.LOGGER.error("Failed to parse NBT for client entity {}", (Object)info.customName(), (Object)ex);
                    }
                }
                e.m_6034_(0.0, 0.0, 0.0);
            }
            this.entityCache.put(info.customName(), e);
            return e;
        }
        this.entityCache.put(info.customName(), null);
        return null;
    }

    public void m_88315_(@NotNull GuiGraphics gui, int mouseX, int mouseY, float pt) {
        int idx;
        this.m_280273_(gui);
        int startX = (this.f_96543_ - this.slotWidth) / 2;
        int startY = 40;
        for (int i = 0; i < this.visibleSlots && (idx = this.scrollOffset + i) < this.displayedMountInfos.size(); ++i) {
            String description;
            PacketMountListResponse.MountInfo info = this.displayedMountInfos.get(idx);
            int y = startY + i * (this.slotHeight + 8);
            gui.m_280509_(startX, y, startX + this.slotWidth, y + this.slotHeight, Config.guiSlotBackgroundColor);
            Entity entityToRender = this.getOrCreateCachedEntity(info);
            int entityScale = this.slotHeight / 3;
            float relativeMouseX = mouseX - (startX + 40);
            float relativeMouseY = (float)mouseY - ((float)y + (float)this.slotHeight / 2.0f + 5.0f);
            this.drawEntityOnScreen(gui, startX + 40, y + this.slotHeight / 2 + 5, entityScale, relativeMouseX, relativeMouseY, entityToRender);
            MutableComponent nameComponent = Component.m_237113_((String)info.customName());
            gui.m_280430_(this.f_96547_, (Component)nameComponent, startX + 80, y + 10, Config.guiMountNameTextColor);
            if (Config.guiShowMountType) {
                int nameWidth = this.f_96547_.m_92852_((FormattedText)nameComponent);
                String typeString = info.mountType() != null ? info.mountType().toUpperCase() : "GROUND";
                MutableComponent typeComponent = Component.m_237113_((String)(" [" + typeString + "]"));
                int color = Config.guiMountNameTextColor;
                color = switch (typeString) {
                    case "GROUND" -> Config.guiMountTypeGroundTextColor;
                    case "AQUATIC" -> Config.guiMountTypeAquaticTextColor;
                    case "FLYING" -> Config.guiMountTypeFlyingTextColor;
                    default -> color;
                };
                gui.m_280430_(this.f_96547_, (Component)typeComponent, startX + 80 + nameWidth, y + 10, color);
            }
            int textY = y + 22;
            int maxTextWidth = this.slotWidth - 80 - this.buttonWidth - 10;
            if (Config.guiShowMountSpeed) {
                String speedText = String.format("Speed: %.2f", info.speedModifier());
                gui.m_280488_(this.f_96547_, speedText, startX + 80, textY, Config.guiSpeedTextColor);
                textY += 12;
            }
            if ((description = info.description()) != null && !description.isEmpty()) {
                Object truncatedDesc = this.f_96547_.m_92834_(description, maxTextWidth);
                if (!((String)truncatedDesc).equals(description)) {
                    truncatedDesc = ((String)truncatedDesc).substring(0, Math.max(0, ((String)truncatedDesc).length() - 3)) + "...";
                }
                gui.m_280488_(this.f_96547_, (String)truncatedDesc, startX + 80, textY, Config.guiDescriptionTextColor);
                textY += 12;
            }
            String costItem = info.costItem();
            int costAmount = info.costAmount();
            if (costItem == null || costItem.isEmpty() || costAmount <= 0) continue;
            Optional item = BuiltInRegistries.f_257033_.m_6612_(ResourceLocation.m_135820_((String)costItem));
            String itemName = item.map(it -> it.m_41466_().getString()).orElse(costItem);
            String costText = String.format("Cost: %dx %s", costAmount, itemName);
            Object truncatedCost = this.f_96547_.m_92834_(costText, maxTextWidth);
            if (!((String)truncatedCost).equals(costText)) {
                truncatedCost = ((String)truncatedCost).substring(0, Math.max(0, ((String)truncatedCost).length() - 3)) + "...";
            }
            gui.m_280488_(this.f_96547_, (String)truncatedCost, startX + 80, textY, Config.guiCostTextColor);
        }
        if (this.displayedMountInfos.size() > this.visibleSlots) {
            int barX = startX + this.slotWidth + 4;
            int barHeight = this.visibleSlots * (this.slotHeight + 8) - 8;
            gui.m_280509_(barX, startY, barX + 6, startY + barHeight, -14671840);
            int cursorHeight = Math.max(barHeight * this.visibleSlots / this.displayedMountInfos.size(), 10);
            int maxOffset = this.displayedMountInfos.size() - this.visibleSlots;
            int cursorY = startY;
            if (maxOffset > 0) {
                cursorY = startY + (barHeight - cursorHeight) * this.scrollOffset / maxOffset;
            }
            gui.m_280509_(barX, cursorY, barX + 6, cursorY + cursorHeight, Config.guiScrollbarColor);
        }
        for (Renderable renderable : this.f_169369_) {
            if (this.filterWidgets.contains(renderable)) continue;
            renderable.m_88315_(gui, mouseX, mouseY, pt);
        }
        if (Config.guiShowFilterButton && this.showFilterMenu) {
            gui.m_280509_(this.filterPanelX, this.filterPanelY, this.filterPanelX + this.filterPanelWidth, this.filterPanelY + this.filterPanelHeight, Config.guiFilterPanelColor);
            for (AbstractWidget widget : this.filterWidgets) {
                widget.m_88315_(gui, mouseX, mouseY, pt);
            }
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6574_(@NotNull Minecraft mc, int width, int height) {
        super.m_6574_(mc, width, height);
    }

    private static enum SortType {
        BY_NAME,
        BY_SPEED;

    }

    private static class ImageButton
    extends Button {
        private final ResourceLocation textureNormal;
        private final ResourceLocation textureHovered;
        private final ResourceLocation textureClicked;
        private final boolean showText;
        private boolean isPressed;

        public ImageButton(int x, int y, int width, int height, Component message, boolean showText, ResourceLocation textureNormal, ResourceLocation textureHovered, ResourceLocation textureClicked, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, f_252438_);
            this.textureNormal = textureNormal;
            this.textureHovered = textureHovered;
            this.textureClicked = textureClicked;
            this.isPressed = false;
            this.showText = showText;
        }

        public void m_5716_(double pMouseX, double pMouseY) {
            this.isPressed = true;
            super.m_5716_(pMouseX, pMouseY);
        }

        public void m_7691_(double pMouseX, double pMouseY) {
            super.m_7691_(pMouseX, pMouseY);
            this.isPressed = false;
        }

        protected void m_7212_(double pMouseX, double pMouseY, double pDragX, double pDragY) {
            if (!this.f_93622_) {
                this.isPressed = false;
            }
            super.m_7212_(pMouseX, pMouseY, pDragX, pDragY);
        }

        protected void m_87963_(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            ResourceLocation texture = this.isPressed && this.m_198029_() ? this.textureClicked : (this.m_198029_() ? this.textureHovered : this.textureNormal);
            if (texture == null) {
                return;
            }
            RenderSystem.enableBlend();
            pGuiGraphics.m_280163_(texture, this.m_252754_(), this.m_252907_(), 0.0f, 0.0f, this.f_93618_, this.f_93619_, this.f_93618_, this.f_93619_);
            RenderSystem.disableBlend();
            if (this.showText) {
                int j = this.getFGColor();
                pGuiGraphics.m_280653_(Minecraft.m_91087_().f_91062_, this.m_6035_(), this.m_252754_() + this.f_93618_ / 2, this.m_252907_() + (this.f_93619_ - 8) / 2, j | (int)(this.f_93625_ * 255.0f) << 24);
            }
        }

        public void m_168797_(@NotNull NarrationElementOutput pNarrationElementOutput) {
            this.m_168802_(pNarrationElementOutput);
        }
    }
}

