/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.entity;

import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="epicka", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class MountController {
    public static final Map<UUID, Entity> controlledMounts = new ConcurrentHashMap<UUID, Entity>();
    public static final Set<UUID> jumpRequests = ConcurrentHashMap.newKeySet();
    public static final Set<UUID> swimRequests = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Long> summonCooldowns = new ConcurrentHashMap<UUID, Long>();

    public static void handleControlPacket(UUID playerId, boolean jump, boolean swim) {
        if (jump) {
            jumpRequests.add(playerId);
        }
        if (swim) {
            swimRequests.add(playerId);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            if (event.player.m_9236_().m_5776_()) {
                return;
            }
            ServerPlayer player = (ServerPlayer)event.player;
            UUID playerUUID = player.m_20148_();
            Entity mount = controlledMounts.get(playerUUID);
            if (mount == null) {
                return;
            }
            if (!(mount instanceof LivingEntity)) {
                MountController.cleanupMount(playerUUID, mount);
                return;
            }
            LivingEntity livingMount = (LivingEntity)mount;
            if (player.m_20202_() == livingMount) {
                MountController.processMountMovement(player, livingMount);
            } else {
                String mountType = livingMount.getPersistentData().m_128461_("RpgMounts_Type");
                if (mountType.isEmpty()) {
                    mountType = "GROUND";
                }
                if (Config.enableAutoDismountInWater && livingMount.m_20069_() && (mountType.equals("GROUND") || mountType.equals("FLYING"))) {
                    MountController.cleanupMount(playerUUID, mount);
                    return;
                }
                if (!Config.enableSneakDismount) {
                    if (livingMount.m_6084_() && !livingMount.m_213877_()) {
                        player.m_7998_((Entity)livingMount, true);
                    } else {
                        MountController.cleanupMount(playerUUID, mount);
                    }
                } else {
                    MountController.cleanupMount(playerUUID, mount);
                }
            }
        }
    }

    private static void processMountMovement(ServerPlayer player, LivingEntity mount) {
        UUID playerId = player.m_20148_();
        if (mount instanceof Mob) {
            Mob mob = (Mob)mount;
            mob.m_21557_(true);
            mob.m_21573_().m_26573_();
        }
        mount.m_146922_(player.m_146908_());
        mount.m_146926_(player.m_146909_());
        float forward = player.f_20902_;
        float sideways = player.f_20900_;
        float yawRad = (float)Math.toRadians(player.m_146908_());
        double speedMod = mount.getPersistentData().m_128459_("RpgMounts_SpeedMod");
        String mountType = mount.getPersistentData().m_128461_("RpgMounts_Type");
        if (speedMod == 0.0) {
            speedMod = 1.0;
        }
        if (mountType.isEmpty()) {
            mountType = "GROUND";
        }
        if (Config.enableAutoDismountInWater && mount.m_20069_() && (mountType.equals("GROUND") || mountType.equals("FLYING"))) {
            player.m_8127_();
            return;
        }
        double speed = 0.3 * (double)Config.multiplyMountSpeed * speedMod;
        double dx = (-Math.sin(yawRad) * (double)forward + Math.cos(yawRad) * (double)sideways) * speed;
        double dz = (Math.cos(yawRad) * (double)forward + Math.sin(yawRad) * (double)sideways) * speed;
        double dy = mount.m_20184_().f_82480_;
        boolean jumpPressed = jumpRequests.remove(playerId);
        boolean swimPressed = swimRequests.remove(playerId);
        switch (mountType) {
            case "FLYING": {
                if (mount.m_20096_()) {
                    dy = MountController.applyGroundMovement(player, mount, dx, dz, dy, forward, jumpPressed);
                    break;
                }
                if (jumpPressed) {
                    dy = 0.4 * speedMod;
                    break;
                }
                if (swimPressed) {
                    dy = -0.4 * speedMod;
                    break;
                }
                if (forward > 0.0f) {
                    dy = dy * 0.95 - 0.01;
                    dy = Math.max(-0.15, dy);
                    break;
                }
                dy = -0.03;
                break;
            }
            case "AQUATIC": {
                if (mount.m_20069_()) {
                    dy = 0.0;
                    if (jumpPressed) {
                        dy = 0.3;
                        break;
                    }
                    if (!swimPressed) break;
                    dy = -0.3;
                    break;
                }
                dy = MountController.applyGroundMovement(player, mount, dx, dz, dy, forward, jumpPressed);
                break;
            }
            default: {
                dy = MountController.applyGroundMovement(player, mount, dx, dz, dy, forward, jumpPressed);
            }
        }
        mount.m_20334_(dx, dy, dz);
        mount.m_6478_(MoverType.SELF, mount.m_20184_());
    }

    private static double applyGroundMovement(ServerPlayer player, LivingEntity mount, double dx, double dz, double dy, float forward, boolean jumpPressed) {
        double newY = dy;
        if (mount.m_20096_() && forward > 0.0f) {
            AABB probe = mount.m_20191_().m_82363_(dx, 1.0, dz);
            if (!mount.m_9236_().m_45756_((Entity)mount, probe)) {
                MountController.performJump(mount);
                newY = mount.m_20184_().f_82480_;
            }
        }
        if (Config.enableMountJump && jumpPressed && mount.m_20096_()) {
            MountController.performJump(mount);
            newY = mount.m_20184_().f_82480_;
        }
        if (!mount.m_20096_() && !mount.m_20069_()) {
            newY -= 0.08 * (double)Config.multiplyMountGravity;
        }
        if (Config.enableMountClimb && mount.m_6147_()) {
            newY = Math.max(newY, 0.2 * (double)Config.multiplyMountClimb);
        }
        return newY;
    }

    public static void cleanupMount(UUID playerId, Entity mount) {
        if (mount != null && !mount.m_213877_() && mount.m_8077_() && Objects.requireNonNull(mount.m_7770_()).getString().equals(playerId.toString())) {
            mount.m_142687_(Entity.RemovalReason.DISCARDED);
        }
        controlledMounts.remove(playerId);
        jumpRequests.remove(playerId);
        swimRequests.remove(playerId);
    }

    private static void performJump(LivingEntity mount) {
        double jumpStrength = 0.5 * Config.multiplyMountJump;
        mount.m_20334_(mount.m_20184_().f_82479_, jumpStrength, mount.m_20184_().f_82481_);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerUUID = event.getEntity().m_20148_();
        Entity mount = controlledMounts.get(playerUUID);
        if (mount != null) {
            MountController.cleanupMount(playerUUID, mount);
        }
    }

    public static void summonMount(ServerPlayer player, String mountCustomName) {
        JsonPlayer.PlayerMountConfig cfg;
        Entity currentMount;
        long cooldownMillis;
        long lastSummonTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastSummonTime = summonCooldowns.getOrDefault(player.m_20148_(), 0L).longValue()) < (cooldownMillis = (long)Config.mountSummonCooldownSeconds * 1000L)) {
            return;
        }
        if (player.m_20202_() != null && (currentMount = controlledMounts.get(player.m_20148_())) != null && currentMount == player.m_20202_()) {
            MountController.cleanupMount(player.m_20148_(), currentMount);
        }
        if ((cfg = PlayerConfigCache.getConfig(player.m_20148_())) == null) {
            return;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(mountCustomName)).filter(e -> e.enable);
        if (entryOpt.isEmpty()) {
            Epicka.LOGGER.warn("[{}] Player {} tried to spawn unauthorized mount: {}", new Object[]{Config.chatPrefixText, player.m_7755_().getString(), mountCustomName});
            return;
        }
        JsonPlayer.MountEntry entry = entryOpt.get();
        if (entry.costItem != null && !entry.costItem.isEmpty() && entry.costAmount > 0) {
            ResourceLocation itemRL = ResourceLocation.m_135820_((String)entry.costItem);
            if (itemRL == null) {
                Epicka.LOGGER.warn("[{}] Player {} tried to spawn mount {} with invalid cost item ID: {}", new Object[]{Config.chatPrefixText, player.m_7755_().getString(), entry.customName, entry.costItem});
                return;
            }
            Item item = BuiltInRegistries.f_257033_.m_6612_(itemRL).orElse(Items.f_41852_);
            if (item == Items.f_41852_) {
                Epicka.LOGGER.warn("[{}] Player {} tried to spawn mount {} with unknown cost item ID: {}", new Object[]{Config.chatPrefixText, player.m_7755_().getString(), entry.customName, entry.costItem});
                return;
            }
            int itemsInInventory = player.m_150109_().m_18947_(item);
            if (itemsInInventory < entry.costAmount) {
                player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] You need " + entry.costAmount + "x " + item.m_41466_().getString() + " (" + (entry.costAmount - itemsInInventory) + " more) to summon this mount.")).m_130940_(ChatFormatting.RED));
                return;
            }
            player.m_150109_().m_36022_(s -> s.m_150930_(item), entry.costAmount, (Container)player.f_36095_.m_39730_());
        }
        if (Config.mountBlacklist.contains(entry.idMonture)) {
            Epicka.LOGGER.warn("[{}] Player {} tried to spawn blacklisted mount: {}", new Object[]{Config.chatPrefixText, player.m_7755_().getString(), entry.idMonture});
            return;
        }
        ResourceLocation id = ResourceLocation.m_135820_((String)entry.idMonture);
        if (id == null) {
            return;
        }
        EntityType type = EntityType.m_20632_((String)entry.idMonture).orElse(null);
        if (type == null) {
            return;
        }
        ServerLevel level = player.m_284548_();
        Entity ent = type.m_20615_((Level)level);
        if (ent == null) {
            return;
        }
        if (entry.nbtData != null && !entry.nbtData.isEmpty()) {
            try {
                CompoundTag tag = TagParser.m_129359_((String)entry.nbtData);
                ent.m_20258_(tag);
            }
            catch (Exception e2) {
                Epicka.LOGGER.error("[{}] Failed to parse NBT for mount {}", new Object[]{Config.chatPrefixText, entry.customName, e2});
            }
        }
        ent.m_7678_(player.m_20185_(), player.m_20186_(), player.m_20189_(), player.m_146908_(), 0.0f);
        if (ent instanceof Mob) {
            Mob mob = (Mob)ent;
            mob.m_6518_((ServerLevelAccessor)level, level.m_6436_(player.m_20183_()), MobSpawnType.COMMAND, null, null);
        }
        ent.getPersistentData().m_128347_("RpgMounts_SpeedMod", entry.speedModifier);
        ent.getPersistentData().m_128359_("RpgMounts_Type", entry.mountType);
        ent.getPersistentData().m_128359_("RpgMounts_ConfigName", entry.customName);
        double px = player.m_20185_();
        double py = player.m_20186_() + 0.5;
        double pz = player.m_20189_();
        int amount = Config.mountSpawnParticlesAmount;
        switch (Config.mountSpawnParticlesType) {
            case "FLAME": {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123744_, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                break;
            }
            case "HEART": {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123750_, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                break;
            }
            case "PORTAL": {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123760_, px, py, pz, amount, 0.5, 0.5, 0.5, 0.1);
                break;
            }
            case "BUBBLE": {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123795_, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                break;
            }
            case "SMOKE": {
                level.m_8767_((ParticleOptions)ParticleTypes.f_123755_, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                break;
            }
        }
        level.m_7967_(ent);
        if (Config.enableMountInvincibility) {
            ent.m_20331_(true);
        }
        ent.m_6593_((Component)Component.m_237113_((String)player.m_20148_().toString()));
        ent.m_20340_(false);
        player.m_7998_(ent, true);
        controlledMounts.put(player.m_20148_(), ent);
        cfg.lastSummonedMount = entry.customName;
        PlayerConfigCache.updateConfig(player.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(player.m_20148_());
        summonCooldowns.put(player.m_20148_(), currentTime);
    }
}

