/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import fr.mod.epicka.network.PacketMount;
import fr.mod.epicka.network.PacketMountListResponse;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketMountListRequest {
    public PacketMountListRequest() {
    }

    public PacketMountListRequest(FriendlyByteBuf buf) {
    }

    public static void register(SimpleChannel channel, int id) {
        channel.messageBuilder(PacketMountListRequest.class, id, NetworkDirection.PLAY_TO_SERVER).encoder(PacketMountListRequest::encode).decoder(PacketMountListRequest::new).consumerMainThread((pkt, ctx) -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                pkt.handle(sender);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        }).add();
    }

    public static void send() {
        PacketMount.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketMountListRequest());
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public void handle(ServerPlayer player) {
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.m_20148_());
        if (cfg != null) {
            List<PacketMountListResponse.MountInfo> enabledMounts = cfg.mounts.values().stream().filter(e -> e.enable).map(e -> new PacketMountListResponse.MountInfo(e.customName, e.idMonture, e.nbtData, e.speedModifier, e.mountType, e.description != null ? e.description : "", e.costItem != null ? e.costItem : "", e.costAmount)).toList();
            PacketMountListResponse.send(player, enabledMounts);
        }
    }
}

