/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.items;

import fr.mod.epicka.Config;
import fr.mod.epicka.entity.MountController;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;

public class ItemMountFeeder
extends Item {
    private final ForgeConfigSpec.DoubleValue boostValue;

    public ItemMountFeeder(Item.Properties pProperties, ForgeConfigSpec.DoubleValue boostValue) {
        super(pProperties);
        this.boostValue = boostValue;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_20202_() != null && MountController.controlledMounts.get(player.m_20148_()) == player.m_20202_()) {
            player.m_6672_(hand);
            return InteractionResultHolder.m_19096_((Object)stack);
        }
        if (!level.m_5776_()) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] You must be riding your active mount to use this!")).m_130940_(ChatFormatting.RED));
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @NotNull
    public ItemStack m_5922_(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Entity mount = player.m_20202_();
        if (mount == null || MountController.controlledMounts.get(player.m_20148_()) != mount) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] You are not riding your mount!")).m_130940_(ChatFormatting.RED));
            return stack;
        }
        String configName = mount.getPersistentData().m_128461_("RpgMounts_ConfigName");
        if (configName.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] This mount cannot be boosted (config name missing).")).m_130940_(ChatFormatting.RED));
            return stack;
        }
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.m_20148_());
        if (cfg == null) {
            return stack;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(configName));
        if (entryOpt.isPresent()) {
            JsonPlayer.MountEntry entry = entryOpt.get();
            double oldSpeed = entry.speedModifier;
            double newSpeed = entry.speedModifier + (Double)this.boostValue.get();
            if (Config.mountMaxSpeed > 0.0) {
                newSpeed = Math.min(newSpeed, Config.mountMaxSpeed);
            }
            entry.speedModifier = newSpeed;
            mount.getPersistentData().m_128347_("RpgMounts_SpeedMod", entry.speedModifier);
            PlayerConfigCache.savePlayer(player.m_20148_());
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + entry.customName + "' speed boosted from " + String.format("%.2f", oldSpeed) + " to " + String.format("%.2f", newSpeed) + "!")).m_130940_(ChatFormatting.GREEN));
            if (!player.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
        } else {
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Could not find mount config entry '" + configName + "'.")).m_130940_(ChatFormatting.RED));
        }
        return stack;
    }

    public int m_8105_(@NotNull ItemStack stack) {
        return 32;
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }
}

