/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.entity.MountController;
import fr.mod.epicka.network.PacketMount;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketDismountRequest {
    private static final Map<UUID, Long> COOLDOWNS = new ConcurrentHashMap<UUID, Long>();
    private static final long COOLDOWN_MS = 1000L;

    public PacketDismountRequest() {
    }

    public PacketDismountRequest(FriendlyByteBuf buf) {
    }

    public static void register(SimpleChannel channel, int id) {
        channel.messageBuilder(PacketDismountRequest.class, id, NetworkDirection.PLAY_TO_SERVER).encoder(PacketDismountRequest::encode).decoder(PacketDismountRequest::new).consumerMainThread((pkt, ctx) -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                pkt.handle(sender);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        }).add();
    }

    public static void send() {
        PacketMount.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketDismountRequest());
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public void handle(ServerPlayer player) {
        long lastRequestTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastRequestTime = COOLDOWNS.getOrDefault(player.m_20148_(), 0L).longValue()) < 1000L) {
            return;
        }
        COOLDOWNS.put(player.m_20148_(), currentTime);
        Entity mount = MountController.controlledMounts.get(player.m_20148_());
        if (mount != null && player.m_20202_() == mount) {
            player.m_8127_();
            MountController.cleanupMount(player.m_20148_(), mount);
        }
    }
}

