/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.items;

import fr.mod.epicka.Config;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;

public class ItemMountUnlocker
extends Item {
    public ItemMountUnlocker(Item.Properties pProperties) {
        super(pProperties);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, Player player, @Nonnull InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        player.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)stack);
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null || !nbt.m_128425_("MountData", 10)) {
            player.m_213846_((Component)Component.m_237113_((String)"This unlocker item is corrupted or misconfigured.").m_130940_(ChatFormatting.RED));
            return stack;
        }
        CompoundTag mountData = nbt.m_128469_("MountData");
        String entityId = mountData.m_128461_("entity_id");
        String customName = mountData.m_128461_("customName");
        double speed = mountData.m_128459_("speed");
        String type = mountData.m_128461_("type");
        String nbtData = mountData.m_128461_("nbt");
        if (entityId.isEmpty() || customName.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)"This unlocker item is missing required data (entity_id, customName).").m_130940_(ChatFormatting.RED));
            return stack;
        }
        if (Config.mountBlacklist.contains(entityId)) {
            player.m_213846_((Component)Component.m_237113_((String)("This entity is blacklisted: " + entityId)).m_130940_(ChatFormatting.RED));
            return stack;
        }
        if (!BuiltInRegistries.f_256780_.m_7804_(ResourceLocation.parse((String)entityId))) {
            player.m_213846_((Component)Component.m_237113_((String)("Entity ID not found: " + entityId)).m_130940_(ChatFormatting.RED));
            return stack;
        }
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.m_20148_());
        if (cfg == null) {
            return stack;
        }
        if (cfg.mounts.containsKey(customName)) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] You have already unlocked a mount named '" + customName + "'.")).m_130940_(ChatFormatting.RED));
            return stack;
        }
        double finalSpeed = speed;
        if (Config.mountMaxSpeed > 0.0) {
            finalSpeed = Math.min(finalSpeed, Config.mountMaxSpeed);
        }
        JsonPlayer.MountEntry entry = new JsonPlayer.MountEntry(entityId, true, customName, nbtData, finalSpeed, type, null, null, 0);
        cfg.mounts.put(customName, entry);
        PlayerConfigCache.savePlayer(player.m_20148_());
        player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] You have unlocked a new mount: '" + customName + "'!")).m_130940_(ChatFormatting.GREEN));
        if (!player.m_150110_().f_35937_) {
            stack.m_41774_(1);
        }
        return stack;
    }

    public int m_8105_(@Nonnull ItemStack stack) {
        return 32;
    }

    @Nonnull
    public UseAnim m_6164_(@Nonnull ItemStack stack) {
        return UseAnim.EAT;
    }
}

