/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.UI.UIMenu;
import fr.mod.epicka.network.PacketMount;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketMountListResponse {
    private final List<MountInfo> mountInfos;

    public PacketMountListResponse(List<MountInfo> mountInfos) {
        this.mountInfos = List.copyOf(mountInfos);
    }

    public PacketMountListResponse(FriendlyByteBuf buf) {
        this.mountInfos = buf.m_236845_(MountInfo::new);
    }

    public static void register(SimpleChannel channel, int id) {
        channel.messageBuilder(PacketMountListResponse.class, id, NetworkDirection.PLAY_TO_CLIENT).encoder(PacketMountListResponse::encode).decoder(PacketMountListResponse::new).consumerMainThread((pkt, ctx) -> {
            pkt.handleClient();
            ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
        }).add();
    }

    public static void send(ServerPlayer player, List<MountInfo> mountInfos) {
        PacketMountListResponse pkt = new PacketMountListResponse(mountInfos);
        PacketMount.CHANNEL.send(PacketDistributor.PLAYER.with(() -> player), (Object)pkt);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_236828_(this.mountInfos, (b, i) -> i.encode((FriendlyByteBuf)b));
    }

    public void handleClient() {
        DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> {
            Minecraft mc = Minecraft.m_91087_();
            Screen patt1873$temp = mc.f_91080_;
            if (patt1873$temp instanceof UIMenu) {
                UIMenu ui = (UIMenu)patt1873$temp;
                ui.onReceiveMountList(this.mountInfos);
            }
        });
    }

    public record MountInfo(String customName, String entityId, String nbtData, double speedModifier, String mountType, String description, String costItem, int costAmount) {
        public MountInfo(FriendlyByteBuf buf) {
            this(buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.readDouble(), buf.m_130277_(), buf.m_130277_(), buf.m_130277_(), buf.readInt());
        }

        public void encode(FriendlyByteBuf buf) {
            buf.m_130070_(this.customName);
            buf.m_130070_(this.entityId);
            buf.m_130070_(this.nbtData);
            buf.writeDouble(this.speedModifier);
            buf.m_130070_(this.mountType);
            buf.m_130070_(this.description);
            buf.m_130070_(this.costItem);
            buf.writeInt(this.costAmount);
        }
    }
}

