/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.json.JsonPlayer;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class PlayerConfigCache {
    private static final Map<UUID, JsonPlayer.PlayerMountConfig> configCache = new ConcurrentHashMap<UUID, JsonPlayer.PlayerMountConfig>();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static ExecutorService saveExecutor;
    private static final ThreadFactory THREAD_FACTORY;

    private static synchronized ExecutorService getExecutor() {
        if (saveExecutor == null || saveExecutor.isShutdown() || saveExecutor.isTerminated()) {
            saveExecutor = Executors.newFixedThreadPool(4, THREAD_FACTORY);
        }
        return saveExecutor;
    }

    public static void loadPlayer(UUID playerUUID) {
        try {
            JsonPlayer.ensureConfigFile(playerUUID);
            JsonPlayer.PlayerMountConfig config = JsonPlayer.loadConfig(playerUUID);
            configCache.put(playerUUID, config);
        }
        catch (IOException e) {
            Epicka.LOGGER.error("[{}] Failed to load config for player {}", new Object[]{Config.chatPrefixText, playerUUID, e});
        }
    }

    public static void unloadPlayer(UUID playerUUID) {
        PlayerConfigCache.savePlayer(playerUUID);
        configCache.remove(playerUUID);
    }

    public static void savePlayer(UUID playerUUID) {
        JsonPlayer.PlayerMountConfig config = configCache.get(playerUUID);
        if (config == null) {
            return;
        }
        Runnable saveTask = () -> {
            try {
                String configJson = GSON.toJson((Object)config);
                JsonPlayer.saveConfigString(playerUUID, configJson);
            }
            catch (Exception e) {
                Epicka.LOGGER.error("[{}] Async save failed for player {}", new Object[]{Config.chatPrefixText, playerUUID, e});
            }
        };
        try {
            PlayerConfigCache.getExecutor().submit(saveTask);
        }
        catch (RejectedExecutionException e) {
            Epicka.LOGGER.warn("[{}] Executor rejected save for {}, saving synchronously to prevent data loss.", (Object)Config.chatPrefixText, (Object)playerUUID);
            saveTask.run();
        }
    }

    public static JsonPlayer.PlayerMountConfig getConfig(UUID playerUUID) {
        return configCache.get(playerUUID);
    }

    public static void updateConfig(UUID playerUUID, JsonPlayer.PlayerMountConfig config) {
        configCache.put(playerUUID, config);
    }

    public static void shutdown() {
        if (saveExecutor != null && !saveExecutor.isShutdown()) {
            saveExecutor.shutdown();
            try {
                if (!saveExecutor.awaitTermination(3L, TimeUnit.SECONDS)) {
                    saveExecutor.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                saveExecutor.shutdownNow();
                Thread.currentThread().interrupt();
            }
        }
    }

    static {
        THREAD_FACTORY = new ThreadFactory(){
            private final AtomicInteger count = new AtomicInteger(1);

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "Epicka-IO-Worker-" + this.count.getAndIncrement());
                t.setDaemon(true);
                return t;
            }
        };
    }
}

