/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.Config;
import fr.mod.epicka.entity.MountController;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import fr.mod.epicka.network.PacketMount;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketQuickMountRequest {
    public PacketQuickMountRequest() {
    }

    public PacketQuickMountRequest(FriendlyByteBuf buf) {
    }

    public static void register(SimpleChannel channel, int id) {
        channel.messageBuilder(PacketQuickMountRequest.class, id, NetworkDirection.PLAY_TO_SERVER).encoder(PacketQuickMountRequest::encode).decoder(PacketQuickMountRequest::new).consumerMainThread((pkt, ctx) -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                pkt.handle(sender);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        }).add();
    }

    public static void send() {
        PacketMount.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketQuickMountRequest());
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public void handle(ServerPlayer player) {
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.m_20148_());
        if (cfg == null || cfg.lastSummonedMount == null || cfg.lastSummonedMount.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] You haven't summoned a mount recently.")).m_130940_(ChatFormatting.RED));
            return;
        }
        String lastMountName = cfg.lastSummonedMount;
        if (!cfg.mounts.containsKey(lastMountName) || !cfg.mounts.get((Object)lastMountName).enable) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Your last summoned mount ('" + lastMountName + "') is no longer available.")).m_130940_(ChatFormatting.RED));
            return;
        }
        MountController.summonMount(player, lastMountName);
    }
}

