/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.Config;
import fr.mod.epicka.entity.MountController;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import fr.mod.epicka.network.PacketMount;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketQuickMountRequest {
    private static final Map<UUID, Long> COOLDOWNS = new ConcurrentHashMap<UUID, Long>();
    private static final long COOLDOWN_MS = 300L;

    public PacketQuickMountRequest() {
    }

    public PacketQuickMountRequest(FriendlyByteBuf buf) {
    }

    public static void register(SimpleChannel channel, int id) {
        channel.messageBuilder(PacketQuickMountRequest.class, id, NetworkDirection.PLAY_TO_SERVER).encoder(PacketQuickMountRequest::encode).decoder(PacketQuickMountRequest::new).consumerMainThread((pkt, ctx) -> {
            ServerPlayer sender = ((NetworkEvent.Context)ctx.get()).getSender();
            if (sender != null) {
                pkt.handle(sender);
                ((NetworkEvent.Context)ctx.get()).setPacketHandled(true);
            }
        }).add();
    }

    public static void send() {
        PacketMount.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PacketQuickMountRequest());
    }

    public void encode(FriendlyByteBuf buf) {
    }

    public void handle(ServerPlayer player) {
        long lastRequestTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastRequestTime = COOLDOWNS.getOrDefault(player.m_20148_(), 0L).longValue()) < 300L) {
            return;
        }
        COOLDOWNS.put(player.m_20148_(), currentTime);
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.m_20148_());
        if (cfg == null) {
            return;
        }
        if (cfg.lastSummonedMount == null || cfg.lastSummonedMount.isEmpty()) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] You haven't summoned a mount recently.")).m_130940_(ChatFormatting.RED));
            return;
        }
        String lastMountName = cfg.lastSummonedMount;
        if (!cfg.mounts.containsKey(lastMountName) || !cfg.mounts.get((Object)lastMountName).enable) {
            player.m_213846_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Your last summoned mount ('" + lastMountName + "') is no longer available.")).m_130940_(ChatFormatting.RED));
            return;
        }
        MountController.summonMount(player, lastMountName);
    }
}

