/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.entity.MountController;
import fr.mod.epicka.network.PacketMount;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class PacketUiMountRequest {
    private static final SimpleChannel CHANNEL = PacketMount.CHANNEL;
    private static final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();
    private final String mountId;

    public PacketUiMountRequest(String mountId) {
        this.mountId = mountId;
    }

    public PacketUiMountRequest(FriendlyByteBuf buf) {
        this.mountId = buf.m_130136_(Short.MAX_VALUE);
    }

    public static void register() {
        CHANNEL.messageBuilder(PacketUiMountRequest.class, 1, NetworkDirection.PLAY_TO_SERVER).encoder(PacketUiMountRequest::encode).decoder(PacketUiMountRequest::new).consumerMainThread((packet, context) -> {
            ServerPlayer player = ((NetworkEvent.Context)context.get()).getSender();
            if (player != null) {
                packet.handle(player);
                ((NetworkEvent.Context)context.get()).setPacketHandled(true);
            }
        }).add();
    }

    public static void send(String mountId) {
        PacketUiMountRequest pkt = new PacketUiMountRequest(mountId);
        CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)pkt);
    }

    public void encode(FriendlyByteBuf buf) {
        buf.m_130072_(this.mountId, Short.MAX_VALUE);
    }

    public void handle(ServerPlayer player) {
        MountController.summonMount(player, this.mountId);
    }
}

