/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.json.JsonPlayer;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class PlayerConfigCache {
    private static final Map<UUID, JsonPlayer.PlayerMountConfig> configCache = new ConcurrentHashMap<UUID, JsonPlayer.PlayerMountConfig>();
    private static final ExecutorService SAVE_EXECUTOR = Executors.newSingleThreadExecutor();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();

    public static void loadPlayer(UUID playerUUID) {
        try {
            JsonPlayer.ensureConfigFile(playerUUID);
            JsonPlayer.PlayerMountConfig config = JsonPlayer.loadConfig(playerUUID);
            configCache.put(playerUUID, config);
        }
        catch (IOException e) {
            Epicka.LOGGER.error("[{}] Failed to load and cache config for player {}", new Object[]{Config.chatPrefixText, playerUUID, e});
        }
    }

    public static void unloadPlayer(UUID playerUUID) {
        PlayerConfigCache.savePlayer(playerUUID);
        configCache.remove(playerUUID);
    }

    public static void savePlayer(UUID playerUUID) {
        JsonPlayer.PlayerMountConfig config = configCache.get(playerUUID);
        if (config != null) {
            SAVE_EXECUTOR.submit(() -> {
                try {
                    String configJson = GSON.toJson((Object)config);
                    JsonPlayer.saveConfigString(playerUUID, configJson);
                }
                catch (Exception e) {
                    Epicka.LOGGER.error("[{}] Failed to save config from cache for player {}", new Object[]{Config.chatPrefixText, playerUUID, e});
                }
            });
        }
    }

    public static JsonPlayer.PlayerMountConfig getConfig(UUID playerUUID) {
        return configCache.get(playerUUID);
    }

    public static void updateConfig(UUID playerUUID, JsonPlayer.PlayerMountConfig config) {
        configCache.put(playerUUID, config);
    }

    public static void shutdown() {
        SAVE_EXECUTOR.shutdown();
        try {
            if (!SAVE_EXECUTOR.awaitTermination(2L, TimeUnit.SECONDS)) {
                SAVE_EXECUTOR.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            SAVE_EXECUTOR.shutdownNow();
        }
    }
}

