/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.UI.UIMenu;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public record PacketMountListResponse(List<MountInfo> mountInfos) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketMountListResponse> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"epicka", (String)"mount_list_response"));
    public static final StreamCodec<FriendlyByteBuf, PacketMountListResponse> STREAM_CODEC = CustomPacketPayload.codec(PacketMountListResponse::write, PacketMountListResponse::new);

    public PacketMountListResponse(FriendlyByteBuf buf) {
        this((List)MountInfo.STREAM_CODEC.apply(ByteBufCodecs.list()).decode((Object)buf));
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToClient(TYPE, STREAM_CODEC, (pkt, ctx) -> ctx.enqueueWork(pkt::handleClient));
    }

    public static void send(ServerPlayer player, List<MountInfo> mountInfos) {
        PacketMountListResponse pkt = new PacketMountListResponse(mountInfos);
        PacketDistributor.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)pkt, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void write(FriendlyByteBuf buf) {
        MountInfo.STREAM_CODEC.apply(ByteBufCodecs.list()).encode((Object)buf, this.mountInfos);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<PacketMountListResponse> type() {
        return TYPE;
    }

    public void handleClient() {
        Minecraft mc = Minecraft.getInstance();
        Screen screen = mc.screen;
        if (screen instanceof UIMenu) {
            UIMenu ui = (UIMenu)screen;
            ui.onReceiveMountList(this.mountInfos);
        }
    }

    public record MountInfo(String customName, String entityId, String nbtData, double speedModifier, String mountType, String description, String costItem, int costAmount) {
        public static final StreamCodec<FriendlyByteBuf, MountInfo> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, MountInfo>(){

            @NotNull
            public MountInfo decode(@NotNull FriendlyByteBuf buf) {
                String customName = buf.readUtf();
                String entityId = buf.readUtf();
                String nbtData = buf.readUtf();
                double speedModifier = buf.readDouble();
                String mountType = buf.readUtf();
                String description = buf.readUtf();
                String costItem = buf.readUtf();
                int costAmount = buf.readInt();
                return new MountInfo(customName, entityId, nbtData, speedModifier, mountType, description, costItem, costAmount);
            }

            public void encode(@NotNull FriendlyByteBuf buf, @NotNull MountInfo info) {
                buf.writeUtf(info.customName);
                buf.writeUtf(info.entityId);
                buf.writeUtf(info.nbtData);
                buf.writeDouble(info.speedModifier);
                buf.writeUtf(info.mountType);
                buf.writeUtf(info.description);
                buf.writeUtf(info.costItem);
                buf.writeInt(info.costAmount);
            }
        };
    }
}

