/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.Config;
import fr.mod.epicka.entity.MountController;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import net.minecraft.ChatFormatting;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public record PacketQuickMountRequest() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketQuickMountRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"epicka", (String)"quick_mount_request"));
    public static final StreamCodec<FriendlyByteBuf, PacketQuickMountRequest> STREAM_CODEC = CustomPacketPayload.codec(PacketQuickMountRequest::write, PacketQuickMountRequest::new);

    public PacketQuickMountRequest(FriendlyByteBuf buf) {
        this();
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToServer(TYPE, STREAM_CODEC, (pkt, ctx) -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sender = (ServerPlayer)patt0$temp;
                ctx.enqueueWork(() -> pkt.handle(sender));
            }
        });
    }

    public static void send() {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketQuickMountRequest(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void write(FriendlyByteBuf buf) {
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<PacketQuickMountRequest> type() {
        return TYPE;
    }

    public void handle(ServerPlayer player) {
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.getUUID());
        if (cfg == null || cfg.lastSummonedMount == null || cfg.lastSummonedMount.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] You haven't summoned a mount recently.")).withStyle(ChatFormatting.RED));
            return;
        }
        String lastMountName = cfg.lastSummonedMount;
        if (!cfg.mounts.containsKey(lastMountName) || !cfg.mounts.get((Object)lastMountName).enable) {
            player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Your last summoned mount ('" + lastMountName + "') is no longer available.")).withStyle(ChatFormatting.RED));
            return;
        }
        MountController.summonMount(player, lastMountName);
    }
}

