/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka;

import java.util.List;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.neoforge.common.ModConfigSpec;

@EventBusSubscriber(modid="epicka")
public class Config {
    private static final ModConfigSpec.Builder BUILDER = new ModConfigSpec.Builder();
    public static final ModConfigSpec.ConfigValue<String> CHAT_PREFIX_TEXT = BUILDER.define("chatPrefixText", (Object)"RpgMounts", s -> s instanceof String && !((String)s).isBlank());
    public static final ModConfigSpec.ConfigValue<String> SET_GUI_TEXTURE_BACKGROUND = BUILDER.define("setGuiMenuTextureBackground", (Object)"epicka:textures/gui/menu_background.png", s -> s instanceof String && !((String)s).isBlank());
    public static final ModConfigSpec.ConfigValue<String> SET_GUI_TEXTURE_CLOSE_BUTTON = BUILDER.define("setGuiMenuTextureCloseButton", (Object)"epicka:textures/gui/close_button.png", s -> s instanceof String && !((String)s).isBlank());
    public static final ModConfigSpec.ConfigValue<String> SET_GUI_TEXTURE_CLOSE_BUTTON_HOVERED = BUILDER.define("setGuiMenuTextureCloseButtonHovered", (Object)"epicka:textures/gui/close_button_hovered.png", s -> s instanceof String && !((String)s).isBlank());
    public static final ModConfigSpec.IntValue GUI_CLOSE_BUTTON_X_OFFSET_RIGHT = BUILDER.comment("X offset from the right screen edge for the Close button.").defineInRange("guiCloseButtonXOffsetRight", 15, 0, 1000);
    public static final ModConfigSpec.IntValue GUI_CLOSE_BUTTON_Y_OFFSET_TOP = BUILDER.comment("Y offset from the top screen edge for the Close button.").defineInRange("guiCloseButtonYOffsetTop", 15, 0, 1000);
    public static final ModConfigSpec.ConfigValue<String> GUI_RIDE_BUTTON_TEXT = BUILDER.comment("Text for the 'Ride' button (if not using custom textures).").define("guiRideButtonText", (Object)"Ride");
    public static final ModConfigSpec.ConfigValue<String> GUI_RIDE_BUTTON_TEXT_COLOR = BUILDER.comment("Hex color for the 'Ride' button text (if not using custom textures).").define("guiRideButtonTextColor", (Object)"#55FF55");
    public static final ModConfigSpec.ConfigValue<String> GUI_SCROLLBAR_COLOR = BUILDER.comment("Hex color for the scrollbar in the UI.").define("guiScrollbarColor", (Object)"#FF00FF00");
    public static final ModConfigSpec.ConfigValue<String> GUI_SLOT_BACKGROUND_COLOR = BUILDER.comment("Hex color for the background of the mount slots in the UI.").define("guiSlotBackgroundColor", (Object)"#303030");
    public static final ModConfigSpec.ConfigValue<String> GUI_MOUNT_NAME_TEXT_COLOR = BUILDER.comment("Hex color for the mount name text.").define("guiMountNameTextColor", (Object)"#FFFFFF");
    public static final ModConfigSpec.BooleanValue GUI_SHOW_MOUNT_TYPE = BUILDER.comment("Show mount type [GROUND, AQUATIC, FLYING] next to the mount name.").define("guiShowMountType", false);
    public static final ModConfigSpec.ConfigValue<String> GUI_MOUNT_TYPE_GROUND_TEXT_COLOR = BUILDER.comment("Hex color for the GROUND mount type text.").define("guiMountTypeGroundTextColor", (Object)"#AAAAAA");
    public static final ModConfigSpec.ConfigValue<String> GUI_MOUNT_TYPE_AQUATIC_TEXT_COLOR = BUILDER.comment("Hex color for the AQUATIC mount type text.").define("guiMountTypeAquaticTextColor", (Object)"#5555FF");
    public static final ModConfigSpec.ConfigValue<String> GUI_MOUNT_TYPE_FLYING_TEXT_COLOR = BUILDER.comment("Hex color for the FLYING mount type text.").define("guiMountTypeFlyingTextColor", (Object)"#FFFFFF");
    public static final ModConfigSpec.BooleanValue GUI_SHOW_MOUNT_SPEED = BUILDER.comment("Show mount speed text (or bar) under the mount name.").define("guiShowMountSpeed", true);
    public static final ModConfigSpec.BooleanValue GUI_SHOW_SPEED_AS_BAR = BUILDER.comment("Show mount speed as a progress bar instead of text.").define("guiShowSpeedAsBar", false);
    public static final ModConfigSpec.ConfigValue<String> GUI_SPEED_BAR_FILLED_COLOR = BUILDER.comment("Hex color for the filled part of the speed bar.").define("guiSpeedBarFilledColor", (Object)"#55FF55");
    public static final ModConfigSpec.ConfigValue<String> GUI_SPEED_BAR_EMPTY_COLOR = BUILDER.comment("Hex color for the empty part (background) of the speed bar.").define("guiSpeedBarEmptyColor", (Object)"#404040");
    public static final ModConfigSpec.ConfigValue<String> GUI_SPEED_TEXT_COLOR = BUILDER.comment("Hex color for the mount speed text.").define("guiSpeedTextColor", (Object)"#AAAAAA");
    public static final ModConfigSpec.ConfigValue<String> GUI_DESCRIPTION_TEXT_COLOR = BUILDER.comment("Hex color for the mount description text.").define("guiDescriptionTextColor", (Object)"#808080");
    public static final ModConfigSpec.ConfigValue<String> GUI_COST_TEXT_COLOR = BUILDER.comment("Hex color for the mount cost text.").define("guiCostTextColor", (Object)"#FF5555");
    public static final ModConfigSpec.BooleanValue ENABLE_GUI_CUSTOM_RIDE_BUTTON = BUILDER.comment("Enable custom textures for the 'Ride' button.").define("enableGuiCustomRideButton", false);
    public static final ModConfigSpec.ConfigValue<String> GUI_RIDE_BUTTON_TEXTURE_NORMAL = BUILDER.define("guiRideButtonTextureNormal", (Object)"epicka:textures/gui/ride_normal.png");
    public static final ModConfigSpec.ConfigValue<String> GUI_RIDE_BUTTON_TEXTURE_HOVERED = BUILDER.define("guiRideButtonTextureHovered", (Object)"epicka:textures/gui/ride_hovered.png");
    public static final ModConfigSpec.ConfigValue<String> GUI_RIDE_BUTTON_TEXTURE_CLICKED = BUILDER.define("guiRideButtonTextureClicked", (Object)"epicka:textures/gui/ride_clicked.png");
    public static final ModConfigSpec.BooleanValue GUI_SHOW_SEARCH_BOX = BUILDER.comment("Show the Search Box to filter mounts by name.").define("guiShowSearchBox", true);
    public static final ModConfigSpec.ConfigValue<String> GUI_SEARCH_TEXT_COLOR = BUILDER.comment("Hex color for the text inside the search box.").define("guiSearchTextColor", (Object)"#FFFFFF");
    public static final ModConfigSpec.IntValue GUI_SEARCH_BOX_X = BUILDER.comment("X position of the Search Box. Set to -1 to auto-position based on UI mode.").defineInRange("guiSearchBoxX", -1, -1, 10000);
    public static final ModConfigSpec.IntValue GUI_SEARCH_BOX_Y = BUILDER.comment("Y position of the Search Box. Set to -1 to auto-position based on UI mode.").defineInRange("guiSearchBoxY", -1, -1, 10000);
    public static final ModConfigSpec.IntValue GUI_SEARCH_BOX_WIDTH = BUILDER.comment("Width of the Search Box. Set to -1 to auto-scale based on UI mode.").defineInRange("guiSearchBoxWidth", -1, -1, 10000);
    public static final ModConfigSpec.BooleanValue GUI_SHOW_FILTER_BUTTON = BUILDER.comment("Show the 'Filters & Sort' button in the UI.").define("guiShowFilterButton", true);
    public static final ModConfigSpec.IntValue GUI_FILTER_BUTTON_X = BUILDER.comment("X position of the Filter button. Set to -1 to center horizontally (or align right if search is active).").defineInRange("guiFilterButtonX", -1, -1, 10000);
    public static final ModConfigSpec.IntValue GUI_FILTER_BUTTON_Y = BUILDER.comment("Y position of the Filter button.").defineInRange("guiFilterButtonY", 15, 0, 10000);
    public static final ModConfigSpec.ConfigValue<String> GUI_FILTER_BUTTON_TEXT = BUILDER.define("guiFilterButtonText", (Object)"Filters & Sort");
    public static final ModConfigSpec.BooleanValue ENABLE_GUI_CUSTOM_FILTER_BUTTON = BUILDER.comment("Enable custom textures for the 'Filter' button.").define("enableGuiCustomFilterButton", false);
    public static final ModConfigSpec.ConfigValue<String> GUI_FILTER_BUTTON_TEXTURE_NORMAL = BUILDER.define("guiFilterButtonTextureNormal", (Object)"epicka:textures/gui/filter_normal.png");
    public static final ModConfigSpec.ConfigValue<String> GUI_FILTER_BUTTON_TEXTURE_HOVERED = BUILDER.define("guiFilterButtonTextureHovered", (Object)"epicka:textures/gui/filter_hovered.png");
    public static final ModConfigSpec.ConfigValue<String> GUI_FILTER_BUTTON_TEXTURE_CLICKED = BUILDER.define("guiFilterButtonTextureClicked", (Object)"epicka:textures/gui/filter_clicked.png");
    public static final ModConfigSpec.ConfigValue<String> GUI_FILTER_PANEL_COLOR = BUILDER.comment("Hex color for the filter dropdown panel background.").define("guiFilterPanelColor", (Object)"#A0202020");
    public static final ModConfigSpec.BooleanValue ENABLE_GUI_CUSTOM_FILTER_SUB_BUTTON = BUILDER.comment("Enable custom textures for the 'Filter' sub-buttons (Ground, Aquatic, etc.).").define("enableGuiCustomFilterSubButton", false);
    public static final ModConfigSpec.ConfigValue<String> GUI_FILTER_SUB_BUTTON_TEXTURE_NORMAL = BUILDER.define("guiFilterSubButtonTextureNormal", (Object)"epicka:textures/gui/filter_sub_normal.png");
    public static final ModConfigSpec.ConfigValue<String> GUI_FILTER_SUB_BUTTON_TEXTURE_HOVERED = BUILDER.define("guiFilterSubButtonTextureHovered", (Object)"epicka:textures/gui/filter_sub_hovered.png");
    public static final ModConfigSpec.ConfigValue<String> GUI_FILTER_SUB_BUTTON_TEXTURE_CLICKED = BUILDER.define("guiFilterSubButtonTextureClicked", (Object)"epicka:textures/gui/filter_sub_clicked.png");
    public static final ModConfigSpec.BooleanValue ENABLE_TEXT_ON_CUSTOM_BUTTONS = BUILDER.comment("If true, renders the default text ON TOP of custom textured buttons (Ride, main Filter). Filter sub-buttons always show text if they use custom textures.").define("enableTextOnCustomButtons", true);
    public static final ModConfigSpec.BooleanValue ENABLE_MODERN_UI = BUILDER.comment("Enable the Modern UI style (List on left, Details on right) instead of the basic list.").define("enableModernUi", false);
    public static final ModConfigSpec.ConfigValue<String> GUI_MODERN_LIST_SELECTED_COLOR = BUILDER.comment("Hex color for the selected mount name in Modern UI.").define("guiModernListSelectedColor", (Object)"#FFFF55");
    public static final ModConfigSpec.ConfigValue<String> GUI_MODERN_LIST_NORMAL_COLOR = BUILDER.comment("Hex color for unselected mount names in Modern UI.").define("guiModernListNormalColor", (Object)"#AAAAAA");
    public static final ModConfigSpec.ConfigValue<String> GUI_MODERN_LIST_HOVER_COLOR = BUILDER.comment("Hex color for hovered mount name in Modern UI.").define("guiModernListHoverColor", (Object)"#FFFFFF");
    public static final ModConfigSpec.IntValue MOUNT_SUMMON_COOLDOWN_SECONDS = BUILDER.defineInRange("mountSummonCooldownSeconds", 5, 0, 3600);
    public static final ModConfigSpec.BooleanValue ENABLE_SUMMON_INDOORS = BUILDER.comment("Allow players to summon mounts indoors (When there is no sky above the player).").define("enableSummonIndoors", true);
    public static final ModConfigSpec.BooleanValue ENABLE_AUTO_DISMOUNT_IN_WATER = BUILDER.comment("Force dismount when entering water.").define("enableAutoDismountInWater", true);
    public static final ModConfigSpec.BooleanValue ENABLE_AUTO_DISMOUNT_IN_LAVA = BUILDER.comment("Force dismount when entering lava.").define("enableAutoDismountInLava", true);
    public static final ModConfigSpec.BooleanValue ENABLE_AUTO_DISMOUNT_IN_POWDER_SNOW = BUILDER.comment("Force dismount when entering powder snow.").define("enableAutoDismountInPowderSnow", false);
    public static final ModConfigSpec.BooleanValue ENABLE_SNEAK_DISMOUNT = BUILDER.comment("Allow players to dismount by pressing Sneak (Shift) key.").define("enableSneakDismount", true);
    public static final ModConfigSpec.BooleanValue ENABLE_MOUNT_JUMP = BUILDER.define("enableMountJump", true);
    public static final ModConfigSpec.DoubleValue MOUNT_SPEED_BOOST_VALUE = BUILDER.comment("Amount of speed to add when using the speed boost food.").defineInRange("mountSpeedBoostValue", 0.1, 0.0, 10.0);
    public static final ModConfigSpec.DoubleValue MOUNT_SUPER_BOOST_VALUE = BUILDER.comment("Amount of speed to add when using the SUPER speed boost food.").defineInRange("mountSuperBoostValue", 0.2, 0.0, 10.0);
    public static final ModConfigSpec.DoubleValue MOUNT_MAX_SPEED = BUILDER.comment("The maximum speed a mount can have. Set to 0 or less to disable the limit.").defineInRange("mountMaxSpeed", 3.0, -1.0, 100.0);
    public static final ModConfigSpec.BooleanValue ENABLE_MOUNT_CLIMB = BUILDER.define("enableMountClimb", true);
    public static final ModConfigSpec.BooleanValue ENABLE_MOUNT_INVINCIBILITY = BUILDER.define("enableMountInvincibility", true);
    public static final ModConfigSpec.ConfigValue<String> MOUNT_SPAWN_PARTICLES_TYPE = BUILDER.comment("Type of particle to spawn. Valid options: \"NONE\", \"FLAME\", \"HEART\", \"PORTAL\", \"BUBBLE\", \"SMOKE\".").define("mountSpawnParticlesType", (Object)"FLAME");
    public static final ModConfigSpec.IntValue MOUNT_SPAWN_PARTICLES_AMOUNT = BUILDER.defineInRange("mountSpawnParticlesAmount", 100, 0, 300);
    public static final ModConfigSpec.IntValue MULTIPLY_MOUNT_GRAVITY = BUILDER.defineInRange("multiplyMountGravity", 1, -10, 10);
    public static final ModConfigSpec.IntValue MULTIPLY_MOUNT_SPEED = BUILDER.defineInRange("multiplyMountSpeed", 1, -10, 10);
    public static final ModConfigSpec.DoubleValue MOUNT_LAVA_SPEED_FACTOR = BUILDER.comment("Speed multiplier when mount is in Lava (0.3 = 30% speed).").defineInRange("mountLavaSpeedFactor", 0.3, 0.0, 1.0);
    public static final ModConfigSpec.DoubleValue MOUNT_POWDER_SNOW_SPEED_FACTOR = BUILDER.comment("Speed multiplier when mount is in Powder Snow (0.4 = 40% speed).").defineInRange("mountPowderSnowSpeedFactor", 0.4, 0.0, 1.0);
    public static final ModConfigSpec.IntValue MULTIPLY_MOUNT_CLIMB = BUILDER.defineInRange("multiplyMountClimb", 1, -10, 10);
    public static final ModConfigSpec.DoubleValue MULTIPLY_MOUNT_JUMP = BUILDER.comment("Multiplier for mount jump height.").defineInRange("multiplyMountJump", 1.0, 0.0, 10.0);
    public static final ModConfigSpec.ConfigValue<List<? extends String>> MOUNT_BLACKLIST = BUILDER.comment("Add blacklisted entities").defineListAllowEmpty("mountBlacklist", List.of("minecraft:wither", "minecraft:player"), s -> s instanceof String);
    public static final ModConfigSpec.BooleanValue ENABLE_STARTUP_MOUNT_VALIDATION = BUILDER.comment("Clean inexistant world entity in player configuration when server start.").define("enableStartupMountValidation", false);
    public static String chatPrefixText;
    public static String setGuiMenuTextureBackground;
    public static String setGuiMenuTextureCloseButton;
    public static String setGuiMenuTextureCloseButtonHovered;
    public static int guiCloseButtonXOffsetRight;
    public static int guiCloseButtonYOffsetTop;
    public static String guiRideButtonText;
    public static int guiRideButtonTextColor;
    public static int guiScrollbarColor;
    public static int guiSlotBackgroundColor;
    public static int guiMountNameTextColor;
    public static boolean guiShowMountType;
    public static int guiMountTypeGroundTextColor;
    public static int guiMountTypeAquaticTextColor;
    public static int guiMountTypeFlyingTextColor;
    public static boolean guiShowMountSpeed;
    public static boolean guiShowSpeedAsBar;
    public static int guiSpeedBarFilledColor;
    public static int guiSpeedBarEmptyColor;
    public static int guiSpeedTextColor;
    public static int guiDescriptionTextColor;
    public static int guiCostTextColor;
    public static boolean enableGuiCustomRideButton;
    public static String guiRideButtonTextureNormal;
    public static String guiRideButtonTextureHovered;
    public static String guiRideButtonTextureClicked;
    public static boolean guiShowFilterButton;
    public static int guiFilterButtonX;
    public static int guiFilterButtonY;
    public static String guiFilterButtonText;
    public static boolean enableGuiCustomFilterButton;
    public static String guiFilterButtonTextureNormal;
    public static String guiFilterButtonTextureHovered;
    public static String guiFilterButtonTextureClicked;
    public static int guiFilterPanelColor;
    public static boolean enableGuiCustomFilterSubButton;
    public static String guiFilterSubButtonTextureNormal;
    public static String guiFilterSubButtonTextureHovered;
    public static String guiFilterSubButtonTextureClicked;
    public static boolean guiShowSearchBox;
    public static int guiSearchTextColor;
    public static int guiSearchBoxX;
    public static int guiSearchBoxY;
    public static int guiSearchBoxWidth;
    public static boolean enableTextOnCustomButtons;
    public static int mountSummonCooldownSeconds;
    public static boolean enableSummonIndoors;
    public static boolean enableAutoDismountInWater;
    public static boolean enableAutoDismountInLava;
    public static boolean enableAutoDismountInPowderSnow;
    public static double mountLavaSpeedFactor;
    public static double mountPowderSnowSpeedFactor;
    public static boolean enableSneakDismount;
    public static boolean enableMountJump;
    public static double mountSpeedBoostValue;
    public static double mountSuperBoostValue;
    public static double mountMaxSpeed;
    public static boolean enableMountClimb;
    public static boolean enableMountInvincibility;
    public static String mountSpawnParticlesType;
    public static int mountSpawnParticlesAmount;
    public static int multiplyMountGravity;
    public static int multiplyMountSpeed;
    public static int multiplyMountClimb;
    public static double multiplyMountJump;
    public static List<String> mountBlacklist;
    public static boolean enableStartupMountValidation;
    public static boolean enableModernUi;
    public static int guiModernListSelectedColor;
    public static int guiModernListNormalColor;
    public static int guiModernListHoverColor;
    static final ModConfigSpec SPEC;

    private static int parseColor(String hex, int defaultColor) {
        try {
            if (((String)hex).startsWith("#")) {
                hex = ((String)hex).substring(1);
            }
            if (((String)hex).length() == 6) {
                hex = "FF" + (String)hex;
            }
            return (int)Long.parseLong((String)hex, 16);
        }
        catch (Exception e) {
            return defaultColor;
        }
    }

    @SubscribeEvent
    static void onLoad(ModConfigEvent event) {
        chatPrefixText = (String)CHAT_PREFIX_TEXT.get();
        setGuiMenuTextureBackground = (String)SET_GUI_TEXTURE_BACKGROUND.get();
        setGuiMenuTextureCloseButton = (String)SET_GUI_TEXTURE_CLOSE_BUTTON.get();
        setGuiMenuTextureCloseButtonHovered = (String)SET_GUI_TEXTURE_CLOSE_BUTTON_HOVERED.get();
        guiCloseButtonXOffsetRight = (Integer)GUI_CLOSE_BUTTON_X_OFFSET_RIGHT.get();
        guiCloseButtonYOffsetTop = (Integer)GUI_CLOSE_BUTTON_Y_OFFSET_TOP.get();
        guiRideButtonText = (String)GUI_RIDE_BUTTON_TEXT.get();
        guiRideButtonTextColor = Config.parseColor((String)GUI_RIDE_BUTTON_TEXT_COLOR.get(), -11141291);
        guiScrollbarColor = Config.parseColor((String)GUI_SCROLLBAR_COLOR.get(), -16711936);
        guiSlotBackgroundColor = Config.parseColor((String)GUI_SLOT_BACKGROUND_COLOR.get(), -13619152);
        guiMountNameTextColor = Config.parseColor((String)GUI_MOUNT_NAME_TEXT_COLOR.get(), -1);
        guiShowMountType = (Boolean)GUI_SHOW_MOUNT_TYPE.get();
        guiMountTypeGroundTextColor = Config.parseColor((String)GUI_MOUNT_TYPE_GROUND_TEXT_COLOR.get(), -5592406);
        guiMountTypeAquaticTextColor = Config.parseColor((String)GUI_MOUNT_TYPE_AQUATIC_TEXT_COLOR.get(), -11184641);
        guiMountTypeFlyingTextColor = Config.parseColor((String)GUI_MOUNT_TYPE_FLYING_TEXT_COLOR.get(), -1);
        guiShowMountSpeed = (Boolean)GUI_SHOW_MOUNT_SPEED.get();
        guiShowSpeedAsBar = (Boolean)GUI_SHOW_SPEED_AS_BAR.get();
        guiSpeedBarFilledColor = Config.parseColor((String)GUI_SPEED_BAR_FILLED_COLOR.get(), -11141291);
        guiSpeedBarEmptyColor = Config.parseColor((String)GUI_SPEED_BAR_EMPTY_COLOR.get(), -12566464);
        guiSpeedTextColor = Config.parseColor((String)GUI_SPEED_TEXT_COLOR.get(), -5592406);
        guiDescriptionTextColor = Config.parseColor((String)GUI_DESCRIPTION_TEXT_COLOR.get(), -8355712);
        guiCostTextColor = Config.parseColor((String)GUI_COST_TEXT_COLOR.get(), -43691);
        enableGuiCustomRideButton = (Boolean)ENABLE_GUI_CUSTOM_RIDE_BUTTON.get();
        guiRideButtonTextureNormal = (String)GUI_RIDE_BUTTON_TEXTURE_NORMAL.get();
        guiRideButtonTextureHovered = (String)GUI_RIDE_BUTTON_TEXTURE_HOVERED.get();
        guiRideButtonTextureClicked = (String)GUI_RIDE_BUTTON_TEXTURE_CLICKED.get();
        guiShowFilterButton = (Boolean)GUI_SHOW_FILTER_BUTTON.get();
        guiFilterButtonX = (Integer)GUI_FILTER_BUTTON_X.get();
        guiFilterButtonY = (Integer)GUI_FILTER_BUTTON_Y.get();
        guiFilterButtonText = (String)GUI_FILTER_BUTTON_TEXT.get();
        enableGuiCustomFilterButton = (Boolean)ENABLE_GUI_CUSTOM_FILTER_BUTTON.get();
        guiFilterButtonTextureNormal = (String)GUI_FILTER_BUTTON_TEXTURE_NORMAL.get();
        guiFilterButtonTextureHovered = (String)GUI_FILTER_BUTTON_TEXTURE_HOVERED.get();
        guiFilterButtonTextureClicked = (String)GUI_FILTER_BUTTON_TEXTURE_CLICKED.get();
        guiFilterPanelColor = Config.parseColor((String)GUI_FILTER_PANEL_COLOR.get(), -1608507360);
        enableGuiCustomFilterSubButton = (Boolean)ENABLE_GUI_CUSTOM_FILTER_SUB_BUTTON.get();
        guiFilterSubButtonTextureNormal = (String)GUI_FILTER_SUB_BUTTON_TEXTURE_NORMAL.get();
        guiFilterSubButtonTextureHovered = (String)GUI_FILTER_SUB_BUTTON_TEXTURE_HOVERED.get();
        guiFilterSubButtonTextureClicked = (String)GUI_FILTER_SUB_BUTTON_TEXTURE_CLICKED.get();
        guiShowSearchBox = (Boolean)GUI_SHOW_SEARCH_BOX.get();
        guiSearchTextColor = Config.parseColor((String)GUI_SEARCH_TEXT_COLOR.get(), -1);
        guiSearchBoxX = (Integer)GUI_SEARCH_BOX_X.get();
        guiSearchBoxY = (Integer)GUI_SEARCH_BOX_Y.get();
        guiSearchBoxWidth = (Integer)GUI_SEARCH_BOX_WIDTH.get();
        enableTextOnCustomButtons = (Boolean)ENABLE_TEXT_ON_CUSTOM_BUTTONS.get();
        enableModernUi = (Boolean)ENABLE_MODERN_UI.get();
        guiModernListSelectedColor = Config.parseColor((String)GUI_MODERN_LIST_SELECTED_COLOR.get(), 0xFFFF55);
        guiModernListNormalColor = Config.parseColor((String)GUI_MODERN_LIST_NORMAL_COLOR.get(), 0xAAAAAA);
        guiModernListHoverColor = Config.parseColor((String)GUI_MODERN_LIST_HOVER_COLOR.get(), 0xFFFFFF);
        mountSummonCooldownSeconds = (Integer)MOUNT_SUMMON_COOLDOWN_SECONDS.get();
        enableSummonIndoors = (Boolean)ENABLE_SUMMON_INDOORS.get();
        enableAutoDismountInWater = (Boolean)ENABLE_AUTO_DISMOUNT_IN_WATER.get();
        enableAutoDismountInLava = (Boolean)ENABLE_AUTO_DISMOUNT_IN_LAVA.get();
        enableAutoDismountInPowderSnow = (Boolean)ENABLE_AUTO_DISMOUNT_IN_POWDER_SNOW.get();
        mountLavaSpeedFactor = (Double)MOUNT_LAVA_SPEED_FACTOR.get();
        mountPowderSnowSpeedFactor = (Double)MOUNT_POWDER_SNOW_SPEED_FACTOR.get();
        enableSneakDismount = (Boolean)ENABLE_SNEAK_DISMOUNT.get();
        enableMountJump = (Boolean)ENABLE_MOUNT_JUMP.get();
        mountSpeedBoostValue = (Double)MOUNT_SPEED_BOOST_VALUE.get();
        mountSuperBoostValue = (Double)MOUNT_SUPER_BOOST_VALUE.get();
        mountMaxSpeed = (Double)MOUNT_MAX_SPEED.get();
        enableMountClimb = (Boolean)ENABLE_MOUNT_CLIMB.get();
        enableMountInvincibility = (Boolean)ENABLE_MOUNT_INVINCIBILITY.get();
        mountSpawnParticlesType = ((String)MOUNT_SPAWN_PARTICLES_TYPE.get()).toUpperCase();
        mountSpawnParticlesAmount = (Integer)MOUNT_SPAWN_PARTICLES_AMOUNT.get();
        multiplyMountGravity = (Integer)MULTIPLY_MOUNT_GRAVITY.get();
        multiplyMountSpeed = (Integer)MULTIPLY_MOUNT_SPEED.get();
        multiplyMountClimb = (Integer)MULTIPLY_MOUNT_CLIMB.get();
        multiplyMountJump = (Double)MULTIPLY_MOUNT_JUMP.get();
        mountBlacklist = ((List)MOUNT_BLACKLIST.get()).stream().map(String::valueOf).toList();
        enableStartupMountValidation = (Boolean)ENABLE_STARTUP_MOUNT_VALIDATION.get();
    }

    static {
        setGuiMenuTextureBackground = "";
        setGuiMenuTextureCloseButton = "";
        setGuiMenuTextureCloseButtonHovered = "";
        SPEC = BUILDER.build();
    }
}

