/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.UI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.mod.epicka.Config;
import fr.mod.epicka.network.PacketMountListRequest;
import fr.mod.epicka.network.PacketMountListResponse;
import fr.mod.epicka.network.PacketUiMountRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class UIMenu
extends Screen {
    private static final int MIN_BUTTON_WIDTH = 60;
    private static final int MIN_BUTTON_HEIGHT = 20;
    private static final int MIN_SLOT_HEIGHT = 60;
    private static final int SLOT_GAP = 8;
    private static final int MAX_SLOT_WIDTH = 400;
    private static final int MODERN_UI_WIDTH = 256;
    private static final int MODERN_UI_HEIGHT = 256;
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.tryParse((String)Config.setGuiMenuTextureBackground);
    private final List<PacketMountListResponse.MountInfo> originalMountInfos = new ArrayList<PacketMountListResponse.MountInfo>();
    private final List<PacketMountListResponse.MountInfo> displayedMountInfos = new ArrayList<PacketMountListResponse.MountInfo>();
    private final Map<String, Entity> entityCache = new HashMap<String, Entity>();
    private final List<AbstractWidget> mountWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> filterWidgets = new ArrayList<AbstractWidget>();
    private AbstractWidget filterButton;
    private Button filterGroundButton;
    private Button filterAquaticButton;
    private Button filterFlyingButton;
    private Button sortButton;
    private EditBox searchBox;
    private PacketMountListResponse.MountInfo selectedMount = null;
    private Button modernSummonButton;
    private int scrollOffset = 0;
    private int buttonWidth;
    private int buttonHeight;
    private int slotWidth;
    private int slotHeight;
    private int visibleSlots;
    private int filterPanelX;
    private int filterPanelY;
    private int filterPanelWidth;
    private int filterPanelHeight;
    private boolean showFilterMenu = false;
    private boolean filterGround = true;
    private boolean filterAquatic = true;
    private boolean filterFlying = true;
    private SortType sortType = SortType.BY_NAME;
    private float currentRotY = 0.0f;
    private float currentRotX = 0.0f;

    public UIMenu() {
        super((Component)Component.empty());
    }

    protected void init() {
        super.init();
        this.originalMountInfos.clear();
        this.displayedMountInfos.clear();
        this.entityCache.values().forEach(entity -> {
            if (entity != null) {
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
        });
        this.entityCache.clear();
        this.mountWidgets.clear();
        this.filterWidgets.clear();
        this.scrollOffset = 0;
        this.showFilterMenu = false;
        this.selectedMount = null;
        this.searchBox = null;
        this.calculateLayout();
        if (Config.guiShowSearchBox) {
            this.createSearchWidget();
        }
        this.createStaticWidgets();
        if (Config.enableModernUi) {
            this.createModernWidgets();
        }
        if (Config.guiShowFilterButton) {
            this.createFilterSubWidgets();
        }
        if (this.originalMountInfos.isEmpty()) {
            PacketMountListRequest.send();
        }
    }

    private void calculateLayout() {
        this.slotWidth = Math.min((int)((double)this.width * 0.6), 400);
        this.buttonWidth = Math.max(60, (int)((double)this.slotWidth * 0.25));
        this.buttonHeight = 20;
        this.slotHeight = 60;
        int startY = 40;
        int availableHeight = this.height - startY - 100;
        int slotFullHeight = this.slotHeight + 8;
        this.visibleSlots = Config.enableModernUi ? 14 : Math.max(3, availableHeight / slotFullHeight);
    }

    private void createSearchWidget() {
        int boxY;
        int boxX;
        int boxWidth;
        int boxHeight = 20;
        if (Config.enableModernUi) {
            int leftPos = (this.width - 256) / 2;
            int topPos = (this.height - 256) / 2;
            boxWidth = Config.guiSearchBoxWidth == -1 ? 85 : Config.guiSearchBoxWidth;
            boxX = Config.guiSearchBoxX == -1 ? leftPos + 15 : Config.guiSearchBoxX;
            boxY = Config.guiSearchBoxY == -1 ? topPos + 10 : Config.guiSearchBoxY;
        } else {
            int startX = (this.width - this.slotWidth) / 2;
            int gap = 4;
            int availableWidth = this.slotWidth;
            int defaultWidth = Config.guiShowFilterButton ? availableWidth / 2 - gap : availableWidth;
            boxWidth = Config.guiSearchBoxWidth == -1 ? defaultWidth : Config.guiSearchBoxWidth;
            boxX = Config.guiSearchBoxX == -1 ? startX + availableWidth - boxWidth : Config.guiSearchBoxX;
            boxY = Config.guiSearchBoxY == -1 ? Config.guiFilterButtonY : Config.guiSearchBoxY;
        }
        this.searchBox = new EditBox(this.font, boxX, boxY, boxWidth, boxHeight, (Component)Component.literal((String)"Search"));
        this.searchBox.setMaxLength(50);
        this.searchBox.setBordered(true);
        this.searchBox.setVisible(true);
        this.searchBox.setTextColor(Config.guiSearchTextColor);
        this.searchBox.setResponder(value -> this.applyFiltersAndSort());
        this.addRenderableWidget((GuiEventListener)this.searchBox);
    }

    public void onReceiveMountList(List<PacketMountListResponse.MountInfo> infos) {
        this.originalMountInfos.clear();
        this.originalMountInfos.addAll(infos);
        this.entityCache.values().forEach(entity -> {
            if (entity != null) {
                entity.remove(Entity.RemovalReason.DISCARDED);
            }
        });
        this.entityCache.clear();
        if (Config.enableModernUi && !infos.isEmpty()) {
            this.selectedMount = infos.getFirst();
        }
        this.applyFiltersAndSort();
    }

    private void applyFiltersAndSort() {
        Stream<Object> stream = this.originalMountInfos.stream();
        if (this.searchBox != null && !this.searchBox.getValue().isEmpty()) {
            String query = this.searchBox.getValue().toLowerCase();
            stream = stream.filter(info -> info.customName().toLowerCase().contains(query));
        }
        if (Config.guiShowFilterButton) {
            stream = stream.filter(info -> {
                String type;
                String string = type = info.mountType() != null ? info.mountType().toUpperCase() : "GROUND";
                if (this.filterGround && "GROUND".equals(type)) {
                    return true;
                }
                if (this.filterAquatic && "AQUATIC".equals(type)) {
                    return true;
                }
                if (this.filterFlying && "FLYING".equals(type)) {
                    return true;
                }
                return !type.equals("GROUND") && !type.equals("AQUATIC") && !type.equals("FLYING");
            });
        }
        stream = !Config.guiShowFilterButton || this.sortType == SortType.BY_NAME ? stream.sorted(Comparator.comparing(PacketMountListResponse.MountInfo::customName)) : stream.sorted(Comparator.comparingDouble(PacketMountListResponse.MountInfo::speedModifier).reversed());
        this.displayedMountInfos.clear();
        stream.forEach(this.displayedMountInfos::add);
        if (Config.enableModernUi) {
            if (this.selectedMount != null && !this.displayedMountInfos.contains(this.selectedMount)) {
                this.selectedMount = !this.displayedMountInfos.isEmpty() ? this.displayedMountInfos.getFirst() : null;
            } else if (this.selectedMount == null && !this.displayedMountInfos.isEmpty()) {
                this.selectedMount = this.displayedMountInfos.getFirst();
            }
        }
        if (!Config.enableModernUi) {
            this.clearMountWidgets();
            this.createMountWidgets();
            this.updateMountWidgetPositions();
        }
        this.scrollOffset = 0;
    }

    private void createStaticWidgets() {
        int closeY;
        int closeX;
        int filterX = 0;
        int filterY = 0;
        int filterWidth = 100;
        int filterHeight = 20;
        if (Config.guiShowFilterButton) {
            if (Config.enableModernUi) {
                int leftPos = (this.width - 256) / 2;
                int topPos = (this.height - 256) / 2;
                filterX = leftPos + 178 - filterWidth / 2;
                filterY = topPos + 10;
            } else {
                filterX = Config.guiShowSearchBox && Config.guiSearchBoxX == -1 && this.searchBox != null ? (this.width - this.slotWidth) / 2 : (Config.guiFilterButtonX == -1 ? (this.width - filterWidth) / 2 : Config.guiFilterButtonX);
                filterY = Config.guiFilterButtonY;
            }
            Button.OnPress onFilterPress = btn -> {
                this.showFilterMenu = !this.showFilterMenu;
                this.updateFilterWidgetsVisibility();
            };
            MutableComponent msg = Component.literal((String)Config.guiFilterButtonText);
            this.filterButton = Config.enableGuiCustomFilterButton ? new ImageButton(filterX, filterY, filterWidth, filterHeight, (Component)msg, Config.enableTextOnCustomButtons, ResourceLocation.tryParse((String)Config.guiFilterButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiFilterButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiFilterButtonTextureClicked), onFilterPress) : Button.builder((Component)msg, (Button.OnPress)onFilterPress).bounds(filterX, filterY, filterWidth, filterHeight).build();
            this.addRenderableWidget((GuiEventListener)this.filterButton);
        }
        final ResourceLocation closeTex = ResourceLocation.tryParse((String)Config.setGuiMenuTextureCloseButton);
        final ResourceLocation closeHoverTex = ResourceLocation.tryParse((String)Config.setGuiMenuTextureCloseButtonHovered);
        int closeSize = 20;
        if (Config.enableModernUi) {
            if (Config.guiShowFilterButton) {
                closeX = filterX + filterWidth + 5;
                closeY = filterY;
            } else {
                int leftPos = (this.width - 256) / 2;
                int topPos = (this.height - 256) / 2;
                closeX = leftPos + 256 - closeSize - 10;
                closeY = topPos + 10;
            }
        } else {
            closeX = this.width - closeSize - Config.guiCloseButtonXOffsetRight;
            closeY = Config.guiCloseButtonYOffsetTop;
        }
        this.addRenderableWidget((GuiEventListener)new AbstractButton(closeX, closeY, closeSize, closeSize, (Component)Component.empty()){

            public void onPress() {
                if (UIMenu.this.minecraft != null) {
                    UIMenu.this.minecraft.setScreen(null);
                }
            }

            public void renderWidget(@NotNull GuiGraphics gui, int mx, int my, float pt) {
                ResourceLocation tex;
                RenderSystem.enableBlend();
                ResourceLocation resourceLocation = tex = this.isHoveredOrFocused() ? closeHoverTex : closeTex;
                if (tex != null) {
                    gui.blit(tex, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
                }
                RenderSystem.disableBlend();
            }

            protected void updateWidgetNarration(@NotNull NarrationElementOutput o) {
                this.defaultButtonNarrationText(o);
            }
        });
    }

    private void createModernWidgets() {
        int btnWidth = 100;
        int btnHeight = 20;
        int leftPos = (this.width - 256) / 2;
        int topPos = (this.height - 256) / 2;
        int btnX = leftPos + 178 - btnWidth / 2;
        int btnY = topPos + 210;
        MutableComponent rideMsg = Component.literal((String)Config.guiRideButtonText).withStyle(Style.EMPTY.withColor(Config.guiRideButtonTextColor));
        Button.OnPress onPress = btn -> {
            if (this.selectedMount != null) {
                PacketUiMountRequest.send(this.selectedMount.customName());
                Minecraft.getInstance().setScreen(null);
            }
        };
        this.modernSummonButton = Config.enableGuiCustomRideButton ? new ImageButton(btnX, btnY, btnWidth, btnHeight, (Component)rideMsg, Config.enableTextOnCustomButtons, ResourceLocation.tryParse((String)Config.guiRideButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiRideButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiRideButtonTextureClicked), onPress) : Button.builder((Component)rideMsg, (Button.OnPress)onPress).bounds(btnX, btnY, btnWidth, btnHeight).build();
        this.addRenderableWidget((GuiEventListener)this.modernSummonButton);
    }

    private void createFilterSubWidgets() {
        int filterWidgetWidth = 100;
        int filterWidgetHeight = 20;
        this.filterPanelX = this.filterButton.getX();
        int currentY = this.filterPanelY = this.filterButton.getY() + this.filterButton.getHeight() + 2;
        MutableComponent groundMsg = Component.literal((String)"Ground: ON");
        Button.OnPress groundPress = btn -> {
            this.filterGround = !this.filterGround;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.filterGroundButton = this.createFilterSubButton((Component)groundMsg, groundPress, currentY, filterWidgetWidth, filterWidgetHeight);
        this.filterWidgets.add((AbstractWidget)this.filterGroundButton);
        MutableComponent aquaticMsg = Component.literal((String)"Aquatic: ON");
        Button.OnPress aquaticPress = btn -> {
            this.filterAquatic = !this.filterAquatic;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.filterAquaticButton = this.createFilterSubButton((Component)aquaticMsg, aquaticPress, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight);
        this.filterWidgets.add((AbstractWidget)this.filterAquaticButton);
        MutableComponent flyingMsg = Component.literal((String)"Flying: ON");
        Button.OnPress flyingPress = btn -> {
            this.filterFlying = !this.filterFlying;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.filterFlyingButton = this.createFilterSubButton((Component)flyingMsg, flyingPress, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight);
        this.filterWidgets.add((AbstractWidget)this.filterFlyingButton);
        MutableComponent sortMsg = Component.literal((String)"Sort: Name");
        Button.OnPress sortPress = btn -> {
            this.sortType = this.sortType == SortType.BY_NAME ? SortType.BY_SPEED : SortType.BY_NAME;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.sortButton = this.createFilterSubButton((Component)sortMsg, sortPress, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight);
        this.filterWidgets.add((AbstractWidget)this.sortButton);
        this.filterPanelWidth = filterWidgetWidth;
        this.filterPanelHeight = currentY + filterWidgetHeight - this.filterPanelY;
        this.filterWidgets.forEach(w -> {
            w.visible = false;
            this.addRenderableWidget((GuiEventListener)w);
        });
    }

    private Button createFilterSubButton(Component msg, Button.OnPress press, int y, int w, int h) {
        if (Config.enableGuiCustomFilterSubButton) {
            return new ImageButton(this.filterPanelX, y, w, h, msg, true, ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureClicked), press);
        }
        return Button.builder((Component)msg, (Button.OnPress)press).bounds(this.filterPanelX, y, w, h).build();
    }

    private void updateFilterWidgetsVisibility() {
        if (!Config.guiShowFilterButton) {
            return;
        }
        this.filterWidgets.forEach(w -> {
            w.visible = this.showFilterMenu;
        });
    }

    private void updateFilterButtonText() {
        if (!Config.guiShowFilterButton) {
            return;
        }
        this.filterGroundButton.setMessage((Component)Component.literal((String)("Ground: " + (this.filterGround ? "ON" : "OFF"))));
        this.filterAquaticButton.setMessage((Component)Component.literal((String)("Aquatic: " + (this.filterAquatic ? "ON" : "OFF"))));
        this.filterFlyingButton.setMessage((Component)Component.literal((String)("Flying: " + (this.filterFlying ? "ON" : "OFF"))));
        this.sortButton.setMessage((Component)Component.literal((String)("Sort: " + (this.sortType == SortType.BY_NAME ? "Name" : "Speed"))));
    }

    private void clearMountWidgets() {
        this.renderables.removeAll(this.mountWidgets);
        this.children().removeAll(this.mountWidgets);
        this.mountWidgets.clear();
    }

    private void createMountWidgets() {
        for (PacketMountListResponse.MountInfo info : this.displayedMountInfos) {
            Button.OnPress onPress = btn -> {
                PacketUiMountRequest.send(info.customName());
                Minecraft.getInstance().setScreen(null);
            };
            MutableComponent rideMsg = Component.literal((String)Config.guiRideButtonText).withStyle(Style.EMPTY.withColor(Config.guiRideButtonTextColor));
            Button button = Config.enableGuiCustomRideButton ? new ImageButton(0, 0, this.buttonWidth, this.buttonHeight, (Component)rideMsg, Config.enableTextOnCustomButtons, ResourceLocation.tryParse((String)Config.guiRideButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiRideButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiRideButtonTextureClicked), onPress) : Button.builder((Component)rideMsg, (Button.OnPress)onPress).bounds(0, 0, this.buttonWidth, this.buttonHeight).build();
            button.visible = false;
            this.addRenderableWidget((GuiEventListener)button);
            this.mountWidgets.add((AbstractWidget)button);
        }
    }

    private void updateMountWidgetPositions() {
        int startX = (this.width - this.slotWidth) / 2;
        int startY = 40;
        for (int i = 0; i < this.mountWidgets.size(); ++i) {
            AbstractWidget widget = this.mountWidgets.get(i);
            int slotIndex = i - this.scrollOffset;
            if (slotIndex >= 0 && slotIndex < this.visibleSlots) {
                widget.setX(startX + this.slotWidth - this.buttonWidth);
                widget.setY(startY + slotIndex * (this.slotHeight + 8) + (this.slotHeight - this.buttonHeight) / 2);
                widget.visible = true;
                continue;
            }
            widget.visible = false;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (Config.guiShowFilterButton && this.showFilterMenu) {
            return false;
        }
        int maxScroll = Math.max(0, this.displayedMountInfos.size() - this.visibleSlots);
        if (deltaY < 0.0 && this.scrollOffset < maxScroll) {
            ++this.scrollOffset;
            if (!Config.enableModernUi) {
                this.updateMountWidgetPositions();
            }
        } else if (deltaY > 0.0 && this.scrollOffset > 0) {
            --this.scrollOffset;
            if (!Config.enableModernUi) {
                this.updateMountWidgetPositions();
            }
        }
        return true;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (super.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (Config.guiShowFilterButton && this.showFilterMenu && (pMouseX < (double)this.filterPanelX || pMouseX > (double)(this.filterPanelX + this.filterPanelWidth) || pMouseY < (double)this.filterPanelY || pMouseY > (double)(this.filterPanelY + this.filterPanelHeight))) {
            this.showFilterMenu = false;
            this.updateFilterWidgetsVisibility();
            return true;
        }
        if (Config.enableModernUi) {
            int idx;
            int leftPos = (this.width - 256) / 2;
            int topPos = (this.height - 256) / 2;
            int listXStart = leftPos + 15;
            int listXEnd = leftPos + 100;
            int startY = topPos + 35;
            for (int i = 0; i < this.visibleSlots && (idx = this.scrollOffset + i) < this.displayedMountInfos.size(); ++i) {
                int itemY = startY + i * 15;
                if (!(pMouseX >= (double)listXStart) || !(pMouseX <= (double)listXEnd) || !(pMouseY >= (double)itemY) || !(pMouseY < (double)(itemY + 15))) continue;
                this.selectedMount = this.displayedMountInfos.get(idx);
                return true;
            }
        }
        return false;
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float pt) {
        this.renderBackground(gui, mouseX, mouseY, pt);
        if (BACKGROUND_TEXTURE != null) {
            if (Config.enableModernUi) {
                int leftPos = (this.width - 256) / 2;
                int topPos = (this.height - 256) / 2;
                gui.blit(BACKGROUND_TEXTURE, leftPos, topPos, 0.0f, 0.0f, 256, 256, 256, 256);
            } else {
                gui.blit(BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            }
        }
        if (Config.enableModernUi) {
            this.renderModernInterface(gui, mouseX, mouseY);
        } else {
            this.renderBasicInterface(gui, mouseX, mouseY, pt);
        }
        for (Renderable renderable : this.renderables) {
            if (this.filterWidgets.contains(renderable)) continue;
            renderable.render(gui, mouseX, mouseY, pt);
        }
        if (Config.guiShowFilterButton && this.showFilterMenu) {
            gui.fill(this.filterPanelX, this.filterPanelY, this.filterPanelX + this.filterPanelWidth, this.filterPanelY + this.filterPanelHeight, Config.guiFilterPanelColor);
            for (AbstractWidget widget : this.filterWidgets) {
                widget.render(gui, mouseX, mouseY, pt);
            }
        }
    }

    private void renderBasicInterface(GuiGraphics gui, int mouseX, int mouseY, float pt) {
        int idx;
        int startX = (this.width - this.slotWidth) / 2;
        int startY = 40;
        for (int i = 0; i < this.visibleSlots && (idx = this.scrollOffset + i) < this.displayedMountInfos.size(); ++i) {
            String typeString;
            PacketMountListResponse.MountInfo info = this.displayedMountInfos.get(idx);
            int y = startY + i * (this.slotHeight + 8);
            gui.fill(startX, y, startX + this.slotWidth, y + this.slotHeight, Config.guiSlotBackgroundColor);
            Entity entityToRender = this.getOrCreateCachedEntity(info);
            int entityScale = this.slotHeight / 3;
            float relativeMouseX = mouseX - (startX + 40);
            float relativeMouseY = (float)mouseY - ((float)y + (float)this.slotHeight / 2.0f + 5.0f);
            this.drawEntityOnScreen(gui, startX + 40, y + this.slotHeight / 2 + 5, entityScale, relativeMouseX, relativeMouseY, entityToRender);
            MutableComponent nameComponent = Component.literal((String)info.customName());
            gui.drawString(this.font, (Component)nameComponent, startX + 80, y + 10, Config.guiMountNameTextColor);
            this.renderMountDetailsCommon(gui, info, startX + 80, y + 22, this.slotWidth - 80 - this.buttonWidth - 10, mouseX, mouseY);
            if (!Config.guiShowMountType) continue;
            int nameWidth = this.font.width((FormattedText)nameComponent);
            String string = typeString = info.mountType() != null ? info.mountType().toUpperCase() : "GROUND";
            int color = "AQUATIC".equals(typeString) ? Config.guiMountTypeAquaticTextColor : ("FLYING".equals(typeString) ? Config.guiMountTypeFlyingTextColor : Config.guiMountTypeGroundTextColor);
            gui.drawString(this.font, (Component)Component.literal((String)(" [" + typeString + "]")), startX + 80 + nameWidth, y + 10, color);
        }
        this.renderScrollbar(gui, startX + this.slotWidth + 4, startY);
    }

    private void renderModernInterface(GuiGraphics gui, int mouseX, int mouseY) {
        int idx;
        int leftPos = (this.width - 256) / 2;
        int topPos = (this.height - 256) / 2;
        int listX = leftPos + 15;
        int listY = topPos + 35;
        int lineHeight = 15;
        for (int i = 0; i < this.visibleSlots && (idx = this.scrollOffset + i) < this.displayedMountInfos.size(); ++i) {
            int color;
            PacketMountListResponse.MountInfo info = this.displayedMountInfos.get(idx);
            boolean isSelected = this.selectedMount == info;
            int n = color = isSelected ? Config.guiModernListSelectedColor : Config.guiModernListNormalColor;
            if (!isSelected && mouseX >= listX && mouseX <= listX + 80 && mouseY >= listY && mouseY < listY + lineHeight) {
                color = Config.guiModernListHoverColor;
            }
            if (isSelected) {
                gui.drawString(this.font, ">", listX - 8, listY, Config.guiModernListSelectedColor);
            }
            String name = this.font.plainSubstrByWidth(info.customName(), 85);
            gui.drawString(this.font, name, listX, listY, color);
            listY += lineHeight;
        }
        if (this.displayedMountInfos.size() > this.visibleSlots) {
            this.renderScrollbar(gui, leftPos + 105, topPos + 35);
        }
        if (this.selectedMount != null) {
            String typeStr;
            int centerX = leftPos + 178;
            int headerY = topPos + 35;
            gui.drawCenteredString(this.font, this.selectedMount.customName(), centerX, headerY, Config.guiMountNameTextColor);
            String string = typeStr = this.selectedMount.mountType() != null ? this.selectedMount.mountType().toUpperCase() : "GROUND";
            int typeColor = "AQUATIC".equals(typeStr) ? Config.guiMountTypeAquaticTextColor : ("FLYING".equals(typeStr) ? Config.guiMountTypeFlyingTextColor : Config.guiMountTypeGroundTextColor);
            gui.drawCenteredString(this.font, typeStr, centerX, headerY + 12, typeColor);
            int bottomAnchorY = topPos + 205;
            int maxTextWidth = 100;
            int statsY = bottomAnchorY - 30;
            this.renderMountDetailsCommon(gui, this.selectedMount, centerX - 50, statsY, maxTextWidth, mouseX, mouseY);
            int entityY = statsY - 10;
            Entity entity = this.getOrCreateCachedEntity(this.selectedMount);
            this.drawEntityOnScreen(gui, centerX, entityY, 45, (float)centerX - (float)mouseX, (float)(entityY - 40) - (float)mouseY, entity);
            if (this.modernSummonButton != null) {
                this.modernSummonButton.visible = true;
            }
        } else {
            if (this.modernSummonButton != null) {
                this.modernSummonButton.visible = false;
            }
            gui.drawCenteredString(this.font, "Select a mount...", leftPos + 178, topPos + 120, 0x808080);
        }
    }

    private void renderMountDetailsCommon(GuiGraphics gui, PacketMountListResponse.MountInfo info, int x, int y, int maxWidth, int mouseX, int mouseY) {
        String description;
        int currentY = y;
        if (Config.guiShowMountSpeed) {
            if (Config.guiShowSpeedAsBar) {
                double maxSpeed = Config.mountMaxSpeed > 0.0 ? Config.mountMaxSpeed : 3.0;
                double currentSpeed = Math.min(info.speedModifier(), maxSpeed);
                float ratio = (float)(currentSpeed / maxSpeed);
                int barHeight = 5;
                gui.fill(x, currentY + 2, x + maxWidth, currentY + 2 + barHeight, Config.guiSpeedBarEmptyColor);
                gui.fill(x, currentY + 2, x + (int)((float)maxWidth * ratio), currentY + 2 + barHeight, Config.guiSpeedBarFilledColor);
                if (mouseX >= x && mouseX <= x + maxWidth && mouseY >= currentY + 2 && mouseY <= currentY + 2 + barHeight) {
                    MutableComponent tooltip = Component.literal((String)("Speed: " + String.format("%.2f", info.speedModifier())));
                    gui.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
                }
            } else {
                gui.drawString(this.font, String.format("Speed: %.2f", info.speedModifier()), x, currentY, Config.guiSpeedTextColor);
            }
            currentY += 10;
        }
        if ((description = info.description()) != null && !description.isEmpty()) {
            Object truncatedDesc = this.font.plainSubstrByWidth(description, maxWidth);
            if (!((String)truncatedDesc).equals(description)) {
                truncatedDesc = (String)truncatedDesc + "...";
            }
            gui.drawString(this.font, (String)truncatedDesc, x, currentY, Config.guiDescriptionTextColor);
            currentY += 10;
        }
        String costItem = info.costItem();
        int costAmount = info.costAmount();
        if (costItem != null && !costItem.isEmpty() && costAmount > 0) {
            Optional item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)costItem));
            String itemName = item.map(it -> it.getDescription().getString()).orElse(costItem);
            String costText = "Cost: " + costAmount + "x " + itemName;
            gui.drawString(this.font, this.font.plainSubstrByWidth(costText, maxWidth), x, currentY, Config.guiCostTextColor);
        }
    }

    private void renderScrollbar(GuiGraphics gui, int x, int y) {
        if (this.displayedMountInfos.size() > this.visibleSlots) {
            int itemHeight = Config.enableModernUi ? 15 : this.slotHeight + 8;
            int barHeight = this.visibleSlots * itemHeight;
            if (!Config.enableModernUi) {
                barHeight -= 8;
            }
            gui.fill(x, y, x + 4, y + barHeight, -14671840);
            int cursorHeight = Math.max(barHeight * this.visibleSlots / this.displayedMountInfos.size(), 10);
            int maxOffset = this.displayedMountInfos.size() - this.visibleSlots;
            int cursorY = y;
            if (maxOffset > 0) {
                cursorY = y + (barHeight - cursorHeight) * this.scrollOffset / maxOffset;
            }
            gui.fill(x, cursorY, x + 4, cursorY + cursorHeight, Config.guiScrollbarColor);
        }
    }

    public void drawEntityOnScreen(GuiGraphics guiGraphics, int x, int y, int scale, float mouseX, float mouseY, Entity entity) {
        if (entity == null) {
            return;
        }
        float targetRotY = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        float targetRotX = (float)Math.atan(mouseY / 40.0f) * 20.0f;
        this.currentRotY += (targetRotY - this.currentRotY) * 0.1f;
        this.currentRotX += (targetRotX - this.currentRotX) * 0.1f;
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 100.0f);
        pose.scale((float)scale, (float)scale, (float)scale);
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        entity.setYRot(this.currentRotY);
        entity.setXRot(this.currentRotX);
        EntityRenderDispatcher disp = Minecraft.getInstance().getEntityRenderDispatcher();
        disp.setRenderShadow(false);
        MultiBufferSource.BufferSource buf = Minecraft.getInstance().renderBuffers().bufferSource();
        disp.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pose, (MultiBufferSource)buf, 0xF000F0);
        buf.endBatch();
        pose.popPose();
        disp.setRenderShadow(true);
    }

    public boolean isPauseScreen() {
        return false;
    }

    private Entity getOrCreateCachedEntity(PacketMountListResponse.MountInfo info) {
        Entity e;
        if (this.entityCache.containsKey(info.customName())) {
            return this.entityCache.get(info.customName());
        }
        if (this.minecraft == null || this.minecraft.level == null) {
            return null;
        }
        EntityType type = EntityType.byString((String)info.entityId()).orElse(null);
        if (type != null && (e = type.create((Level)this.minecraft.level)) != null) {
            if (info.nbtData() != null && !info.nbtData().isEmpty()) {
                try {
                    CompoundTag tag = TagParser.parseTag((String)info.nbtData());
                    e.load(tag);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            e.setPos(0.0, 0.0, 0.0);
            this.entityCache.put(info.customName(), e);
            return e;
        }
        this.entityCache.put(info.customName(), null);
        return null;
    }

    private static enum SortType {
        BY_NAME,
        BY_SPEED;

    }

    private static class ImageButton
    extends Button {
        private final ResourceLocation textureNormal;
        private final ResourceLocation textureHovered;
        private final ResourceLocation textureClicked;
        private final boolean showText;
        private boolean isPressed;

        public ImageButton(int x, int y, int w, int h, Component msg, boolean txt, ResourceLocation n, ResourceLocation ho, ResourceLocation c, Button.OnPress p) {
            super(x, y, w, h, msg, p, DEFAULT_NARRATION);
            this.textureNormal = n;
            this.textureHovered = ho;
            this.textureClicked = c;
            this.showText = txt;
        }

        public void onClick(double mx, double my) {
            this.isPressed = true;
            super.onClick(mx, my);
        }

        public void onRelease(double mx, double my) {
            super.onRelease(mx, my);
            this.isPressed = false;
        }

        public void renderWidget(@NotNull GuiGraphics gui, int mx, int my, float pt) {
            ResourceLocation tex;
            ResourceLocation resourceLocation = this.isPressed && this.isHoveredOrFocused() ? this.textureClicked : (tex = this.isHoveredOrFocused() ? this.textureHovered : this.textureNormal);
            if (tex != null) {
                RenderSystem.enableBlend();
                gui.blit(tex, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
                RenderSystem.disableBlend();
            }
            if (this.showText) {
                gui.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, this.getFGColor() | (int)(this.alpha * 255.0f) << 24);
            }
        }

        public void updateWidgetNarration(@NotNull NarrationElementOutput o) {
            this.defaultButtonNarrationText(o);
        }
    }
}

