/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.items;

import fr.mod.epicka.Config;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.Objects;
import net.minecraft.ChatFormatting;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ItemMountUnlocker
extends Item {
    public ItemMountUnlocker(Item.Properties pProperties) {
        super(pProperties);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        player.startUsingItem(hand);
        return InteractionResultHolder.consume((Object)stack);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        CustomData customData = (CustomData)stack.get(DataComponents.CUSTOM_DATA);
        if (customData == null) {
            player.sendSystemMessage((Component)Component.literal((String)"This unlocker item has no data.").withStyle(ChatFormatting.RED));
            return stack;
        }
        CompoundTag nbt = customData.copyTag();
        if (!nbt.contains("MountData", 10)) {
            player.sendSystemMessage((Component)Component.literal((String)"This unlocker item is corrupted or misconfigured.").withStyle(ChatFormatting.RED));
            return stack;
        }
        CompoundTag mountData = nbt.getCompound("MountData");
        String entityId = mountData.getString("entity_id");
        String customName = mountData.getString("customName");
        double speed = mountData.getDouble("speed");
        String type = mountData.getString("type");
        String nbtData = mountData.getString("nbt");
        if (entityId.isEmpty() || customName.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)"This unlocker item is missing required data (entity_id, customName).").withStyle(ChatFormatting.RED));
            return stack;
        }
        if (Config.mountBlacklist.contains(entityId)) {
            player.sendSystemMessage((Component)Component.literal((String)("This entity is blacklisted: " + entityId)).withStyle(ChatFormatting.RED));
            return stack;
        }
        if (!BuiltInRegistries.ENTITY_TYPE.containsKey(Objects.requireNonNull(ResourceLocation.tryParse((String)entityId)))) {
            player.sendSystemMessage((Component)Component.literal((String)("Entity ID not found: " + entityId)).withStyle(ChatFormatting.RED));
            return stack;
        }
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.getUUID());
        if (cfg == null) {
            return stack;
        }
        if (cfg.mounts.containsKey(customName)) {
            player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] You have already unlocked a mount named '" + customName + "'.")).withStyle(ChatFormatting.RED));
            return stack;
        }
        if (!nbtData.isEmpty()) {
            try {
                CompoundTag parsedTag = TagParser.parseTag((String)nbtData);
                parsedTag.remove("Pos");
                parsedTag.remove("Motion");
                parsedTag.remove("UUID");
                parsedTag.remove("Passengers");
                nbtData = parsedTag.toString();
            }
            catch (Exception e) {
                nbtData = "";
                player.sendSystemMessage((Component)Component.literal((String)"Warning: Invalid NBT data in unlocker, mount will be default.").withStyle(ChatFormatting.YELLOW));
            }
        }
        double finalSpeed = speed;
        if (Config.mountMaxSpeed > 0.0) {
            finalSpeed = Math.min(finalSpeed, Config.mountMaxSpeed);
        }
        JsonPlayer.MountEntry entry = new JsonPlayer.MountEntry(entityId, true, customName, nbtData, finalSpeed, type, null, null, 0, null, 0);
        cfg.mounts.put(customName, entry);
        PlayerConfigCache.savePlayer(player.getUUID());
        player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] You have unlocked a new mount: '" + customName + "'!")).withStyle(ChatFormatting.GREEN));
        if (!player.getAbilities().instabuild) {
            stack.shrink(1);
        }
        return stack;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }
}

