/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.entity.MountController;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public record PacketDismountRequest() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketDismountRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"epicka", (String)"dismount_request"));
    public static final StreamCodec<FriendlyByteBuf, PacketDismountRequest> STREAM_CODEC = CustomPacketPayload.codec(PacketDismountRequest::write, PacketDismountRequest::new);
    private static final Map<UUID, Long> COOLDOWNS = new ConcurrentHashMap<UUID, Long>();
    private static final long COOLDOWN_MS = 1000L;

    public PacketDismountRequest(FriendlyByteBuf buf) {
        this();
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToServer(TYPE, STREAM_CODEC, (pkt, ctx) -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sender = (ServerPlayer)patt0$temp;
                ctx.enqueueWork(() -> pkt.handle(sender));
            }
        });
    }

    public static void send() {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketDismountRequest(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void write(FriendlyByteBuf buf) {
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<PacketDismountRequest> type() {
        return TYPE;
    }

    public void handle(ServerPlayer player) {
        long lastRequestTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastRequestTime = COOLDOWNS.getOrDefault(player.getUUID(), 0L).longValue()) < 1000L) {
            return;
        }
        COOLDOWNS.put(player.getUUID(), currentTime);
        Entity mount = MountController.controlledMounts.get(player.getUUID());
        if (mount != null && player.getVehicle() == mount) {
            player.stopRiding();
            MountController.cleanupMount(player.getUUID(), mount);
        }
    }
}

