/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.entity.MountController;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public record PacketUiMountRequest(String mountCustomName) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUiMountRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"epicka", (String)"ui_mount_request"));
    public static final StreamCodec<FriendlyByteBuf, PacketUiMountRequest> STREAM_CODEC = CustomPacketPayload.codec(PacketUiMountRequest::write, PacketUiMountRequest::new);

    public PacketUiMountRequest(FriendlyByteBuf buf) {
        this(buf.readUtf(Short.MAX_VALUE));
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToServer(TYPE, STREAM_CODEC, (packet, context) -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                context.enqueueWork(() -> packet.handle(player));
            }
        });
    }

    public static void send(String mountCustomName) {
        PacketUiMountRequest pkt = new PacketUiMountRequest(mountCustomName);
        PacketDistributor.sendToServer((CustomPacketPayload)pkt, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.mountCustomName, Short.MAX_VALUE);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<PacketUiMountRequest> type() {
        return TYPE;
    }

    public void handle(ServerPlayer player) {
        MountController.summonMount(player, this.mountCustomName);
    }
}

