/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.UI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.network.PacketMountListRequest;
import fr.mod.epicka.network.PacketMountListResponse;
import fr.mod.epicka.network.PacketUiMountRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class UIMenu
extends Screen {
    private static final int MIN_BUTTON_WIDTH = 60;
    private static final int MIN_BUTTON_HEIGHT = 20;
    private static final int MIN_SLOT_HEIGHT = 60;
    private static final int SLOT_GAP = 8;
    private static final int MAX_SLOT_WIDTH = 400;
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.tryParse((String)Config.setGuiMenuTextureBackground);
    private final List<PacketMountListResponse.MountInfo> originalMountInfos = new ArrayList<PacketMountListResponse.MountInfo>();
    private final List<PacketMountListResponse.MountInfo> displayedMountInfos = new ArrayList<PacketMountListResponse.MountInfo>();
    private final Map<String, Entity> entityCache = new HashMap<String, Entity>();
    private final List<AbstractWidget> mountWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> filterWidgets = new ArrayList<AbstractWidget>();
    private AbstractWidget filterButton;
    private Button filterGroundButton;
    private Button filterAquaticButton;
    private Button filterFlyingButton;
    private Button sortButton;
    private int scrollOffset = 0;
    private int buttonWidth;
    private int buttonHeight;
    private int slotWidth;
    private int slotHeight;
    private int visibleSlots;
    private int filterPanelX;
    private int filterPanelY;
    private int filterPanelWidth;
    private int filterPanelHeight;
    private boolean showFilterMenu = false;
    private boolean filterGround = true;
    private boolean filterAquatic = true;
    private boolean filterFlying = true;
    private SortType sortType = SortType.BY_NAME;
    private float targetRotY = 0.0f;
    private float currentRotY = 0.0f;
    private float targetRotX = 0.0f;
    private float currentRotX = 0.0f;

    public UIMenu() {
        super((Component)Component.empty());
    }

    public void drawEntityOnScreen(GuiGraphics guiGraphics, int x, int y, int scale, float mouseX, float mouseY, Entity entity) {
        if (entity == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        this.targetRotY = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        this.targetRotX = (float)Math.atan(mouseY / 40.0f) * 20.0f;
        this.currentRotY += (this.targetRotY - this.currentRotY) * 0.1f;
        this.currentRotX += (this.targetRotX - this.currentRotX) * 0.1f;
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 100.0f);
        pose.scale((float)scale, (float)scale, (float)scale);
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        entity.setYRot(this.currentRotY);
        entity.setXRot(this.currentRotX);
        EntityRenderDispatcher disp = mc.getEntityRenderDispatcher();
        disp.setRenderShadow(false);
        MultiBufferSource.BufferSource buf = mc.renderBuffers().bufferSource();
        disp.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pose, (MultiBufferSource)buf, 0xF000F0);
        buf.endBatch();
        pose.popPose();
        disp.setRenderShadow(true);
    }

    protected void init() {
        super.init();
        this.originalMountInfos.clear();
        this.displayedMountInfos.clear();
        this.entityCache.clear();
        this.mountWidgets.clear();
        this.filterWidgets.clear();
        this.scrollOffset = 0;
        this.showFilterMenu = false;
        this.calculateLayout();
        this.createStaticWidgets();
        if (Config.guiShowFilterButton) {
            this.createFilterWidgets();
        }
        PacketMountListRequest.send();
    }

    private void calculateLayout() {
        this.slotWidth = Math.min((int)((double)this.width * 0.6), 400);
        this.buttonWidth = Math.max(60, (int)((double)this.slotWidth * 0.25));
        this.buttonHeight = 20;
        this.slotHeight = 60;
        int startY = 40;
        int availableHeight = this.height - startY - 100;
        int slotFullHeight = this.slotHeight + 8;
        this.visibleSlots = Math.max(3, availableHeight / slotFullHeight);
    }

    public void onReceiveMountList(List<PacketMountListResponse.MountInfo> infos) {
        this.originalMountInfos.clear();
        this.originalMountInfos.addAll(infos);
        this.entityCache.clear();
        this.applyFiltersAndSort();
    }

    private void applyFiltersAndSort() {
        Stream<Object> stream = Config.guiShowFilterButton ? this.originalMountInfos.stream().filter(info -> {
            String type;
            String string = type = info.mountType() != null ? info.mountType().toUpperCase() : "GROUND";
            if (this.filterGround && "GROUND".equals(type)) {
                return true;
            }
            if (this.filterAquatic && "AQUATIC".equals(type)) {
                return true;
            }
            if (this.filterFlying && "FLYING".equals(type)) {
                return true;
            }
            return !type.equals("GROUND") && !type.equals("AQUATIC") && !type.equals("FLYING");
        }) : this.originalMountInfos.stream();
        stream = !Config.guiShowFilterButton || this.sortType == SortType.BY_NAME ? stream.sorted(Comparator.comparing(PacketMountListResponse.MountInfo::customName)) : stream.sorted(Comparator.comparingDouble(PacketMountListResponse.MountInfo::speedModifier).reversed());
        this.displayedMountInfos.clear();
        stream.forEach(this.displayedMountInfos::add);
        this.clearMountWidgets();
        this.createMountWidgets();
        this.scrollOffset = 0;
        this.updateMountWidgetPositions();
    }

    private void createStaticWidgets() {
        final ResourceLocation closeButtonTexture = ResourceLocation.tryParse((String)Config.setGuiMenuTextureCloseButton);
        final ResourceLocation closeButtonTextureHovered = ResourceLocation.tryParse((String)Config.setGuiMenuTextureCloseButtonHovered);
        int closeButtonSize = 20;
        int closeX = this.width - closeButtonSize - Config.guiCloseButtonXOffsetRight;
        int closeY = Config.guiCloseButtonYOffsetTop;
        this.addRenderableWidget((GuiEventListener)new AbstractButton(closeX, closeY, closeButtonSize, closeButtonSize, (Component)Component.empty()){

            public void onPress() {
                if (UIMenu.this.minecraft != null) {
                    UIMenu.this.minecraft.setScreen(null);
                }
            }

            public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                ResourceLocation texture;
                RenderSystem.enableBlend();
                ResourceLocation resourceLocation = texture = this.isHoveredOrFocused() ? closeButtonTextureHovered : closeButtonTexture;
                if (texture == null) {
                    texture = closeButtonTexture;
                }
                if (texture != null) {
                    pGuiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
                }
                RenderSystem.disableBlend();
            }

            protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
                this.defaultButtonNarrationText(pNarrationElementOutput);
            }
        });
        if (Config.guiShowFilterButton) {
            int filterButtonWidth = 100;
            int filterButtonHeight = 20;
            int filterButtonX = Config.guiFilterButtonX == -1 ? (this.width - filterButtonWidth) / 2 : Config.guiFilterButtonX;
            int filterButtonY = Config.guiFilterButtonY;
            MutableComponent msg = Component.literal((String)Config.guiFilterButtonText);
            Button.OnPress onFilterPress = btn -> {
                this.showFilterMenu = !this.showFilterMenu;
                this.updateFilterWidgetsVisibility();
            };
            this.filterButton = Config.enableGuiCustomFilterButton ? new ImageButton(filterButtonX, filterButtonY, filterButtonWidth, filterButtonHeight, (Component)msg, Config.enableTextOnCustomButtons, ResourceLocation.tryParse((String)Config.guiFilterButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiFilterButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiFilterButtonTextureClicked), onFilterPress) : Button.builder((Component)msg, (Button.OnPress)onFilterPress).bounds(filterButtonX, filterButtonY, filterButtonWidth, filterButtonHeight).build();
            this.addRenderableWidget((GuiEventListener)this.filterButton);
        }
    }

    private void createFilterWidgets() {
        int filterWidgetWidth = 100;
        int filterWidgetHeight = 20;
        this.filterPanelX = this.filterButton.getX();
        int currentY = this.filterPanelY = this.filterButton.getY() + this.filterButton.getHeight() + 2;
        MutableComponent groundMsg = Component.literal((String)"Ground: ON");
        Button.OnPress groundPress = btn -> {
            this.filterGround = !this.filterGround;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.filterGroundButton = Config.enableGuiCustomFilterSubButton ? new ImageButton(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight, (Component)groundMsg, true, ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureClicked), groundPress) : Button.builder((Component)groundMsg, (Button.OnPress)groundPress).bounds(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight).build();
        this.filterWidgets.add((AbstractWidget)this.filterGroundButton);
        MutableComponent aquaticMsg = Component.literal((String)"Aquatic: ON");
        Button.OnPress aquaticPress = btn -> {
            this.filterAquatic = !this.filterAquatic;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.filterAquaticButton = Config.enableGuiCustomFilterSubButton ? new ImageButton(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight, (Component)aquaticMsg, true, ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureClicked), aquaticPress) : Button.builder((Component)aquaticMsg, (Button.OnPress)aquaticPress).bounds(this.filterPanelX, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight).build();
        this.filterWidgets.add((AbstractWidget)this.filterAquaticButton);
        MutableComponent flyingMsg = Component.literal((String)"Flying: ON");
        Button.OnPress flyingPress = btn -> {
            this.filterFlying = !this.filterFlying;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.filterFlyingButton = Config.enableGuiCustomFilterSubButton ? new ImageButton(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight, (Component)flyingMsg, true, ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureClicked), flyingPress) : Button.builder((Component)flyingMsg, (Button.OnPress)flyingPress).bounds(this.filterPanelX, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight).build();
        this.filterWidgets.add((AbstractWidget)this.filterFlyingButton);
        MutableComponent sortMsg = Component.literal((String)"Sort: Name");
        Button.OnPress sortPress = btn -> {
            this.sortType = this.sortType == SortType.BY_NAME ? SortType.BY_SPEED : SortType.BY_NAME;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        };
        this.sortButton = Config.enableGuiCustomFilterSubButton ? new ImageButton(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight, (Component)sortMsg, true, ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiFilterSubButtonTextureClicked), sortPress) : Button.builder((Component)sortMsg, (Button.OnPress)sortPress).bounds(this.filterPanelX, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight).build();
        this.filterWidgets.add((AbstractWidget)this.sortButton);
        this.filterPanelWidth = filterWidgetWidth;
        this.filterPanelHeight = currentY + filterWidgetHeight - this.filterPanelY;
        this.filterWidgets.forEach(w -> {
            w.visible = false;
            this.addRenderableWidget((GuiEventListener)w);
        });
    }

    private void updateFilterWidgetsVisibility() {
        if (!Config.guiShowFilterButton) {
            return;
        }
        this.filterWidgets.forEach(w -> {
            w.visible = this.showFilterMenu;
        });
    }

    private void updateFilterButtonText() {
        if (!Config.guiShowFilterButton) {
            return;
        }
        this.filterGroundButton.setMessage((Component)Component.literal((String)("Ground: " + (this.filterGround ? "ON" : "OFF"))));
        this.filterAquaticButton.setMessage((Component)Component.literal((String)("Aquatic: " + (this.filterAquatic ? "ON" : "OFF"))));
        this.filterFlyingButton.setMessage((Component)Component.literal((String)("Flying: " + (this.filterFlying ? "ON" : "OFF"))));
        this.sortButton.setMessage((Component)Component.literal((String)("Sort: " + (this.sortType == SortType.BY_NAME ? "Name" : "Speed"))));
    }

    private void clearMountWidgets() {
        this.renderables.removeAll(this.mountWidgets);
        this.children().removeAll(this.mountWidgets);
        this.mountWidgets.clear();
    }

    private void createMountWidgets() {
        for (PacketMountListResponse.MountInfo info : this.displayedMountInfos) {
            Button.OnPress onPress = btn -> {
                PacketUiMountRequest.send(info.customName());
                Minecraft.getInstance().setScreen(null);
            };
            MutableComponent rideMsg = Component.literal((String)Config.guiRideButtonText).withStyle(Style.EMPTY.withColor(Config.guiRideButtonTextColor));
            Button button = Config.enableGuiCustomRideButton ? new ImageButton(0, 0, this.buttonWidth, this.buttonHeight, (Component)rideMsg, Config.enableTextOnCustomButtons, ResourceLocation.tryParse((String)Config.guiRideButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiRideButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiRideButtonTextureClicked), onPress) : Button.builder((Component)rideMsg, (Button.OnPress)onPress).bounds(0, 0, this.buttonWidth, this.buttonHeight).build();
            button.visible = false;
            this.addRenderableWidget((GuiEventListener)button);
            this.mountWidgets.add((AbstractWidget)button);
        }
    }

    private void updateMountWidgetPositions() {
        int startX = (this.width - this.slotWidth) / 2;
        int startY = 40;
        for (int i = 0; i < this.mountWidgets.size(); ++i) {
            AbstractWidget widget = this.mountWidgets.get(i);
            int slotIndex = i - this.scrollOffset;
            if (slotIndex >= 0 && slotIndex < this.visibleSlots) {
                widget.setX(startX + this.slotWidth - this.buttonWidth);
                widget.setY(startY + slotIndex * (this.slotHeight + 8) + (this.slotHeight - this.buttonHeight) / 2);
                widget.visible = true;
                continue;
            }
            widget.visible = false;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (Config.guiShowFilterButton && this.showFilterMenu) {
            return false;
        }
        int maxScroll = Math.max(0, this.displayedMountInfos.size() - this.visibleSlots);
        if (deltaY < 0.0 && this.scrollOffset < maxScroll) {
            ++this.scrollOffset;
            this.updateMountWidgetPositions();
        } else if (deltaY > 0.0 && this.scrollOffset > 0) {
            --this.scrollOffset;
            this.updateMountWidgetPositions();
        }
        return true;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (super.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (Config.guiShowFilterButton && this.showFilterMenu && (pMouseX < (double)this.filterPanelX || pMouseX > (double)(this.filterPanelX + this.filterPanelWidth) || pMouseY < (double)this.filterPanelY || pMouseY > (double)(this.filterPanelY + this.filterPanelHeight))) {
            this.showFilterMenu = false;
            this.updateFilterWidgetsVisibility();
            return true;
        }
        return false;
    }

    public void renderBackground(@NotNull GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (BACKGROUND_TEXTURE != null) {
            gui.blit(BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        } else {
            super.renderBackground(gui, mouseX, mouseY, delta);
        }
    }

    private Entity getOrCreateCachedEntity(PacketMountListResponse.MountInfo info) {
        Entity cachedEntity = this.entityCache.get(info.customName());
        if (cachedEntity != null) {
            return cachedEntity;
        }
        if (this.minecraft == null || this.minecraft.level == null) {
            return null;
        }
        EntityType type = EntityType.byString((String)info.entityId()).orElse(null);
        if (type != null) {
            Entity e = type.create((Level)this.minecraft.level);
            if (e != null) {
                if (info.nbtData() != null && !info.nbtData().isEmpty()) {
                    try {
                        CompoundTag tag = TagParser.parseTag((String)info.nbtData());
                        e.load(tag);
                    }
                    catch (Exception ex) {
                        Epicka.LOGGER.error("Failed to parse NBT for client entity {}", (Object)info.customName(), (Object)ex);
                    }
                }
                e.setPos(0.0, 0.0, 0.0);
            }
            this.entityCache.put(info.customName(), e);
            return e;
        }
        this.entityCache.put(info.customName(), null);
        return null;
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float pt) {
        int idx;
        this.renderBackground(gui, mouseX, mouseY, pt);
        int startX = (this.width - this.slotWidth) / 2;
        int startY = 40;
        for (int i = 0; i < this.visibleSlots && (idx = this.scrollOffset + i) < this.displayedMountInfos.size(); ++i) {
            String description;
            PacketMountListResponse.MountInfo info = this.displayedMountInfos.get(idx);
            int y = startY + i * (this.slotHeight + 8);
            gui.fill(startX, y, startX + this.slotWidth, y + this.slotHeight, Config.guiSlotBackgroundColor);
            Entity entityToRender = this.getOrCreateCachedEntity(info);
            int entityScale = this.slotHeight / 3;
            float relativeMouseX = mouseX - (startX + 40);
            float relativeMouseY = (float)mouseY - ((float)y + (float)this.slotHeight / 2.0f + 5.0f);
            this.drawEntityOnScreen(gui, startX + 40, y + this.slotHeight / 2 + 5, entityScale, relativeMouseX, relativeMouseY, entityToRender);
            MutableComponent nameComponent = Component.literal((String)info.customName());
            gui.drawString(this.font, (Component)nameComponent, startX + 80, y + 10, Config.guiMountNameTextColor);
            if (Config.guiShowMountType) {
                int nameWidth = this.font.width((FormattedText)nameComponent);
                String typeString = info.mountType() != null ? info.mountType().toUpperCase() : "GROUND";
                MutableComponent typeComponent = Component.literal((String)(" [" + typeString + "]"));
                int color = Config.guiMountNameTextColor;
                color = switch (typeString) {
                    case "GROUND" -> Config.guiMountTypeGroundTextColor;
                    case "AQUATIC" -> Config.guiMountTypeAquaticTextColor;
                    case "FLYING" -> Config.guiMountTypeFlyingTextColor;
                    default -> color;
                };
                gui.drawString(this.font, (Component)typeComponent, startX + 80 + nameWidth, y + 10, color);
            }
            int textY = y + 22;
            int maxTextWidth = this.slotWidth - 80 - this.buttonWidth - 10;
            if (Config.guiShowMountSpeed) {
                String speedText = String.format("Speed: %.2f", info.speedModifier());
                gui.drawString(this.font, speedText, startX + 80, textY, Config.guiSpeedTextColor);
                textY += 12;
            }
            if ((description = info.description()) != null && !description.isEmpty()) {
                Object truncatedDesc = this.font.plainSubstrByWidth(description, maxTextWidth);
                if (!((String)truncatedDesc).equals(description)) {
                    truncatedDesc = ((String)truncatedDesc).substring(0, Math.max(0, ((String)truncatedDesc).length() - 3)) + "...";
                }
                gui.drawString(this.font, (String)truncatedDesc, startX + 80, textY, Config.guiDescriptionTextColor);
                textY += 12;
            }
            String costItem = info.costItem();
            int costAmount = info.costAmount();
            if (costItem == null || costItem.isEmpty() || costAmount <= 0) continue;
            Optional item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)costItem));
            String itemName = item.map(it -> it.getDescription().getString()).orElse(costItem);
            String costText = String.format("Cost: %dx %s", costAmount, itemName);
            Object truncatedCost = this.font.plainSubstrByWidth(costText, maxTextWidth);
            if (!((String)truncatedCost).equals(costText)) {
                truncatedCost = ((String)truncatedCost).substring(0, Math.max(0, ((String)truncatedCost).length() - 3)) + "...";
            }
            gui.drawString(this.font, (String)truncatedCost, startX + 80, textY, Config.guiCostTextColor);
        }
        if (this.displayedMountInfos.size() > this.visibleSlots) {
            int barX = startX + this.slotWidth + 4;
            int barHeight = this.visibleSlots * (this.slotHeight + 8) - 8;
            gui.fill(barX, startY, barX + 6, startY + barHeight, -14671840);
            int cursorHeight = Math.max(barHeight * this.visibleSlots / this.displayedMountInfos.size(), 10);
            int maxOffset = this.displayedMountInfos.size() - this.visibleSlots;
            int cursorY = startY;
            if (maxOffset > 0) {
                cursorY = startY + (barHeight - cursorHeight) * this.scrollOffset / maxOffset;
            }
            gui.fill(barX, cursorY, barX + 6, cursorY + cursorHeight, Config.guiScrollbarColor);
        }
        for (Renderable renderable : this.renderables) {
            if (this.filterWidgets.contains(renderable)) continue;
            renderable.render(gui, mouseX, mouseY, pt);
        }
        if (Config.guiShowFilterButton && this.showFilterMenu) {
            gui.fill(this.filterPanelX, this.filterPanelY, this.filterPanelX + this.filterPanelWidth, this.filterPanelY + this.filterPanelHeight, Config.guiFilterPanelColor);
            for (AbstractWidget widget : this.filterWidgets) {
                widget.render(gui, mouseX, mouseY, pt);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void resize(@NotNull Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
    }

    private static enum SortType {
        BY_NAME,
        BY_SPEED;

    }

    private static class ImageButton
    extends Button {
        private final ResourceLocation textureNormal;
        private final ResourceLocation textureHovered;
        private final ResourceLocation textureClicked;
        private final boolean showText;
        private boolean isPressed;

        public ImageButton(int x, int y, int width, int height, Component message, boolean showText, ResourceLocation textureNormal, ResourceLocation textureHovered, ResourceLocation textureClicked, Button.OnPress onPress) {
            super(x, y, width, height, message, onPress, DEFAULT_NARRATION);
            this.textureNormal = textureNormal;
            this.textureHovered = textureHovered;
            this.textureClicked = textureClicked;
            this.isPressed = false;
            this.showText = showText;
        }

        public void onClick(double pMouseX, double pMouseY) {
            this.isPressed = true;
            super.onClick(pMouseX, pMouseY);
        }

        public void onRelease(double pMouseX, double pMouseY) {
            super.onRelease(pMouseX, pMouseY);
            this.isPressed = false;
        }

        protected void onDrag(double pMouseX, double pMouseY, double pDragX, double pDragY) {
            if (!this.isHovered) {
                this.isPressed = false;
            }
            super.onDrag(pMouseX, pMouseY, pDragX, pDragY);
        }

        public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            ResourceLocation texture = this.isPressed && this.isHoveredOrFocused() ? this.textureClicked : (this.isHoveredOrFocused() ? this.textureHovered : this.textureNormal);
            if (texture == null) {
                return;
            }
            RenderSystem.enableBlend();
            pGuiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            RenderSystem.disableBlend();
            if (this.showText) {
                int j = this.getFGColor();
                pGuiGraphics.drawCenteredString(Minecraft.getInstance().font, this.getMessage(), this.getX() + this.width / 2, this.getY() + (this.height - 8) / 2, j | (int)(this.alpha * 255.0f) << 24);
            }
        }

        public void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
            this.defaultButtonNarrationText(pNarrationElementOutput);
        }
    }
}

