/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka;

import com.mojang.logging.LogUtils;
import fr.mod.epicka.Config;
import fr.mod.epicka.items.ItemRegister;
import fr.mod.epicka.keybind.Keybinds;
import fr.mod.epicka.network.PacketDismountRequest;
import fr.mod.epicka.network.PacketGui;
import fr.mod.epicka.network.PacketMount;
import fr.mod.epicka.network.PacketMountListRequest;
import fr.mod.epicka.network.PacketMountListResponse;
import fr.mod.epicka.network.PacketUiMountRequest;
import fr.mod.epicka.tabs.ModCreativeTabs;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLLoader;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.slf4j.Logger;

@Mod(value="epicka")
public class Epicka {
    public static final String MODID = "epicka";
    public static final String COMMAND_ID = "rpgmounts";
    public static final Logger LOGGER = LogUtils.getLogger();

    public Epicka(ModContainer container, IEventBus modEventBus) {
        modEventBus.addListener(this::commonSetup);
        ItemRegister.ITEMS.register(modEventBus);
        ModCreativeTabs.CREATIVE_MODE_TABS.register(modEventBus);
        modEventBus.addListener(this::onRegisterPayloadHandlers);
        NeoForge.EVENT_BUS.register((Object)this);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)Config.SPEC);
        if (FMLLoader.getDist() == Dist.CLIENT) {
            modEventBus.addListener(this::onRegisterKeyMappings);
            NeoForge.EVENT_BUS.register(Keybinds.class);
        }
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    private void onRegisterPayloadHandlers(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar(MODID).versioned("1");
        PacketGui.register(registrar);
        PacketMount.register(registrar);
        PacketUiMountRequest.register(registrar);
        PacketMountListRequest.register(registrar);
        PacketMountListResponse.register(registrar);
        PacketDismountRequest.register(registrar);
    }

    private void onRegisterKeyMappings(RegisterKeyMappingsEvent event) {
        Keybinds.registerKeys(event);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
        LOGGER.info("[epicka] Loaded");
    }
}

