/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.UI;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.network.PacketMountListRequest;
import fr.mod.epicka.network.PacketMountListResponse;
import fr.mod.epicka.network.PacketUiMountRequest;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

@OnlyIn(value=Dist.CLIENT)
public class UIMenu
extends Screen {
    private static final int MIN_BUTTON_WIDTH = 60;
    private static final int MIN_BUTTON_HEIGHT = 20;
    private static final int MIN_SLOT_HEIGHT = 60;
    private static final int SLOT_GAP = 8;
    private static final int MAX_SLOT_WIDTH = 400;
    private static final ResourceLocation BACKGROUND_TEXTURE = ResourceLocation.tryParse((String)Config.setGuiMenuTextureBackground);
    private final List<PacketMountListResponse.MountInfo> originalMountInfos = new ArrayList<PacketMountListResponse.MountInfo>();
    private final List<PacketMountListResponse.MountInfo> displayedMountInfos = new ArrayList<PacketMountListResponse.MountInfo>();
    private final List<Entity> displayedMountEntities = new ArrayList<Entity>();
    private final List<AbstractWidget> mountWidgets = new ArrayList<AbstractWidget>();
    private final List<AbstractWidget> filterWidgets = new ArrayList<AbstractWidget>();
    private AbstractWidget filterButton;
    private Button filterGroundButton;
    private Button filterAquaticButton;
    private Button filterFlyingButton;
    private Button sortButton;
    private int scrollOffset = 0;
    private int buttonWidth;
    private int buttonHeight;
    private int slotWidth;
    private int slotHeight;
    private int visibleSlots;
    private int filterPanelX;
    private int filterPanelY;
    private int filterPanelWidth;
    private int filterPanelHeight;
    private boolean showFilterMenu = false;
    private boolean filterGround = true;
    private boolean filterAquatic = true;
    private boolean filterFlying = true;
    private SortType sortType = SortType.BY_NAME;

    public UIMenu() {
        super((Component)Component.empty());
    }

    public static void drawEntityOnScreen(GuiGraphics guiGraphics, int x, int y, int scale, float mouseX, float mouseY, Entity entity) {
        if (entity == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        PoseStack pose = guiGraphics.pose();
        pose.pushPose();
        pose.translate((float)x, (float)y, 100.0f);
        pose.scale((float)scale, (float)scale, (float)scale);
        pose.mulPose(Axis.ZP.rotationDegrees(180.0f));
        float ry = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        float rx = (float)Math.atan(mouseY / 40.0f) * 20.0f;
        entity.setYRot(ry);
        entity.setXRot(rx);
        EntityRenderDispatcher disp = mc.getEntityRenderDispatcher();
        disp.setRenderShadow(false);
        MultiBufferSource.BufferSource buf = mc.renderBuffers().bufferSource();
        disp.render(entity, 0.0, 0.0, 0.0, 0.0f, 1.0f, pose, (MultiBufferSource)buf, 0xF000F0);
        buf.endBatch();
        pose.popPose();
        disp.setRenderShadow(true);
    }

    protected void init() {
        super.init();
        this.originalMountInfos.clear();
        this.displayedMountInfos.clear();
        this.displayedMountEntities.clear();
        this.mountWidgets.clear();
        this.filterWidgets.clear();
        this.scrollOffset = 0;
        this.showFilterMenu = false;
        this.calculateLayout();
        this.createStaticWidgets();
        if (Config.guiShowFilterButton) {
            this.createFilterWidgets();
        }
        PacketMountListRequest.send();
    }

    private void calculateLayout() {
        this.slotWidth = Math.min((int)((double)this.width * 0.6), 400);
        this.buttonWidth = Math.max(60, (int)((double)this.slotWidth * 0.25));
        this.buttonHeight = 20;
        this.slotHeight = 60;
        int startY = 40;
        int availableHeight = this.height - startY - 100;
        int slotFullHeight = this.slotHeight + 8;
        this.visibleSlots = Math.max(3, availableHeight / slotFullHeight);
    }

    public void onReceiveMountList(List<PacketMountListResponse.MountInfo> infos) {
        this.originalMountInfos.clear();
        this.originalMountInfos.addAll(infos);
        this.applyFiltersAndSort();
    }

    private void applyFiltersAndSort() {
        Stream<Object> stream = Config.guiShowFilterButton ? this.originalMountInfos.stream().filter(info -> {
            String type;
            String string = type = info.mountType() != null ? info.mountType().toUpperCase() : "GROUND";
            if (this.filterGround && "GROUND".equals(type)) {
                return true;
            }
            if (this.filterAquatic && "AQUATIC".equals(type)) {
                return true;
            }
            if (this.filterFlying && "FLYING".equals(type)) {
                return true;
            }
            return !type.equals("GROUND") && !type.equals("AQUATIC") && !type.equals("FLYING");
        }) : this.originalMountInfos.stream();
        stream = !Config.guiShowFilterButton || this.sortType == SortType.BY_NAME ? stream.sorted(Comparator.comparing(PacketMountListResponse.MountInfo::customName)) : stream.sorted(Comparator.comparingDouble(PacketMountListResponse.MountInfo::speedModifier).reversed());
        this.displayedMountInfos.clear();
        stream.forEach(this.displayedMountInfos::add);
        this.displayedMountEntities.clear();
        Minecraft mc = Minecraft.getInstance();
        for (PacketMountListResponse.MountInfo info2 : this.displayedMountInfos) {
            EntityType type = EntityType.byString((String)info2.entityId()).orElse(null);
            if (type != null && mc.level != null) {
                Entity e = type.create((Level)mc.level);
                if (e != null) {
                    if (info2.nbtData() != null && !info2.nbtData().isEmpty()) {
                        try {
                            CompoundTag tag = TagParser.parseTag((String)info2.nbtData());
                            e.load(tag);
                        }
                        catch (Exception ex) {
                            Epicka.LOGGER.error("Failed to parse NBT for client entity {}", (Object)info2.customName(), (Object)ex);
                        }
                    }
                    e.setPos(0.0, 0.0, 0.0);
                }
                this.displayedMountEntities.add(e);
                continue;
            }
            this.displayedMountEntities.add(null);
        }
        this.clearMountWidgets();
        this.createMountWidgets();
        this.scrollOffset = 0;
        this.updateMountWidgetPositions();
    }

    private void createStaticWidgets() {
        final ResourceLocation closeButtonTexture = ResourceLocation.tryParse((String)Config.setGuiMenuTextureCloseButton);
        final ResourceLocation closeButtonTextureHovered = ResourceLocation.tryParse((String)Config.setGuiMenuTextureCloseButtonHovered);
        int closeButtonSize = 20;
        int closeX = this.width - closeButtonSize - Config.guiCloseButtonXOffsetRight;
        int closeY = Config.guiCloseButtonYOffsetTop;
        this.addRenderableWidget((GuiEventListener)new AbstractButton(closeX, closeY, closeButtonSize, closeButtonSize, (Component)Component.empty()){

            public void onPress() {
                if (UIMenu.this.minecraft != null) {
                    UIMenu.this.minecraft.setScreen(null);
                }
            }

            public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
                ResourceLocation texture;
                RenderSystem.enableBlend();
                ResourceLocation resourceLocation = texture = this.isHoveredOrFocused() ? closeButtonTextureHovered : closeButtonTexture;
                if (texture == null) {
                    texture = closeButtonTexture;
                }
                if (texture != null) {
                    pGuiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
                }
                RenderSystem.disableBlend();
            }

            protected void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
                this.defaultButtonNarrationText(pNarrationElementOutput);
            }
        });
        if (Config.guiShowFilterButton) {
            int filterButtonWidth = 100;
            int filterButtonHeight = 20;
            int filterButtonX = Config.guiFilterButtonX == -1 ? (this.width - filterButtonWidth) / 2 : Config.guiFilterButtonX;
            int filterButtonY = Config.guiFilterButtonY;
            Button.OnPress onFilterPress = btn -> {
                this.showFilterMenu = !this.showFilterMenu;
                this.updateFilterWidgetsVisibility();
            };
            this.filterButton = Config.enableGuiCustomFilterButton ? new ImageButton(filterButtonX, filterButtonY, filterButtonWidth, filterButtonHeight, ResourceLocation.tryParse((String)Config.guiFilterButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiFilterButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiFilterButtonTextureClicked), onFilterPress) : Button.builder((Component)Component.literal((String)Config.guiFilterButtonText), (Button.OnPress)onFilterPress).bounds(filterButtonX, filterButtonY, filterButtonWidth, filterButtonHeight).build();
            this.addRenderableWidget((GuiEventListener)this.filterButton);
        }
    }

    private void createFilterWidgets() {
        int filterWidgetWidth = 100;
        int filterWidgetHeight = 20;
        this.filterPanelX = this.filterButton.getX();
        int currentY = this.filterPanelY = this.filterButton.getY() + this.filterButton.getHeight() + 2;
        this.filterGroundButton = Button.builder((Component)Component.literal((String)"Ground: ON"), btn -> {
            this.filterGround = !this.filterGround;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        }).bounds(this.filterPanelX, currentY, filterWidgetWidth, filterWidgetHeight).build();
        this.filterWidgets.add((AbstractWidget)this.filterGroundButton);
        this.filterAquaticButton = Button.builder((Component)Component.literal((String)"Aquatic: ON"), btn -> {
            this.filterAquatic = !this.filterAquatic;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        }).bounds(this.filterPanelX, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight).build();
        this.filterWidgets.add((AbstractWidget)this.filterAquaticButton);
        this.filterFlyingButton = Button.builder((Component)Component.literal((String)"Flying: ON"), btn -> {
            this.filterFlying = !this.filterFlying;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        }).bounds(this.filterPanelX, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight).build();
        this.filterWidgets.add((AbstractWidget)this.filterFlyingButton);
        this.sortButton = Button.builder((Component)Component.literal((String)"Sort: Name"), btn -> {
            this.sortType = this.sortType == SortType.BY_NAME ? SortType.BY_SPEED : SortType.BY_NAME;
            this.applyFiltersAndSort();
            this.updateFilterButtonText();
        }).bounds(this.filterPanelX, currentY += filterWidgetHeight, filterWidgetWidth, filterWidgetHeight).build();
        this.filterWidgets.add((AbstractWidget)this.sortButton);
        this.filterPanelWidth = filterWidgetWidth;
        this.filterPanelHeight = currentY + filterWidgetHeight - this.filterPanelY;
        this.filterWidgets.forEach(w -> {
            w.visible = false;
            this.addRenderableWidget((GuiEventListener)w);
        });
    }

    private void updateFilterWidgetsVisibility() {
        if (!Config.guiShowFilterButton) {
            return;
        }
        this.filterWidgets.forEach(w -> {
            w.visible = this.showFilterMenu;
        });
    }

    private void updateFilterButtonText() {
        if (!Config.guiShowFilterButton) {
            return;
        }
        this.filterGroundButton.setMessage((Component)Component.literal((String)("Ground: " + (this.filterGround ? "ON" : "OFF"))));
        this.filterAquaticButton.setMessage((Component)Component.literal((String)("Aquatic: " + (this.filterAquatic ? "ON" : "OFF"))));
        this.filterFlyingButton.setMessage((Component)Component.literal((String)("Flying: " + (this.filterFlying ? "ON" : "OFF"))));
        this.sortButton.setMessage((Component)Component.literal((String)("Sort: " + (this.sortType == SortType.BY_NAME ? "Name" : "Speed"))));
    }

    private void clearMountWidgets() {
        this.renderables.removeAll(this.mountWidgets);
        this.children().removeAll(this.mountWidgets);
        this.mountWidgets.clear();
    }

    private void createMountWidgets() {
        for (PacketMountListResponse.MountInfo info : this.displayedMountInfos) {
            Button.OnPress onPress = btn -> {
                PacketUiMountRequest.send(info.customName());
                Minecraft.getInstance().setScreen(null);
            };
            ImageButton button = Config.enableGuiCustomRideButton ? new ImageButton(0, 0, this.buttonWidth, this.buttonHeight, ResourceLocation.tryParse((String)Config.guiRideButtonTextureNormal), ResourceLocation.tryParse((String)Config.guiRideButtonTextureHovered), ResourceLocation.tryParse((String)Config.guiRideButtonTextureClicked), onPress) : Button.builder((Component)Component.literal((String)Config.guiRideButtonText).withStyle(Style.EMPTY.withColor(Config.guiRideButtonTextColor)), (Button.OnPress)onPress).bounds(0, 0, this.buttonWidth, this.buttonHeight).build();
            ((AbstractWidget)button).visible = false;
            this.addRenderableWidget((GuiEventListener)button);
            this.mountWidgets.add((AbstractWidget)button);
        }
    }

    private void updateMountWidgetPositions() {
        int startX = (this.width - this.slotWidth) / 2;
        int startY = 40;
        for (int i = 0; i < this.mountWidgets.size(); ++i) {
            AbstractWidget widget = this.mountWidgets.get(i);
            int slotIndex = i - this.scrollOffset;
            if (slotIndex >= 0 && slotIndex < this.visibleSlots) {
                widget.setX(startX + this.slotWidth - this.buttonWidth);
                widget.setY(startY + slotIndex * (this.slotHeight + 8) + (this.slotHeight - this.buttonHeight) / 2);
                widget.visible = true;
                continue;
            }
            widget.visible = false;
        }
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double deltaX, double deltaY) {
        if (Config.guiShowFilterButton && this.showFilterMenu) {
            return false;
        }
        int maxScroll = Math.max(0, this.displayedMountEntities.size() - this.visibleSlots);
        if (deltaY < 0.0 && this.scrollOffset < maxScroll) {
            ++this.scrollOffset;
            this.updateMountWidgetPositions();
        } else if (deltaY > 0.0 && this.scrollOffset > 0) {
            --this.scrollOffset;
            this.updateMountWidgetPositions();
        }
        return true;
    }

    public boolean mouseClicked(double pMouseX, double pMouseY, int pButton) {
        if (super.mouseClicked(pMouseX, pMouseY, pButton)) {
            return true;
        }
        if (Config.guiShowFilterButton && this.showFilterMenu && (pMouseX < (double)this.filterPanelX || pMouseX > (double)(this.filterPanelX + this.filterPanelWidth) || pMouseY < (double)this.filterPanelY || pMouseY > (double)(this.filterPanelY + this.filterPanelHeight))) {
            this.showFilterMenu = false;
            this.updateFilterWidgetsVisibility();
            return true;
        }
        return false;
    }

    public void renderBackground(@NotNull GuiGraphics gui, int mouseX, int mouseY, float delta) {
        if (BACKGROUND_TEXTURE != null) {
            gui.blit(BACKGROUND_TEXTURE, 0, 0, 0.0f, 0.0f, this.width, this.height, this.width, this.height);
        } else {
            super.renderBackground(gui, mouseX, mouseY, delta);
        }
    }

    public void render(@NotNull GuiGraphics gui, int mouseX, int mouseY, float pt) {
        int idx;
        this.renderBackground(gui, mouseX, mouseY, pt);
        int startX = (this.width - this.slotWidth) / 2;
        int startY = 40;
        for (int i = 0; i < this.visibleSlots && (idx = this.scrollOffset + i) < this.displayedMountEntities.size(); ++i) {
            String description;
            int y = startY + i * (this.slotHeight + 8);
            gui.fill(startX, y, startX + this.slotWidth, y + this.slotHeight, Config.guiSlotBackgroundColor);
            int entityScale = this.slotHeight / 3;
            UIMenu.drawEntityOnScreen(gui, startX + 40, y + this.slotHeight / 2 + 5, entityScale, mouseX - (startX + 40), (float)mouseY - ((float)y + (float)this.slotHeight / 2.0f + 5.0f), this.displayedMountEntities.get(idx));
            gui.drawString(this.font, (Component)Component.literal((String)this.displayedMountInfos.get(idx).customName()), startX + 80, y + 10, Config.guiMountNameTextColor);
            int textY = y + 22;
            int maxTextWidth = this.slotWidth - 80 - this.buttonWidth - 10;
            if (Config.guiShowMountSpeed) {
                String speedText = String.format("Speed: %.2f", this.displayedMountInfos.get(idx).speedModifier());
                gui.drawString(this.font, speedText, startX + 80, textY, Config.guiSpeedTextColor);
                textY += 12;
            }
            if ((description = this.displayedMountInfos.get(idx).description()) != null && !description.isEmpty()) {
                Object truncatedDesc = this.font.plainSubstrByWidth(description, maxTextWidth);
                if (!((String)truncatedDesc).equals(description)) {
                    truncatedDesc = ((String)truncatedDesc).substring(0, Math.max(0, ((String)truncatedDesc).length() - 3)) + "...";
                }
                gui.drawString(this.font, (String)truncatedDesc, startX + 80, textY, Config.guiDescriptionTextColor);
                textY += 12;
            }
            String costItem = this.displayedMountInfos.get(idx).costItem();
            int costAmount = this.displayedMountInfos.get(idx).costAmount();
            if (costItem == null || costItem.isEmpty() || costAmount <= 0) continue;
            Optional item = BuiltInRegistries.ITEM.getOptional(ResourceLocation.tryParse((String)costItem));
            String itemName = item.map(it -> it.getDescription().getString()).orElse(costItem);
            String costText = String.format("Cost: %dx %s", costAmount, itemName);
            Object truncatedCost = this.font.plainSubstrByWidth(costText, maxTextWidth);
            if (!((String)truncatedCost).equals(costText)) {
                truncatedCost = ((String)truncatedCost).substring(0, Math.max(0, ((String)truncatedCost).length() - 3)) + "...";
            }
            gui.drawString(this.font, (String)truncatedCost, startX + 80, textY, Config.guiCostTextColor);
        }
        if (this.displayedMountEntities.size() > this.visibleSlots) {
            int barX = startX + this.slotWidth + 4;
            int barHeight = this.visibleSlots * (this.slotHeight + 8) - 8;
            gui.fill(barX, startY, barX + 6, startY + barHeight, -14671840);
            int cursorHeight = Math.max(barHeight * this.visibleSlots / this.displayedMountEntities.size(), 10);
            int maxOffset = this.displayedMountEntities.size() - this.visibleSlots;
            int cursorY = startY;
            if (maxOffset > 0) {
                cursorY = startY + (barHeight - cursorHeight) * this.scrollOffset / maxOffset;
            }
            gui.fill(barX, cursorY, barX + 6, cursorY + cursorHeight, Config.guiScrollbarColor);
        }
        for (Renderable renderable : this.renderables) {
            if (this.filterWidgets.contains(renderable)) continue;
            renderable.render(gui, mouseX, mouseY, pt);
        }
        if (Config.guiShowFilterButton && this.showFilterMenu) {
            gui.fill(this.filterPanelX, this.filterPanelY, this.filterPanelX + this.filterPanelWidth, this.filterPanelY + this.filterPanelHeight, Config.guiFilterPanelColor);
            for (AbstractWidget widget : this.filterWidgets) {
                widget.render(gui, mouseX, mouseY, pt);
            }
        }
    }

    public boolean isPauseScreen() {
        return false;
    }

    public void resize(@NotNull Minecraft mc, int width, int height) {
        super.resize(mc, width, height);
    }

    private static enum SortType {
        BY_NAME,
        BY_SPEED;

    }

    private static class ImageButton
    extends Button {
        private final ResourceLocation textureNormal;
        private final ResourceLocation textureHovered;
        private final ResourceLocation textureClicked;
        private boolean isPressed;

        public ImageButton(int x, int y, int width, int height, ResourceLocation textureNormal, ResourceLocation textureHovered, ResourceLocation textureClicked, Button.OnPress onPress) {
            super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
            this.textureNormal = textureNormal;
            this.textureHovered = textureHovered;
            this.textureClicked = textureClicked;
            this.isPressed = false;
        }

        public void onClick(double pMouseX, double pMouseY) {
            this.isPressed = true;
            super.onClick(pMouseX, pMouseY);
        }

        public void onRelease(double pMouseX, double pMouseY) {
            super.onRelease(pMouseX, pMouseY);
            this.isPressed = false;
        }

        protected void onDrag(double pMouseX, double pMouseY, double pDragX, double pDragY) {
            if (!this.isHovered) {
                this.isPressed = false;
            }
            super.onDrag(pMouseX, pMouseY, pDragX, pDragY);
        }

        public void renderWidget(@NotNull GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            ResourceLocation texture = this.isPressed && this.isHoveredOrFocused() ? this.textureClicked : (this.isHoveredOrFocused() ? this.textureHovered : this.textureNormal);
            if (texture == null) {
                return;
            }
            RenderSystem.enableBlend();
            pGuiGraphics.blit(texture, this.getX(), this.getY(), 0.0f, 0.0f, this.width, this.height, this.width, this.height);
            RenderSystem.disableBlend();
        }

        public void updateWidgetNarration(@NotNull NarrationElementOutput pNarrationElementOutput) {
            this.defaultButtonNarrationText(pNarrationElementOutput);
        }
    }
}

