/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.entity;

import fr.mod.epicka.Config;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="epicka")
public class MountController {
    public static final Map<UUID, Entity> controlledMounts = new ConcurrentHashMap<UUID, Entity>();
    public static final Set<UUID> jumpRequests = ConcurrentHashMap.newKeySet();
    public static final Set<UUID> swimRequests = ConcurrentHashMap.newKeySet();

    public static void handleControlPacket(UUID playerId, boolean jump, boolean swim) {
        if (jump) {
            jumpRequests.add(playerId);
        }
        if (swim) {
            swimRequests.add(playerId);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        UUID playerUUID = player.getUUID();
        Entity mount = controlledMounts.get(playerUUID);
        if (mount == null) {
            return;
        }
        if (!(mount instanceof LivingEntity)) {
            MountController.cleanupMount(playerUUID, mount);
            return;
        }
        LivingEntity livingMount = (LivingEntity)mount;
        if (player.getVehicle() == livingMount) {
            MountController.processMountMovement(player, livingMount);
        } else {
            String mountType = livingMount.getPersistentData().getString("RpgMounts_Type");
            if (mountType.isEmpty()) {
                mountType = "GROUND";
            }
            if (Config.enableAutoDismountInWater && livingMount.isInWater() && (mountType.equals("GROUND") || mountType.equals("FLYING"))) {
                MountController.cleanupMount(playerUUID, mount);
                return;
            }
            if (!Config.enableSneakDismount) {
                if (livingMount.isAlive() && !livingMount.isRemoved()) {
                    player.startRiding((Entity)livingMount, true);
                } else {
                    MountController.cleanupMount(playerUUID, mount);
                }
            } else {
                MountController.cleanupMount(playerUUID, mount);
            }
        }
    }

    private static void processMountMovement(ServerPlayer player, LivingEntity mount) {
        UUID playerId = player.getUUID();
        if (mount instanceof Mob) {
            Mob mob = (Mob)mount;
            mob.setNoAi(true);
            mob.getNavigation().stop();
        }
        mount.setYRot(player.getYRot());
        mount.setXRot(player.getXRot());
        float forward = player.zza;
        float sideways = player.xxa;
        float yawRad = (float)Math.toRadians(player.getYRot());
        double speedMod = mount.getPersistentData().getDouble("RpgMounts_SpeedMod");
        String mountType = mount.getPersistentData().getString("RpgMounts_Type");
        if (speedMod == 0.0) {
            speedMod = 1.0;
        }
        if (mountType.isEmpty()) {
            mountType = "GROUND";
        }
        if (Config.enableAutoDismountInWater && mount.isInWater() && (mountType.equals("GROUND") || mountType.equals("FLYING"))) {
            player.stopRiding();
            return;
        }
        double speed = 0.3 * (double)Config.multiplyMountSpeed * speedMod;
        double dx = (-Math.sin(yawRad) * (double)forward + Math.cos(yawRad) * (double)sideways) * speed;
        double dz = (Math.cos(yawRad) * (double)forward + Math.sin(yawRad) * (double)sideways) * speed;
        double dy = mount.getDeltaMovement().y;
        boolean jumpPressed = jumpRequests.remove(playerId);
        boolean swimPressed = swimRequests.remove(playerId);
        switch (mountType) {
            case "FLYING": {
                if (mount.onGround()) {
                    dy = MountController.applyGroundMovement(player, mount, dx, dz, dy, forward, jumpPressed);
                    break;
                }
                if (jumpPressed) {
                    dy = 0.4 * speedMod;
                    break;
                }
                if (swimPressed) {
                    dy = -0.4 * speedMod;
                    break;
                }
                if (forward > 0.0f) {
                    dy = dy * 0.95 - 0.01;
                    dy = Math.max(-0.15, dy);
                    break;
                }
                dy = -0.03;
                break;
            }
            case "AQUATIC": {
                if (mount.isInWater()) {
                    dy = 0.0;
                    if (jumpPressed) {
                        dy = 0.3;
                        break;
                    }
                    if (!swimPressed) break;
                    dy = -0.3;
                    break;
                }
                dy = MountController.applyGroundMovement(player, mount, dx, dz, dy, forward, jumpPressed);
                break;
            }
            default: {
                dy = MountController.applyGroundMovement(player, mount, dx, dz, dy, forward, jumpPressed);
            }
        }
        mount.setDeltaMovement(dx, dy, dz);
        mount.move(MoverType.SELF, mount.getDeltaMovement());
    }

    private static double applyGroundMovement(ServerPlayer player, LivingEntity mount, double dx, double dz, double dy, float forward, boolean jumpPressed) {
        double newY = dy;
        if (mount.onGround() && forward > 0.0f) {
            AABB probe = mount.getBoundingBox().expandTowards(dx, 1.0, dz);
            if (!mount.level().noCollision((Entity)mount, probe)) {
                MountController.performJump(mount);
                newY = mount.getDeltaMovement().y;
            }
        }
        if (Config.enableMountJump && jumpPressed && mount.onGround()) {
            MountController.performJump(mount);
            newY = mount.getDeltaMovement().y;
        }
        if (!mount.onGround() && !mount.isInWater()) {
            newY -= 0.08 * (double)Config.multiplyMountGravity;
        }
        if (Config.enableMountClimb && mount.onClimbable()) {
            newY = Math.max(newY, 0.2 * (double)Config.multiplyMountClimb);
        }
        return newY;
    }

    public static void cleanupMount(UUID playerId, Entity mount) {
        if (mount != null && !mount.isRemoved() && mount.hasCustomName() && Objects.requireNonNull(mount.getCustomName()).getString().equals(playerId.toString())) {
            mount.remove(Entity.RemovalReason.DISCARDED);
        }
        controlledMounts.remove(playerId);
        jumpRequests.remove(playerId);
        swimRequests.remove(playerId);
    }

    private static void performJump(LivingEntity mount) {
        mount.jumpFromGround();
        double jumpStrength = 0.5 * Config.multiplyMountJump;
        mount.setDeltaMovement(mount.getDeltaMovement().x, jumpStrength, mount.getDeltaMovement().z);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerUUID = event.getEntity().getUUID();
        Entity mount = controlledMounts.get(playerUUID);
        if (mount != null) {
            MountController.cleanupMount(playerUUID, mount);
        }
    }
}

