/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.json;

import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.json.JsonPlayer;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;

public class PlayerConfigCache {
    private static final Map<UUID, JsonPlayer.PlayerMountConfig> configCache = new ConcurrentHashMap<UUID, JsonPlayer.PlayerMountConfig>();

    public static void loadPlayer(UUID playerUUID) {
        try {
            JsonPlayer.ensureConfigFile(playerUUID);
            JsonPlayer.PlayerMountConfig config = JsonPlayer.loadConfig(playerUUID);
            configCache.put(playerUUID, config);
        }
        catch (IOException e) {
            Epicka.LOGGER.error("[{}] Failed to load and cache config for player {}", new Object[]{Config.chatPrefixText, playerUUID, e});
        }
    }

    public static void unloadPlayer(UUID playerUUID) {
        PlayerConfigCache.savePlayer(playerUUID);
        configCache.remove(playerUUID);
    }

    public static void savePlayer(UUID playerUUID) {
        JsonPlayer.PlayerMountConfig config = configCache.get(playerUUID);
        if (config != null) {
            try {
                JsonPlayer.saveConfig(playerUUID, config);
            }
            catch (IOException e) {
                Epicka.LOGGER.error("[{}] Failed to save config from cache for player {}", new Object[]{Config.chatPrefixText, playerUUID, e});
            }
        }
    }

    public static JsonPlayer.PlayerMountConfig getConfig(UUID playerUUID) {
        return configCache.get(playerUUID);
    }

    public static void updateConfig(UUID playerUUID, JsonPlayer.PlayerMountConfig config) {
        configCache.put(playerUUID, config);
    }
}

