/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import fr.mod.epicka.network.PacketMountListResponse;
import java.util.List;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public record PacketMountListRequest() implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketMountListRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"epicka", (String)"mount_list_request"));
    public static final StreamCodec<FriendlyByteBuf, PacketMountListRequest> STREAM_CODEC = CustomPacketPayload.codec(PacketMountListRequest::write, PacketMountListRequest::new);

    public PacketMountListRequest(FriendlyByteBuf buf) {
        this();
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToServer(TYPE, STREAM_CODEC, (pkt, ctx) -> {
            Player patt0$temp = ctx.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer sender = (ServerPlayer)patt0$temp;
                ctx.enqueueWork(() -> pkt.handle(sender));
            }
        });
    }

    public static void send() {
        PacketDistributor.sendToServer((CustomPacketPayload)new PacketMountListRequest(), (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void write(FriendlyByteBuf buf) {
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<PacketMountListRequest> type() {
        return TYPE;
    }

    public void handle(ServerPlayer player) {
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.getUUID());
        if (cfg != null) {
            List<PacketMountListResponse.MountInfo> enabledMounts = cfg.mounts.stream().filter(e -> e.enable).map(e -> new PacketMountListResponse.MountInfo(e.customName, e.idMonture, e.nbtData, e.speedModifier, e.mountType, e.description != null ? e.description : "", e.costItem != null ? e.costItem : "", e.costAmount)).toList();
            PacketMountListResponse.send(player, enabledMounts);
        }
    }
}

