/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.network;

import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.entity.MountController;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import org.jetbrains.annotations.NotNull;

public record PacketUiMountRequest(String mountCustomName) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<PacketUiMountRequest> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"epicka", (String)"ui_mount_request"));
    public static final StreamCodec<FriendlyByteBuf, PacketUiMountRequest> STREAM_CODEC = CustomPacketPayload.codec(PacketUiMountRequest::write, PacketUiMountRequest::new);
    private static final Map<UUID, Long> cooldowns = new ConcurrentHashMap<UUID, Long>();

    public PacketUiMountRequest(FriendlyByteBuf buf) {
        this(buf.readUtf(Short.MAX_VALUE));
    }

    public static void register(PayloadRegistrar registrar) {
        registrar.playToServer(TYPE, STREAM_CODEC, (packet, context) -> {
            Player patt0$temp = context.player();
            if (patt0$temp instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)patt0$temp;
                context.enqueueWork(() -> packet.handle(player));
            }
        });
    }

    public static void send(String mountCustomName) {
        PacketUiMountRequest pkt = new PacketUiMountRequest(mountCustomName);
        PacketDistributor.sendToServer((CustomPacketPayload)pkt, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public void write(FriendlyByteBuf buf) {
        buf.writeUtf(this.mountCustomName, Short.MAX_VALUE);
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
    @NotNull CustomPacketPayload.Type<PacketUiMountRequest> type() {
        return TYPE;
    }

    public void handle(ServerPlayer player) {
        JsonPlayer.PlayerMountConfig cfg;
        Entity currentMount;
        long cooldownMillis;
        long lastSummonTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastSummonTime = cooldowns.getOrDefault(player.getUUID(), 0L).longValue()) < (cooldownMillis = (long)Config.mountSummonCooldownSeconds * 1000L)) {
            return;
        }
        if (player.getVehicle() != null && (currentMount = MountController.controlledMounts.get(player.getUUID())) != null && currentMount == player.getVehicle()) {
            MountController.cleanupMount(player.getUUID(), currentMount);
        }
        if ((cfg = PlayerConfigCache.getConfig(player.getUUID())) == null) {
            return;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = cfg.mounts.stream().filter(e -> e.enable && e.customName.equals(this.mountCustomName)).findFirst();
        if (entryOpt.isEmpty()) {
            Epicka.LOGGER.warn("[{}] Player {} tried to spawn unauthorized mount: {}", new Object[]{Config.chatPrefixText, player.getName().getString(), this.mountCustomName});
            return;
        }
        JsonPlayer.MountEntry entry = entryOpt.get();
        if (entry.costItem != null && !entry.costItem.isEmpty() && entry.costAmount > 0) {
            ResourceLocation itemRL = ResourceLocation.tryParse((String)entry.costItem);
            if (itemRL == null) {
                Epicka.LOGGER.warn("[{}] Player {} tried to spawn mount {} with invalid cost item ID: {}", new Object[]{Config.chatPrefixText, player.getName().getString(), entry.customName, entry.costItem});
                return;
            }
            Item item = BuiltInRegistries.ITEM.getOptional(itemRL).orElse(Items.AIR);
            if (item == Items.AIR) {
                Epicka.LOGGER.warn("[{}] Player {} tried to spawn mount {} with unknown cost item ID: {}", new Object[]{Config.chatPrefixText, player.getName().getString(), entry.customName, entry.costItem});
                return;
            }
            int itemsInInventory = player.getInventory().countItem(item);
            if (itemsInInventory < entry.costAmount) {
                player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] You need " + entry.costAmount + "x " + item.getDescription().getString() + " (" + (entry.costAmount - itemsInInventory) + " more) to summon this mount.")).withStyle(ChatFormatting.RED));
                return;
            }
            player.getInventory().clearOrCountMatchingItems(s -> s.is(item), entry.costAmount, (Container)player.inventoryMenu.getCraftSlots());
        }
        if (Config.mountBlacklist.contains(entry.idMonture)) {
            Epicka.LOGGER.warn("[{}] Player {} tried to spawn blacklisted mount: {}", new Object[]{Config.chatPrefixText, player.getName().getString(), entry.idMonture});
            return;
        }
        ResourceLocation id = ResourceLocation.tryParse((String)entry.idMonture);
        if (id == null) {
            return;
        }
        EntityType type = EntityType.byString((String)entry.idMonture).orElse(null);
        if (type == null) {
            return;
        }
        ServerLevel level = player.serverLevel();
        Entity ent = type.create((Level)level);
        if (ent == null) {
            return;
        }
        if (entry.nbtData != null && !entry.nbtData.isEmpty()) {
            try {
                CompoundTag tag = TagParser.parseTag((String)entry.nbtData);
                ent.load(tag);
            }
            catch (Exception e2) {
                Epicka.LOGGER.error("[{}] Failed to parse NBT for mount {}", new Object[]{Config.chatPrefixText, entry.customName, e2});
            }
        }
        ent.moveTo(player.getX(), player.getY(), player.getZ(), player.getYRot(), 0.0f);
        if (ent instanceof Mob) {
            Mob mob = (Mob)ent;
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(player.blockPosition()), MobSpawnType.COMMAND, null);
        }
        ent.getPersistentData().putDouble("RpgMounts_SpeedMod", entry.speedModifier);
        ent.getPersistentData().putString("RpgMounts_Type", entry.mountType);
        ent.getPersistentData().putString("RpgMounts_ConfigName", entry.customName);
        if (Config.enableMountSpawnParticles) {
            double px = player.getX();
            double py = player.getY() + 0.5;
            double pz = player.getZ();
            int amount = Config.mountSpawnParticlesAmount;
            switch (Config.enableMountSpawnParticlesType) {
                case 1: {
                    level.sendParticles((ParticleOptions)ParticleTypes.FLAME, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                    break;
                }
                case 2: {
                    level.sendParticles((ParticleOptions)ParticleTypes.HEART, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                    break;
                }
                case 3: {
                    level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, px, py, pz, amount, 0.5, 0.5, 0.5, 0.1);
                    break;
                }
                case 4: {
                    level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                    break;
                }
                case 5: {
                    level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                }
            }
        }
        level.addFreshEntity(ent);
        if (Config.enableMountInvincibility) {
            ent.setInvulnerable(true);
        }
        ent.setCustomName((Component)Component.literal((String)player.getUUID().toString()));
        ent.setCustomNameVisible(false);
        player.startRiding(ent, true);
        MountController.controlledMounts.put(player.getUUID(), ent);
        cooldowns.put(player.getUUID(), currentTime);
    }
}

