/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka;

import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.server.ServerStartedEvent;

@EventBusSubscriber(modid="epicka")
public class CacheEventHandler {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            PlayerConfigCache.loadPlayer(event.getEntity().getUUID());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            PlayerConfigCache.unloadPlayer(event.getEntity().getUUID());
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        Epicka.LOGGER.info("[{}] Server started, scanning for orphaned mounts...", (Object)Config.chatPrefixText);
        int cleanupCount = 0;
        for (ServerLevel level : event.getServer().getAllLevels()) {
            for (Entity entity : level.getEntities().getAll()) {
                if (!entity.hasCustomName() || !entity.getPassengers().isEmpty()) continue;
                try {
                    UUID.fromString(Objects.requireNonNull(entity.getCustomName()).getString());
                    entity.remove(Entity.RemovalReason.DISCARDED);
                    ++cleanupCount;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (cleanupCount > 0) {
            Epicka.LOGGER.info("[{}] Cleaned up {} orphaned mounts.", (Object)Config.chatPrefixText, (Object)cleanupCount);
        }
        if (Config.enableStartupMountValidation) {
            JsonPlayer.validateAndCleanAllConfigs();
        } else {
            Epicka.LOGGER.info("[{}] Skipping validation of player mount configs as per config.", (Object)Config.chatPrefixText);
        }
    }
}

