/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.mod.epicka.Config;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CommandMount {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rpgmounts").requires(src -> src.hasPermission(4))).then(Commands.literal((String)"addbyview").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(((RequiredArgumentBuilder)Commands.argument((String)"customName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandMount.addMountByView((CommandContext<CommandSourceStack>)ctx, 1.0, "GROUND"))).then(((RequiredArgumentBuilder)Commands.argument((String)"speedModifier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(ctx -> CommandMount.addMountByView((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), "GROUND"))).then(Commands.argument((String)"mountType", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(List.of("GROUND", "AQUATIC", "FLYING"), (SuggestionsBuilder)builder)).executes(ctx -> CommandMount.addMountByView((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), StringArgumentType.getString((CommandContext)ctx, (String)"mountType"))))))))).then(Commands.literal((String)"addmount").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"entity_id", (ArgumentType)ResourceLocationArgument.id()).suggests(CommandMount::suggestEntities).then(((RequiredArgumentBuilder)Commands.argument((String)"customName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandMount.addMount((CommandContext<CommandSourceStack>)ctx, 1.0, "GROUND"))).then(((RequiredArgumentBuilder)Commands.argument((String)"speedModifier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(ctx -> CommandMount.addMount((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), "GROUND"))).then(Commands.argument((String)"mountType", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.suggest(List.of("GROUND", "AQUATIC", "FLYING"), (SuggestionsBuilder)builder)).executes(ctx -> CommandMount.addMount((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), StringArgumentType.getString((CommandContext)ctx, (String)"mountType")))))))))).then(Commands.literal((String)"delmount").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).executes(CommandMount::deleteMount))))).then(Commands.literal((String)"setenabled").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).then(Commands.argument((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(CommandMount::setEnabled)))))).then(Commands.literal((String)"setdesc").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).then(Commands.argument((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(CommandMount::setDescription)))))).then(Commands.literal((String)"cleardesc").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).executes(CommandMount::clearDescription))))).then(Commands.literal((String)"setspeed").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).then(Commands.argument((String)"speedModifier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(CommandMount::setSpeed)))))).then(Commands.literal((String)"setcost").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).then(((RequiredArgumentBuilder)Commands.argument((String)"item_id", (ArgumentType)ResourceLocationArgument.id()).suggests((ctx, builder) -> SharedSuggestionProvider.suggestResource((Iterable)BuiltInRegistries.ITEM.keySet(), (SuggestionsBuilder)builder)).executes(ctx -> CommandMount.setCost((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CommandMount.setCost((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"))))))))).then(Commands.literal((String)"clearcost").then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).then(Commands.argument((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).executes(CommandMount::clearCost)))));
    }

    private static CompletableFuture<Suggestions> suggestEntities(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        Stream<String> ids = BuiltInRegistries.ENTITY_TYPE.keySet().stream().map(ResourceLocation::toString);
        return SharedSuggestionProvider.suggest(ids, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestPlayerMounts(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        try {
            ServerPlayer player = EntityArgument.getPlayer(ctx, (String)"player");
            JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.getUUID());
            if (cfg != null) {
                return SharedSuggestionProvider.suggest(cfg.mounts.keySet(), (SuggestionsBuilder)builder);
            }
        }
        catch (CommandSyntaxException e) {
            return Suggestions.empty();
        }
        return Suggestions.empty();
    }

    private static int addMountByView(CommandContext<CommandSourceStack> ctx, double speedModifier, String mountType) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = src.getPlayerOrException();
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        Entity targetEntity = CommandMount.getTargetEntity(player);
        if (targetEntity == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] You must be looking at an entity to copy.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        ResourceLocation id = BuiltInRegistries.ENTITY_TYPE.getKey((Object)targetEntity.getType());
        String sId = id.toString();
        if (Config.mountBlacklist.contains(sId)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] This entity is blacklisted: " + sId)).withStyle(ChatFormatting.RED));
            return 0;
        }
        CompoundTag nbt = targetEntity.saveWithoutId(new CompoundTag());
        String nbtData = nbt.isEmpty() ? "" : nbt.toString();
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.getUUID());
        if (cfg == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        boolean exists = cfg.mounts.containsKey(customName);
        if (exists) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] A mount with the name '" + customName + "' already exists for this player.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        double finalSpeed = speedModifier;
        if (Config.mountMaxSpeed > 0.0) {
            finalSpeed = Math.min(finalSpeed, Config.mountMaxSpeed);
        }
        JsonPlayer.MountEntry entry = new JsonPlayer.MountEntry(sId, true, customName, nbtData, finalSpeed, mountType.toUpperCase(), null, null, 0);
        cfg.mounts.put(customName, entry);
        PlayerConfigCache.updateConfig(target.getUUID(), cfg);
        PlayerConfigCache.savePlayer(target.getUUID());
        src.sendSuccess(() -> Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' (" + sId + ") added to " + target.getName().getString())).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    static int addMount(CommandContext<CommandSourceStack> ctx, double speedModifier, String mountType) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        ResourceLocation id = ResourceLocationArgument.getId(ctx, (String)"entity_id");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        String sId = id.toString();
        if (Config.mountBlacklist.contains(sId)) {
            src.sendFailure((Component)Component.literal((String)("This entity is blacklisted: " + sId)).withStyle(ChatFormatting.RED));
            return 0;
        }
        if (!BuiltInRegistries.ENTITY_TYPE.containsKey(id)) {
            src.sendFailure((Component)Component.literal((String)("Entity ID not found: " + sId)).withStyle(ChatFormatting.RED));
            return 0;
        }
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.getUUID());
        if (cfg == null) {
            src.sendFailure((Component)Component.literal((String)"Player config not loaded.").withStyle(ChatFormatting.RED));
            return 0;
        }
        boolean exists = cfg.mounts.containsKey(customName);
        if (exists) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] A mount with the name '" + customName + "' already exists for this player.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        double finalSpeed = speedModifier;
        if (Config.mountMaxSpeed > 0.0) {
            finalSpeed = Math.min(finalSpeed, Config.mountMaxSpeed);
        }
        JsonPlayer.MountEntry entry = new JsonPlayer.MountEntry(sId, true, customName, "", finalSpeed, mountType.toUpperCase(), null, null, 0);
        cfg.mounts.put(customName, entry);
        PlayerConfigCache.updateConfig(target.getUUID(), cfg);
        PlayerConfigCache.savePlayer(target.getUUID());
        src.sendSuccess(() -> Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' (" + sId + ") added to " + target.getName().getString())).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int deleteMount(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.getUUID());
        if (cfg == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        JsonPlayer.MountEntry removed = cfg.mounts.remove(customName);
        if (removed == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.getName().getString())).withStyle(ChatFormatting.RED));
            return 0;
        }
        PlayerConfigCache.updateConfig(target.getUUID(), cfg);
        PlayerConfigCache.savePlayer(target.getUUID());
        src.sendSuccess(() -> Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' removed from " + target.getName().getString())).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int setEnabled(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        boolean enabled = BoolArgumentType.getBool(ctx, (String)"enabled");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.getUUID());
        if (cfg == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.getName().getString())).withStyle(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().enable = enabled;
        PlayerConfigCache.updateConfig(target.getUUID(), cfg);
        PlayerConfigCache.savePlayer(target.getUUID());
        String action = enabled ? "Enabled" : "Disabled";
        ChatFormatting color = enabled ? ChatFormatting.GREEN : ChatFormatting.RED;
        src.sendSuccess(() -> Component.literal((String)(action + " mount '" + customName + "' for " + target.getName().getString())).withStyle(color), false);
        return 1;
    }

    private static int setDescription(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        String description = StringArgumentType.getString(ctx, (String)"description");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.getUUID());
        if (cfg == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.getName().getString())).withStyle(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().description = description;
        PlayerConfigCache.updateConfig(target.getUUID(), cfg);
        PlayerConfigCache.savePlayer(target.getUUID());
        src.sendSuccess(() -> Component.literal((String)("Set description for mount '" + customName + "' for " + target.getName().getString())).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int clearDescription(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.getUUID());
        if (cfg == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.getName().getString())).withStyle(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().description = null;
        PlayerConfigCache.updateConfig(target.getUUID(), cfg);
        PlayerConfigCache.savePlayer(target.getUUID());
        src.sendSuccess(() -> Component.literal((String)("Cleared description for mount '" + customName + "' for " + target.getName().getString())).withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int setSpeed(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        double effectiveSpeed;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        double speed = DoubleArgumentType.getDouble(ctx, (String)"speedModifier");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.getUUID());
        if (cfg == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.getName().getString())).withStyle(ChatFormatting.RED));
            return 0;
        }
        double speedToApply = speed;
        if (Config.mountMaxSpeed > 0.0) {
            speedToApply = Math.min(speedToApply, Config.mountMaxSpeed);
        }
        entryOpt.get().speedModifier = effectiveSpeed = speedToApply;
        PlayerConfigCache.updateConfig(target.getUUID(), cfg);
        PlayerConfigCache.savePlayer(target.getUUID());
        src.sendSuccess(() -> Component.literal((String)("Set speed for mount '" + customName + "' to " + effectiveSpeed + " for " + target.getName().getString())).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int setCost(CommandContext<CommandSourceStack> ctx, int count) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        ResourceLocation itemId = ResourceLocationArgument.getId(ctx, (String)"item_id");
        Optional itemOpt = BuiltInRegistries.ITEM.getOptional(itemId);
        if (itemOpt.isEmpty() || itemOpt.get() == Items.AIR) {
            src.sendFailure((Component)Component.literal((String)("Invalid item ID: " + String.valueOf(itemId))).withStyle(ChatFormatting.RED));
            return 0;
        }
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.getUUID());
        if (cfg == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.getName().getString())).withStyle(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().costItem = itemId.toString();
        entryOpt.get().costAmount = count;
        PlayerConfigCache.updateConfig(target.getUUID(), cfg);
        PlayerConfigCache.savePlayer(target.getUUID());
        src.sendSuccess(() -> Component.literal((String)("Set cost for mount '" + customName + "' to " + count + "x " + String.valueOf(itemId) + " for " + target.getName().getString())).withStyle(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int clearCost(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.getPlayer(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.getUUID());
        if (cfg == null) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).withStyle(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.sendFailure((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.getName().getString())).withStyle(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().costItem = null;
        entryOpt.get().costAmount = 0;
        PlayerConfigCache.updateConfig(target.getUUID(), cfg);
        PlayerConfigCache.savePlayer(target.getUUID());
        src.sendSuccess(() -> Component.literal((String)("Cleared cost for mount '" + customName + "' for " + target.getName().getString())).withStyle(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static Entity getTargetEntity(ServerPlayer player) {
        Vec3 eyePos = player.getEyePosition();
        Vec3 lookVec = player.getLookAngle();
        Vec3 endPos = eyePos.add(lookVec.scale(10.0));
        AABB searchBox = player.getBoundingBox().expandTowards(lookVec.scale(10.0)).inflate(1.0);
        EntityHitResult hitResult = ProjectileUtil.getEntityHitResult((Level)player.level(), (Entity)player, (Vec3)eyePos, (Vec3)endPos, (AABB)searchBox, e -> !e.isSpectator() && e.isPickable());
        return hitResult != null ? hitResult.getEntity() : null;
    }
}

