/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.entity;

import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="epicka")
public class MountController {
    public static final Map<UUID, Entity> controlledMounts = new ConcurrentHashMap<UUID, Entity>();
    public static final Set<UUID> jumpRequests = ConcurrentHashMap.newKeySet();
    public static final Set<UUID> swimRequests = ConcurrentHashMap.newKeySet();
    private static final Map<UUID, Long> summonCooldowns = new ConcurrentHashMap<UUID, Long>();

    public static void handleControlPacket(UUID playerId, boolean jump, boolean swim) {
        if (jump) {
            jumpRequests.add(playerId);
        }
        if (swim) {
            swimRequests.add(playerId);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Post event) {
        if (event.getEntity().level().isClientSide()) {
            return;
        }
        ServerPlayer player = (ServerPlayer)event.getEntity();
        UUID playerUUID = player.getUUID();
        Entity mount = controlledMounts.get(playerUUID);
        if (mount == null) {
            return;
        }
        if (!(mount instanceof LivingEntity)) {
            MountController.cleanupMount(playerUUID, mount);
            return;
        }
        LivingEntity livingMount = (LivingEntity)mount;
        if (player.getVehicle() == livingMount) {
            MountController.processMountMovement(player, livingMount);
        } else {
            String mountType = livingMount.getPersistentData().getString("RpgMounts_Type");
            if (mountType.isEmpty()) {
                mountType = "GROUND";
            }
            if (Config.enableAutoDismountInWater && livingMount.isInWater() && (mountType.equals("GROUND") || mountType.equals("FLYING"))) {
                MountController.cleanupMount(playerUUID, mount);
                return;
            }
            if (!Config.enableSneakDismount) {
                if (livingMount.isAlive() && !livingMount.isRemoved()) {
                    player.startRiding((Entity)livingMount, true);
                } else {
                    MountController.cleanupMount(playerUUID, mount);
                }
            } else {
                MountController.cleanupMount(playerUUID, mount);
            }
        }
    }

    private static void processMountMovement(ServerPlayer player, LivingEntity mount) {
        UUID playerId = player.getUUID();
        if (mount instanceof Mob) {
            Mob mob = (Mob)mount;
            mob.setNoAi(true);
            mob.getNavigation().stop();
        }
        mount.setYRot(player.getYRot());
        mount.setXRot(player.getXRot());
        float forward = player.zza;
        float sideways = player.xxa;
        float yawRad = (float)Math.toRadians(player.getYRot());
        double speedMod = mount.getPersistentData().getDouble("RpgMounts_SpeedMod");
        String mountType = mount.getPersistentData().getString("RpgMounts_Type");
        if (speedMod == 0.0) {
            speedMod = 1.0;
        }
        if (mountType.isEmpty()) {
            mountType = "GROUND";
        }
        if (Config.enableAutoDismountInWater && mount.isInWater() && (mountType.equals("GROUND") || mountType.equals("FLYING"))) {
            player.stopRiding();
            return;
        }
        double speed = 0.3 * (double)Config.multiplyMountSpeed * speedMod;
        double dx = (-Math.sin(yawRad) * (double)forward + Math.cos(yawRad) * (double)sideways) * speed;
        double dz = (Math.cos(yawRad) * (double)forward + Math.sin(yawRad) * (double)sideways) * speed;
        double dy = mount.getDeltaMovement().y;
        boolean jumpPressed = jumpRequests.remove(playerId);
        boolean swimPressed = swimRequests.remove(playerId);
        switch (mountType) {
            case "FLYING": {
                if (mount.onGround()) {
                    dy = MountController.applyGroundMovement(player, mount, dx, dz, dy, forward, jumpPressed);
                    break;
                }
                if (jumpPressed) {
                    dy = 0.4 * speedMod;
                    break;
                }
                if (swimPressed) {
                    dy = -0.4 * speedMod;
                    break;
                }
                if (forward > 0.0f) {
                    dy = dy * 0.95 - 0.01;
                    dy = Math.max(-0.15, dy);
                    break;
                }
                dy = -0.03;
                break;
            }
            case "AQUATIC": {
                if (mount.isInWater()) {
                    dy = 0.0;
                    if (jumpPressed) {
                        dy = 0.3;
                        break;
                    }
                    if (!swimPressed) break;
                    dy = -0.3;
                    break;
                }
                dy = MountController.applyGroundMovement(player, mount, dx, dz, dy, forward, jumpPressed);
                break;
            }
            default: {
                dy = MountController.applyGroundMovement(player, mount, dx, dz, dy, forward, jumpPressed);
            }
        }
        mount.setDeltaMovement(dx, dy, dz);
        mount.move(MoverType.SELF, mount.getDeltaMovement());
    }

    private static double applyGroundMovement(ServerPlayer player, LivingEntity mount, double dx, double dz, double dy, float forward, boolean jumpPressed) {
        double newY = dy;
        if (mount.onGround() && forward > 0.0f) {
            AABB probe = mount.getBoundingBox().expandTowards(dx, 1.0, dz);
            if (!mount.level().noCollision((Entity)mount, probe)) {
                MountController.performJump(mount);
                newY = mount.getDeltaMovement().y;
            }
        }
        if (Config.enableMountJump && jumpPressed && mount.onGround()) {
            MountController.performJump(mount);
            newY = mount.getDeltaMovement().y;
        }
        if (!mount.onGround() && !mount.isInWater()) {
            newY -= 0.08 * (double)Config.multiplyMountGravity;
        }
        if (Config.enableMountClimb && mount.onClimbable()) {
            newY = Math.max(newY, 0.2 * (double)Config.multiplyMountClimb);
        }
        return newY;
    }

    public static void cleanupMount(UUID playerId, Entity mount) {
        if (mount != null && !mount.isRemoved() && mount.hasCustomName() && Objects.requireNonNull(mount.getCustomName()).getString().equals(playerId.toString())) {
            mount.remove(Entity.RemovalReason.DISCARDED);
        }
        controlledMounts.remove(playerId);
        jumpRequests.remove(playerId);
        swimRequests.remove(playerId);
    }

    private static void performJump(LivingEntity mount) {
        mount.jumpFromGround();
        double jumpStrength = 0.5 * Config.multiplyMountJump;
        mount.setDeltaMovement(mount.getDeltaMovement().x, jumpStrength, mount.getDeltaMovement().z);
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        UUID playerUUID = event.getEntity().getUUID();
        Entity mount = controlledMounts.get(playerUUID);
        if (mount != null) {
            MountController.cleanupMount(playerUUID, mount);
        }
    }

    public static void summonMount(ServerPlayer player, String mountCustomName) {
        JsonPlayer.PlayerMountConfig cfg;
        Entity currentMount;
        long cooldownMillis;
        long lastSummonTime;
        long currentTime = System.currentTimeMillis();
        if (currentTime - (lastSummonTime = summonCooldowns.getOrDefault(player.getUUID(), 0L).longValue()) < (cooldownMillis = (long)Config.mountSummonCooldownSeconds * 1000L)) {
            return;
        }
        if (player.getVehicle() != null && (currentMount = controlledMounts.get(player.getUUID())) != null && currentMount == player.getVehicle()) {
            MountController.cleanupMount(player.getUUID(), currentMount);
        }
        if ((cfg = PlayerConfigCache.getConfig(player.getUUID())) == null) {
            return;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(mountCustomName)).filter(e -> e.enable);
        if (entryOpt.isEmpty()) {
            Epicka.LOGGER.warn("[{}] Player {} tried to spawn unauthorized mount: {}", new Object[]{Config.chatPrefixText, player.getName().getString(), mountCustomName});
            return;
        }
        JsonPlayer.MountEntry entry = entryOpt.get();
        if (entry.costItem != null && !entry.costItem.isEmpty() && entry.costAmount > 0) {
            ResourceLocation itemRL = ResourceLocation.tryParse((String)entry.costItem);
            if (itemRL == null) {
                Epicka.LOGGER.warn("[{}] Player {} tried to spawn mount {} with invalid cost item ID: {}", new Object[]{Config.chatPrefixText, player.getName().getString(), entry.customName, entry.costItem});
                return;
            }
            Item item = BuiltInRegistries.ITEM.getOptional(itemRL).orElse(Items.AIR);
            if (item == Items.AIR) {
                Epicka.LOGGER.warn("[{}] Player {} tried to spawn mount {} with unknown cost item ID: {}", new Object[]{Config.chatPrefixText, player.getName().getString(), entry.customName, entry.costItem});
                return;
            }
            int itemsInInventory = player.getInventory().countItem(item);
            if (itemsInInventory < entry.costAmount) {
                player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] You need " + entry.costAmount + "x " + item.getDescription().getString() + " (" + (entry.costAmount - itemsInInventory) + " more) to summon this mount.")).withStyle(ChatFormatting.RED));
                return;
            }
            player.getInventory().clearOrCountMatchingItems(s -> s.is(item), entry.costAmount, (Container)player.inventoryMenu.getCraftSlots());
        }
        if (Config.mountBlacklist.contains(entry.idMonture)) {
            Epicka.LOGGER.warn("[{}] Player {} tried to spawn blacklisted mount: {}", new Object[]{Config.chatPrefixText, player.getName().getString(), entry.idMonture});
            return;
        }
        ResourceLocation id = ResourceLocation.tryParse((String)entry.idMonture);
        if (id == null) {
            return;
        }
        EntityType type = EntityType.byString((String)entry.idMonture).orElse(null);
        if (type == null) {
            return;
        }
        ServerLevel level = player.serverLevel();
        Entity ent = type.create((Level)level);
        if (ent == null) {
            return;
        }
        if (entry.nbtData != null && !entry.nbtData.isEmpty()) {
            try {
                CompoundTag tag = TagParser.parseTag((String)entry.nbtData);
                ent.load(tag);
            }
            catch (Exception e2) {
                Epicka.LOGGER.error("[{}] Failed to parse NBT for mount {}", new Object[]{Config.chatPrefixText, entry.customName, e2});
            }
        }
        ent.moveTo(player.getX(), player.getY(), player.getZ(), player.getYRot(), 0.0f);
        if (ent instanceof Mob) {
            Mob mob = (Mob)ent;
            mob.finalizeSpawn((ServerLevelAccessor)level, level.getCurrentDifficultyAt(player.blockPosition()), MobSpawnType.COMMAND, null);
        }
        ent.getPersistentData().putDouble("RpgMounts_SpeedMod", entry.speedModifier);
        ent.getPersistentData().putString("RpgMounts_Type", entry.mountType);
        ent.getPersistentData().putString("RpgMounts_ConfigName", entry.customName);
        double px = player.getX();
        double py = player.getY() + 0.5;
        double pz = player.getZ();
        int amount = Config.mountSpawnParticlesAmount;
        switch (Config.mountSpawnParticlesType) {
            case "FLAME": {
                level.sendParticles((ParticleOptions)ParticleTypes.FLAME, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                break;
            }
            case "HEART": {
                level.sendParticles((ParticleOptions)ParticleTypes.HEART, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                break;
            }
            case "PORTAL": {
                level.sendParticles((ParticleOptions)ParticleTypes.PORTAL, px, py, pz, amount, 0.5, 0.5, 0.5, 0.1);
                break;
            }
            case "BUBBLE": {
                level.sendParticles((ParticleOptions)ParticleTypes.BUBBLE, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                break;
            }
            case "SMOKE": {
                level.sendParticles((ParticleOptions)ParticleTypes.LARGE_SMOKE, px, py, pz, amount, 0.5, 0.5, 0.5, 0.05);
                break;
            }
        }
        level.addFreshEntity(ent);
        if (Config.enableMountInvincibility) {
            ent.setInvulnerable(true);
        }
        ent.setCustomName((Component)Component.literal((String)player.getUUID().toString()));
        ent.setCustomNameVisible(false);
        player.startRiding(ent, true);
        controlledMounts.put(player.getUUID(), ent);
        cfg.lastSummonedMount = entry.customName;
        PlayerConfigCache.updateConfig(player.getUUID(), cfg);
        PlayerConfigCache.savePlayer(player.getUUID());
        summonCooldowns.put(player.getUUID(), currentTime);
    }
}

