/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.items;

import fr.mod.epicka.Config;
import fr.mod.epicka.entity.MountController;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.jetbrains.annotations.NotNull;

public class ItemMountFeeder
extends Item {
    private final ModConfigSpec.DoubleValue boostValue;

    public ItemMountFeeder(Item.Properties pProperties, ModConfigSpec.DoubleValue boostValue) {
        super(pProperties);
        this.boostValue = boostValue;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> use(@NotNull Level level, Player player, @NotNull InteractionHand hand) {
        ItemStack stack = player.getItemInHand(hand);
        if (player.getVehicle() != null && MountController.controlledMounts.get(player.getUUID()) == player.getVehicle()) {
            player.startUsingItem(hand);
            return InteractionResultHolder.consume((Object)stack);
        }
        if (!level.isClientSide()) {
            player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] You must be riding your active mount to use this!")).withStyle(ChatFormatting.RED));
        }
        return InteractionResultHolder.fail((Object)stack);
    }

    @NotNull
    public ItemStack finishUsingItem(@NotNull ItemStack stack, @NotNull Level level, @NotNull LivingEntity livingEntity) {
        if (!(livingEntity instanceof ServerPlayer)) {
            return stack;
        }
        ServerPlayer player = (ServerPlayer)livingEntity;
        Entity mount = player.getVehicle();
        if (mount == null || MountController.controlledMounts.get(player.getUUID()) != mount) {
            player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] You are not riding your mount!")).withStyle(ChatFormatting.RED));
            return stack;
        }
        String configName = mount.getPersistentData().getString("RpgMounts_ConfigName");
        if (configName.isEmpty()) {
            player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] This mount cannot be boosted (config name missing).")).withStyle(ChatFormatting.RED));
            return stack;
        }
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.getUUID());
        if (cfg == null) {
            return stack;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(configName));
        if (entryOpt.isPresent()) {
            JsonPlayer.MountEntry entry = entryOpt.get();
            double oldSpeed = entry.speedModifier;
            double newSpeed = entry.speedModifier + (Double)this.boostValue.get();
            if (Config.mountMaxSpeed > 0.0) {
                newSpeed = Math.min(newSpeed, Config.mountMaxSpeed);
            }
            entry.speedModifier = newSpeed;
            mount.getPersistentData().putDouble("RpgMounts_SpeedMod", entry.speedModifier);
            PlayerConfigCache.savePlayer(player.getUUID());
            player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Mount '" + entry.customName + "' speed boosted from " + String.format("%.2f", oldSpeed) + " to " + String.format("%.2f", newSpeed) + "!")).withStyle(ChatFormatting.GREEN));
            if (!player.getAbilities().instabuild) {
                stack.shrink(1);
            }
        } else {
            player.sendSystemMessage((Component)Component.literal((String)("[" + Config.chatPrefixText + "] Could not find mount config entry '" + configName + "'.")).withStyle(ChatFormatting.RED));
        }
        return stack;
    }

    public int getUseDuration(@NotNull ItemStack stack, @NotNull LivingEntity entity) {
        return 32;
    }

    @NotNull
    public UseAnim getUseAnimation(@NotNull ItemStack stack) {
        return UseAnim.EAT;
    }
}

