/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka;

import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.event.server.ServerStoppingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="epicka", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CacheEventHandler {
    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            PlayerConfigCache.loadPlayer(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onPlayerLogout(PlayerEvent.PlayerLoggedOutEvent event) {
        if (event.getEntity() instanceof ServerPlayer) {
            PlayerConfigCache.unloadPlayer(event.getEntity().m_20148_());
        }
    }

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        Epicka.LOGGER.info("[{}] Server started, scanning for orphaned mounts...", (Object)Config.chatPrefixText);
        int cleanupCount = 0;
        for (ServerLevel level : event.getServer().m_129785_()) {
            for (Entity entity : level.m_142646_().m_142273_()) {
                if (entity.getPersistentData().m_128441_("RpgMounts_OwnerUUID") && entity.m_20197_().isEmpty()) {
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                    ++cleanupCount;
                    continue;
                }
                if (!entity.m_8077_() || !entity.m_20197_().isEmpty()) continue;
                try {
                    UUID.fromString(Objects.requireNonNull(entity.m_7770_()).getString());
                    entity.m_142687_(Entity.RemovalReason.DISCARDED);
                    ++cleanupCount;
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        if (cleanupCount > 0) {
            Epicka.LOGGER.info("[{}] Cleaned up {} orphaned mounts.", (Object)Config.chatPrefixText, (Object)cleanupCount);
        }
        if (Config.enableStartupMountValidation) {
            JsonPlayer.validateAndCleanAllConfigs();
        } else {
            Epicka.LOGGER.info("[{}] Skipping validation of player mount configs as per config.", (Object)Config.chatPrefixText);
        }
    }

    @SubscribeEvent
    public static void onServerStopping(ServerStoppingEvent event) {
        Epicka.LOGGER.info("[{}] Stopping Config Saver Executor...", (Object)Config.chatPrefixText);
        PlayerConfigCache.shutdown();
    }
}

