/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import fr.mod.epicka.Config;
import fr.mod.epicka.items.ItemRegister;
import fr.mod.epicka.json.JsonPlayer;
import fr.mod.epicka.json.PlayerConfigCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Stream;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class CommandMount {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"rpgmounts").requires(src -> src.m_6761_(4))).then(Commands.m_82127_((String)"addbyview").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandMount.addMountByView((CommandContext<CommandSourceStack>)ctx, 1.0, "GROUND"))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"speedModifier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(ctx -> CommandMount.addMountByView((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), "GROUND"))).then(Commands.m_82129_((String)"mountType", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("GROUND", "AQUATIC", "FLYING"), (SuggestionsBuilder)builder)).executes(ctx -> CommandMount.addMountByView((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), StringArgumentType.getString((CommandContext)ctx, (String)"mountType"))))))))).then(Commands.m_82127_((String)"addmount").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"entity_id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CommandMount::suggestEntities).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandMount.addMount((CommandContext<CommandSourceStack>)ctx, 1.0, "GROUND"))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"speedModifier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(ctx -> CommandMount.addMount((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), "GROUND"))).then(Commands.m_82129_((String)"mountType", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("GROUND", "AQUATIC", "FLYING"), (SuggestionsBuilder)builder)).executes(ctx -> CommandMount.addMount((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), StringArgumentType.getString((CommandContext)ctx, (String)"mountType")))))))))).then(Commands.m_82127_((String)"giveunlocker").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"entity_id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CommandMount::suggestEntities).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).executes(ctx -> CommandMount.giveUnlocker((CommandContext<CommandSourceStack>)ctx, 1.0, "GROUND", ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"speedModifier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(ctx -> CommandMount.giveUnlocker((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), "GROUND", ""))).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"mountType", (ArgumentType)StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_(List.of("GROUND", "AQUATIC", "FLYING"), (SuggestionsBuilder)builder)).executes(ctx -> CommandMount.giveUnlocker((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), StringArgumentType.getString((CommandContext)ctx, (String)"mountType"), ""))).then(Commands.m_82129_((String)"nbtData", (ArgumentType)StringArgumentType.greedyString()).executes(ctx -> CommandMount.giveUnlocker((CommandContext<CommandSourceStack>)ctx, DoubleArgumentType.getDouble((CommandContext)ctx, (String)"speedModifier"), StringArgumentType.getString((CommandContext)ctx, (String)"mountType"), StringArgumentType.getString((CommandContext)ctx, (String)"nbtData"))))))))))).then(Commands.m_82127_((String)"delmount").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).executes(CommandMount::deleteMount))))).then(Commands.m_82127_((String)"setenabled").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).then(Commands.m_82129_((String)"enabled", (ArgumentType)BoolArgumentType.bool()).executes(CommandMount::setEnabled)))))).then(Commands.m_82127_((String)"setdesc").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).then(Commands.m_82129_((String)"description", (ArgumentType)StringArgumentType.greedyString()).executes(CommandMount::setDescription)))))).then(Commands.m_82127_((String)"cleardesc").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).executes(CommandMount::clearDescription))))).then(Commands.m_82127_((String)"setspeed").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).then(Commands.m_82129_((String)"speedModifier", (ArgumentType)DoubleArgumentType.doubleArg((double)0.1)).executes(CommandMount::setSpeed)))))).then(Commands.m_82127_((String)"setcost").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"item_id", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82926_((Iterable)BuiltInRegistries.f_257033_.m_6566_(), (SuggestionsBuilder)builder)).executes(ctx -> CommandMount.setCost((CommandContext<CommandSourceStack>)ctx, 1))).then(Commands.m_82129_((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> CommandMount.setCost((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count"))))))))).then(Commands.m_82127_((String)"clearcost").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).executes(CommandMount::clearCost))))).then(Commands.m_82127_((String)"setparticle").then(Commands.m_82129_((String)"player", (ArgumentType)EntityArgument.m_91466_()).then(Commands.m_82129_((String)"customName", (ArgumentType)StringArgumentType.string()).suggests(CommandMount::suggestPlayerMounts).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"particleId", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(CommandMount::suggestParticles).executes(ctx -> CommandMount.setMountParticle((CommandContext<CommandSourceStack>)ctx, Config.mountSpawnParticlesAmount))).then(Commands.m_82129_((String)"amount", (ArgumentType)IntegerArgumentType.integer((int)1, (int)500)).executes(ctx -> CommandMount.setMountParticle((CommandContext<CommandSourceStack>)ctx, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"amount")))))))));
    }

    private static CompletableFuture<Suggestions> suggestEntities(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        Stream<String> ids = BuiltInRegistries.f_256780_.m_6566_().stream().map(ResourceLocation::toString);
        return SharedSuggestionProvider.m_82981_(ids, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestPlayerMounts(CommandContext<CommandSourceStack> ctx, SuggestionsBuilder builder) {
        try {
            ServerPlayer player = EntityArgument.m_91474_(ctx, (String)"player");
            JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(player.m_20148_());
            if (cfg != null) {
                return SharedSuggestionProvider.m_82970_(cfg.mounts.keySet(), (SuggestionsBuilder)builder);
            }
        }
        catch (CommandSyntaxException e) {
            return Suggestions.empty();
        }
        return Suggestions.empty();
    }

    private static String sanitizeNbt(String rawNbt) {
        if (rawNbt == null || rawNbt.isEmpty()) {
            return "";
        }
        try {
            CompoundTag tag = TagParser.m_129359_((String)rawNbt);
            tag.m_128473_("Pos");
            tag.m_128473_("Motion");
            tag.m_128473_("Rotation");
            tag.m_128473_("UUID");
            tag.m_128473_("UUIDMost");
            tag.m_128473_("UUIDLeast");
            tag.m_128473_("Passengers");
            tag.m_128473_("OnGround");
            tag.m_128473_("FallDistance");
            tag.m_128473_("PortalCooldown");
            return tag.toString();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static int addMountByView(CommandContext<CommandSourceStack> ctx, double speedModifier, String mountType) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer player = src.m_81375_();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        Entity targetEntity = CommandMount.getTargetEntity(player);
        if (targetEntity == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] You must be looking at an entity to copy.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        ResourceLocation id = BuiltInRegistries.f_256780_.m_7981_((Object)targetEntity.m_6095_());
        String sId = id.toString();
        if (Config.mountBlacklist.contains(sId)) {
            ((CommandSourceStack)ctx.getSource()).m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] This entity is blacklisted: " + sId)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        CompoundTag nbt = targetEntity.m_20240_(new CompoundTag());
        String rawNbt = nbt.m_128456_() ? "" : nbt.toString();
        String nbtData = CommandMount.sanitizeNbt(rawNbt);
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        boolean exists = cfg.mounts.containsKey(customName);
        if (exists) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] A mount with the name '" + customName + "' already exists for this player.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        double finalSpeed = speedModifier;
        if (Config.mountMaxSpeed > 0.0) {
            finalSpeed = Math.min(finalSpeed, Config.mountMaxSpeed);
        }
        JsonPlayer.MountEntry entry = new JsonPlayer.MountEntry(sId, true, customName, nbtData, finalSpeed, mountType.toUpperCase(), null, null, 0, null, 0);
        cfg.mounts.put(customName, entry);
        PlayerConfigCache.updateConfig(target.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(target.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' (" + sId + ") added to " + target.m_7755_().getString())).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    static int addMount(CommandContext<CommandSourceStack> ctx, double speedModifier, String mountType) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"entity_id");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        String sId = id.toString();
        if (Config.mountBlacklist.contains(sId)) {
            src.m_81352_((Component)Component.m_237113_((String)("This entity is blacklisted: " + sId)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        if (!BuiltInRegistries.f_256780_.m_7804_(id)) {
            src.m_81352_((Component)Component.m_237113_((String)("Entity ID not found: " + sId)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null) {
            src.m_81352_((Component)Component.m_237113_((String)"Player config not loaded.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        boolean exists = cfg.mounts.containsKey(customName);
        if (exists) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] A mount with the name '" + customName + "' already exists for this player.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        double finalSpeed = speedModifier;
        if (Config.mountMaxSpeed > 0.0) {
            finalSpeed = Math.min(finalSpeed, Config.mountMaxSpeed);
        }
        JsonPlayer.MountEntry entry = new JsonPlayer.MountEntry(sId, true, customName, "", finalSpeed, mountType.toUpperCase(), null, null, 0, null, 0);
        cfg.mounts.put(customName, entry);
        PlayerConfigCache.updateConfig(target.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(target.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' (" + sId + ") added to " + target.m_7755_().getString())).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int deleteMount(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        JsonPlayer.MountEntry removed = cfg.mounts.remove(customName);
        if (removed == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.m_7755_().getString())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        PlayerConfigCache.updateConfig(target.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(target.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' removed from " + target.m_7755_().getString())).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int setEnabled(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        boolean enabled = BoolArgumentType.getBool(ctx, (String)"enabled");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.m_7755_().getString())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().enable = enabled;
        PlayerConfigCache.updateConfig(target.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(target.m_20148_());
        String action = enabled ? "Enabled" : "Disabled";
        ChatFormatting color = enabled ? ChatFormatting.GREEN : ChatFormatting.RED;
        src.m_288197_(() -> Component.m_237113_((String)(action + " mount '" + customName + "' for " + target.m_7755_().getString())).m_130940_(color), false);
        return 1;
    }

    private static int setDescription(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        String description = StringArgumentType.getString(ctx, (String)"description");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.m_7755_().getString())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().description = description;
        PlayerConfigCache.updateConfig(target.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(target.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)("Set description for mount '" + customName + "' for " + target.m_7755_().getString())).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int clearDescription(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.m_7755_().getString())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().description = null;
        PlayerConfigCache.updateConfig(target.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(target.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)("Cleared description for mount '" + customName + "' for " + target.m_7755_().getString())).m_130940_(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static int setSpeed(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        double effectiveSpeed;
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        double speed = DoubleArgumentType.getDouble(ctx, (String)"speedModifier");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.m_7755_().getString())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        double speedToApply = speed;
        if (Config.mountMaxSpeed > 0.0) {
            speedToApply = Math.min(speedToApply, Config.mountMaxSpeed);
        }
        entryOpt.get().speedModifier = effectiveSpeed = speedToApply;
        PlayerConfigCache.updateConfig(target.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(target.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)("Set speed for mount '" + customName + "' to " + effectiveSpeed + " for " + target.m_7755_().getString())).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int setCost(CommandContext<CommandSourceStack> ctx, int count) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        ResourceLocation itemId = ResourceLocationArgument.m_107011_(ctx, (String)"item_id");
        Optional itemOpt = BuiltInRegistries.f_257033_.m_6612_(itemId);
        if (itemOpt.isEmpty() || itemOpt.get() == Items.f_41852_) {
            src.m_81352_((Component)Component.m_237113_((String)("Invalid item ID: " + String.valueOf(itemId))).m_130940_(ChatFormatting.RED));
            return 0;
        }
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.m_7755_().getString())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().costItem = itemId.toString();
        entryOpt.get().costAmount = count;
        PlayerConfigCache.updateConfig(target.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(target.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)("Set cost for mount '" + customName + "' to " + count + "x " + String.valueOf(itemId) + " for " + target.m_7755_().getString())).m_130940_(ChatFormatting.GREEN), false);
        return 1;
    }

    private static int clearCost(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Player config not loaded.")).m_130940_(ChatFormatting.RED));
            return 0;
        }
        Optional<JsonPlayer.MountEntry> entryOpt = Optional.ofNullable(cfg.mounts.get(customName));
        if (entryOpt.isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount '" + customName + "' not found for " + target.m_7755_().getString())).m_130940_(ChatFormatting.RED));
            return 0;
        }
        entryOpt.get().costItem = null;
        entryOpt.get().costAmount = 0;
        PlayerConfigCache.updateConfig(target.m_20148_(), cfg);
        PlayerConfigCache.savePlayer(target.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)("Cleared cost for mount '" + customName + "' for " + target.m_7755_().getString())).m_130940_(ChatFormatting.YELLOW), false);
        return 1;
    }

    private static Entity getTargetEntity(ServerPlayer player) {
        Vec3 eyePos = player.m_146892_();
        Vec3 lookVec = player.m_20154_();
        Vec3 endPos = eyePos.m_82549_(lookVec.m_82490_(10.0));
        AABB searchBox = player.m_20191_().m_82369_(lookVec.m_82490_(10.0)).m_82400_(1.0);
        EntityHitResult hitResult = ProjectileUtil.m_37304_((Level)player.m_9236_(), (Entity)player, (Vec3)eyePos, (Vec3)endPos, (AABB)searchBox, e -> !e.m_5833_() && e.m_6087_());
        return hitResult != null ? hitResult.m_82443_() : null;
    }

    private static int giveUnlocker(CommandContext<CommandSourceStack> ctx, double speedModifier, String mountType, String nbtData) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        ResourceLocation id = ResourceLocationArgument.m_107011_(ctx, (String)"entity_id");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        String sId = id.toString();
        if (!nbtData.isEmpty() && (nbtData = CommandMount.sanitizeNbt(nbtData)).isEmpty()) {
            src.m_81352_((Component)Component.m_237113_((String)"Invalid or dangerous NBT data provided.").m_130940_(ChatFormatting.RED));
            return 0;
        }
        ItemStack stack = new ItemStack((ItemLike)ItemRegister.MOUNT_UNLOCK_ITEM.get());
        CompoundTag mountDataTag = new CompoundTag();
        mountDataTag.m_128359_("entity_id", sId);
        mountDataTag.m_128359_("customName", customName);
        mountDataTag.m_128347_("speed", speedModifier);
        mountDataTag.m_128359_("type", mountType.toUpperCase());
        if (!nbtData.isEmpty()) {
            mountDataTag.m_128359_("nbt", nbtData);
        }
        CompoundTag mainTag = new CompoundTag();
        mainTag.m_128365_("MountData", (Tag)mountDataTag);
        stack.m_41751_(mainTag);
        MutableComponent itemName = Component.m_237113_((String)"Unlocker: ").m_130940_(ChatFormatting.GOLD).m_7220_((Component)Component.m_237113_((String)customName).m_130940_(ChatFormatting.AQUA));
        stack.m_41714_((Component)itemName);
        ArrayList<MutableComponent> lore = new ArrayList<MutableComponent>();
        lore.add(Component.m_237113_((String)"Entity: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)sId)));
        lore.add(Component.m_237113_((String)"Speed: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.format("%.2f", speedModifier))));
        lore.add(Component.m_237113_((String)"Type: ").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)mountType.toUpperCase())));
        lore.add(Component.m_237119_());
        lore.add(Component.m_237113_((String)"Use this item to unlock the mount!").m_130940_(ChatFormatting.GREEN));
        CompoundTag displayTag = stack.m_41698_("display");
        ListTag loreList = new ListTag();
        for (Component component : lore) {
            loreList.add((Object)StringTag.m_129297_((String)Component.Serializer.m_130703_((Component)component)));
        }
        displayTag.m_128365_("Lore", (Tag)loreList);
        if (!target.m_150109_().m_36054_(stack)) {
            target.m_36176_(stack, false);
        }
        src.m_288197_(() -> Component.m_237113_((String)("Gave mount unlocker '" + customName + "' to " + target.m_7755_().getString())), true);
        return 1;
    }

    private static int setMountParticle(CommandContext<CommandSourceStack> ctx, int amount) throws CommandSyntaxException {
        CommandSourceStack src = (CommandSourceStack)ctx.getSource();
        ServerPlayer target = EntityArgument.m_91474_(ctx, (String)"player");
        String customName = StringArgumentType.getString(ctx, (String)"customName");
        ResourceLocation particleId = ResourceLocationArgument.m_107011_(ctx, (String)"particleId");
        if (!BuiltInRegistries.f_257034_.m_7804_(particleId)) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Invalid particle ID: " + String.valueOf(particleId))).m_130940_(ChatFormatting.RED));
            return 0;
        }
        JsonPlayer.PlayerMountConfig cfg = PlayerConfigCache.getConfig(target.m_20148_());
        if (cfg == null || !cfg.mounts.containsKey(customName)) {
            src.m_81352_((Component)Component.m_237113_((String)("[" + Config.chatPrefixText + "] Mount not found: " + customName)).m_130940_(ChatFormatting.RED));
            return 0;
        }
        JsonPlayer.MountEntry entry = cfg.mounts.get(customName);
        entry.particleType = particleId.toString();
        entry.particleAmount = amount;
        PlayerConfigCache.savePlayer(target.m_20148_());
        src.m_288197_(() -> Component.m_237113_((String)("[" + Config.chatPrefixText + "] Set particle for '" + customName + "' to " + String.valueOf(particleId) + " (x" + amount + ").")).m_130940_(ChatFormatting.GREEN), true);
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestParticles(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_((Iterable)BuiltInRegistries.f_257034_.m_6566_(), (SuggestionsBuilder)builder);
    }
}

