/*
 * Decompiled with CFR 0.152.
 */
package fr.mod.epicka.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import fr.mod.epicka.Config;
import fr.mod.epicka.Epicka;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.loading.FMLPaths;

public class JsonPlayer {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final Path CONFIG_DIR = FMLPaths.CONFIGDIR.get().resolve("epicka");
    private static final String FILE_EXT = ".json";

    public static void ensureConfigFile(UUID uuid) throws IOException {
        if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
            Files.createDirectories(CONFIG_DIR, new FileAttribute[0]);
        }
        Path file = CONFIG_DIR.resolve(uuid.toString() + FILE_EXT);
        boolean create = false;
        if (!Files.exists(file, new LinkOption[0])) {
            create = true;
        } else if (Files.size(file) == 0L) {
            create = true;
        } else {
            try (BufferedReader reader = Files.newBufferedReader(file);){
                PlayerMountConfig config = (PlayerMountConfig)GSON.fromJson((Reader)reader, PlayerMountConfig.class);
                if (config == null) {
                    create = true;
                }
            }
            catch (JsonSyntaxException | IOException e) {
                create = true;
            }
        }
        if (create) {
            JsonPlayer.writeDefaultConfig(file);
        }
    }

    private static void writeDefaultConfig(Path file) throws IOException {
        PlayerMountConfig cfg = new PlayerMountConfig();
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson((Object)cfg, (Appendable)writer);
        }
    }

    public static PlayerMountConfig loadConfig(UUID uuid) throws IOException {
        Path file = CONFIG_DIR.resolve(uuid.toString() + FILE_EXT);
        try (BufferedReader reader = Files.newBufferedReader(file);){
            PlayerMountConfig config = (PlayerMountConfig)GSON.fromJson((Reader)reader, PlayerMountConfig.class);
            if (config == null) {
                PlayerMountConfig playerMountConfig = new PlayerMountConfig();
                return playerMountConfig;
            }
            if (config.mounts == null) {
                config.mounts = new ConcurrentHashMap<String, MountEntry>();
            }
            PlayerMountConfig playerMountConfig = config;
            return playerMountConfig;
        }
    }

    public static void saveConfig(UUID uuid, PlayerMountConfig cfg) throws IOException {
        Path file = CONFIG_DIR.resolve(uuid.toString() + FILE_EXT);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            GSON.toJson((Object)cfg, (Appendable)writer);
        }
    }

    public static void saveConfigString(UUID uuid, String jsonString) throws IOException {
        Path file = CONFIG_DIR.resolve(uuid.toString() + FILE_EXT);
        try (BufferedWriter writer = Files.newBufferedWriter(file, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);){
            writer.write(jsonString);
        }
    }

    public static void validateAndCleanAllConfigs() {
        Epicka.LOGGER.info("[{}] Starting validation of all player mount configs...", (Object)Config.chatPrefixText);
        Set validIds = BuiltInRegistries.f_256780_.m_6566_().stream().map(ResourceLocation::toString).collect(Collectors.toSet());
        if (!Files.exists(CONFIG_DIR, new LinkOption[0])) {
            Epicka.LOGGER.info("[{}] Config directory not found. Skipping validation.", (Object)Config.chatPrefixText);
            return;
        }
        int filesChecked = 0;
        int entriesRemoved = 0;
        try (Stream<Path> stream = Files.walk(CONFIG_DIR, new FileVisitOption[0]);){
            List<Path> jsonFiles = stream.filter(file -> !Files.isDirectory(file, new LinkOption[0])).filter(file -> file.getFileName().toString().endsWith(FILE_EXT)).toList();
            for (Path file2 : jsonFiles) {
                ++filesChecked;
                boolean modified = false;
                try {
                    String fileName = file2.getFileName().toString();
                    String uuidString = fileName.substring(0, fileName.length() - FILE_EXT.length());
                    UUID uuid = UUID.fromString(uuidString);
                    PlayerMountConfig config = JsonPlayer.loadConfig(uuid);
                    if (config.mounts == null) continue;
                    Iterator<Map.Entry<String, MountEntry>> iterator = config.mounts.entrySet().iterator();
                    while (iterator.hasNext()) {
                        MountEntry entry = iterator.next().getValue();
                        if (validIds.contains(entry.idMonture)) continue;
                        Epicka.LOGGER.warn("[{}] Removing invalid mount ID '{}' ({}) from player config {}", new Object[]{Config.chatPrefixText, entry.idMonture, entry.customName, fileName});
                        iterator.remove();
                        modified = true;
                        ++entriesRemoved;
                    }
                    if (!modified) continue;
                    JsonPlayer.saveConfig(uuid, config);
                    Epicka.LOGGER.info("[{}] Cleaned and saved config for {}", (Object)Config.chatPrefixText, (Object)fileName);
                }
                catch (IllegalArgumentException e) {
                    Epicka.LOGGER.warn("[{}] Found file with invalid UUID format: {}", (Object)Config.chatPrefixText, (Object)file2.getFileName());
                }
                catch (JsonSyntaxException | IOException e) {
                    Epicka.LOGGER.error("[{}] Failed to read or parse config file: {}", new Object[]{Config.chatPrefixText, file2.getFileName(), e});
                }
            }
        }
        catch (IOException e) {
            Epicka.LOGGER.error("[{}] Failed to scan config directory: {}", new Object[]{Config.chatPrefixText, CONFIG_DIR, e});
        }
        Epicka.LOGGER.info("[{}] Validation complete. Checked {} files, removed {} invalid entries.", new Object[]{Config.chatPrefixText, filesChecked, entriesRemoved});
    }

    public static class PlayerMountConfig {
        public Map<String, MountEntry> mounts = new ConcurrentHashMap<String, MountEntry>();
        public String lastSummonedMount;
    }

    public static class MountEntry {
        public String idMonture;
        public boolean enable;
        public String customName;
        public String nbtData;
        public double speedModifier;
        public String mountType;
        public String description;
        public String costItem;
        public int costAmount;
        public String particleType;
        public int particleAmount;

        public MountEntry(String idMonture, boolean enable, String customName, String nbtData, double speedModifier, String mountType, String description, String costItem, int costAmount, String particleType, int particleAmount) {
            this.idMonture = idMonture;
            this.enable = enable;
            this.customName = customName;
            this.nbtData = nbtData;
            this.speedModifier = speedModifier;
            this.mountType = mountType;
            this.description = description;
            this.costItem = costItem;
            this.costAmount = costAmount;
            this.particleType = particleType;
            this.particleAmount = particleAmount;
        }
    }
}

