/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.beans;

import cn.coostack.usefulmagic.UsefulMagic;
import java.util.ArrayList;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.client.Minecraft;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001d\u001a\u00020\u0003J\u000e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020!J\u000e\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0003J\u0016\u0010#\u001a\u00020\u001f2\u0006\u0010\u0010\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u001fJ\u0006\u0010%\u001a\u00020\u001fJ\u0006\u0010&\u001a\u00020\u001cJ\u0006\u0010'\u001a\u00020\u001cR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\u0005R$\u0010\u000b\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR$\u0010\u0010\u001a\u00020\n2\u0006\u0010\t\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\r\"\u0004\b\u0012\u0010\u000fR\u001a\u0010\u0013\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\r\"\u0004\b\u0015\u0010\u000fR$\u0010\u0016\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u0017j\b\u0012\u0004\u0012\u00020\u0003`\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u000e\u0010'\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lcn/coostack/usefulmagic/beans/MagicPlayerData;", "", "owner", "Ljava/util/UUID;", "<init>", "(Ljava/util/UUID;)V", "getOwner", "()Ljava/util/UUID;", "setOwner", "value", "", "maxMana", "getMaxMana", "()I", "setMaxMana", "(I)V", "mana", "getMana", "setMana", "manaRegeneration", "getManaRegeneration", "setManaRegeneration", "friends", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "getFriends$usefulmagic_neoforge_1_21_1", "()Ljava/util/ArrayList;", "addFriend", "", "uuid", "isFriend", "", "player", "Lnet/minecraft/world/entity/player/Player;", "removeFriend", "canCost", "client", "isFull", "setFull", "tick", "usefulmagic-neoforge-1.21.1"})
public final class MagicPlayerData {
    @NotNull
    private UUID owner;
    private int maxMana;
    private int mana;
    private int manaRegeneration;
    @NotNull
    private final ArrayList<UUID> friends;
    private int tick;

    public MagicPlayerData(@NotNull UUID owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        this.owner = owner;
        this.maxMana = 100;
        this.manaRegeneration = 1;
        this.friends = new ArrayList();
    }

    @NotNull
    public final UUID getOwner() {
        return this.owner;
    }

    public final void setOwner(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.owner = uUID;
    }

    public final int getMaxMana() {
        return this.maxMana;
    }

    public final void setMaxMana(int value) {
        this.maxMana = RangesKt.coerceAtLeast((int)value, (int)0);
    }

    public final int getMana() {
        return this.mana;
    }

    public final void setMana(int value) {
        this.mana = RangesKt.coerceIn((int)value, (int)0, (int)this.maxMana);
    }

    public final int getManaRegeneration() {
        return this.manaRegeneration;
    }

    public final void setManaRegeneration(int n) {
        this.manaRegeneration = n;
    }

    @NotNull
    public final ArrayList<UUID> getFriends$usefulmagic_neoforge_1_21_1() {
        return this.friends;
    }

    public final void addFriend(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        if (this.isFriend(uuid)) {
            return;
        }
        this.friends.add(uuid);
    }

    public final boolean isFriend(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        return this.friends.contains(uuid) || Intrinsics.areEqual((Object)uuid, (Object)this.owner);
    }

    public final boolean isFriend(@NotNull Player player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        UUID uUID = player.getUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUUID(...)");
        return this.isFriend(uUID);
    }

    public final void removeFriend(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        this.friends.remove(uuid);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean canCost(int mana, boolean client) {
        Player playerInstance = client ? (Player)Minecraft.getInstance().player : (Player)UsefulMagic.INSTANCE.getServer().getPlayerList().getPlayer(this.owner);
        if (this.mana >= mana) return true;
        Player player = playerInstance;
        if (player == null) return false;
        boolean bl = player.isCreative();
        if (!bl) return false;
        return true;
    }

    public final boolean isFull() {
        return this.mana >= this.maxMana;
    }

    public final void setFull() {
        this.setMana(this.maxMana);
    }

    public final void tick() {
        if (UsefulMagic.INSTANCE.getServer().getPlayerList().getPlayer(this.owner) == null) {
            return;
        }
        int n = this.tick;
        this.tick = n + 1;
        if (n % 20 != 0) {
            return;
        }
        this.tick = 1;
        this.setMana(this.mana + this.manaRegeneration);
        if (this.mana > this.maxMana) {
            this.setMana(this.maxMana);
        }
    }
}

