/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.blocks;

import cn.coostack.usefulmagic.blocks.MagicCoreBlock;
import cn.coostack.usefulmagic.blocks.entity.MagicCoreBlockEntity;
import cn.coostack.usefulmagic.blocks.entity.UsefulMagicBlockEntities;
import cn.coostack.usefulmagic.recipe.AltarRecipeType;
import com.mojang.serialization.MapCodec;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0012\u0010\u0007\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\bH\u0014J\u001c\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u000e0\fH\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000eH\u0016JD\u0010\u0014\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0016\u0018\u00010\u0015\"\n\b\u0000\u0010\u0016*\u0004\u0018\u00010\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\b\u0010\u0013\u001a\u0004\u0018\u00010\u000e2\u0010\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\u0016\u0018\u00010\u001aH\u0016J@\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0014J(\u0010&\u001a\u00020'2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u001f\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010)\u001a\u00020*H\u0014J\u0010\u0010+\u001a\u00020,2\u0006\u0010\u0013\u001a\u00020\u000eH\u0014\u00a8\u0006."}, d2={"Lcn/coostack/usefulmagic/blocks/MagicCoreBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "Lnet/minecraft/world/level/block/SimpleWaterloggedBlock;", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "codec", "Lcom/mojang/serialization/MapCodec;", "createBlockStateDefinition", "", "builder", "Lnet/minecraft/world/level/block/state/StateDefinition$Builder;", "Lnet/minecraft/world/level/block/Block;", "Lnet/minecraft/world/level/block/state/BlockState;", "newBlockEntity", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "world", "Lnet/minecraft/world/level/Level;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "useItemOn", "Lnet/minecraft/world/ItemInteractionResult;", "stack", "Lnet/minecraft/world/item/ItemStack;", "level", "player", "Lnet/minecraft/world/entity/player/Player;", "hand", "Lnet/minecraft/world/InteractionHand;", "hitResult", "Lnet/minecraft/world/phys/BlockHitResult;", "getShape", "Lnet/minecraft/world/phys/shapes/VoxelShape;", "Lnet/minecraft/world/level/BlockGetter;", "context", "Lnet/minecraft/world/phys/shapes/CollisionContext;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "Companion", "usefulmagic-neoforge-1.21.1"})
public final class MagicCoreBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final IntegerProperty LEVEL;
    @JvmField
    @NotNull
    public static final BooleanProperty WATER_LOGGED;

    public MagicCoreBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
        ((BlockState)this.defaultBlockState().setValue((Property)LEVEL, (Comparable)Integer.valueOf(15))).setValue((Property)WATER_LOGGED, (Comparable)Boolean.valueOf(false));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(MagicCoreBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        return mapCodec;
    }

    protected void createBlockStateDefinition(@NotNull StateDefinition.Builder<Block, BlockState> builder) {
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        Property[] propertyArray = new Property[]{LEVEL, WATER_LOGGED};
        builder.add(propertyArray);
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new MagicCoreBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nullable Level world, @Nullable BlockState state, @Nullable BlockEntityType<T> type) {
        return BaseEntityBlock.createTickerHelper(type, (BlockEntityType)UsefulMagicBlockEntities.getMAGIC_CORE().get(), (BlockEntityTicker)getTicker.1.INSTANCE);
    }

    @NotNull
    protected ItemInteractionResult useItemOn(@NotNull ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, @NotNull Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hitResult) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hand, (String)"hand");
        Intrinsics.checkNotNullParameter((Object)hitResult, (String)"hitResult");
        if (level.isClientSide) {
            ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
            Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
            return itemInteractionResult;
        }
        BlockEntity entity = level.getBlockEntity(pos);
        if (!(entity instanceof MagicCoreBlockEntity)) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        if (!((MagicCoreBlockEntity)entity).checkCompleteness()) {
            ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
            Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
            return itemInteractionResult;
        }
        if (hand != InteractionHand.MAIN_HAND) {
            ItemInteractionResult itemInteractionResult = super.useItemOn(stack, state, level, pos, player, hand, hitResult);
            Intrinsics.checkNotNullExpressionValue((Object)itemInteractionResult, (String)"useItemOn(...)");
            return itemInteractionResult;
        }
        int n = ((MagicCoreBlockEntity)entity).getCurrentMana();
        int n2 = ((MagicCoreBlockEntity)entity).getMaxMana();
        if (((MagicCoreBlockEntity)entity).getCrafting()) {
            String string = "%.2f";
            Object[] objectArray = new Object[1];
            AltarRecipeType altarRecipeType = ((MagicCoreBlockEntity)entity).getCurrentRecipe();
            objectArray[0] = (double)((MagicCoreBlockEntity)entity).getCraftingTick() * (double)100 / (double)(altarRecipeType != null ? altarRecipeType.getTick() : 1);
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
            object = string2 + "%";
        } else {
            object = "\u672a\u53d1\u73b0\u5408\u6210\u914d\u65b9";
        }
        player.sendSystemMessage((Component)Component.literal((String)StringsKt.trimIndent((String)("\n                        \u00a7a \u9b54\u529b\u6838\u5fc3-\u5c5e\u6027\n                        \u00a77| \u00a7f\u5f53\u524d\u9b54\u529b\u503c: " + n + "\n                        \u00a77| \u00a7f\u6700\u5927\u50a8\u5b58\u9b54\u529b\u503c: " + n2 + "\n                        \u00a77| \u00a7f\u5408\u6210\u8fdb\u5ea6: " + (String)object + "\n                        \u00a77| \u00a7f\u9b54\u529b\u6062\u590d\u901f\u5ea6:" + ((MagicCoreBlockEntity)entity).getCurrentReviveSpeed() + "\n                    "))));
        return ItemInteractionResult.CONSUME;
    }

    @NotNull
    protected VoxelShape getShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        VoxelShape voxelShape = Shapes.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)1.0, (double)1.0);
        Intrinsics.checkNotNullExpressionValue((Object)voxelShape, (String)"box(...)");
        return voxelShape;
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.INVISIBLE;
    }

    static {
        IntegerProperty integerProperty = IntegerProperty.create((String)"level", (int)0, (int)15);
        Intrinsics.checkNotNullExpressionValue((Object)integerProperty, (String)"create(...)");
        LEVEL = integerProperty;
        BooleanProperty booleanProperty = BlockStateProperties.WATERLOGGED;
        Intrinsics.checkNotNullExpressionValue((Object)booleanProperty, (String)"WATERLOGGED");
        WATER_LOGGED = booleanProperty;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcn/coostack/usefulmagic/blocks/MagicCoreBlock$Companion;", "", "<init>", "()V", "LEVEL", "Lnet/minecraft/world/level/block/state/properties/IntegerProperty;", "WATER_LOGGED", "Lnet/minecraft/world/level/block/state/properties/BooleanProperty;", "usefulmagic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

