/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.blocks.entity;

import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.impl.SimpleParticleEmitters;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableFireworkEffect;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.usefulmagic.blocks.entity.AltarEntity;
import cn.coostack.usefulmagic.blocks.entity.MagicCoreBlockEntity;
import cn.coostack.usefulmagic.blocks.entity.UsefulMagicBlockEntities;
import cn.coostack.usefulmagic.items.weapon.wands.WandItem;
import java.util.Optional;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u000f\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\u0018\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0012\u0010\u0019\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001b\u0018\u00010\u001aH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u0004\u0018\u00010 J\u001e\u0010&\u001a\u00020\u00112\u0006\u0010'\u001a\u00020(2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,H\u0016J\"\u0010-\u001a\u00020.2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\n2\b\u00100\u001a\u0004\u0018\u00010,H\u0016J \u00101\u001a\u00020.2\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010/\u001a\u00020\n2\u0006\u00100\u001a\u00020,H\u0016J\b\u00102\u001a\u00020\u001dH\u0016J\b\u00103\u001a\u00020.H\u0016J\u0010\u00104\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u001dH\u0016J\u0018\u00105\u001a\u00020\n2\u0006\u00106\u001a\u00020\u001d2\u0006\u00107\u001a\u00020\u001dH\u0016J\u0010\u00108\u001a\u00020\n2\u0006\u0010+\u001a\u00020\u001dH\u0016J\u0018\u00109\u001a\u00020\u00112\u0006\u0010+\u001a\u00020\u001d2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010:\u001a\u00020.2\u0006\u0010+\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020\u0011H\u0016J\b\u0010=\u001a\u00020\u001dH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010!\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\"\u0010#\"\u0004\b$\u0010%\u00a8\u0006>"}, d2={"Lcn/coostack/usefulmagic/blocks/entity/AltarBlockCoreEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lcn/coostack/usefulmagic/blocks/entity/AltarEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "stack", "Lnet/minecraft/world/item/ItemStack;", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "setStack", "(Lnet/minecraft/world/item/ItemStack;)V", "getAltarStack", "setAltarStack", "", "getUpdateTag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "saveAdditional", "tag", "loadAdditional", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getDownActiveBlocksMaxMana", "", "getDownActiveBlocksManaReviveSpeed", "getCore", "Lcn/coostack/usefulmagic/blocks/entity/MagicCoreBlockEntity;", "time", "getTime", "()I", "setTime", "(I)V", "tick", "world", "Lnet/minecraft/world/level/Level;", "getSlotsForFace", "", "p0", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "", "p1", "p2", "canTakeItemThroughFace", "getContainerSize", "isEmpty", "getItem", "removeItem", "slot", "amount", "removeItemNoUpdate", "setItem", "stillValid", "Lnet/minecraft/world/entity/player/Player;", "clearContent", "getMaxStackSize", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAltarBlockCoreEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AltarBlockCoreEntity.kt\ncn/coostack/usefulmagic/blocks/entity/AltarBlockCoreEntity\n+ 2 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n*L\n1#1,201:1\n40#2:202\n*S KotlinDebug\n*F\n+ 1 AltarBlockCoreEntity.kt\ncn/coostack/usefulmagic/blocks/entity/AltarBlockCoreEntity\n*L\n63#1:202\n*E\n"})
public final class AltarBlockCoreEntity
extends BlockEntity
implements AltarEntity {
    @NotNull
    private ItemStack stack;
    private int time;

    public AltarBlockCoreEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(UsefulMagicBlockEntities.getALTAR_BLOCK_CORE().get(), pos, state);
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.stack = itemStack;
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    public final void setStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.stack = itemStack;
    }

    @Override
    @NotNull
    public ItemStack getAltarStack() {
        return this.stack;
    }

    @Override
    public void setAltarStack(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.stack = stack;
        this.setChanged();
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag tag = new CompoundTag();
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        RegistryAccess registryAccess = level.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        this.saveAdditional(tag, (HolderLookup.Provider)registryAccess);
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        if (this.stack.isEmpty()) {
            tag.putBoolean("stack_empty", true);
            return;
        }
        Tag stackTag = this.stack.save(registries, (Tag)new CompoundTag());
        tag.put("stack", stackTag);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Tag tag2 = tag.get("stack");
        if (tag2 == null) {
            AltarBlockCoreEntity it = this;
            boolean bl = false;
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.stack = itemStack;
            return;
        }
        Tag stackElement = tag2;
        AltarBlockCoreEntity altarBlockCoreEntity = this;
        Optional optional = ItemStack.parse((HolderLookup.Provider)registries, (Tag)stackElement);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"parse(...)");
        Optional $this$getOrElse$iv = optional;
        boolean $i$f$getOrElse = false;
        if ($this$getOrElse$iv.isPresent()) {
            object = $this$getOrElse$iv.get();
        } else {
            AltarBlockCoreEntity altarBlockCoreEntity2 = altarBlockCoreEntity;
            boolean bl = false;
            object = ItemStack.EMPTY;
            altarBlockCoreEntity = altarBlockCoreEntity2;
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrElse(...)");
        altarBlockCoreEntity.stack = (ItemStack)object;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public int getDownActiveBlocksMaxMana() {
        BlockPos current = null;
        current = this.worldPosition.below();
        int res = 0;
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Level level = this.level;
            if (level == null || (level = level.getBlockState(current)) == null) {
                return 0;
            }
            Level state = level;
            current = current.below();
            if (!AltarEntity.Companion.getBlockMapper().containsKey(state.getBlock())) {
                return res;
            }
            Block block = state.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            res += AltarEntity.Companion.getBlockMaxMana(block);
        }
        return res;
    }

    @Override
    public int getDownActiveBlocksManaReviveSpeed() {
        BlockPos current = null;
        current = this.worldPosition.below();
        int res = 0;
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Level level = this.level;
            if (level == null || (level = level.getBlockState(current)) == null) {
                return 0;
            }
            Level state = level;
            current = current.below();
            if (!AltarEntity.Companion.getBlockMapper().containsKey(state.getBlock())) {
                return res;
            }
            Block block = state.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            res += AltarEntity.Companion.getBlockRevive(block);
        }
        return res;
    }

    @Nullable
    public final MagicCoreBlockEntity getCore() {
        BlockPos p = this.worldPosition.above(3);
        Level level = this.level;
        BlockEntity entity = level != null ? level.getBlockEntity(p) : null;
        return entity instanceof MagicCoreBlockEntity ? (MagicCoreBlockEntity)entity : null;
    }

    public final int getTime() {
        return this.time;
    }

    public final void setTime(int n) {
        this.time = n;
    }

    public final void tick(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        int n = this.time;
        this.time = n + 1;
        if (world.isClientSide) {
            return;
        }
        MagicCoreBlockEntity magicCoreBlockEntity = this.getCore();
        if (magicCoreBlockEntity == null) {
            return;
        }
        MagicCoreBlockEntity core = magicCoreBlockEntity;
        if (core.getCrafting()) {
            return;
        }
        Item item = this.stack.getItem();
        if (!(item instanceof WandItem)) {
            return;
        }
        if (this.time % 10 == 0 && core.getCurrentMana() >= 10 && this.stack.getDamageValue() > 0) {
            ControlableParticleData it;
            ControlableParticleData controlableParticleData;
            ItemStack itemStack = this.stack;
            int n2 = itemStack.getDamageValue();
            itemStack.setDamageValue(n2 + -1);
            core.setCurrentMana(core.getCurrentMana() - 10);
            Vec3 vec3 = pos.above(3).getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            ControlableParticleData controlableParticleData2 = controlableParticleData = new ControlableParticleData();
            Level level = (Level)((ServerLevel)world);
            Vec3 vec32 = vec3;
            boolean bl = false;
            UUID uUID = it.getUuid();
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
            it.setEffect((ControlableParticleEffect)new ControlableFireworkEffect(uUID, false, 2, null));
            it.setVelocity(new Vec3(0.0, 0.2, 0.0));
            it.setSpeed(-0.1);
            it.setMaxAge(20);
            it.setColor(Math3DUtil.INSTANCE.colorOf(200, 100, 250));
            Unit unit = Unit.INSTANCE;
            ControlableParticleData controlableParticleData3 = controlableParticleData;
            Level level2 = level;
            Vec3 vec33 = vec32;
            it = controlableParticleData = new SimpleParticleEmitters(vec33, level2, controlableParticleData3);
            boolean bl2 = false;
            it.setMaxTick(5);
            it.setDelay(3);
            ControlableParticleData emitter = controlableParticleData;
            ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitter);
        }
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        int[] nArray = new int[]{0};
        return nArray;
    }

    public boolean canPlaceItemThroughFace(int p0, @NotNull ItemStack p1, @Nullable Direction p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        MagicCoreBlockEntity magicCoreBlockEntity = this.getCore();
        return !(magicCoreBlockEntity != null ? magicCoreBlockEntity.getCrafting() : false);
    }

    public boolean canTakeItemThroughFace(int p0, @NotNull ItemStack p1, @NotNull Direction p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        MagicCoreBlockEntity magicCoreBlockEntity = this.getCore();
        return !(magicCoreBlockEntity != null ? magicCoreBlockEntity.getCrafting() : false);
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int p0) {
        return this.stack;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack old = this.stack;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.setAltarStack(itemStack);
        return old;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int p0) {
        ItemStack old = this.stack;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.stack = itemStack;
        return old;
    }

    public void setItem(int p0, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.setAltarStack(stack);
    }

    public boolean stillValid(@NotNull Player p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return true;
    }

    public void clearContent() {
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.setAltarStack(itemStack);
    }

    public int getMaxStackSize() {
        return 1;
    }
}

