/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.blocks.entity;

import cn.coostack.cooparticlesapi.renderer.client.AlphasVertexConsumers;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.usefulmagic.blocks.UsefulMagicBlocks;
import cn.coostack.usefulmagic.blocks.entity.AltarBlockCoreEntity;
import cn.coostack.usefulmagic.blocks.entity.AltarBlockEntity;
import cn.coostack.usefulmagic.blocks.entity.MagicCoreBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0016J.\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bJ.\u0010\u001f\u001a\u00020\u00122\u0006\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bR\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006 "}, d2={"Lcn/coostack/usefulmagic/blocks/entity/AltarBlockCoreEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lcn/coostack/usefulmagic/blocks/entity/AltarBlockCoreEntity;", "<init>", "()V", "shouldPlaceLocations", "", "Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "getShouldPlaceLocations", "()Ljava/util/List;", "up", "Lnet/minecraft/core/BlockPos;", "getUp", "()Lnet/minecraft/core/BlockPos;", "upRelative", "getUpRelative", "()Lcn/coostack/cooparticlesapi/utils/RelativeLocation;", "render", "", "entity", "tickDelta", "", "matrices", "Lcom/mojang/blaze3d/vertex/PoseStack;", "vertexConsumers", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "handleAltarBlockRender", "relative", "handleMagicCoreRender", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAltarBlockCoreEntityRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AltarBlockCoreEntityRenderer.kt\ncn/coostack/usefulmagic/blocks/entity/AltarBlockCoreEntityRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,122:1\n1869#2,2:123\n*S KotlinDebug\n*F\n+ 1 AltarBlockCoreEntityRenderer.kt\ncn/coostack/usefulmagic/blocks/entity/AltarBlockCoreEntityRenderer\n*L\n45#1:123,2\n*E\n"})
public final class AltarBlockCoreEntityRenderer
implements BlockEntityRenderer<AltarBlockCoreEntity> {
    @NotNull
    private final List<RelativeLocation> shouldPlaceLocations;
    @NotNull
    private final BlockPos up;
    @NotNull
    private final RelativeLocation upRelative;

    public AltarBlockCoreEntityRenderer() {
        Object[] objectArray = new RelativeLocation[]{new RelativeLocation(3.0, 0.0, 0.0), new RelativeLocation(-3.0, 0.0, 0.0), new RelativeLocation(0.0, 0.0, 3.0), new RelativeLocation(0.0, 0.0, -3.0), new RelativeLocation(2.0, 0.0, 2.0), new RelativeLocation(2.0, 0.0, -2.0), new RelativeLocation(-2.0, 0.0, 2.0), new RelativeLocation(-2.0, 0.0, -2.0)};
        this.shouldPlaceLocations = CollectionsKt.listOf((Object[])objectArray);
        this.up = new BlockPos(0, 3, 0);
        this.upRelative = new RelativeLocation(0.0, 3.0, 0.0);
    }

    @NotNull
    public final List<RelativeLocation> getShouldPlaceLocations() {
        return this.shouldPlaceLocations;
    }

    @NotNull
    public final BlockPos getUp() {
        return this.up;
    }

    @NotNull
    public final RelativeLocation getUpRelative() {
        return this.upRelative;
    }

    public void render(@NotNull AltarBlockCoreEntity entity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();
        Level level = entity.getLevel();
        if (level == null) {
            return;
        }
        Level world = level;
        long time = world.getGameTime();
        float angle = (float)(0.0017453292519943296 * (double)(((float)time + tickDelta) * (float)50 % (float)3600));
        ItemStack stack = entity.getStack();
        Iterable $this$forEach$iv = this.shouldPlaceLocations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RelativeLocation it = (RelativeLocation)element$iv;
            boolean bl = false;
            BlockEntity blockEntity = world.getBlockEntity(entity.getBlockPos().offset((int)it.getX(), (int)it.getY(), (int)it.getZ()));
            if (blockEntity instanceof AltarBlockEntity) continue;
            this.handleAltarBlockRender(it, matrices, vertexConsumers, light, overlay);
        }
        BlockEntity e = world.getBlockEntity(entity.getBlockPos().offset((Vec3i)this.up));
        if (!(e instanceof MagicCoreBlockEntity)) {
            this.handleMagicCoreRender(this.upRelative, matrices, vertexConsumers, light, overlay);
        }
        if (stack.isEmpty()) {
            return;
        }
        matrices.translate(0.5, 1.0 + 0.125 * (double)((float)Math.sin(angle)), 0.5);
        matrices.mulPose(new Quaternionf().rotateY(angle));
        matrices.scale(0.75f, 0.75f, 0.75f);
        itemRenderer.renderStatic(stack, ItemDisplayContext.GROUND, 240, overlay, matrices, vertexConsumers, entity.getLevel(), 0);
    }

    public final void handleAltarBlockRender(@NotNull RelativeLocation relative, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        matrices.translate(relative.getX(), relative.getY(), relative.getZ());
        BlockState state = UsefulMagicBlocks.getALTAR_BLOCK().get().defaultBlockState();
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.translucent());
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
        AlphasVertexConsumers buffer = new AlphasVertexConsumers(127, vertexConsumer);
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrices.last(), (VertexConsumer)buffer, state, Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(state), 1.0f, 1.0f, 1.0f, light, overlay);
        matrices.translate(-relative.getX(), -relative.getY(), -relative.getZ());
    }

    public final void handleMagicCoreRender(@NotNull RelativeLocation relative, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)relative, (String)"relative");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        matrices.translate(relative.getX(), relative.getY(), relative.getZ());
        BlockState state = UsefulMagicBlocks.getMAGIC_CORE().get().defaultBlockState();
        VertexConsumer vertexConsumer = vertexConsumers.getBuffer(RenderType.translucent());
        Intrinsics.checkNotNullExpressionValue((Object)vertexConsumer, (String)"getBuffer(...)");
        AlphasVertexConsumers buffer = new AlphasVertexConsumers(127, vertexConsumer);
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrices.last(), (VertexConsumer)buffer, state, Minecraft.getInstance().getBlockRenderer().getBlockModelShaper().getBlockModel(state), 1.0f, 1.0f, 1.0f, light, overlay);
        matrices.translate(-relative.getX(), -relative.getY(), -relative.getZ());
    }
}

