/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.blocks.entity;

import cn.coostack.usefulmagic.blocks.entity.AltarEntity;
import cn.coostack.usefulmagic.blocks.entity.UsefulMagicBlockEntities;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\u0012\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0017H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\nH\u0016J\u0010\u0010\u001c\u001a\u00020\u00102\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u001d\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u001e\u001a\u00020\u001aH\u0016J$\u0010\u001f\u001a\u00020\u00102\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020%H\u0016J\"\u0010&\u001a\u00020'2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\n2\b\u0010)\u001a\u0004\u0018\u00010%H\u0016J \u0010*\u001a\u00020'2\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020%H\u0016J\b\u0010+\u001a\u00020\u001aH\u0016J\b\u0010,\u001a\u00020'H\u0016J\u0010\u0010-\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u001aH\u0016J\u0018\u0010.\u001a\u00020\n2\u0006\u0010/\u001a\u00020\u001a2\u0006\u00100\u001a\u00020\u001aH\u0016J\u0010\u00101\u001a\u00020\n2\u0006\u0010$\u001a\u00020\u001aH\u0016J\u0018\u00102\u001a\u00020\u00102\u0006\u0010$\u001a\u00020\u001a2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u00103\u001a\u00020'2\u0006\u0010$\u001a\u000204H\u0016J\b\u00105\u001a\u00020\u0010H\u0016J\b\u00106\u001a\u00020\u001aH\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u00067"}, d2={"Lcn/coostack/usefulmagic/blocks/entity/AltarBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lcn/coostack/usefulmagic/blocks/entity/AltarEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "stack", "Lnet/minecraft/world/item/ItemStack;", "getStack", "()Lnet/minecraft/world/item/ItemStack;", "setStack", "(Lnet/minecraft/world/item/ItemStack;)V", "saveAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getDownActiveBlocksMaxMana", "", "getAltarStack", "setAltarStack", "getUpdateTag", "getDownActiveBlocksManaReviveSpeed", "tick", "world", "Lnet/minecraft/world/level/Level;", "getSlotsForFace", "", "p0", "Lnet/minecraft/core/Direction;", "canPlaceItemThroughFace", "", "p1", "p2", "canTakeItemThroughFace", "getContainerSize", "isEmpty", "getItem", "removeItem", "slot", "amount", "removeItemNoUpdate", "setItem", "stillValid", "Lnet/minecraft/world/entity/player/Player;", "clearContent", "getMaxStackSize", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nAltarBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AltarBlockEntity.kt\ncn/coostack/usefulmagic/blocks/entity/AltarBlockEntity\n+ 2 Optionals.kt\nkotlin/jvm/optionals/OptionalsKt\n*L\n1#1,155:1\n40#2:156\n*S KotlinDebug\n*F\n+ 1 AltarBlockEntity.kt\ncn/coostack/usefulmagic/blocks/entity/AltarBlockEntity\n*L\n36#1:156\n*E\n"})
public final class AltarBlockEntity
extends BlockEntity
implements AltarEntity {
    @NotNull
    private ItemStack stack;

    public AltarBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(UsefulMagicBlockEntities.getALTAR_BLOCK().get(), pos, state);
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.stack = itemStack;
    }

    @NotNull
    public final ItemStack getStack() {
        return this.stack;
    }

    public final void setStack(@NotNull ItemStack itemStack) {
        Intrinsics.checkNotNullParameter((Object)itemStack, (String)"<set-?>");
        this.stack = itemStack;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        if (this.stack.isEmpty()) {
            tag.putBoolean("stack_empty", true);
            return;
        }
        Tag stackTag = this.stack.save(registries, (Tag)new CompoundTag());
        tag.put("stack", stackTag);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Tag tag2 = tag.get("stack");
        if (tag2 == null) {
            AltarBlockEntity it = this;
            boolean bl = false;
            ItemStack itemStack = ItemStack.EMPTY;
            Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
            this.stack = itemStack;
            return;
        }
        Tag stackElement = tag2;
        AltarBlockEntity altarBlockEntity = this;
        Optional optional = ItemStack.parse((HolderLookup.Provider)registries, (Tag)stackElement);
        Intrinsics.checkNotNullExpressionValue((Object)optional, (String)"parse(...)");
        Optional $this$getOrElse$iv = optional;
        boolean $i$f$getOrElse = false;
        if ($this$getOrElse$iv.isPresent()) {
            object = $this$getOrElse$iv.get();
        } else {
            AltarBlockEntity altarBlockEntity2 = altarBlockEntity;
            boolean bl = false;
            object = ItemStack.EMPTY;
            altarBlockEntity = altarBlockEntity2;
        }
        Intrinsics.checkNotNullExpressionValue(object, (String)"getOrElse(...)");
        altarBlockEntity.stack = (ItemStack)object;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @Override
    public int getDownActiveBlocksMaxMana() {
        BlockPos current = null;
        current = this.worldPosition.below();
        int res = 0;
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Level level = this.level;
            if (level == null || (level = level.getBlockState(current)) == null) {
                return 0;
            }
            Level state = level;
            current = current.below();
            if (!AltarEntity.Companion.getBlockMapper().containsKey(state.getBlock())) {
                return res;
            }
            Block block = state.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            res += AltarEntity.Companion.getBlockMaxMana(block);
        }
        return res;
    }

    @Override
    @NotNull
    public ItemStack getAltarStack() {
        return this.stack;
    }

    @Override
    public void setAltarStack(@NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.stack = stack;
        this.setChanged();
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        level.sendBlockUpdated(this.worldPosition, this.getBlockState(), this.getBlockState(), 3);
    }

    @NotNull
    public CompoundTag getUpdateTag(@NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag tag = new CompoundTag();
        Level level = this.level;
        Intrinsics.checkNotNull((Object)level);
        RegistryAccess registryAccess = level.registryAccess();
        Intrinsics.checkNotNullExpressionValue((Object)registryAccess, (String)"registryAccess(...)");
        this.saveAdditional(tag, (HolderLookup.Provider)registryAccess);
        return tag;
    }

    @Override
    public int getDownActiveBlocksManaReviveSpeed() {
        BlockPos current = null;
        current = this.worldPosition.below();
        int res = 0;
        int n = 10;
        int n2 = 0;
        while (n2 < n) {
            int it = n2++;
            boolean bl = false;
            Level level = this.level;
            if (level == null || (level = level.getBlockState(current)) == null) {
                return 0;
            }
            Level state = level;
            current = current.below();
            if (!AltarEntity.Companion.getBlockMapper().containsKey(state.getBlock())) {
                return res;
            }
            Block block = state.getBlock();
            Intrinsics.checkNotNullExpressionValue((Object)block, (String)"getBlock(...)");
            res += AltarEntity.Companion.getBlockRevive(block);
        }
        return res;
    }

    public final void tick(@Nullable Level world, @Nullable BlockPos pos, @Nullable BlockState state) {
    }

    @NotNull
    public int[] getSlotsForFace(@NotNull Direction p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        int[] nArray = new int[]{0};
        return nArray;
    }

    public boolean canPlaceItemThroughFace(int p0, @NotNull ItemStack p1, @Nullable Direction p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        return true;
    }

    public boolean canTakeItemThroughFace(int p0, @NotNull ItemStack p1, @NotNull Direction p2) {
        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
        Intrinsics.checkNotNullParameter((Object)p2, (String)"p2");
        return true;
    }

    public int getContainerSize() {
        return 1;
    }

    public boolean isEmpty() {
        return this.stack.isEmpty();
    }

    @NotNull
    public ItemStack getItem(int p0) {
        return this.stack;
    }

    @NotNull
    public ItemStack removeItem(int slot, int amount) {
        ItemStack old = this.stack;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.setAltarStack(itemStack);
        return old;
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int p0) {
        ItemStack old = this.stack;
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.stack = itemStack;
        return old;
    }

    public void setItem(int p0, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        this.setAltarStack(stack);
    }

    public boolean stillValid(@NotNull Player p0) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return true;
    }

    public void clearContent() {
        ItemStack itemStack = ItemStack.EMPTY;
        Intrinsics.checkNotNullExpressionValue((Object)itemStack, (String)"EMPTY");
        this.setAltarStack(itemStack);
    }

    public int getMaxStackSize() {
        return 1;
    }
}

