/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.blocks.entity.formation;

import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageHitResult;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableEndRodEffect;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.usefulmagic.blocks.entity.UsefulMagicBlockEntities;
import cn.coostack.usefulmagic.formation.api.BlockFormation;
import cn.coostack.usefulmagic.formation.api.DefendCrystal;
import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import cn.coostack.usefulmagic.formation.target.BarrageTargetOption;
import cn.coostack.usefulmagic.formation.target.LivingEntityTargetOption;
import cn.coostack.usefulmagic.formation.target.MeteoriteEntityTargetOption;
import cn.coostack.usefulmagic.formation.target.ProjectileEntityTargetOption;
import cn.coostack.usefulmagic.particles.barrages.api.DamagedBarrage;
import cn.coostack.usefulmagic.particles.emitters.CircleEmitters;
import cn.coostack.usefulmagic.particles.style.formation.crystal.CrystalStyle;
import cn.coostack.usefulmagic.particles.style.formation.crystal.DefendCrystalStyle;
import cn.coostack.usefulmagic.sounds.UsefulMagicSoundEvents;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0005\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\nH\u0016J\u0010\u0010#\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010%0$H\u0016J\b\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0016J\u0010\u0010,\u001a\u00020)2\u0006\u0010*\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020'2\u0006\u0010*\u001a\u00020-2\u0006\u0010/\u001a\u00020)H\u0016J \u00100\u001a\u00020!2\u0006\u00101\u001a\u0002022\u0006\u0010/\u001a\u00020)2\u0006\u0010*\u001a\u00020-H\u0002J\u0010\u00103\u001a\u00020'2\u0006\u0010*\u001a\u00020+H\u0016J\u0018\u00104\u001a\u00020!2\u0006\u00105\u001a\u00020\u00102\u0006\u00106\u001a\u00020\u0010H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u00108V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u001c\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001c\u0010\u001d\"\u0004\b\u001e\u0010\u001f\u00a8\u00067"}, d2={"Lcn/coostack/usefulmagic/blocks/entity/formation/DefendCrystalBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lcn/coostack/usefulmagic/formation/api/DefendCrystal;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "activeFormation", "Lcn/coostack/usefulmagic/formation/api/BlockFormation;", "getActiveFormation", "()Lcn/coostack/usefulmagic/formation/api/BlockFormation;", "setActiveFormation", "(Lcn/coostack/usefulmagic/formation/api/BlockFormation;)V", "value", "Lnet/minecraft/world/phys/Vec3;", "crystalPos", "getCrystalPos", "()Lnet/minecraft/world/phys/Vec3;", "setCrystalPos", "(Lnet/minecraft/world/phys/Vec3;)V", "preDamageTake", "", "getPreDamageTake", "()F", "style", "Lcn/coostack/usefulmagic/particles/style/formation/crystal/CrystalStyle;", "getStyle", "()Lcn/coostack/usefulmagic/particles/style/formation/crystal/CrystalStyle;", "setStyle", "(Lcn/coostack/usefulmagic/particles/style/formation/crystal/CrystalStyle;)V", "onFormationActive", "", "formation", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "getWallWidth", "", "canDefendBarrage", "", "target", "Lcn/coostack/usefulmagic/formation/target/BarrageTargetOption;", "canDefendEntities", "Lcn/coostack/usefulmagic/formation/api/FormationTargetOption;", "defendEntities", "wallInner", "setVelocity", "force", "", "defendBarrage", "displayDeterParticle", "deterPos", "deterDirection", "usefulmagic-neoforge-1.21.1"})
public final class DefendCrystalBlockEntity
extends BlockEntity
implements DefendCrystal {
    @Nullable
    private BlockFormation activeFormation;
    private final float preDamageTake;
    @Nullable
    private CrystalStyle style;

    public DefendCrystalBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(UsefulMagicBlockEntities.getDEFEND_CRYSTAL().get(), pos, state);
        this.preDamageTake = 8.0f;
    }

    @Override
    @Nullable
    public BlockFormation getActiveFormation() {
        return this.activeFormation;
    }

    @Override
    public void setActiveFormation(@Nullable BlockFormation blockFormation) {
        this.activeFormation = blockFormation;
    }

    @Override
    @NotNull
    public Vec3 getCrystalPos() {
        Vec3 vec3 = this.worldPosition.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        return vec3;
    }

    @Override
    public void setCrystalPos(@NotNull Vec3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
    }

    public final float getPreDamageTake() {
        return this.preDamageTake;
    }

    @Nullable
    public final CrystalStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@Nullable CrystalStyle crystalStyle) {
        this.style = crystalStyle;
    }

    @Override
    public void onFormationActive(@NotNull BlockFormation formation) {
        Intrinsics.checkNotNullParameter((Object)formation, (String)"formation");
        this.setActiveFormation(formation);
        Level level = formation.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (level.isClientSide) {
            return;
        }
        CrystalStyle crystalStyle = this.style = (CrystalStyle)new DefendCrystalStyle(null, 1, null);
        Intrinsics.checkNotNull((Object)((Object)crystalStyle));
        BlockPos blockPos = this.worldPosition;
        Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
        crystalStyle.setCrystalPos(blockPos);
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        Vec3 vec3 = this.worldPosition.getCenter().add(0.0, -0.4, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        CrystalStyle crystalStyle2 = this.style;
        Intrinsics.checkNotNull((Object)((Object)crystalStyle2));
        ParticleStyleManager.INSTANCE.spawnStyle(level2, vec3, (ParticleGroupStyle)crystalStyle2);
    }

    @NotNull
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        ClientboundBlockEntityDataPacket clientboundBlockEntityDataPacket = ClientboundBlockEntityDataPacket.create((BlockEntity)this);
        Intrinsics.checkNotNullExpressionValue((Object)clientboundBlockEntityDataPacket, (String)"create(...)");
        return (Packet)clientboundBlockEntityDataPacket;
    }

    @Override
    public int getWallWidth() {
        return 4;
    }

    @Override
    public boolean canDefendBarrage(@NotNull BarrageTargetOption target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Barrage barrage = target.getTarget();
        if (!(barrage instanceof DamagedBarrage)) {
            BlockFormation blockFormation = this.getActiveFormation();
            Intrinsics.checkNotNull((Object)blockFormation);
            return blockFormation.hasManaToTransform(30);
        }
        int need = MathKt.roundToInt((double)(((DamagedBarrage)barrage).getDamage() * (double)this.preDamageTake));
        BlockFormation blockFormation = this.getActiveFormation();
        Intrinsics.checkNotNull((Object)blockFormation);
        return blockFormation.hasManaToTransform(need);
    }

    @Override
    public boolean canDefendEntities(@NotNull FormationTargetOption target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof ProjectileEntityTargetOption) {
            BlockFormation blockFormation = this.getActiveFormation();
            Intrinsics.checkNotNull((Object)blockFormation);
            return blockFormation.hasManaToTransform(20);
        }
        if (target instanceof MeteoriteEntityTargetOption) {
            BlockFormation blockFormation = this.getActiveFormation();
            Intrinsics.checkNotNull((Object)blockFormation);
            return blockFormation.hasManaToTransform((int)((float)200 * this.preDamageTake));
        }
        BlockFormation blockFormation = this.getActiveFormation();
        Intrinsics.checkNotNull((Object)blockFormation);
        return blockFormation.hasManaToTransform(1);
    }

    @Override
    public int defendEntities(@NotNull FormationTargetOption target, boolean wallInner) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (target instanceof ProjectileEntityTargetOption) {
            this.displayDeterParticle(((ProjectileEntityTargetOption)target).pos(), ((ProjectileEntityTargetOption)target).movementVec());
            ((ProjectileEntityTargetOption)target).getTarget().kill();
            return 20;
        }
        if (target instanceof MeteoriteEntityTargetOption) {
            this.displayDeterParticle(((MeteoriteEntityTargetOption)target).pos(), ((MeteoriteEntityTargetOption)target).movementVec());
            ((MeteoriteEntityTargetOption)target).getMeteorite().hit(((MeteoriteEntityTargetOption)target).pos());
            return (int)((float)200 * this.preDamageTake);
        }
        if (target instanceof LivingEntityTargetOption && !((LivingEntityTargetOption)target).getTouch()) {
            return 0;
        }
        this.setVelocity(0.7, wallInner, target);
        return 1;
    }

    private final void setVelocity(double force, boolean wallInner, FormationTargetOption target) {
        if (wallInner) {
            Vec3 vec3 = target.pos();
            BlockFormation blockFormation = this.getActiveFormation();
            Intrinsics.checkNotNull((Object)blockFormation);
            Vec3 innerDirection = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)blockFormation.getFormationCore()).normalize().scale(force);
            Intrinsics.checkNotNull((Object)innerDirection);
            target.setVelocity(innerDirection);
        } else {
            Vec3 vec3 = target.pos();
            BlockFormation blockFormation = this.getActiveFormation();
            Intrinsics.checkNotNull((Object)blockFormation);
            Vec3 outerDirection = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)blockFormation.getFormationCore()).normalize().scale(-force);
            Intrinsics.checkNotNull((Object)outerDirection);
            target.setVelocity(outerDirection);
        }
    }

    @Override
    public int defendBarrage(@NotNull BarrageTargetOption target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Barrage barrage = target.getTarget();
        Vec3 vec3 = target.pos();
        BlockFormation blockFormation = this.getActiveFormation();
        Intrinsics.checkNotNull((Object)blockFormation);
        Vec3 d = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)blockFormation.getFormationCore()).normalize();
        Vec3 vec32 = target.pos();
        Intrinsics.checkNotNull((Object)d);
        this.displayDeterParticle(vec32, d);
        if (!(barrage instanceof DamagedBarrage)) {
            barrage.hit(new BarrageHitResult());
            barrage.setDirection(d);
            return 30;
        }
        ((DamagedBarrage)barrage).setDirection(d);
        ((DamagedBarrage)barrage).hit(new BarrageHitResult());
        return MathKt.roundToInt((double)(((DamagedBarrage)barrage).getDamage() * (double)this.preDamageTake));
    }

    @Override
    public void displayDeterParticle(@NotNull Vec3 deterPos, @NotNull Vec3 deterDirection) {
        ControlableParticleData controlableParticleData;
        CircleEmitters emitters;
        CircleEmitters circleEmitters;
        Intrinsics.checkNotNullParameter((Object)deterPos, (String)"deterPos");
        Intrinsics.checkNotNullParameter((Object)deterDirection, (String)"deterDirection");
        Level level = this.level;
        boolean bl = level != null ? level.isClientSide : false;
        if (bl) {
            return;
        }
        Level level2 = this.level;
        Intrinsics.checkNotNull((Object)level2);
        level2.playSound(null, this.getCrystalPos().x, this.getCrystalPos().y, this.getCrystalPos().z, UsefulMagicSoundEvents.getDEFEND_SHIELD_HIT().get(), SoundSource.BLOCKS, 10.0f, 1.0f);
        Vec3 vec3 = deterPos.add(deterDirection.normalize());
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
        CircleEmitters $this$displayDeterParticle_u24lambda_u241 = circleEmitters = (emitters = new CircleEmitters(vec3, this.level));
        boolean bl2 = false;
        $this$displayDeterParticle_u24lambda_u241.setMaxTick(1);
        ControlableParticleData it = controlableParticleData = $this$displayDeterParticle_u24lambda_u241.getTemplateData();
        boolean bl3 = false;
        it.setEffect((ControlableParticleEffect)new ControlableEndRodEffect($this$displayDeterParticle_u24lambda_u241.getUuid(), false, 2, null));
        it.setSize(0.1f);
        it.setColor(Math3DUtil.INSTANCE.colorOf(147, 242, 255));
        $this$displayDeterParticle_u24lambda_u241.setCircleSpeed(0.8);
        $this$displayDeterParticle_u24lambda_u241.setPrecentDrag(0.6);
        $this$displayDeterParticle_u24lambda_u241.setCircleDirection(deterDirection);
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitters);
    }

    @Override
    @NotNull
    public FormationTargetOption handle(@NotNull FormationTargetOption option) {
        return DefendCrystal.super.handle(option);
    }

    @Override
    public boolean transformMana(int count) {
        return DefendCrystal.super.transformMana(count);
    }

    @Override
    public void tick() {
        DefendCrystal.super.tick();
    }
}

