/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.blocks.entity.formation;

import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import cn.coostack.usefulmagic.blocks.entity.UsefulMagicBlockEntities;
import cn.coostack.usefulmagic.formation.api.BlockFormation;
import cn.coostack.usefulmagic.formation.api.FormationCrystal;
import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import cn.coostack.usefulmagic.packet.s2c.PacketS2CEnergyCrystalChange;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u0012\u0010\u001a\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u001c\u0018\u00010\u001bH\u0016J\u000e\u0010\u001d\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\nJ\u000e\u0010\u001f\u001a\u00020\u00142\u0006\u0010\u001e\u001a\u00020\nJ\u001e\u0010 \u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010/\u001a\u0002002\u0006\u00101\u001a\u000200H\u0016J\u0010\u00102\u001a\u00020\u00142\u0006\u00103\u001a\u00020$H\u0016R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR$\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\n@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\f\"\u0004\b\u0012\u0010\u000eR\u001c\u0010#\u001a\u0004\u0018\u00010$X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R$\u0010*\u001a\u00020)2\u0006\u0010\u000f\u001a\u00020)8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.\u00a8\u00064"}, d2={"Lcn/coostack/usefulmagic/blocks/entity/formation/EnergyCrystalsBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "Lcn/coostack/usefulmagic/formation/api/FormationCrystal;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "maxMana", "", "getMaxMana", "()I", "setMaxMana", "(I)V", "value", "currentMana", "getCurrentMana", "setCurrentMana", "saveAdditional", "", "tag", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "increase", "mana", "decrease", "tick", "world", "Lnet/minecraft/world/level/Level;", "activeFormation", "Lcn/coostack/usefulmagic/formation/api/BlockFormation;", "getActiveFormation", "()Lcn/coostack/usefulmagic/formation/api/BlockFormation;", "setActiveFormation", "(Lcn/coostack/usefulmagic/formation/api/BlockFormation;)V", "Lnet/minecraft/world/phys/Vec3;", "crystalPos", "getCrystalPos", "()Lnet/minecraft/world/phys/Vec3;", "setCrystalPos", "(Lnet/minecraft/world/phys/Vec3;)V", "handle", "Lcn/coostack/usefulmagic/formation/api/FormationTargetOption;", "option", "onFormationActive", "formation", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nEnergyCrystalsBlockEntity.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EnergyCrystalsBlockEntity.kt\ncn/coostack/usefulmagic/blocks/entity/formation/EnergyCrystalsBlockEntity\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1869#2,2:94\n1869#2,2:96\n*S KotlinDebug\n*F\n+ 1 EnergyCrystalsBlockEntity.kt\ncn/coostack/usefulmagic/blocks/entity/formation/EnergyCrystalsBlockEntity\n*L\n53#1:94,2\n64#1:96,2\n*E\n"})
public final class EnergyCrystalsBlockEntity
extends BlockEntity
implements FormationCrystal {
    private int maxMana;
    private int currentMana;
    @Nullable
    private BlockFormation activeFormation;

    public EnergyCrystalsBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(UsefulMagicBlockEntities.getENERGY_CRYSTAL().get(), pos, state);
        this.maxMana = 5000;
        this.currentMana = 5000;
    }

    public final int getMaxMana() {
        return this.maxMana;
    }

    public final void setMaxMana(int n) {
        this.maxMana = n;
    }

    public final int getCurrentMana() {
        return this.currentMana;
    }

    public final void setCurrentMana(int value) {
        this.currentMana = value;
        this.setChanged();
    }

    protected void saveAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag it = tag;
        boolean bl = false;
        it.putInt("maxMana", this.maxMana);
        it.putInt("currentMana", this.currentMana);
    }

    protected void loadAdditional(@NotNull CompoundTag tag, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        CompoundTag it = tag;
        boolean bl = false;
        this.maxMana = it.getInt("maxMana");
        this.setCurrentMana(it.getInt("currentMana"));
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public final void increase(int mana) {
        this.setCurrentMana(RangesKt.coerceAtMost((int)(this.currentMana + mana), (int)this.maxMana));
        Level level = this.level;
        boolean bl = level != null ? !level.isClientSide : false;
        if (bl) {
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            List list = level2.players();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                ServerPlayer cfr_ignored_0 = (ServerPlayer)it;
                BlockPos blockPos = this.worldPosition;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                PacketS2CEnergyCrystalChange change = new PacketS2CEnergyCrystalChange(blockPos, this.currentMana, this.maxMana);
                CooParticlesServices.SERVER_NETWORK.send((CustomPacketPayload)change, (ServerPlayer)it);
            }
        }
    }

    public final void decrease(int mana) {
        this.setCurrentMana(RangesKt.coerceAtLeast((int)(this.currentMana - mana), (int)0));
        Level level = this.level;
        boolean bl = level != null ? !level.isClientSide : false;
        if (bl) {
            Level level2 = this.level;
            Intrinsics.checkNotNull((Object)level2);
            List list = level2.players();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                ServerPlayer cfr_ignored_0 = (ServerPlayer)it;
                BlockPos blockPos = this.worldPosition;
                Intrinsics.checkNotNullExpressionValue((Object)blockPos, (String)"worldPosition");
                PacketS2CEnergyCrystalChange change = new PacketS2CEnergyCrystalChange(blockPos, this.currentMana, this.maxMana);
                CooParticlesServices.SERVER_NETWORK.send((CustomPacketPayload)change, (ServerPlayer)it);
            }
        }
    }

    public final void tick(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
    }

    @Override
    @Nullable
    public BlockFormation getActiveFormation() {
        return this.activeFormation;
    }

    @Override
    public void setActiveFormation(@Nullable BlockFormation blockFormation) {
        this.activeFormation = blockFormation;
    }

    @Override
    @NotNull
    public Vec3 getCrystalPos() {
        Vec3 vec3 = this.worldPosition.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        return vec3;
    }

    @Override
    public void setCrystalPos(@NotNull Vec3 value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
    }

    @Override
    @NotNull
    public FormationTargetOption handle(@NotNull FormationTargetOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        return option;
    }

    @Override
    public void onFormationActive(@NotNull BlockFormation formation) {
        Intrinsics.checkNotNullParameter((Object)formation, (String)"formation");
        this.setActiveFormation(formation);
    }

    @Override
    public void tick() {
        FormationCrystal.super.tick();
    }
}

