/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.blocks.entity.formation;

import cn.coostack.usefulmagic.blocks.entity.UsefulMagicBlockEntities;
import cn.coostack.usefulmagic.formation.CrystalFormation;
import cn.coostack.usefulmagic.formation.api.FormationScale;
import cn.coostack.usefulmagic.formation.api.FormationSettings;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0018\u0010\u000e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0014J\u0012\u0010\u000f\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0011\u0018\u00010\u0010H\u0016J\u001e\u0010\u0016\u001a\u00020\t2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\u0019"}, d2={"Lcn/coostack/usefulmagic/blocks/entity/formation/FormationCoreBlockEntity;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "<init>", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "saveAdditional", "", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "registries", "Lnet/minecraft/core/HolderLookup$Provider;", "loadAdditional", "getUpdatePacket", "Lnet/minecraft/network/protocol/Packet;", "Lnet/minecraft/network/protocol/game/ClientGamePacketListener;", "formation", "Lcn/coostack/usefulmagic/formation/CrystalFormation;", "getFormation", "()Lcn/coostack/usefulmagic/formation/CrystalFormation;", "tick", "world", "Lnet/minecraft/world/level/Level;", "usefulmagic-neoforge-1.21.1"})
public final class FormationCoreBlockEntity
extends BlockEntity {
    @NotNull
    private final CrystalFormation formation;

    public FormationCoreBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(UsefulMagicBlockEntities.getFORMATION_CORE().get(), pos, state);
        Vec3 vec3 = pos.getCenter();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
        this.formation = new CrystalFormation(this.level, null, vec3);
    }

    protected void saveAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        Object object = this.formation.getOwner();
        if (object == null || (object = ((UUID)object).toString()) == null) {
            object = "null";
        }
        nbt.putString("owner_uuid", (String)object);
        nbt.putString("scale", this.formation.getScale().name());
        FormationSettings settings = this.formation.getSettings();
        CompoundTag settingsNBT = new CompoundTag();
        settingsNBT.putBoolean("player_attack", settings.getPlayerEntityAttack());
        settingsNBT.putBoolean("hostile_attack", settings.getHostileEntityAttack());
        settingsNBT.putBoolean("animal_attack", settings.getAnimalEntityAttack());
        settingsNBT.putBoolean("another_attack", settings.getAnotherEntityAttack());
        settingsNBT.putBoolean("display_particle_only_trigger", settings.getDisplayParticleOnlyTrigger());
        settingsNBT.putBoolean("display_defend_ball_only_trigger", settings.getDisplayDefendBallOnlyTrigger());
        settingsNBT.putDouble("trigger_range", settings.getTriggerRange());
        nbt.put("settings", (Tag)settingsNBT);
        nbt.putUUID("formation_uuid", this.formation.getUuid());
    }

    protected void loadAdditional(@NotNull CompoundTag nbt, @NotNull HolderLookup.Provider registries) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        Intrinsics.checkNotNullParameter((Object)registries, (String)"registries");
        this.formation.setWorld(this.level);
        String string = nbt.getString("scale");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
        this.formation.setScale(FormationScale.valueOf(string));
        FormationSettings settings = this.formation.getSettings();
        CompoundTag settingsNBT = nbt.getCompound("settings");
        settings.setPlayerEntityAttack(settingsNBT.getBoolean("player_attack"));
        settings.setHostileEntityAttack(settingsNBT.getBoolean("hostile_attack"));
        settings.setAnimalEntityAttack(settingsNBT.getBoolean("animal_attack"));
        settings.setAnotherEntityAttack(settingsNBT.getBoolean("another_attack"));
        settings.setDisplayParticleOnlyTrigger(settingsNBT.getBoolean("display_particle_only_trigger"));
        settings.setDisplayDefendBallOnlyTrigger(settingsNBT.getBoolean("display_defend_ball_only_trigger"));
        settings.setTriggerRange(settingsNBT.getDouble("trigger_range"));
        UUID formationUUID = nbt.getUUID("formation_uuid");
        Intrinsics.checkNotNull((Object)formationUUID);
        this.formation.setUuid$usefulmagic_neoforge_1_21_1(formationUUID);
        String string2 = nbt.getString("owner_uuid");
        if (string2 == null) {
            return;
        }
        String ownerUUID = string2;
        if (!Intrinsics.areEqual((Object)ownerUUID, (Object)"null")) {
            this.formation.setOwner(UUID.fromString(ownerUUID));
        }
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return (Packet)ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    @NotNull
    public final CrystalFormation getFormation() {
        return this.formation;
    }

    public final void tick(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (this.formation.getWorld() == null) {
            this.formation.setWorld(world);
        }
        if (!this.formation.isActiveFormation() && this.formation.getOwner() != null) {
            this.formation.tryBuildFormation();
        }
        this.formation.tick();
        this.setChanged();
    }
}

