/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.blocks.entity.formation.renderer;

import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.usefulmagic.blocks.entity.formation.FormationCoreBlockEntity;
import cn.coostack.usefulmagic.formation.api.BlockFormation;
import cn.coostack.usefulmagic.formation.api.FormationCrystal;
import com.mojang.blaze3d.vertex.PoseStack;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.joml.Quaternionf;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J8\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00022\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0016J.\u0010\u0011\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f\u00a8\u0006\u0014"}, d2={"Lcn/coostack/usefulmagic/blocks/entity/formation/renderer/CrystalEntityRenderer;", "Lnet/minecraft/client/renderer/blockentity/BlockEntityRenderer;", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "<init>", "()V", "render", "", "entity", "tickDelta", "", "matrices", "Lcom/mojang/blaze3d/vertex/PoseStack;", "vertexConsumers", "Lnet/minecraft/client/renderer/MultiBufferSource;", "light", "", "overlay", "doNormal", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "usefulmagic-neoforge-1.21.1"})
public final class CrystalEntityRenderer
implements BlockEntityRenderer<BlockEntity> {
    public void render(@NotNull BlockEntity entity, float tickDelta, @NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        if (!(entity instanceof FormationCrystal)) {
            return;
        }
        Level level = entity.getLevel();
        if (level == null) {
            return;
        }
        Level world = level;
        long time = world.getGameTime();
        float angle = (float)(0.0017453292519943296 * (double)(((float)time + tickDelta) * (float)50 % (float)3600));
        BlockState state = entity.getBlockState();
        if (((FormationCrystal)entity).getActiveFormation() == null) {
            Intrinsics.checkNotNull((Object)state);
            this.doNormal(matrices, vertexConsumers, state, light, overlay);
            return;
        }
        BlockFormation blockFormation = ((FormationCrystal)entity).getActiveFormation();
        Intrinsics.checkNotNull((Object)blockFormation);
        if (!blockFormation.isActiveFormation()) {
            Intrinsics.checkNotNull((Object)state);
            this.doNormal(matrices, vertexConsumers, state, light, overlay);
            ((FormationCrystal)entity).setActiveFormation(null);
            return;
        }
        BlockFormation blockFormation2 = ((FormationCrystal)entity).getActiveFormation();
        Intrinsics.checkNotNull((Object)blockFormation2);
        BlockEntity core = world.getBlockEntity(BlockPosExtendsKt.ofFloored((Vec3)blockFormation2.getFormationCore()));
        if (!(core instanceof FormationCoreBlockEntity)) {
            Intrinsics.checkNotNull((Object)state);
            this.doNormal(matrices, vertexConsumers, state, light, overlay);
            ((FormationCrystal)entity).setActiveFormation(null);
            return;
        }
        matrices.translate(0.5, 0.0, 0.5);
        matrices.mulPose(new Quaternionf().rotateY(angle));
        matrices.translate(-0.5, 0.0, -0.5);
        matrices.translate(0.0, 0.125 * (double)((float)Math.sin(angle)), 0.0);
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrices.last(), vertexConsumers.getBuffer(RenderType.translucent()), state, Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(state), 1.0f, 1.0f, 1.0f, light, overlay);
    }

    public final void doNormal(@NotNull PoseStack matrices, @NotNull MultiBufferSource vertexConsumers, @NotNull BlockState state, int light, int overlay) {
        Intrinsics.checkNotNullParameter((Object)matrices, (String)"matrices");
        Intrinsics.checkNotNullParameter((Object)vertexConsumers, (String)"vertexConsumers");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Minecraft.getInstance().getBlockRenderer().getModelRenderer().renderModel(matrices.last(), vertexConsumers.getBuffer(RenderType.translucent()), state, Minecraft.getInstance().getModelManager().getBlockModelShaper().getBlockModel(state), 1.0f, 1.0f, 1.0f, light, overlay);
    }
}

