/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.blocks.formation;

import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.blocks.entity.UsefulMagicBlockEntities;
import cn.coostack.usefulmagic.blocks.entity.formation.FormationCoreBlockEntity;
import cn.coostack.usefulmagic.blocks.formation.FormationCoreBlock;
import cn.coostack.usefulmagic.formation.CrystalFormation;
import cn.coostack.usefulmagic.gui.formation.FormationSettingScreen;
import cn.coostack.usefulmagic.managers.client.ClientRequestManager;
import cn.coostack.usefulmagic.managers.server.ServerFormationManager;
import cn.coostack.usefulmagic.packet.c2s.PacketC2SFormationSettingRequest;
import cn.coostack.usefulmagic.packet.s2c.PacketS2CFormationSettingsResponse;
import com.mojang.serialization.MapCodec;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0012\u0010\u0006\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\u00010\u0007H\u0014JD\u0010\b\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0018\u00010\t\"\n\b\u0000\u0010\n*\u0004\u0018\u00010\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0010\u0010\u0010\u001a\f\u0012\u0006\u0012\u0004\u0018\u0001H\n\u0018\u00010\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u000e\u001a\u00020\u000fH\u0014J0\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J(\u0010\u001c\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001d\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000fH\u0016\u00a8\u0006\u001e"}, d2={"Lcn/coostack/usefulmagic/blocks/formation/FormationCoreBlock;", "Lnet/minecraft/world/level/block/BaseEntityBlock;", "settings", "Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;", "<init>", "(Lnet/minecraft/world/level/block/state/BlockBehaviour$Properties;)V", "codec", "Lcom/mojang/serialization/MapCodec;", "getTicker", "Lnet/minecraft/world/level/block/entity/BlockEntityTicker;", "T", "Lnet/minecraft/world/level/block/entity/BlockEntity;", "world", "Lnet/minecraft/world/level/Level;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "type", "Lnet/minecraft/world/level/block/entity/BlockEntityType;", "getRenderShape", "Lnet/minecraft/world/level/block/RenderShape;", "useWithoutItem", "Lnet/minecraft/world/InteractionResult;", "pos", "Lnet/minecraft/core/BlockPos;", "player", "Lnet/minecraft/world/entity/player/Player;", "hit", "Lnet/minecraft/world/phys/BlockHitResult;", "playerWillDestroy", "newBlockEntity", "usefulmagic-neoforge-1.21.1"})
public final class FormationCoreBlock
extends BaseEntityBlock {
    public FormationCoreBlock(@NotNull BlockBehaviour.Properties settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        super(settings);
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        MapCodec mapCodec = BaseEntityBlock.simpleCodec(FormationCoreBlock::new);
        Intrinsics.checkNotNullExpressionValue((Object)mapCodec, (String)"simpleCodec(...)");
        return mapCodec;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(@Nullable Level world, @Nullable BlockState state, @Nullable BlockEntityType<T> type) {
        return BaseEntityBlock.createTickerHelper(type, (BlockEntityType)UsefulMagicBlockEntities.getFORMATION_CORE().get(), (BlockEntityTicker)getTicker.1.INSTANCE);
    }

    @NotNull
    protected RenderShape getRenderShape(@NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return RenderShape.MODEL;
    }

    @NotNull
    protected InteractionResult useWithoutItem(@NotNull BlockState state, @NotNull Level world, @NotNull BlockPos pos, @NotNull Player player, @NotNull BlockHitResult hit) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Intrinsics.checkNotNullParameter((Object)hit, (String)"hit");
        BlockEntity blockEntity = world.getBlockEntity(pos);
        if (blockEntity == null) {
            InteractionResult interactionResult = super.useWithoutItem(state, world, pos, player, hit);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
            return interactionResult;
        }
        BlockEntity entity = blockEntity;
        if (!(entity instanceof FormationCoreBlockEntity)) {
            InteractionResult interactionResult = super.useWithoutItem(state, world, pos, player, hit);
            Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
            return interactionResult;
        }
        if (world.isClientSide) {
            UsefulMagic.logger.debug("try send request");
            ClientRequestManager.INSTANCE.sendRequest(new PacketC2SFormationSettingRequest(pos), PacketS2CFormationSettingsResponse.Companion.getPayloadID()).recall((Function2<? super ClientRequestManager.RequestRecall, ? super CustomPacketPayload, Unit>)((Function2)(arg_0, arg_1) -> FormationCoreBlock.useWithoutItem$lambda$1(pos, arg_0, arg_1)));
            return InteractionResult.SUCCESS_NO_ITEM_USED;
        }
        CrystalFormation formation = ((FormationCoreBlockEntity)entity).getFormation();
        if (formation.canBeFormation() && !formation.isActiveFormation()) {
            Vec3 vec3 = pos.getCenter();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getCenter(...)");
            if (!ServerFormationManager.INSTANCE.checkPosInFormationRange(vec3, (ServerLevel)world)) {
                formation.setOwner(player.getUUID());
                formation.tryBuildFormation();
                return InteractionResult.SUCCESS_NO_ITEM_USED;
            }
        }
        InteractionResult interactionResult = super.useWithoutItem(state, world, pos, player, hit);
        Intrinsics.checkNotNullExpressionValue((Object)interactionResult, (String)"useWithoutItem(...)");
        return interactionResult;
    }

    @NotNull
    public BlockState playerWillDestroy(@NotNull Level world, @NotNull BlockPos pos, @NotNull BlockState state, @NotNull Player player) {
        BlockEntity blockEntity;
        FormationCoreBlockEntity entity;
        Object object;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (!world.isClientSide && (object = (entity = (blockEntity = world.getBlockEntity(pos)) instanceof FormationCoreBlockEntity ? (FormationCoreBlockEntity)blockEntity : null)) != null && (object = ((FormationCoreBlockEntity)((Object)object)).getFormation()) != null) {
            ((CrystalFormation)object).breakFormation(Float.MAX_VALUE, null);
        }
        BlockState blockState = super.playerWillDestroy(world, pos, state, player);
        Intrinsics.checkNotNullExpressionValue((Object)blockState, (String)"playerWillDestroy(...)");
        return blockState;
    }

    @NotNull
    public BlockEntity newBlockEntity(@NotNull BlockPos pos, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        return new FormationCoreBlockEntity(pos, state);
    }

    private static final void useWithoutItem$lambda$1$lambda$0(BlockPos $pos, CustomPacketPayload $it) {
        Minecraft.getInstance().setScreen((Screen)new FormationSettingScreen($pos, ((PacketS2CFormationSettingsResponse)$it).getSettings()));
    }

    private static final Unit useWithoutItem$lambda$1(BlockPos $pos, ClientRequestManager.RequestRecall $this$recall, CustomPacketPayload it) {
        Intrinsics.checkNotNullParameter((Object)$this$recall, (String)"$this$recall");
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        PacketS2CFormationSettingsResponse cfr_ignored_0 = (PacketS2CFormationSettingsResponse)it;
        if (!((PacketS2CFormationSettingsResponse)it).isOwner()) {
            UsefulMagic.logger.debug("request failed");
            return Unit.INSTANCE;
        }
        UsefulMagic.logger.debug("try set screen");
        Minecraft.getInstance().execute(() -> FormationCoreBlock.useWithoutItem$lambda$1$lambda$0($pos, it));
        return Unit.INSTANCE;
    }
}

