/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.entity;

import cn.coostack.usefulmagic.entity.animation.MagicBookEntityAnimation;
import cn.coostack.usefulmagic.entity.custom.MagicBookEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class MagicBookEntityModel
extends HierarchicalModel<MagicBookEntity> {
    private final ModelPart root;
    private final ModelPart book_left;
    private final ModelPart left_arm;
    private final ModelPart left;
    private final ModelPart body;
    private final ModelPart book_right;
    private final ModelPart right_arm;
    private final ModelPart right;

    public MagicBookEntityModel(ModelPart root) {
        this.root = root.getChild("root");
        this.book_left = this.root.getChild("book_left");
        this.left_arm = this.book_left.getChild("left_arm");
        this.left = this.book_left.getChild("left");
        this.body = this.root.getChild("body");
        this.book_right = this.root.getChild("book_right");
        this.right_arm = this.book_right.getChild("right_arm");
        this.right = this.book_right.getChild("right");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.getRoot();
        PartDefinition root = partdefinition.addOrReplaceChild("root", CubeListBuilder.create(), PartPose.offsetAndRotation((float)-1.0f, (float)22.0f, (float)2.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition book_left = root.addOrReplaceChild("book_left", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)0.0f, (float)0.0f));
        PartDefinition left_arm = book_left.addOrReplaceChild("left_arm", CubeListBuilder.create(), PartPose.offset((float)0.0449f, (float)-1.4064f, (float)-0.0518f));
        PartDefinition left_r1 = left_arm.addOrReplaceChild("left_r1", CubeListBuilder.create().texOffs(53, 51).addBox(-0.5999f, 1.5795f, -6.0f, 9.0f, 0.1f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.2022f, (float)-1.7332f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4189f));
        PartDefinition left = book_left.addOrReplaceChild("left", CubeListBuilder.create(), PartPose.offset((float)0.0f, (float)-1.0f, (float)0.0f));
        PartDefinition left_pi_r1 = left.addOrReplaceChild("left_pi_r1", CubeListBuilder.create().texOffs(0, 37).addBox(-6.0f, 0.5f, -8.0f, 11.0f, 0.1f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)6.2f, (float)-2.5f, (float)0.0f, (float)0.0f, (float)0.0f, (float)-0.4363f));
        PartDefinition left_r2 = left.addOrReplaceChild("left_r2", CubeListBuilder.create().texOffs(0, 17).addBox(-0.6058f, 1.555f, -6.0f, 9.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-0.1573f, (float)-2.0896f, (float)-0.0518f, (float)0.0f, (float)0.0f, (float)-0.4189f));
        PartDefinition body = root.addOrReplaceChild("body", CubeListBuilder.create().texOffs(48, 13).addBox(-2.0f, -2.5f, -6.0f, 2.0f, 0.1f, 16.0f, new CubeDeformation(0.0f)), PartPose.offset((float)1.0f, (float)2.0f, (float)-2.0f));
        PartDefinition book_right = root.addOrReplaceChild("book_right", CubeListBuilder.create(), PartPose.offset((float)-0.9f, (float)-0.6f, (float)-2.0f));
        PartDefinition right_arm = book_right.addOrReplaceChild("right_arm", CubeListBuilder.create(), PartPose.offset((float)0.8708f, (float)-0.8192f, (float)0.8f));
        PartDefinition right_r1 = right_arm.addOrReplaceChild("right_r1", CubeListBuilder.create().texOffs(53, 36).addBox(-8.9734f, -0.0593f, -5.4306f, 9.0f, 0.1f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)0.0292f, (float)0.0124f, (float)0.5788f, (float)0.0f, (float)0.0f, (float)0.4189f));
        PartDefinition right = book_right.addOrReplaceChild("right", CubeListBuilder.create(), PartPose.offset((float)-0.1f, (float)0.2645f, (float)2.0f));
        PartDefinition right_r2 = right.addOrReplaceChild("right_r2", CubeListBuilder.create().texOffs(0, 1).addBox(-8.9734f, -0.0593f, -5.4306f, 9.0f, 1.0f, 12.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)1.0f, (float)-1.0462f, (float)-0.6212f, (float)0.0f, (float)0.0f, (float)0.4189f));
        PartDefinition right_pi_r1 = right.addOrReplaceChild("right_pi_r1", CubeListBuilder.create().texOffs(0, 59).addBox(-5.0f, 0.5f, -8.0f, 11.0f, 0.1f, 16.0f, new CubeDeformation(0.0f)), PartPose.offsetAndRotation((float)-5.2f, (float)-3.1645f, (float)0.0f, (float)0.0f, (float)0.0f, (float)0.4363f));
        return LayerDefinition.create((MeshDefinition)meshdefinition, (int)128, (int)128);
    }

    public void setupAnim(@NotNull MagicBookEntity entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.root.getAllParts().forEach(ModelPart::resetPose);
        this.setHead(netHeadYaw, headPitch);
        this.animate(entity.getAttackAnimateState(), MagicBookEntityAnimation.ATTACKING, ageInTicks, 1.0f);
    }

    public void renderToBuffer(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, int rgba) {
        this.root.render(poseStack, vertexConsumer, packedLight, packedOverlay, rgba);
    }

    @NotNull
    public ModelPart root() {
        return this.root;
    }

    private void setHead(float yaw, float pitch) {
        yaw = Mth.clamp((float)yaw, (float)-30.0f, (float)30.0f);
        pitch = Mth.clamp((float)pitch, (float)-25.0f, (float)45.0f);
        this.root.xRot = pitch * 0.017f;
        this.root.yRot = yaw * 0.017f;
    }
}

