/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.entity.custom;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.barrages.HitBox;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.emitters.type.EmittersShootTypes;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableCloudEffect;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.cooparticlesapi.utils.ServerCameraUtil;
import cn.coostack.usefulmagic.entity.UsefulMagicEntityTypes;
import cn.coostack.usefulmagic.entity.custom.UnlimitHealthEntity;
import cn.coostack.usefulmagic.entity.custom.goal.IllegalFlyingGoal;
import cn.coostack.usefulmagic.entity.custom.goal.MagicAttackGoal;
import cn.coostack.usefulmagic.entity.custom.goal.MagicCloseTargetGoal;
import cn.coostack.usefulmagic.entity.custom.skills.BookCannonballsSkill;
import cn.coostack.usefulmagic.entity.custom.skills.BookShootSkill;
import cn.coostack.usefulmagic.entity.custom.skills.BookSwordSlashSkill;
import cn.coostack.usefulmagic.entity.custom.skills.HealthReverseSkill;
import cn.coostack.usefulmagic.entity.custom.skills.MagicSwordSkill;
import cn.coostack.usefulmagic.items.UsefulMagicItems;
import cn.coostack.usefulmagic.managers.server.SkillManagerManager;
import cn.coostack.usefulmagic.particles.animation.EmittersAnimate;
import cn.coostack.usefulmagic.particles.animation.ParticleAnimation;
import cn.coostack.usefulmagic.particles.animation.StyleAnimate;
import cn.coostack.usefulmagic.particles.barrages.entity.EntityWoodenBarrage;
import cn.coostack.usefulmagic.particles.emitters.DirectionShootEmitters;
import cn.coostack.usefulmagic.particles.emitters.ExplodeMagicEmitters;
import cn.coostack.usefulmagic.particles.emitters.LightningParticleEmitters;
import cn.coostack.usefulmagic.particles.emitters.ParticleWaveEmitters;
import cn.coostack.usefulmagic.particles.style.entitiy.BookEntityDeathStyle;
import cn.coostack.usefulmagic.skill.api.EntitySkillManager;
import cn.coostack.usefulmagic.skill.api.Skill;
import cn.coostack.usefulmagic.skill.api.SkillDamageCancelCondition;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import kotlin.ranges.RangesKt;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerBossEvent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.BossEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageSources;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.EnderMan;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 v2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001vB\u001f\u0012\u000e\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tB\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\nJ\b\u0010+\u001a\u00020,H\u0002J\u0010\u0010-\u001a\u00020,2\u0006\u0010.\u001a\u00020/H\u0014J\u0006\u00100\u001a\u00020\u001dJ\u000e\u00101\u001a\u00020,2\u0006\u00102\u001a\u00020\u001dJ\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0016J\u0012\u00107\u001a\u00020,2\b\u00108\u001a\u0004\u0018\u000109H\u0016J\u0006\u0010:\u001a\u00020,J\u0010\u0010;\u001a\u00020,2\u0006\u0010<\u001a\u00020\u0016H\u0014J\u0006\u0010=\u001a\u00020\u001dJ\b\u0010>\u001a\u00020,H\u0014J\u0006\u0010?\u001a\u00020,J\u0010\u0010@\u001a\u00020,2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010C\u001a\u00020,2\u0006\u0010A\u001a\u00020BH\u0016J\u0010\u0010D\u001a\u00020,2\u0006\u0010E\u001a\u00020FH\u0016J\b\u0010G\u001a\u00020,H\u0002J\b\u0010H\u001a\u00020,H\u0002J\u0018\u0010I\u001a\u00020\u001d2\u0006\u0010J\u001a\u00020F2\u0006\u0010K\u001a\u00020\u0016H\u0016J\b\u0010L\u001a\u00020\u001dH\u0016J\b\u0010M\u001a\u00020\u0016H\u0016J\u0010\u0010N\u001a\u00020,2\u0006\u0010O\u001a\u00020\u0016H\u0016J\b\u0010P\u001a\u00020\u0016H\u0016J\u0012\u0010c\u001a\u0004\u0018\u00010d2\u0006\u0010J\u001a\u00020FH\u0014J \u0010e\u001a\u00020,2\u0006\u0010f\u001a\u00020g2\u0006\u0010E\u001a\u00020F2\u0006\u0010h\u001a\u00020\u001dH\u0014J\u0010\u0010i\u001a\u00020,2\u0006\u0010j\u001a\u00020kH\u0016J\b\u0010l\u001a\u00020,H\u0016J\b\u0010Q\u001a\u00020,H\u0016J\b\u0010p\u001a\u00020,H\u0002J\u0018\u0010q\u001a\u00020,2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020\u0016H\u0016J\u0006\u0010u\u001a\u00020RR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u000f\u001a\u00020\u0010X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R$\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u00168F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001bR$\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001f\u0010 \"\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u001a\u0010Q\u001a\u00020RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bS\u0010T\"\u0004\bU\u0010VR\u001a\u0010W\u001a\u00020RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bX\u0010T\"\u0004\bY\u0010VR\u001a\u0010Z\u001a\u00020\u0016X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b[\u0010\u0019\"\u0004\b\\\u0010\u001bR\u001a\u0010]\u001a\u00020\u001dX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b^\u0010 \"\u0004\b_\u0010\"R\u001a\u0010`\u001a\u00020RX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\ba\u0010T\"\u0004\bb\u0010VR\u001a\u0010m\u001a\u00020RX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u0010T\"\u0004\bo\u0010V\u00a8\u0006w"}, d2={"Lcn/coostack/usefulmagic/entity/custom/MagicBookEntity;", "Lnet/minecraft/world/entity/PathfinderMob;", "Lnet/minecraft/world/entity/monster/RangedAttackMob;", "Lcn/coostack/usefulmagic/entity/custom/UnlimitHealthEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "<init>", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "(Lnet/minecraft/world/level/Level;)V", "bossBar", "Lnet/minecraft/server/level/ServerBossEvent;", "getBossBar", "()Lnet/minecraft/server/level/ServerBossEvent;", "skillManager", "Lcn/coostack/usefulmagic/skill/api/EntitySkillManager;", "getSkillManager", "()Lcn/coostack/usefulmagic/skill/api/EntitySkillManager;", "setSkillManager", "(Lcn/coostack/usefulmagic/skill/api/EntitySkillManager;)V", "field", "", "bookMaxHealth", "getBookMaxHealth", "()F", "setBookMaxHealth", "(F)V", "value", "", "entitySpawning", "getEntitySpawning", "()Z", "setEntitySpawning", "(Z)V", "attackAnimateState", "Lnet/minecraft/world/entity/AnimationState;", "getAttackAnimateState", "()Lnet/minecraft/world/entity/AnimationState;", "deathAnimation", "Lcn/coostack/usefulmagic/particles/animation/ParticleAnimation;", "getDeathAnimation", "()Lcn/coostack/usefulmagic/particles/animation/ParticleAnimation;", "initSkillManager", "", "defineSynchedData", "builder", "Lnet/minecraft/network/syncher/SynchedEntityData$Builder;", "isAttacking", "setAttacking", "attacking", "readAdditionalSaveData", "nbt", "Lnet/minecraft/nbt/CompoundTag;", "addAdditionalSaveData", "setCustomName", "name", "Lnet/minecraft/network/chat/Component;", "setEntityDeath", "updateWalkAnimation", "posDelta", "isEntityDeath", "registerGoals", "tickMovement", "startSeenByPlayer", "serverPlayer", "Lnet/minecraft/server/level/ServerPlayer;", "stopSeenByPlayer", "die", "damageSource", "Lnet/minecraft/world/damagesource/DamageSource;", "cancelAllAI", "playDeathAnimation", "hurt", "source", "amount", "isPersistenceRequired", "getUnlimitMaxHealth", "setHealth", "health", "getHealth", "tick", "", "getTick", "()I", "setTick", "(I)V", "startAge", "getStartAge", "setStartAge", "startPitch", "getStartPitch", "setStartPitch", "handled", "getHandled", "setHandled", "spawningTick", "getSpawningTick", "setSpawningTick", "getHurtSound", "Lnet/minecraft/sounds/SoundEvent;", "dropCustomDeathLoot", "level", "Lnet/minecraft/server/level/ServerLevel;", "recentlyHit", "remove", "reason", "Lnet/minecraft/world/entity/Entity$RemovalReason;", "checkDespawn", "attackTick", "getAttackTick$usefulmagic_neoforge_1_21_1", "setAttackTick$usefulmagic_neoforge_1_21_1", "setAnimation", "performRangedAttack", "target", "Lnet/minecraft/world/entity/LivingEntity;", "pullProgress", "getHealthState", "Companion", "usefulmagic-neoforge-1.21.1"})
public final class MagicBookEntity
extends PathfinderMob
implements RangedAttackMob,
UnlimitHealthEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerBossEvent bossBar;
    @NotNull
    private EntitySkillManager skillManager;
    @NotNull
    private final AnimationState attackAnimateState;
    @NotNull
    private final ParticleAnimation deathAnimation;
    private int tick;
    private int startAge;
    private float startPitch;
    private boolean handled;
    private int spawningTick;
    private int attackTick;
    private static final EntityDataAccessor<Boolean> ENTITY_SPAWNING = SynchedEntityData.defineId(MagicBookEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> SET_ENTITY_DEATH = SynchedEntityData.defineId(MagicBookEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Boolean> IS_ATTACKING = SynchedEntityData.defineId(MagicBookEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    private static final EntityDataAccessor<Float> LARGE_MAX_HEALTH = SynchedEntityData.defineId(MagicBookEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);
    private static final EntityDataAccessor<Float> BOOK_HEALTH = SynchedEntityData.defineId(MagicBookEntity.class, (EntityDataSerializer)EntityDataSerializers.FLOAT);

    public MagicBookEntity(@NotNull EntityType<? extends PathfinderMob> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        Component component = this.getDisplayName();
        Intrinsics.checkNotNull((Object)component);
        this.bossBar = new ServerBossEvent(component, BossEvent.BossBarColor.RED, BossEvent.BossBarOverlay.PROGRESS);
        this.skillManager = new EntitySkillManager((LivingEntity)this);
        this.attackAnimateState = new AnimationState();
        this.deathAnimation = new ParticleAnimation();
        this.setHealth(1.0f);
        this.initSkillManager();
        this.startPitch = 1.0f;
        this.spawningTick = 80;
    }

    @NotNull
    public final ServerBossEvent getBossBar() {
        return this.bossBar;
    }

    @NotNull
    public final EntitySkillManager getSkillManager() {
        return this.skillManager;
    }

    public final void setSkillManager(@NotNull EntitySkillManager entitySkillManager) {
        Intrinsics.checkNotNullParameter((Object)entitySkillManager, (String)"<set-?>");
        this.skillManager = entitySkillManager;
    }

    public final float getBookMaxHealth() {
        Object object = this.entityData.get(LARGE_MAX_HEALTH);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).floatValue();
    }

    public final void setBookMaxHealth(float field) {
        this.entityData.set(LARGE_MAX_HEALTH, (Object)Float.valueOf(RangesKt.coerceAtLeast((float)field, (float)0.5f)));
    }

    public MagicBookEntity(@NotNull Level world) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        this((EntityType<? extends PathfinderMob>)UsefulMagicEntityTypes.INSTANCE.getMAGIC_BOOK_ENTITY_TYPE().get(), world);
    }

    public final boolean getEntitySpawning() {
        Object object = this.entityData.get(ENTITY_SPAWNING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final void setEntitySpawning(boolean value) {
        this.entityData.set(ENTITY_SPAWNING, (Object)value);
    }

    @NotNull
    public final AnimationState getAttackAnimateState() {
        return this.attackAnimateState;
    }

    @NotNull
    public final ParticleAnimation getDeathAnimation() {
        return this.deathAnimation;
    }

    private final void initSkillManager() {
        this.skillManager.addSkill(new MagicSwordSkill());
        this.skillManager.addSkill(new HealthReverseSkill());
        this.skillManager.addSkill(new BookShootSkill(2));
        this.skillManager.addSkill(new BookCannonballsSkill(18.0f));
        this.skillManager.addSkill(new BookSwordSlashSkill(8.0f));
        SkillManagerManager.INSTANCE.setCache(this.skillManager);
    }

    protected void defineSynchedData(@NotNull SynchedEntityData.Builder builder) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        super.defineSynchedData(builder);
        builder.define(IS_ATTACKING, (Object)false);
        builder.define(LARGE_MAX_HEALTH, (Object)Float.valueOf(4096.0f));
        builder.define(BOOK_HEALTH, (Object)Float.valueOf(1.0f));
        builder.define(SET_ENTITY_DEATH, (Object)false);
        builder.define(ENTITY_SPAWNING, (Object)true);
    }

    public final boolean isAttacking() {
        Object object = this.entityData.get(IS_ATTACKING);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    public final void setAttacking(boolean attacking) {
        this.entityData.set(IS_ATTACKING, (Object)attacking);
    }

    public void readAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        if (this.hasCustomName()) {
            Component component = this.getDisplayName();
            Intrinsics.checkNotNull((Object)component);
            this.bossBar.setName(component);
        }
        this.entityData.set(SET_ENTITY_DEATH, (Object)nbt.getBoolean("entity_death"));
        this.entityData.set(ENTITY_SPAWNING, (Object)(nbt.contains("entity_spawning") ? nbt.getBoolean("entity_spawning") : true));
        MagicBookEntity magicBookEntity = this;
        try {
            MagicBookEntity $this$readAdditionalSaveData_u24lambda_u240 = magicBookEntity;
            boolean bl = false;
            UUID cache = nbt.getUUID("cache_uuid");
            Intrinsics.checkNotNull((Object)cache);
            EntitySkillManager fromCache = SkillManagerManager.INSTANCE.loadFromCache(cache);
            if (fromCache != null) {
                $this$readAdditionalSaveData_u24lambda_u240.skillManager = fromCache;
                $this$readAdditionalSaveData_u24lambda_u240.skillManager.setOwner((LivingEntity)$this$readAdditionalSaveData_u24lambda_u240);
            }
            Object object = Result.constructor-impl((Object)Unit.INSTANCE);
        }
        catch (Throwable throwable) {
            Object object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
        }
        super.readAdditionalSaveData(nbt);
    }

    public void addAdditionalSaveData(@NotNull CompoundTag nbt) {
        Intrinsics.checkNotNullParameter((Object)nbt, (String)"nbt");
        nbt.putBoolean("entity_death", this.isEntityDeath());
        nbt.putBoolean("entity_spawning", this.getEntitySpawning());
        nbt.putUUID("cache_uuid", this.skillManager.getCacheUUID());
        super.addAdditionalSaveData(nbt);
    }

    public void setCustomName(@Nullable Component name) {
        super.setCustomName(name);
        Component component = name;
        if (component == null) {
            component = (Component)Component.literal((String)"null");
        }
        this.bossBar.setName(component);
    }

    public final void setEntityDeath() {
        this.entityData.set(SET_ENTITY_DEATH, (Object)true);
    }

    protected void updateWalkAnimation(float posDelta) {
        super.updateWalkAnimation(posDelta);
        float poseAmount = this.getPose() == Pose.STANDING ? Math.min(posDelta * 6.0f, 5.0f) : 0.0f;
        this.walkAnimation.update(poseAmount, 0.02f);
    }

    public final boolean isEntityDeath() {
        Object object = this.entityData.get(SET_ENTITY_DEATH);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (Boolean)object;
    }

    protected void registerGoals() {
        GoalSelector goalSelector;
        super.registerGoals();
        GoalSelector $this$registerGoals_u24lambda_u241 = goalSelector = this.goalSelector;
        boolean bl = false;
        $this$registerGoals_u24lambda_u241.addGoal(0, (Goal)new FloatGoal((Mob)this));
        $this$registerGoals_u24lambda_u241.addGoal(3, (Goal)new MagicCloseTargetGoal(this, 8.0));
        $this$registerGoals_u24lambda_u241.addGoal(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 3.0f));
        $this$registerGoals_u24lambda_u241.addGoal(7, (Goal)new RandomLookAroundGoal((Mob)this));
        $this$registerGoals_u24lambda_u241.addGoal(1, (Goal)new MagicAttackGoal(this, 5));
        $this$registerGoals_u24lambda_u241.addGoal(1, (Goal)new IllegalFlyingGoal(this));
        GoalSelector $this$registerGoals_u24lambda_u242 = goalSelector = this.targetSelector;
        boolean bl2 = false;
        $this$registerGoals_u24lambda_u242.addGoal(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        $this$registerGoals_u24lambda_u242.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
        $this$registerGoals_u24lambda_u242.addGoal(1, (Goal)new NearestAttackableTargetGoal((Mob)this, EnderMan.class, true));
        this.moveControl = (MoveControl)new FlyingMoveControl((Mob)this, 10, true);
    }

    public final void tickMovement() {
        if (this.isEntityDeath() || this.getEntitySpawning()) {
            this.setDeltaMovement(Vec3.ZERO);
            return;
        }
        if (this.getTarget() == null) {
            if (!this.onGround()) {
                this.moveControl.setWantedPosition(this.getX(), -1.0, this.getZ(), 0.8);
            }
            return;
        }
        LivingEntity livingEntity = this.getTarget();
        Intrinsics.checkNotNull((Object)livingEntity);
        if (livingEntity.getY() + 6.0 > this.getY()) {
            this.setDeltaMovement(this.getDeltaMovement().add(0.0, 0.05, 0.0));
        } else {
            LivingEntity livingEntity2 = this.getTarget();
            Intrinsics.checkNotNull((Object)livingEntity2);
            if (livingEntity2.getY() + (double)4 < this.getY()) {
                this.setDeltaMovement(this.getDeltaMovement().add(0.0, -0.05, 0.0));
            }
        }
        LivingEntity livingEntity3 = this.getTarget();
        Intrinsics.checkNotNull((Object)livingEntity3);
        double d = Math.pow(livingEntity3.getX() - this.getX(), 2);
        LivingEntity livingEntity4 = this.getTarget();
        Intrinsics.checkNotNull((Object)livingEntity4);
        double len = Math.sqrt(d + Math.pow(livingEntity4.getZ() - this.getZ(), 2));
        if (len >= 16.0 && this.skillManager.getActive() == null) {
            Vec3 vec3 = this.getDeltaMovement();
            LivingEntity livingEntity5 = this.getTarget();
            Intrinsics.checkNotNull((Object)livingEntity5);
            double d2 = livingEntity5.getX() - this.getX();
            LivingEntity livingEntity6 = this.getTarget();
            Intrinsics.checkNotNull((Object)livingEntity6);
            this.setDeltaMovement(vec3.add(new Vec3(d2, 0.0, livingEntity6.getZ() - this.getZ()).normalize().scale(0.25)));
        }
    }

    public void startSeenByPlayer(@NotNull ServerPlayer serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        super.startSeenByPlayer(serverPlayer);
        this.bossBar.addPlayer(serverPlayer);
    }

    public void stopSeenByPlayer(@NotNull ServerPlayer serverPlayer) {
        Intrinsics.checkNotNullParameter((Object)serverPlayer, (String)"serverPlayer");
        super.stopSeenByPlayer(serverPlayer);
        this.bossBar.removePlayer(serverPlayer);
    }

    public void die(@NotNull DamageSource damageSource) {
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        if (!this.isEntityDeath()) {
            this.setAttacking(false);
            this.setEntityDeath();
            this.playDeathAnimation();
            this.startAge = this.tickCount;
            this.skillManager.setEntityDeath();
            this.cancelAllAI();
            this.setHealth(1.0f);
            SkillManagerManager.INSTANCE.clearCacheIfOwnerDead();
            return;
        }
        super.die(damageSource);
    }

    private final void cancelAllAI() {
        this.goalSelector.removeAllGoals(MagicBookEntity::cancelAllAI$lambda$3);
        this.targetSelector.removeAllGoals(MagicBookEntity::cancelAllAI$lambda$4);
    }

    private final void playDeathAnimation() {
        if (this.level().isClientSide) {
            return;
        }
        Random random = RandomKt.Random((long)System.currentTimeMillis());
        Function1 function1 = arg_0 -> MagicBookEntity.playDeathAnimation$lambda$7(random, this, arg_0);
        Vec3 vec3 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        ParticleAnimation particleAnimation = this.deathAnimation.addAnimate(new EmittersAnimate((Function1<? super Vec3, ? extends ParticleEmitters>)function1, vec3, 2, -1, (Function1<? super ParticleEmitters, Unit>)((Function1)arg_0 -> MagicBookEntity.playDeathAnimation$lambda$9(random, arg_0))));
        ParticleGroupStyle particleGroupStyle = new BookEntityDeathStyle(this.getId(), null, 2, null);
        Level level = this.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        ServerLevel serverLevel = (ServerLevel)level;
        Vec3 vec32 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position(...)");
        ParticleAnimation particleAnimation2 = particleAnimation.addAnimate(new StyleAnimate(particleGroupStyle, serverLevel, vec32, -1));
        Function1 function12 = arg_0 -> MagicBookEntity.playDeathAnimation$lambda$12(this, arg_0);
        Vec3 vec33 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"position(...)");
        ParticleAnimation particleAnimation3 = particleAnimation2.addAnimate(new EmittersAnimate((Function1<? super Vec3, ? extends ParticleEmitters>)function12, vec33, 20, -1, (Function1<? super ParticleEmitters, Unit>)((Function1)MagicBookEntity::playDeathAnimation$lambda$13)));
        Function1 function13 = arg_0 -> MagicBookEntity.playDeathAnimation$lambda$16(this, arg_0);
        Vec3 vec34 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"position(...)");
        ParticleAnimation particleAnimation4 = particleAnimation3.addAnimate(new EmittersAnimate((Function1<? super Vec3, ? extends ParticleEmitters>)function13, vec34, 20, -1, (Function1<? super ParticleEmitters, Unit>)((Function1)MagicBookEntity::playDeathAnimation$lambda$17)));
        Function1 function14 = arg_0 -> MagicBookEntity.playDeathAnimation$lambda$20(this, arg_0);
        Vec3 vec35 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"position(...)");
        particleAnimation4.addAnimate(new EmittersAnimate((Function1<? super Vec3, ? extends ParticleEmitters>)function14, vec35, 20, -1, (Function1<? super ParticleEmitters, Unit>)((Function1)MagicBookEntity::playDeathAnimation$lambda$21)));
        int n = this.deathAnimation.getAnimations().size();
        for (int i = 0; i < n; ++i) {
            this.deathAnimation.spawnSingle();
        }
    }

    public boolean hurt(@NotNull DamageSource source, float amount) {
        Skill activeSkill;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (this.isEntityDeath()) {
            return false;
        }
        if (this.getEntitySpawning()) {
            return false;
        }
        DamageSources sources = this.level().damageSources();
        DamageType onFire = sources.onFire().type();
        DamageType inFire = sources.inFire().type();
        DamageType campFire = sources.campfire().type();
        float actualDamage = amount;
        if (Intrinsics.areEqual((Object)source.type(), (Object)sources.fall().type())) {
            return false;
        }
        if (Intrinsics.areEqual((Object)source.type(), (Object)inFire) || Intrinsics.areEqual((Object)source.type(), (Object)onFire) || Intrinsics.areEqual((Object)campFire, (Object)onFire)) {
            actualDamage *= (float)3;
        }
        if ((activeSkill = this.skillManager.getActive()) != null && activeSkill instanceof SkillDamageCancelCondition) {
            ((SkillDamageCancelCondition)((Object)activeSkill)).damage(actualDamage);
        }
        return super.hurt(source, actualDamage);
    }

    public boolean isPersistenceRequired() {
        return true;
    }

    @Override
    public float getUnlimitMaxHealth() {
        Object object = this.entityData.get(LARGE_MAX_HEALTH);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).floatValue();
    }

    @Override
    public void setHealth(float health) {
        this.entityData.set(BOOK_HEALTH, (Object)Float.valueOf(RangesKt.coerceIn((float)health, (float)0.0f, (float)this.getBookMaxHealth())));
    }

    @Override
    public float getHealth() {
        Object object = this.entityData.get(BOOK_HEALTH);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return ((Number)object).floatValue();
    }

    public final int getTick() {
        return this.tick;
    }

    public final void setTick(int n) {
        this.tick = n;
    }

    public final int getStartAge() {
        return this.startAge;
    }

    public final void setStartAge(int n) {
        this.startAge = n;
    }

    public final float getStartPitch() {
        return this.startPitch;
    }

    public final void setStartPitch(float f) {
        this.startPitch = f;
    }

    public final boolean getHandled() {
        return this.handled;
    }

    public final void setHandled(boolean bl) {
        this.handled = bl;
    }

    public final int getSpawningTick() {
        return this.spawningTick;
    }

    public final void setSpawningTick(int n) {
        this.spawningTick = n;
    }

    @Nullable
    protected SoundEvent getHurtSound(@NotNull DamageSource source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return SoundEvents.BOOK_PAGE_TURN;
    }

    protected void dropCustomDeathLoot(@NotNull ServerLevel level, @NotNull DamageSource damageSource, boolean recentlyHit) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)damageSource, (String)"damageSource");
        super.dropCustomDeathLoot(level, damageSource, recentlyHit);
        this.spawnAtLocation(MagicBookEntity::dropCustomDeathLoot$lambda$22);
    }

    public void remove(@NotNull Entity.RemovalReason reason) {
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        super.remove(reason);
        this.skillManager.resetActiveSkill(false);
    }

    public void checkDespawn() {
        super.checkDespawn();
    }

    public void tick() {
        this.bossBar.setProgress(this.getHealth() / this.getBookMaxHealth());
        if (this.getEntitySpawning()) {
            float step = this.getBookMaxHealth() / (float)this.spawningTick;
            this.setHealth(this.getHealth() + step);
            if (this.getHealth() >= this.getBookMaxHealth()) {
                ControlableParticleData controlableParticleData;
                ExplodeMagicEmitters explodeMagicEmitters;
                this.setEntitySpawning(false);
                if (!this.level().isClientSide) {
                    Level level = this.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ServerLevel serverLevel = (ServerLevel)level;
                    Vec3 vec3 = this.position();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                    ServerCameraUtil.INSTANCE.sendShake(serverLevel, vec3, 128.0, 0.6, 20);
                }
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), (Holder)SoundEvents.GENERIC_EXPLODE, SoundSource.HOSTILE, 10.0f, 1.2f);
                Vec3 vec3 = this.position();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                ExplodeMagicEmitters $this$tick_u24lambda_u2424 = explodeMagicEmitters = new ExplodeMagicEmitters(vec3, this.level());
                boolean bl = false;
                ControlableParticleData it = controlableParticleData = $this$tick_u24lambda_u2424.getTemplateData();
                boolean bl2 = false;
                it.setColor(Math3DUtil.INSTANCE.colorOf(255, 255, 255));
                it.setSize(0.4f);
                $this$tick_u24lambda_u2424.setRandomParticleAgeMin(20);
                $this$tick_u24lambda_u2424.setRandomParticleAgeMax(60);
                $this$tick_u24lambda_u2424.setPrecentDrag(0.95);
                $this$tick_u24lambda_u2424.setMaxTick(5);
                $this$tick_u24lambda_u2424.setBallCountPow(20);
                $this$tick_u24lambda_u2424.setMinSpeed(0.5);
                $this$tick_u24lambda_u2424.setMaxSpeed(8.0);
                $this$tick_u24lambda_u2424.setRandomCountMin(120);
                $this$tick_u24lambda_u2424.setRandomCountMax(400);
                ExplodeMagicEmitters explosion = explodeMagicEmitters;
                ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)explosion);
            }
            return;
        }
        if (this.isEntityDeath()) {
            int currentTick = this.tickCount - this.startAge;
            if (currentTick > 380 && !this.level().isClientSide) {
                Level level = this.level();
                Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                ExperienceOrb.award((ServerLevel)((ServerLevel)level), (Vec3)this.position(), (int)250);
            }
            if (currentTick > 400) {
                this.setHealth(0.0f);
                super.tick();
                LivingEntity source = this.getLastAttacker();
                if (source != null) {
                    if (source instanceof Player) {
                        DamageSource damageSource = this.damageSources().playerAttack((Player)source);
                        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"playerAttack(...)");
                        this.die(damageSource);
                    } else {
                        DamageSource damageSource = this.damageSources().mobAttack(source);
                        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"mobAttack(...)");
                        this.die(damageSource);
                    }
                } else {
                    DamageSource damageSource = this.damageSources().generic();
                    Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"generic(...)");
                    this.die(damageSource);
                }
                if (!this.level().isClientSide && !this.handled) {
                    ControlableParticleData controlableParticleData;
                    ExplodeMagicEmitters explodeMagicEmitters;
                    this.handled = true;
                    Vec3 vec3 = this.position();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                    ExplodeMagicEmitters $this$tick_u24lambda_u2426 = explodeMagicEmitters = new ExplodeMagicEmitters(vec3, this.level());
                    boolean bl = false;
                    ControlableParticleData it = controlableParticleData = $this$tick_u24lambda_u2426.getTemplateData();
                    boolean bl3 = false;
                    it.setColor(Math3DUtil.INSTANCE.colorOf(255, 170, 200));
                    it.setSize(0.4f);
                    $this$tick_u24lambda_u2426.setRandomParticleAgeMin(20);
                    $this$tick_u24lambda_u2426.setRandomParticleAgeMax(60);
                    $this$tick_u24lambda_u2426.setPrecentDrag(0.95);
                    $this$tick_u24lambda_u2426.setMaxTick(30);
                    $this$tick_u24lambda_u2426.setBallCountPow(10);
                    $this$tick_u24lambda_u2426.setMinSpeed(0.5);
                    $this$tick_u24lambda_u2426.setMaxSpeed(5.0);
                    $this$tick_u24lambda_u2426.setRandomCountMin(30);
                    $this$tick_u24lambda_u2426.setRandomCountMax(80);
                    ExplodeMagicEmitters explosion = explodeMagicEmitters;
                    ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)explosion);
                    this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BEACON_DEACTIVATE, SoundSource.HOSTILE, 10.0f, 0.9f);
                    this.deathAnimation.cancel();
                }
                return;
            }
            if (currentTick % 2 == 0) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BOOK_PAGE_TURN, SoundSource.HOSTILE, 4.0f, 1.0f);
            }
            if (currentTick % 20 == 0) {
                this.level().playSound(null, this.getX(), this.getY(), this.getZ(), SoundEvents.BEACON_ACTIVATE, SoundSource.HOSTILE, 10.0f, this.startPitch);
                this.startPitch += 0.05f;
            }
            if (!this.level().isClientSide) {
                this.deathAnimation.doTick();
                if (this.deathAnimation.getAnimations().isEmpty()) {
                    this.playDeathAnimation();
                }
                if (currentTick % 10 == 0) {
                    Level level = this.level();
                    Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                    ServerLevel serverLevel = (ServerLevel)level;
                    Vec3 vec3 = this.position();
                    Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
                    ServerCameraUtil.INSTANCE.sendShake(serverLevel, vec3, 64.0, 0.4, 10);
                }
            }
            return;
        }
        if (this.getDeltaMovement().y > 1.0) {
            this.setDeltaMovement(new Vec3(RangesKt.coerceIn((double)this.getDeltaMovement().x, (double)-1.0, (double)1.0), 1.0, RangesKt.coerceIn((double)this.getDeltaMovement().z, (double)-1.0, (double)1.0)));
        }
        super.tick();
        int n = this.tick;
        this.tick = n + 1;
        this.setAnimation();
        this.skillManager.tick();
    }

    public final int getAttackTick$usefulmagic_neoforge_1_21_1() {
        return this.attackTick;
    }

    public final void setAttackTick$usefulmagic_neoforge_1_21_1(int n) {
        this.attackTick = n;
    }

    private final void setAnimation() {
        if (this.isAttacking() && this.attackTick <= 0) {
            this.attackTick = 5;
            this.attackAnimateState.start(this.tickCount);
        } else {
            int n = this.attackTick;
            this.attackTick = n + -1;
        }
        if (!this.isAttacking()) {
            this.attackTick = 0;
            this.attackAnimateState.stop();
        }
    }

    public void performRangedAttack(@NotNull LivingEntity target, float pullProgress) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (this.level().isClientSide) {
            return;
        }
        Vec3 vec3 = this.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Vec3 vec32 = target.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position(...)");
        Vec3 direction = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)vec32);
        Vec3 vec33 = this.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"getEyePosition(...)");
        Level level = this.level();
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        EntityWoodenBarrage barrage = new EntityWoodenBarrage(2.0, target, vec33, (ServerLevel)level, this.random.nextDouble() > 0.8);
        barrage.setDirection(direction);
        barrage.setShooter((LivingEntity)this);
        BarrageManager.INSTANCE.spawn((Barrage)barrage);
    }

    public final int getHealthState() {
        int n;
        float max = this.getUnlimitMaxHealth();
        float f = this.getHealth();
        boolean bl = 0.0f <= f ? f <= max / 5.0f : false;
        if (bl) {
            n = 1;
        } else {
            float f2 = max / 5.0f;
            n = (f <= (float)2 * max / 3.0f ? f2 <= f : false) ? 2 : (((float)2 * max / 3.0f <= f ? f <= max : false) ? 3 : 3);
        }
        return n;
    }

    private static final boolean cancelAllAI$lambda$3(Goal it) {
        return true;
    }

    private static final boolean cancelAllAI$lambda$4(Goal it) {
        return true;
    }

    private static final ParticleEmitters playDeathAnimation$lambda$7(Random $random, MagicBookEntity this$0, Vec3 it) {
        ControlableParticleData controlableParticleData;
        LightningParticleEmitters lightningParticleEmitters;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        double startRadius = 5.0;
        double endRandomRange = 40.0;
        double sin = Math.sin($random.nextDouble(-Math.PI, Math.PI)) * startRadius;
        double cos = Math.cos($random.nextDouble(-Math.PI, Math.PI)) * startRadius;
        Vec3 randomPos = new Vec3(cos, $random.nextDouble(-startRadius, startRadius), sin);
        Vec3 spawnPos = this$0.getEyePosition().add(randomPos);
        Intrinsics.checkNotNull((Object)spawnPos);
        LightningParticleEmitters $this$playDeathAnimation_u24lambda_u247_u24lambda_u246 = lightningParticleEmitters = new LightningParticleEmitters(spawnPos, this$0.level());
        boolean bl = false;
        $this$playDeathAnimation_u24lambda_u247_u24lambda_u246.setEndPos(new RelativeLocation($random.nextDouble(-endRandomRange, endRandomRange), $random.nextDouble(-endRandomRange, endRandomRange), $random.nextDouble(-endRandomRange, endRandomRange)));
        $this$playDeathAnimation_u24lambda_u247_u24lambda_u246.setMaxTick($random.nextInt(1, 5));
        ControlableParticleData it2 = controlableParticleData = $this$playDeathAnimation_u24lambda_u247_u24lambda_u246.getTemplateData();
        boolean bl2 = false;
        it2.setMaxAge(5);
        it2.setColor(Math3DUtil.INSTANCE.colorOf(121, 211, 249));
        return (ParticleEmitters)lightningParticleEmitters;
    }

    private static final void playDeathAnimation$lambda$9$lambda$8(ParticleEmitters $it, Random $random) {
        double endRandomRange = 40.0;
        ((LightningParticleEmitters)$it).setEndPos(new RelativeLocation($random.nextDouble(-endRandomRange, endRandomRange), $random.nextDouble(-endRandomRange, endRandomRange), $random.nextDouble(-endRandomRange, endRandomRange)));
    }

    private static final Unit playDeathAnimation$lambda$9(Random $random, ParticleEmitters it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        LightningParticleEmitters cfr_ignored_0 = (LightningParticleEmitters)it;
        CooParticlesAPI.scheduler.runTaskTimerMaxTick(((LightningParticleEmitters)it).getMaxTick(), () -> MagicBookEntity.playDeathAnimation$lambda$9$lambda$8(it, $random));
        return Unit.INSTANCE;
    }

    private static final ParticleEmitters playDeathAnimation$lambda$12(MagicBookEntity this$0, Vec3 it) {
        ControlableParticleData controlableParticleData;
        DirectionShootEmitters directionShootEmitters;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Vec3 vec3 = this$0.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        DirectionShootEmitters $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411 = directionShootEmitters = new DirectionShootEmitters(vec3, this$0.level());
        boolean bl = false;
        ControlableParticleData it2 = controlableParticleData = $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.getTemplateData();
        boolean bl2 = false;
        it2.setMaxAge(40);
        it2.setSpeed(1.5);
        UUID uUID = it2.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        it2.setEffect((ControlableParticleEffect)new ControlableCloudEffect(uUID, false, 2, null));
        $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.setShootDirection(new Vec3(0.0, 24.0, 0.0));
        $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.setCount(40);
        $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.setRandomX(4.0);
        $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.setRandomY(12.0);
        $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.setRandomZ(4.0);
        $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.setRandomSpeedOffset(0.5);
        $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.setGravity(0.05);
        $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.setShootType(EmittersShootTypes.box((HitBox)HitBox.Companion.of(8.0, 1.0, 8.0)));
        $this$playDeathAnimation_u24lambda_u2412_u24lambda_u2411.setMaxTick(20);
        DirectionShootEmitters emitter = directionShootEmitters;
        return (ParticleEmitters)emitter;
    }

    private static final Unit playDeathAnimation$lambda$13(ParticleEmitters it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final ParticleEmitters playDeathAnimation$lambda$16(MagicBookEntity this$0, Vec3 it) {
        ControlableParticleData controlableParticleData;
        DirectionShootEmitters directionShootEmitters;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Vec3 vec3 = this$0.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        DirectionShootEmitters $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415 = directionShootEmitters = new DirectionShootEmitters(vec3, this$0.level());
        boolean bl = false;
        ControlableParticleData it2 = controlableParticleData = $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.getTemplateData();
        boolean bl2 = false;
        it2.setMaxAge(40);
        it2.setSpeed(1.0);
        it2.setColor(Math3DUtil.INSTANCE.colorOf(255, 100, 80));
        $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.setShootDirection(new Vec3(0.0, 16.0, 0.0));
        $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.setCount(5);
        $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.setRandomX(4.0);
        $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.setRandomY(12.0);
        $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.setRandomZ(4.0);
        $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.setRandomSpeedOffset(0.3);
        $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.setGravity(0.05);
        $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.setShootType(EmittersShootTypes.box((HitBox)HitBox.Companion.of(8.0, 1.0, 8.0)));
        $this$playDeathAnimation_u24lambda_u2416_u24lambda_u2415.setMaxTick(20);
        DirectionShootEmitters emitter = directionShootEmitters;
        return (ParticleEmitters)emitter;
    }

    private static final Unit playDeathAnimation$lambda$17(ParticleEmitters it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final ParticleEmitters playDeathAnimation$lambda$20(MagicBookEntity this$0, Vec3 it) {
        ControlableParticleData controlableParticleData;
        ParticleWaveEmitters particleWaveEmitters;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        Vec3 vec3 = this$0.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        ParticleWaveEmitters $this$playDeathAnimation_u24lambda_u2420_u24lambda_u2419 = particleWaveEmitters = new ParticleWaveEmitters(vec3, this$0.level());
        boolean bl = false;
        ControlableParticleData it2 = controlableParticleData = $this$playDeathAnimation_u24lambda_u2420_u24lambda_u2419.getTemplateData();
        boolean bl2 = false;
        it2.setMaxAge(40);
        it2.setColor(Math3DUtil.INSTANCE.colorOf(255, 100, 80));
        UUID uUID = it2.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        it2.setEffect((ControlableParticleEffect)new ControlableCloudEffect(uUID, false, 2, null));
        $this$playDeathAnimation_u24lambda_u2420_u24lambda_u2419.setWaveCircleCountMin(240);
        $this$playDeathAnimation_u24lambda_u2420_u24lambda_u2419.setWaveCircleCountMax(480);
        $this$playDeathAnimation_u24lambda_u2420_u24lambda_u2419.setWaveSize(40.0);
        $this$playDeathAnimation_u24lambda_u2420_u24lambda_u2419.setWaveSpeed(-1.0);
        $this$playDeathAnimation_u24lambda_u2420_u24lambda_u2419.setMaxTick(1);
        ParticleWaveEmitters emitter = particleWaveEmitters;
        return (ParticleEmitters)emitter;
    }

    private static final Unit playDeathAnimation$lambda$21(ParticleEmitters it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    private static final Item dropCustomDeathLoot$lambda$22() {
        return UsefulMagicItems.INSTANCE.getEXPLOSION_WAND().getItem();
    }

    @JvmStatic
    @NotNull
    public static final AttributeSupplier.Builder createDefaultMobAttributes() {
        return Companion.createDefaultMobAttributes();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0012\u001a\u00020\u0013H\u0007R:\u0010\u0004\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0003R:\u0010\t\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0003R:\u0010\u000b\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\f\u0010\u0003R:\u0010\r\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u000f\u0010\u0003R:\u0010\u0010\u001a&\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e \u0007*\u0012\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u000e0\u000e\u0018\u00010\u00050\u00058\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0011\u0010\u0003\u00a8\u0006\u0014"}, d2={"Lcn/coostack/usefulmagic/entity/custom/MagicBookEntity$Companion;", "", "<init>", "()V", "ENTITY_SPAWNING", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "", "kotlin.jvm.PlatformType", "getENTITY_SPAWNING$annotations", "SET_ENTITY_DEATH", "getSET_ENTITY_DEATH$annotations", "IS_ATTACKING", "getIS_ATTACKING$annotations", "LARGE_MAX_HEALTH", "", "getLARGE_MAX_HEALTH$annotations", "BOOK_HEALTH", "getBOOK_HEALTH$annotations", "createDefaultMobAttributes", "Lnet/minecraft/world/entity/ai/attributes/AttributeSupplier$Builder;", "usefulmagic-neoforge-1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getENTITY_SPAWNING$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getSET_ENTITY_DEATH$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getIS_ATTACKING$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getLARGE_MAX_HEALTH$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getBOOK_HEALTH$annotations() {
        }

        @JvmStatic
        @NotNull
        public final AttributeSupplier.Builder createDefaultMobAttributes() {
            AttributeSupplier.Builder builder = Mob.createMobAttributes().add(Attributes.MAX_HEALTH, 1.0).add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FLYING_SPEED, 0.5).add(Attributes.ATTACK_DAMAGE, 10.0).add(Attributes.ATTACK_KNOCKBACK, 1.0).add(Attributes.KNOCKBACK_RESISTANCE, 20.0).add(Attributes.FOLLOW_RANGE, 64.0);
            Intrinsics.checkNotNullExpressionValue((Object)builder, (String)"add(...)");
            return builder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

