/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.entity.custom.goal;

import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.usefulmagic.entity.custom.MagicBookEntity;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u000fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcn/coostack/usefulmagic/entity/custom/goal/MagicCloseTargetGoal;", "Lnet/minecraft/world/entity/ai/goal/Goal;", "entity", "Lcn/coostack/usefulmagic/entity/custom/MagicBookEntity;", "maxRange", "", "<init>", "(Lcn/coostack/usefulmagic/entity/custom/MagicBookEntity;D)V", "getEntity", "()Lcn/coostack/usefulmagic/entity/custom/MagicBookEntity;", "getMaxRange", "()D", "canUse", "", "tick", "", "usefulmagic-neoforge-1.21.1"})
public final class MagicCloseTargetGoal
extends Goal {
    @NotNull
    private final MagicBookEntity entity;
    private final double maxRange;

    public MagicCloseTargetGoal(@NotNull MagicBookEntity entity, double maxRange) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        this.entity = entity;
        this.maxRange = maxRange;
    }

    @NotNull
    public final MagicBookEntity getEntity() {
        return this.entity;
    }

    public final double getMaxRange() {
        return this.maxRange;
    }

    public boolean canUse() {
        return this.entity.getTarget() != null;
    }

    public void tick() {
        LivingEntity livingEntity = this.entity.getTarget();
        if (livingEntity == null) {
            MagicCloseTargetGoal it = this;
            boolean bl = false;
            this.entity.getNavigation().moveTo(this.entity.getX(), this.entity.getY() - 1.0, this.entity.getZ(), 1.0);
            return;
        }
        LivingEntity target = livingEntity;
        float distance = target.distanceTo((Entity)this.entity);
        if (this.maxRange > (double)distance) {
            return;
        }
        Vec3 vec3 = this.entity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        Vec3 vec32 = target.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"position(...)");
        Vec3 dir = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)vec32);
        this.entity.getMoveControl().setWantedPosition(this.entity.getX() + dir.x / (double)2, this.entity.getY() + dir.y / (double)2, this.entity.getZ() + dir.z / (double)2, 1.0);
    }
}

