/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.entity.custom.skills;

import cn.coostack.cooparticlesapi.CooParticlesAPI;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableCloudEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableFireworkEffect;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.usefulmagic.entity.custom.MagicBookEntity;
import cn.coostack.usefulmagic.entity.custom.UnlimitHealthEntity;
import cn.coostack.usefulmagic.particles.emitters.LineEmitters;
import cn.coostack.usefulmagic.particles.emitters.ShrinkParticleEmitters;
import cn.coostack.usefulmagic.particles.style.EnchantLineStyle;
import cn.coostack.usefulmagic.skill.api.Skill;
import cn.coostack.usefulmagic.skill.api.SkillCondition;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u0014H\u0016J\u0018\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u0016\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0012H\u0016J\u0018\u0010\u001a\u001a\u00020\u00182\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\u0010\u0010 \u001a\u00020\u00182\u0006\u0010!\u001a\u00020\u0014H\u0002J\u0018\u0010\"\u001a\u00020\u00182\u0006\u0010#\u001a\u00020\u00142\u0006\u0010\u001b\u001a\u00020\u0012H\u0016J\b\u0010$\u001a\u00020%H\u0016J\u0010\u0010&\u001a\u00020'2\u0006\u0010#\u001a\u00020\u0014H\u0016R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u00020\nX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001f\u00a8\u0006("}, d2={"Lcn/coostack/usefulmagic/entity/custom/skills/BookSwordSlashSkill;", "Lcn/coostack/usefulmagic/skill/api/Skill;", "Lcn/coostack/usefulmagic/skill/api/SkillCondition;", "damage", "", "<init>", "(F)V", "getDamage", "()F", "chance", "", "getChance", "()D", "setChance", "(D)V", "holdingEmitters", "Lcn/coostack/usefulmagic/particles/emitters/ShrinkParticleEmitters;", "getMaxHoldingTick", "", "holdingEntity", "Lnet/minecraft/world/entity/LivingEntity;", "getSkillCountDown", "source", "onActive", "", "onRelease", "holdingTick", "holdTicks", "random", "Lkotlin/random/Random;", "getRandom", "()Lkotlin/random/Random;", "handleOnceDamage", "attacker", "stopHolding", "entity", "getSkillID", "", "canTrigger", "", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nBookSwordSlashSkill.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BookSwordSlashSkill.kt\ncn/coostack/usefulmagic/entity/custom/skills/BookSwordSlashSkill\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,179:1\n1869#2,2:180\n*S KotlinDebug\n*F\n+ 1 BookSwordSlashSkill.kt\ncn/coostack/usefulmagic/entity/custom/skills/BookSwordSlashSkill\n*L\n152#1:180,2\n*E\n"})
public final class BookSwordSlashSkill
implements Skill,
SkillCondition {
    private final float damage;
    private double chance;
    @Nullable
    private ShrinkParticleEmitters holdingEmitters;
    @NotNull
    private final Random random;

    public BookSwordSlashSkill(float damage) {
        this.damage = damage;
        this.chance = 0.5;
        this.random = RandomKt.Random((long)System.currentTimeMillis());
    }

    public final float getDamage() {
        return this.damage;
    }

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public void setChance(double d) {
        this.chance = d;
    }

    @Override
    public int getMaxHoldingTick(@NotNull LivingEntity holdingEntity) {
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
        if (!(holdingEntity instanceof MagicBookEntity)) {
            return 100;
        }
        return switch (((MagicBookEntity)holdingEntity).getHealthState()) {
            case 3 -> 100;
            case 2 -> 160;
            case 1 -> 200;
            default -> 100;
        };
    }

    @Override
    public int getSkillCountDown(@NotNull LivingEntity source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(source instanceof MagicBookEntity)) {
            return 500;
        }
        return switch (((MagicBookEntity)source).getHealthState()) {
            case 3 -> 500;
            case 2 -> 400;
            case 1 -> 200;
            default -> 500;
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void onActive(@NotNull LivingEntity source) {
        void $this$onActive_u24lambda_u241;
        ControlableParticleData controlableParticleData;
        ShrinkParticleEmitters shrinkParticleEmitters;
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Vec3 vec3 = source.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        ShrinkParticleEmitters shrinkParticleEmitters2 = shrinkParticleEmitters = new ShrinkParticleEmitters(vec3, source.level());
        BookSwordSlashSkill bookSwordSlashSkill = this;
        boolean bl = false;
        ControlableParticleData it = controlableParticleData = $this$onActive_u24lambda_u241.getTemplateData();
        boolean bl2 = false;
        UUID uUID = it.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        it.setEffect((ControlableParticleEffect)new ControlableFireworkEffect(uUID, false, 2, null));
        it.setMaxAge(10);
        it.setColor(Math3DUtil.INSTANCE.colorOf(255, 150, 80));
        $this$onActive_u24lambda_u241.setMaxTick(-1);
        $this$onActive_u24lambda_u241.setSpeedDrag(0.98);
        $this$onActive_u24lambda_u241.setStartSpeed(3.0);
        $this$onActive_u24lambda_u241.setStartRange(30.0);
        bookSwordSlashSkill.holdingEmitters = shrinkParticleEmitters;
        ShrinkParticleEmitters shrinkParticleEmitters3 = this.holdingEmitters;
        Intrinsics.checkNotNull((Object)((Object)shrinkParticleEmitters3));
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)shrinkParticleEmitters3);
    }

    @Override
    public void onRelease(@NotNull LivingEntity source, int holdingTick) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (source instanceof MagicBookEntity) {
            ((MagicBookEntity)source).setAttacking(false);
            ((MagicBookEntity)source).setAttackTick$usefulmagic_neoforge_1_21_1(0);
        }
        ShrinkParticleEmitters shrinkParticleEmitters = this.holdingEmitters;
        if (shrinkParticleEmitters != null) {
            shrinkParticleEmitters.remove();
        }
        this.holdingEmitters = null;
    }

    @Override
    public void holdingTick(@NotNull LivingEntity holdingEntity, int holdTicks) {
        int interval;
        int n;
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
        if (holdingEntity instanceof MagicBookEntity) {
            ((MagicBookEntity)holdingEntity).setAttacking(true);
        }
        if (holdTicks % 4 == 0) {
            int n2 = 6;
            int n3 = 0;
            while (n3 < n2) {
                EnchantLineStyle style;
                EnchantLineStyle enchantLineStyle;
                int it = n3++;
                boolean bl = false;
                double x = this.random.nextDouble(-10.0, 10.0);
                double y = this.random.nextDouble(-5.0, 10.0);
                double z = this.random.nextDouble(-10.0, 10.0);
                Vec3 pos = holdingEntity.position().add(x, y, z);
                RelativeLocation line = new RelativeLocation(0.0, this.random.nextDouble(1.0, 5.0), 0.0);
                int count = MathKt.roundToInt((double)(line.length() * (double)2));
                EnchantLineStyle $this$holdingTick_u24lambda_u243_u24lambda_u242 = enchantLineStyle = (style = new EnchantLineStyle(line, count, this.random.nextInt(30, 45), null, 8, null));
                boolean bl2 = false;
                $this$holdingTick_u24lambda_u243_u24lambda_u242.setParticleRandomAgePreTick(true);
                $this$holdingTick_u24lambda_u243_u24lambda_u242.setFade(true);
                $this$holdingTick_u24lambda_u243_u24lambda_u242.colorOf(255, 150, 80);
                $this$holdingTick_u24lambda_u243_u24lambda_u242.setFadeInTick(15);
                $this$holdingTick_u24lambda_u243_u24lambda_u242.setFadeOutTick(15);
                $this$holdingTick_u24lambda_u243_u24lambda_u242.setSpeedDirection(new RelativeLocation(0.0, this.random.nextDouble(-0.1, 0.1), 0.0));
                Level level = holdingEntity.level();
                Intrinsics.checkNotNullExpressionValue((Object)level, (String)"level(...)");
                Intrinsics.checkNotNull((Object)pos);
                ParticleStyleManager.INSTANCE.spawnStyle(level, pos, (ParticleGroupStyle)style);
            }
        }
        ShrinkParticleEmitters shrinkParticleEmitters = this.holdingEmitters;
        if (shrinkParticleEmitters != null) {
            Vec3 vec3 = holdingEntity.position();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
            shrinkParticleEmitters.teleportTo(vec3);
        }
        if (holdingEntity instanceof MagicBookEntity) {
            switch (((MagicBookEntity)holdingEntity).getHealthState()) {
                case 3: {
                    n = 6;
                    break;
                }
                case 2: {
                    n = 3;
                    break;
                }
                case 1: {
                    n = 2;
                    break;
                }
                default: {
                    n = 6;
                    break;
                }
            }
        } else {
            n = 6;
        }
        if (holdTicks % (interval = n) == 0) {
            this.handleOnceDamage(holdingEntity);
        }
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    private final void handleOnceDamage(LivingEntity attacker) {
        if (!(attacker instanceof Mob)) {
            return;
        }
        LivingEntity livingEntity = ((Mob)attacker).getTarget();
        if (livingEntity == null) {
            return;
        }
        LivingEntity target = livingEntity;
        Vec3 targetPos = target.getEyePosition().add(0.0, -0.5, 0.0);
        Vec3 spawnPos = targetPos.add(this.random.nextDouble(-5.0, 5.0), this.random.nextDouble(-5.0, 5.0), this.random.nextDouble(-5.0, 5.0));
        Intrinsics.checkNotNull((Object)spawnPos);
        Intrinsics.checkNotNull((Object)targetPos);
        Vec3 dir = Vec3ExtendsKt.relativize((Vec3)spawnPos, (Vec3)targetPos);
        CooParticlesAPI.scheduler.runTask(10, () -> BookSwordSlashSkill.handleOnceDamage$lambda$9(spawnPos, attacker, targetPos, dir, this));
    }

    @Override
    public void stopHolding(@NotNull LivingEntity entity, int holdTicks) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (entity instanceof MagicBookEntity) {
            ((MagicBookEntity)entity).setAttacking(false);
            ((MagicBookEntity)entity).setAttackTick$usefulmagic_neoforge_1_21_1(0);
        }
        ShrinkParticleEmitters shrinkParticleEmitters = this.holdingEmitters;
        if (shrinkParticleEmitters != null) {
            shrinkParticleEmitters.remove();
        }
        this.holdingEmitters = null;
    }

    @Override
    @NotNull
    public String getSkillID() {
        return "book-sword-slash-skill";
    }

    @Override
    public boolean canTrigger(@NotNull LivingEntity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        if (!(entity instanceof UnlimitHealthEntity)) {
            return false;
        }
        if (!(entity instanceof Mob)) {
            return false;
        }
        return ((Mob)entity).getTarget() != null;
    }

    private static final boolean handleOnceDamage$lambda$9$lambda$6(LivingEntity $attacker, LivingEntity it) {
        return !Intrinsics.areEqual((Object)it.getUUID(), (Object)((Mob)$attacker).getUUID());
    }

    private static final boolean handleOnceDamage$lambda$9$lambda$7(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final void handleOnceDamage$lambda$9(Vec3 $spawnPos, LivingEntity $attacker, Vec3 $targetPos, Vec3 $dir, BookSwordSlashSkill this$0) {
        void $this$forEach$iv;
        LineEmitters lineEmitters;
        Intrinsics.checkNotNull((Object)$spawnPos);
        Object $this$handleOnceDamage_u24lambda_u249_u24lambda_u245 = lineEmitters = new LineEmitters($spawnPos, $attacker.level());
        boolean bl = false;
        ControlableParticleData controlableParticleData = $this$handleOnceDamage_u24lambda_u249_u24lambda_u245.getTemplateData();
        ControlableParticleData $this$handleOnceDamage_u24lambda_u249_u24lambda_u245_u24lambda_u244 = controlableParticleData;
        boolean bl2 = false;
        UUID uUID = $this$handleOnceDamage_u24lambda_u249_u24lambda_u245_u24lambda_u244.getUuid();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"<get-uuid>(...)");
        $this$handleOnceDamage_u24lambda_u249_u24lambda_u245_u24lambda_u244.setEffect((ControlableParticleEffect)new ControlableCloudEffect(uUID, false, 2, null));
        $this$handleOnceDamage_u24lambda_u249_u24lambda_u245_u24lambda_u244.setColor(Math3DUtil.INSTANCE.colorOf(255, 150, 80));
        $this$handleOnceDamage_u24lambda_u249_u24lambda_u245_u24lambda_u244.setMaxAge(20);
        $this$handleOnceDamage_u24lambda_u249_u24lambda_u245.setMaxTick(1);
        Vec3 vec3 = $dir.scale(2.0);
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"scale(...)");
        $this$handleOnceDamage_u24lambda_u249_u24lambda_u245.setEndPos(vec3);
        $this$handleOnceDamage_u24lambda_u249_u24lambda_u245.setCount((int)($dir.length() * (double)3));
        LineEmitters emitter = lineEmitters;
        Level world = $attacker.level();
        world.playSound(null, ((Mob)$attacker).getX(), ((Mob)$attacker).getY(), ((Mob)$attacker).getZ(), SoundEvents.PLAYER_ATTACK_SWEEP, SoundSource.HOSTILE, 10.0f, 2.0f);
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitter);
        List list = world.getEntitiesOfClass(LivingEntity.class, AABB.ofSize((Vec3)$targetPos, (double)4.0, (double)4.0, (double)4.0), arg_0 -> BookSwordSlashSkill.handleOnceDamage$lambda$9$lambda$7(arg_0 -> BookSwordSlashSkill.handleOnceDamage$lambda$9$lambda$6($attacker, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
        $this$handleOnceDamage_u24lambda_u249_u24lambda_u245 = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            LivingEntity it = (LivingEntity)element$iv;
            boolean bl3 = false;
            DamageSource source = it.damageSources().mobAttack($attacker);
            it.hurt(source, this$0.damage);
            it.invulnerableTime = 0;
        }
    }
}

