/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.entity.custom.skills;

import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.usefulmagic.particles.emitters.ExplodeMagicEmitters;
import cn.coostack.usefulmagic.particles.emitters.LightningParticleEmitters;
import cn.coostack.usefulmagic.skill.api.Skill;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.random.Random;
import kotlin.random.RandomKt;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\rH\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\f\u001a\u00020\rH\u0016J\u0018\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0010H\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u001a\u0010\u0004\u001a\u00020\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/coostack/usefulmagic/entity/custom/skills/LightningShootSkill;", "Lcn/coostack/usefulmagic/skill/api/Skill;", "<init>", "()V", "chance", "", "getChance", "()D", "setChance", "(D)V", "onActive", "", "source", "Lnet/minecraft/world/entity/LivingEntity;", "onRelease", "holdingTick", "", "handleMultipleDamage", "random", "Lkotlin/random/Random;", "handleSingleDamage", "target", "getMaxHoldingTick", "holdingEntity", "getSkillCountDown", "holdTicks", "stopHolding", "entity", "getSkillID", "", "usefulmagic-neoforge-1.21.1"})
public final class LightningShootSkill
implements Skill {
    private double chance = 1.0;
    @NotNull
    private final Random random = RandomKt.Random((long)System.currentTimeMillis());

    @Override
    public double getChance() {
        return this.chance;
    }

    @Override
    public void setChance(double d) {
        this.chance = d;
    }

    @Override
    public void onActive(@NotNull LivingEntity source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
    }

    @Override
    public void onRelease(@NotNull LivingEntity source, int holdingTick) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        if (!(source instanceof Mob)) {
            this.handleMultipleDamage(source);
            return;
        }
        LivingEntity livingEntity = ((Mob)source).getTarget();
        if (livingEntity == null) {
            LightningShootSkill it = this;
            boolean bl = false;
            this.handleMultipleDamage(source);
            return;
        }
        LivingEntity target = livingEntity;
        this.handleSingleDamage(source, target);
    }

    private final void handleMultipleDamage(LivingEntity source) {
        Level world = source.level();
        world.explode((Entity)source, source.getX(), source.getY(), source.getZ(), 10.0f, false, Level.ExplosionInteraction.MOB);
    }

    private final void handleSingleDamage(LivingEntity source, LivingEntity target) {
        ControlableParticleData controlableParticleData;
        LightningParticleEmitters lightningParticleEmitters;
        Vec3 vec3 = source.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"getEyePosition(...)");
        Vec3 vec32 = target.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"getEyePosition(...)");
        Vec3 dir = Vec3ExtendsKt.relativize((Vec3)vec3, (Vec3)vec32).normalize().scale(4.5);
        Vec3 vec33 = source.getEyePosition().add(this.random.nextDouble(-1.0, 1.0), this.random.nextDouble(-1.0, 1.0), this.random.nextDouble(-1.0, 1.0));
        Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"add(...)");
        LightningParticleEmitters $this$handleSingleDamage_u24lambda_u242 = lightningParticleEmitters = new LightningParticleEmitters(vec33, source.level());
        boolean bl = false;
        Vec3 vec34 = source.getEyePosition();
        Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"getEyePosition(...)");
        Vec3 vec35 = target.getEyePosition().add(dir);
        Intrinsics.checkNotNullExpressionValue((Object)vec35, (String)"add(...)");
        $this$handleSingleDamage_u24lambda_u242.setEndPos(RelativeLocation.Companion.of(Vec3ExtendsKt.relativize((Vec3)vec34, (Vec3)vec35)));
        $this$handleSingleDamage_u24lambda_u242.setMaxTick($this$handleSingleDamage_u24lambda_u242.getRandom().nextInt(1, 6));
        ControlableParticleData it = controlableParticleData = $this$handleSingleDamage_u24lambda_u242.getTemplateData();
        boolean bl2 = false;
        it.setMaxAge(5);
        it.setColor(Math3DUtil.INSTANCE.colorOf(121, 211, 249));
        LightningParticleEmitters lightning = lightningParticleEmitters;
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)lightning);
        DamageSource damageSource = source.damageSources().mobAttack(source);
        target.hurt(damageSource, 20.0f);
    }

    @Override
    public int getMaxHoldingTick(@NotNull LivingEntity holdingEntity) {
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
        return 60;
    }

    @Override
    public int getSkillCountDown(@NotNull LivingEntity source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        return 120;
    }

    @Override
    public void holdingTick(@NotNull LivingEntity holdingEntity, int holdTicks) {
        LightningParticleEmitters lightningParticleEmitters;
        Intrinsics.checkNotNullParameter((Object)holdingEntity, (String)"holdingEntity");
        Vec3 vec3 = holdingEntity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        LightningParticleEmitters $this$holdingTick_u24lambda_u243 = lightningParticleEmitters = new LightningParticleEmitters(vec3, holdingEntity.level());
        boolean bl = false;
        $this$holdingTick_u24lambda_u243.setEndPos(new RelativeLocation($this$holdingTick_u24lambda_u243.getRandom().nextDouble(-20.0, 20.0), $this$holdingTick_u24lambda_u243.getRandom().nextDouble(0.0, 20.0), $this$holdingTick_u24lambda_u243.getRandom().nextDouble(-20.0, 20.0)));
        $this$holdingTick_u24lambda_u243.setMaxTick($this$holdingTick_u24lambda_u243.getRandom().nextInt(1, 2));
        LightningParticleEmitters emitters = lightningParticleEmitters;
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitters);
    }

    @Override
    public void stopHolding(@NotNull LivingEntity entity, int holdTicks) {
        ExplodeMagicEmitters explodeMagicEmitters;
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Vec3 vec3 = entity.position();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position(...)");
        ExplodeMagicEmitters $this$stopHolding_u24lambda_u244 = explodeMagicEmitters = new ExplodeMagicEmitters(vec3, entity.level());
        boolean bl = false;
        $this$stopHolding_u24lambda_u244.setMaxTick(1);
        $this$stopHolding_u24lambda_u244.setMinSpeed(1.0);
        $this$stopHolding_u24lambda_u244.setMaxSpeed(5.0);
        $this$stopHolding_u24lambda_u244.setBallCountPow(20);
        $this$stopHolding_u24lambda_u244.setRandomCountMin(100);
        $this$stopHolding_u24lambda_u244.setRandomCountMax(200);
        $this$stopHolding_u24lambda_u244.setPrecentDrag(0.9);
        $this$stopHolding_u24lambda_u244.setRandomParticleAgeMin(30);
        $this$stopHolding_u24lambda_u244.setRandomParticleAgeMax(80);
        ExplodeMagicEmitters explode = explodeMagicEmitters;
        ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)explode);
    }

    @Override
    @NotNull
    public String getSkillID() {
        return "lightning-shoot";
    }
}

