/*
 * Decompiled with CFR 0.152.
 */
package cn.coostack.usefulmagic.formation;

import cn.coostack.cooparticlesapi.barrages.Barrage;
import cn.coostack.cooparticlesapi.barrages.BarrageManager;
import cn.coostack.cooparticlesapi.extend.BlockPosExtendsKt;
import cn.coostack.cooparticlesapi.extend.Vec3ExtendsKt;
import cn.coostack.cooparticlesapi.network.particle.emitters.ControlableParticleData;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmitters;
import cn.coostack.cooparticlesapi.network.particle.emitters.ParticleEmittersManager;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleGroupStyle;
import cn.coostack.cooparticlesapi.network.particle.style.ParticleStyleManager;
import cn.coostack.cooparticlesapi.particles.ControlableParticleEffect;
import cn.coostack.cooparticlesapi.particles.impl.ControlableCloudEffect;
import cn.coostack.cooparticlesapi.platform.CooParticlesServices;
import cn.coostack.cooparticlesapi.renderer.RenderEntity;
import cn.coostack.cooparticlesapi.renderer.server.ServerRenderEntityManager;
import cn.coostack.cooparticlesapi.utils.Math3DUtil;
import cn.coostack.cooparticlesapi.utils.RelativeLocation;
import cn.coostack.usefulmagic.UsefulMagic;
import cn.coostack.usefulmagic.beans.MagicPlayerData;
import cn.coostack.usefulmagic.blocks.entity.formation.EnergyCrystalsBlockEntity;
import cn.coostack.usefulmagic.blocks.entity.formation.RecoverCrystalBlockEntity;
import cn.coostack.usefulmagic.entity.custom.formation.FormationCoreEntity;
import cn.coostack.usefulmagic.formation.api.AttackCrystal;
import cn.coostack.usefulmagic.formation.api.BlockFormation;
import cn.coostack.usefulmagic.formation.api.DefendCrystal;
import cn.coostack.usefulmagic.formation.api.FormationCrystal;
import cn.coostack.usefulmagic.formation.api.FormationScale;
import cn.coostack.usefulmagic.formation.api.FormationSettings;
import cn.coostack.usefulmagic.formation.api.FormationTargetOption;
import cn.coostack.usefulmagic.formation.target.BarrageTargetOption;
import cn.coostack.usefulmagic.formation.target.LivingEntityTargetOption;
import cn.coostack.usefulmagic.formation.target.MeteoriteEntityTargetOption;
import cn.coostack.usefulmagic.formation.target.ProjectileEntityTargetOption;
import cn.coostack.usefulmagic.managers.server.ServerFormationManager;
import cn.coostack.usefulmagic.meteorite.Meteorite;
import cn.coostack.usefulmagic.meteorite.MeteoriteFallingBlockEntity;
import cn.coostack.usefulmagic.meteorite.MeteoriteManager;
import cn.coostack.usefulmagic.packet.s2c.PacketS2CFormationBreak;
import cn.coostack.usefulmagic.packet.s2c.PacketS2CFormationCreate;
import cn.coostack.usefulmagic.particles.barrages.api.DamagedBarrage;
import cn.coostack.usefulmagic.particles.emitters.CircleEmitters;
import cn.coostack.usefulmagic.particles.emitters.LightningParticleEmitters;
import cn.coostack.usefulmagic.particles.style.formation.FormationStyle;
import cn.coostack.usefulmagic.particles.style.formation.LargeFormationStyle;
import cn.coostack.usefulmagic.particles.style.formation.MidFormationStyle;
import cn.coostack.usefulmagic.particles.style.formation.SmallFormationStyle;
import cn.coostack.usefulmagic.renderer.DefendCrystalRenderEntity;
import cn.coostack.usefulmagic.states.ManaServerState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.math.MathKt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractFish;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u000e\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u000e\n\u0002\u0010\b\n\u0002\b\u0015\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020A2\b\u0010M\u001a\u0004\u0018\u00010NH\u0016J\u0018\u0010U\u001a\u0002022\u000e\u0010V\u001a\n\u0012\u0006\b\u0001\u0012\u00020,0WH\u0016J\b\u0010X\u001a\u00020YH\u0016J\b\u0010Z\u001a\u00020PH\u0016J\u0010\u0010[\u001a\u0002022\u0006\u0010\\\u001a\u00020NH\u0016J\b\u0010]\u001a\u000202H\u0016J\b\u0010^\u001a\u000202H\u0016J\u0010\u0010]\u001a\u0002022\u0006\u0010O\u001a\u00020PH\u0002J\b\u0010_\u001a\u000202H\u0016J\b\u0010`\u001a\u00020\u0017H\u0016J\b\u0010a\u001a\u000202H\u0016J\u0006\u0010b\u001a\u00020KJ\b\u0010c\u001a\u00020KH\u0002J\b\u0010d\u001a\u00020KH\u0002J\b\u0010e\u001a\u00020KH\u0002J\b\u0010f\u001a\u00020KH\u0002J\b\u0010s\u001a\u00020KH\u0016J\u0018\u0010t\u001a\u0002022\u0006\u0010u\u001a\u00020,2\u0006\u0010v\u001a\u00020hH\u0016J\"\u0010w\u001a\u0002022\u0006\u0010L\u001a\u00020A2\b\u0010x\u001a\u0004\u0018\u00010N2\u0006\u0010y\u001a\u00020\u0007H\u0016J\u001e\u0010{\u001a\u00020K2\u0006\u0010|\u001a\u00020,2\f\u0010}\u001a\b\u0012\u0004\u0012\u00020\u007f0~H\u0002J\u0011\u0010\u0080\u0001\u001a\u0002022\u0006\u0010v\u001a\u00020hH\u0016J\t\u0010\u0081\u0001\u001a\u00020KH\u0002J\t\u0010\u0082\u0001\u001a\u000202H\u0002R\u001c\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0006\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\"\u0010\u0018\u001a\u0004\u0018\u00010\u00172\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R$\u0010'\u001a\u00020\u00052\u0006\u0010\u0016\u001a\u00020\u0005@PX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b(\u0010\u000f\"\u0004\b)\u0010\u0011R \u0010*\u001a\b\u0012\u0004\u0012\u00020,0+X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010.\"\u0004\b/\u00100R\u001a\u00101\u001a\u000202X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b3\u00104\"\u0004\b5\u00106R\u001a\u00107\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00104\"\u0004\b9\u00106R\u001a\u0010:\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b;\u00104\"\u0004\b<\u00106R\u001a\u0010=\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u00104\"\u0004\b?\u00106R\u001a\u0010@\u001a\u00020AX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bB\u0010C\"\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020G\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010IR\u001a\u0010O\u001a\u00020PX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bQ\u0010R\"\u0004\bS\u0010TR\u001a\u0010g\u001a\u00020hX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bi\u0010j\"\u0004\bk\u0010lR\u001a\u0010m\u001a\u000202X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bn\u00104\"\u0004\bo\u00106R\u001a\u0010p\u001a\u00020hX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\bq\u0010j\"\u0004\br\u0010lR\u000e\u0010z\u001a\u00020hX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0083\u0001"}, d2={"Lcn/coostack/usefulmagic/formation/CrystalFormation;", "Lcn/coostack/usefulmagic/formation/api/BlockFormation;", "world", "Lnet/minecraft/world/level/Level;", "owner", "Ljava/util/UUID;", "formationCore", "Lnet/minecraft/world/phys/Vec3;", "<init>", "(Lnet/minecraft/world/level/Level;Ljava/util/UUID;Lnet/minecraft/world/phys/Vec3;)V", "getWorld", "()Lnet/minecraft/world/level/Level;", "setWorld", "(Lnet/minecraft/world/level/Level;)V", "getOwner", "()Ljava/util/UUID;", "setOwner", "(Ljava/util/UUID;)V", "getFormationCore", "()Lnet/minecraft/world/phys/Vec3;", "setFormationCore", "(Lnet/minecraft/world/phys/Vec3;)V", "value", "Lcn/coostack/usefulmagic/entity/custom/formation/FormationCoreEntity;", "bindEntity", "getBindEntity", "()Lcn/coostack/usefulmagic/entity/custom/formation/FormationCoreEntity;", "style", "Lcn/coostack/usefulmagic/particles/style/formation/FormationStyle;", "getStyle", "()Lcn/coostack/usefulmagic/particles/style/formation/FormationStyle;", "setStyle", "(Lcn/coostack/usefulmagic/particles/style/formation/FormationStyle;)V", "defendEntity", "Lcn/coostack/usefulmagic/renderer/DefendCrystalRenderEntity;", "getDefendEntity", "()Lcn/coostack/usefulmagic/renderer/DefendCrystalRenderEntity;", "setDefendEntity", "(Lcn/coostack/usefulmagic/renderer/DefendCrystalRenderEntity;)V", "uuid", "getUuid", "setUuid$usefulmagic_neoforge_1_21_1", "activeCrystals", "", "Lcn/coostack/usefulmagic/formation/api/FormationCrystal;", "getActiveCrystals", "()Ljava/util/List;", "setActiveCrystals", "(Ljava/util/List;)V", "active", "", "getActive$usefulmagic_neoforge_1_21_1", "()Z", "setActive$usefulmagic_neoforge_1_21_1", "(Z)V", "hasDefend", "getHasDefend", "setHasDefend", "hasAttack", "getHasAttack", "setHasAttack", "hasRecover", "getHasRecover", "setHasRecover", "formationHealth", "", "getFormationHealth", "()F", "setFormationHealth", "(F)V", "settings", "Lcn/coostack/usefulmagic/formation/api/FormationSettings;", "getSettings", "()Lcn/coostack/usefulmagic/formation/api/FormationSettings;", "breakFormation", "", "damage", "attackerOption", "Lcn/coostack/usefulmagic/formation/api/FormationTargetOption;", "scale", "Lcn/coostack/usefulmagic/formation/api/FormationScale;", "getScale", "()Lcn/coostack/usefulmagic/formation/api/FormationScale;", "setScale", "(Lcn/coostack/usefulmagic/formation/api/FormationScale;)V", "hasCrystalType", "type", "Ljava/lang/Class;", "getFormationTriggerRange", "", "getFormationScale", "isFriendly", "option", "canBeFormation", "chunkLoaded", "isActiveFormation", "createFormationEntity", "tryBuildFormation", "onBuild", "createEntityOnBuild", "displayEntityOnBuild", "displayStyleOnBuild", "createStyleOnBuild", "workTime", "", "getWorkTime", "()I", "setWorkTime", "(I)V", "inTriggerRangeActive", "getInTriggerRangeActive", "setInTriggerRangeActive", "triggerTime", "getTriggerTime", "setTriggerTime", "tick", "transformMana", "requestCrystal", "count", "attack", "who", "attackedPos", "displayTime", "displayTransformManaParticle", "request", "responseCrystals", "", "Lcn/coostack/usefulmagic/blocks/entity/formation/EnergyCrystalsBlockEntity;", "hasManaToTransform", "resetFormationHealth", "checkIntact", "usefulmagic-neoforge-1.21.1"})
@SourceDebugExtension(value={"SMAP\nCrystalFormation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CrystalFormation.kt\ncn/coostack/usefulmagic/formation/CrystalFormation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,606:1\n1869#2,2:607\n2756#2:609\n1761#2,3:611\n1563#2:614\n1634#2,3:615\n1740#2,3:618\n1788#2,4:621\n1788#2,4:625\n1869#2,2:629\n1869#2,2:631\n1869#2,2:633\n1869#2:635\n1869#2,2:636\n1870#2:638\n774#2:639\n865#2,2:640\n1869#2:642\n1869#2,2:643\n1870#2:645\n774#2:646\n865#2,2:647\n295#2,2:649\n1869#2,2:651\n774#2:653\n865#2,2:654\n1740#2,3:656\n1#3:610\n*S KotlinDebug\n*F\n+ 1 CrystalFormation.kt\ncn/coostack/usefulmagic/formation/CrystalFormation\n*L\n84#1:607,2\n126#1:609\n145#1:611,3\n203#1:614\n203#1:615,3\n206#1:618,3\n210#1:621,4\n214#1:625,4\n248#1:629,2\n266#1:631,2\n356#1:633,2\n386#1:635\n408#1:636,2\n386#1:638\n417#1:639\n417#1:640,2\n424#1:642\n429#1:643,2\n424#1:645\n495#1:646\n495#1:647,2\n537#1:649,2\n558#1:651,2\n577#1:653\n577#1:654,2\n599#1:656,3\n126#1:610\n*E\n"})
public final class CrystalFormation
implements BlockFormation {
    @Nullable
    private Level world;
    @Nullable
    private UUID owner;
    @NotNull
    private Vec3 formationCore;
    @Nullable
    private FormationCoreEntity bindEntity;
    @Nullable
    private FormationStyle style;
    @Nullable
    private DefendCrystalRenderEntity defendEntity;
    @NotNull
    private UUID uuid;
    @NotNull
    private List<FormationCrystal> activeCrystals;
    private boolean active;
    private boolean hasDefend;
    private boolean hasAttack;
    private boolean hasRecover;
    private float formationHealth;
    @NotNull
    private final FormationSettings settings;
    @NotNull
    private FormationScale scale;
    private int workTime;
    private boolean inTriggerRangeActive;
    private int triggerTime;
    private int displayTime;

    public CrystalFormation(@Nullable Level world, @Nullable UUID owner, @NotNull Vec3 formationCore) {
        Intrinsics.checkNotNullParameter((Object)formationCore, (String)"formationCore");
        this.world = world;
        this.owner = owner;
        this.formationCore = formationCore;
        UUID uUID = UUID.randomUUID();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"randomUUID(...)");
        this.uuid = uUID;
        this.activeCrystals = new ArrayList();
        this.formationHealth = 10.0f;
        this.settings = new FormationSettings();
        this.scale = FormationScale.NONE;
    }

    @Override
    @Nullable
    public Level getWorld() {
        return this.world;
    }

    @Override
    public void setWorld(@Nullable Level level) {
        this.world = level;
    }

    @Override
    @Nullable
    public UUID getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(@Nullable UUID uUID) {
        this.owner = uUID;
    }

    @Override
    @NotNull
    public Vec3 getFormationCore() {
        return this.formationCore;
    }

    @Override
    public void setFormationCore(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.formationCore = vec3;
    }

    @Nullable
    public final FormationCoreEntity getBindEntity() {
        return this.bindEntity;
    }

    @Nullable
    public final FormationStyle getStyle() {
        return this.style;
    }

    public final void setStyle(@Nullable FormationStyle formationStyle) {
        this.style = formationStyle;
    }

    @Nullable
    public final DefendCrystalRenderEntity getDefendEntity() {
        return this.defendEntity;
    }

    public final void setDefendEntity(@Nullable DefendCrystalRenderEntity defendCrystalRenderEntity) {
        this.defendEntity = defendCrystalRenderEntity;
    }

    @Override
    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid$usefulmagic_neoforge_1_21_1(@NotNull UUID uUID) {
        Intrinsics.checkNotNullParameter((Object)uUID, (String)"<set-?>");
        this.uuid = uUID;
    }

    @Override
    @NotNull
    public List<FormationCrystal> getActiveCrystals() {
        return this.activeCrystals;
    }

    @Override
    public void setActiveCrystals(@NotNull List<FormationCrystal> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.activeCrystals = list;
    }

    public final boolean getActive$usefulmagic_neoforge_1_21_1() {
        return this.active;
    }

    public final void setActive$usefulmagic_neoforge_1_21_1(boolean bl) {
        this.active = bl;
    }

    public final boolean getHasDefend() {
        return this.hasDefend;
    }

    public final void setHasDefend(boolean bl) {
        this.hasDefend = bl;
    }

    public final boolean getHasAttack() {
        return this.hasAttack;
    }

    public final void setHasAttack(boolean bl) {
        this.hasAttack = bl;
    }

    public final boolean getHasRecover() {
        return this.hasRecover;
    }

    public final void setHasRecover(boolean bl) {
        this.hasRecover = bl;
    }

    public final float getFormationHealth() {
        return this.formationHealth;
    }

    public final void setFormationHealth(float f) {
        this.formationHealth = f;
    }

    @NotNull
    public final FormationSettings getSettings() {
        return this.settings;
    }

    @Override
    public void breakFormation(float damage, @Nullable FormationTargetOption attackerOption) {
        if (!this.active) {
            return;
        }
        this.formationHealth -= damage;
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (level.isClientSide) {
            return;
        }
        PacketS2CFormationBreak breakPacket = new PacketS2CFormationBreak(BlockPosExtendsKt.ofFloored((Vec3)this.getFormationCore()), damage);
        Level level2 = this.getWorld();
        Intrinsics.checkNotNull((Object)level2);
        List list = level2.players();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Player it = (Player)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
            ServerPlayer cfr_ignored_0 = (ServerPlayer)it;
            CooParticlesServices.SERVER_NETWORK.send((CustomPacketPayload)breakPacket, (ServerPlayer)it);
        }
        FormationTargetOption formationTargetOption = attackerOption;
        if (formationTargetOption != null) {
            ControlableParticleData controlableParticleData;
            CircleEmitters emitters;
            CircleEmitters circleEmitters;
            FormationTargetOption it = formationTargetOption;
            boolean bl = false;
            Vec3 pos = attackerOption.pos();
            Vec3 dir = Vec3ExtendsKt.relativize((Vec3)this.getFormationCore(), (Vec3)pos);
            CircleEmitters $this$breakFormation_u24lambda_u243_u24lambda_u242 = circleEmitters = (emitters = new CircleEmitters(pos, this.getWorld()));
            boolean bl2 = false;
            $this$breakFormation_u24lambda_u243_u24lambda_u242.setMaxTick(1);
            ControlableParticleData it2 = controlableParticleData = $this$breakFormation_u24lambda_u243_u24lambda_u242.getTemplateData();
            boolean bl3 = false;
            it2.setEffect((ControlableParticleEffect)new ControlableCloudEffect($this$breakFormation_u24lambda_u243_u24lambda_u242.getUuid(), false, 2, null));
            it2.setSize(0.1f);
            it2.setColor(Math3DUtil.INSTANCE.colorOf(147, 242, 255));
            $this$breakFormation_u24lambda_u243_u24lambda_u242.setCircleSpeed(0.8);
            $this$breakFormation_u24lambda_u243_u24lambda_u242.setPrecentDrag(0.6);
            $this$breakFormation_u24lambda_u243_u24lambda_u242.setCircleDirection(dir);
            ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)emitters);
        }
        Level level3 = this.getWorld();
        Intrinsics.checkNotNull((Object)level3);
        level3.playSound(null, this.getFormationCore().x, this.getFormationCore().y, this.getFormationCore().z, SoundEvents.ZOMBIE_BREAK_WOODEN_DOOR, SoundSource.BLOCKS, 10.0f, 1.0f);
        if (this.formationHealth <= 0.0f) {
            Iterable iterable;
            Level level4 = this.getWorld();
            Intrinsics.checkNotNull((Object)level4);
            level4.playSound(null, this.getFormationCore().x, this.getFormationCore().y, this.getFormationCore().z, SoundEvents.BEACON_DEACTIVATE, SoundSource.BLOCKS, 10.0f, 1.0f);
            DefendCrystalRenderEntity defendCrystalRenderEntity = this.defendEntity;
            if (defendCrystalRenderEntity != null) {
                defendCrystalRenderEntity.over();
            }
            this.defendEntity = null;
            this.scale = FormationScale.NONE;
            this.setOwner(null);
            this.active = false;
            Iterable $this$onEach$iv = this.getActiveCrystals();
            boolean $i$f$onEach = false;
            Iterable $this$onEach_u24lambda_u2418$iv = iterable = $this$onEach$iv;
            boolean bl = false;
            for (Object element$iv : $this$onEach_u24lambda_u2418$iv) {
                FormationCrystal it = (FormationCrystal)element$iv;
                boolean bl4 = false;
                it.setActiveFormation(null);
            }
            ((List)iterable).clear();
            this.formationHealth = 10.0f;
            this.inTriggerRangeActive = false;
            this.triggerTime = 0;
        }
    }

    @NotNull
    public final FormationScale getScale() {
        return this.scale;
    }

    public final void setScale(@NotNull FormationScale formationScale) {
        Intrinsics.checkNotNullParameter((Object)((Object)formationScale), (String)"<set-?>");
        this.scale = formationScale;
    }

    @Override
    public boolean hasCrystalType(@NotNull Class<? extends FormationCrystal> type) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter(type, (String)"type");
            if (DefendCrystal.class.isAssignableFrom(type)) {
                return this.hasDefend;
            }
            if (AttackCrystal.class.isAssignableFrom(type)) {
                return this.hasAttack;
            }
            if (RecoverCrystalBlockEntity.class.isAssignableFrom(type)) {
                return this.hasRecover;
            }
            Iterable $this$any$iv = this.getActiveCrystals();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    FormationCrystal it = (FormationCrystal)element$iv;
                    boolean bl2 = false;
                    if (!type.isAssignableFrom(it.getClass())) continue;
                    bl = true;
                    break block6;
                }
                bl = false;
            }
        }
        return bl;
    }

    @Override
    public double getFormationTriggerRange() {
        return switch (WhenMappings.$EnumSwitchMapping$0[this.scale.ordinal()]) {
            case 1 -> 0.0;
            case 2 -> 16.0;
            case 3 -> 32.0;
            case 4 -> 64.0;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @Override
    @NotNull
    public FormationScale getFormationScale() {
        return this.scale;
    }

    @Override
    public boolean isFriendly(@NotNull FormationTargetOption option) {
        Intrinsics.checkNotNullParameter((Object)option, (String)"option");
        UUID optionOwnerUUID = option.getOwnerUUID();
        if (this.getOwner() == null) {
            return optionOwnerUUID == null;
        }
        if (optionOwnerUUID == null) {
            return false;
        }
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (level.isClientSide) {
            return true;
        }
        ManaServerState manaServerState = UsefulMagic.INSTANCE.getState();
        UUID uUID = this.getOwner();
        Intrinsics.checkNotNull((Object)uUID);
        MagicPlayerData data = manaServerState.getDataFromServer(uUID);
        if (option instanceof LivingEntityTargetOption) {
            boolean animal;
            LivingEntity target = ((LivingEntityTargetOption)option).getTarget();
            boolean hostile = target instanceof Monster;
            if (hostile && !this.settings.getHostileEntityAttack()) {
                return true;
            }
            boolean bl = animal = target instanceof Animal || target instanceof AbstractFish;
            if (animal && !this.settings.getAnimalEntityAttack()) {
                return true;
            }
            if (target instanceof Player && !this.settings.getPlayerEntityAttack()) {
                return true;
            }
            if (!(animal || hostile || this.settings.getAnotherEntityAttack() || target instanceof Player)) {
                return true;
            }
            if (target instanceof Player && (((Player)target).isSpectator() || ((Player)target).isCreative())) {
                return true;
            }
        }
        return data.isFriend(optionOwnerUUID);
    }

    @Override
    public boolean canBeFormation() {
        return this.canBeFormation(FormationScale.SMALL);
    }

    @Override
    public boolean chunkLoaded() {
        Level level = this.getWorld();
        if (level == null) {
            return false;
        }
        Level level2 = level;
        BlockPos blockPos = BlockPosExtendsKt.ofFloored((Vec3)this.getFormationCore());
        return level2.hasChunk(blockPos.getX(), blockPos.getZ());
    }

    /*
     * WARNING - void declaration
     */
    private final boolean canBeFormation(FormationScale scale) {
        int n;
        int n2;
        boolean bl;
        List structure;
        BlockEntity it;
        block11: {
            void $this$mapTo$iv$iv;
            if (this.getWorld() == null) {
                return false;
            }
            Iterable $this$map$iv = scale.getStructure();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                BlockPos blockPos = (BlockPos)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Level level = this.getWorld();
                Intrinsics.checkNotNull((Object)level);
                collection.add(level.getBlockEntity(it.offset((Vec3i)BlockPosExtendsKt.ofFloored((Vec3)this.getFormationCore()))));
            }
            structure = (List)destination$iv$iv;
            Iterable $this$all$iv = structure;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BlockEntity it2 = (BlockEntity)element$iv;
                    boolean bl3 = false;
                    if (it2 instanceof FormationCrystal) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        boolean allCrystal = bl;
        Iterable $this$count$iv = structure;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n2 = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                it = (BlockEntity)element$iv;
                boolean bl4 = false;
                if (!(it instanceof AttackCrystal || it instanceof DefendCrystal) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n2 = count$iv;
        }
        boolean hasSpecialCrystal = n2 > 0;
        Iterable $this$count$iv2 = structure;
        boolean $i$f$count2 = false;
        if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv2) {
                BlockEntity it3 = (BlockEntity)element$iv;
                boolean bl5 = false;
                if (!(it3 instanceof EnergyCrystalsBlockEntity) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        boolean hasEnergyCrystal = n > 0;
        return allCrystal && hasEnergyCrystal && hasSpecialCrystal;
    }

    @Override
    public boolean isActiveFormation() {
        return this.active && this.formationHealth > 0.0f;
    }

    @Override
    @NotNull
    public FormationCoreEntity createFormationEntity() {
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        FormationCoreEntity entity = new FormationCoreEntity(level);
        entity.setCore(BlockPosExtendsKt.ofFloored((Vec3)this.getFormationCore()));
        Level level2 = this.getWorld();
        Intrinsics.checkNotNull((Object)level2);
        level2.addFreshEntity((Entity)entity);
        return entity;
    }

    @Override
    public boolean tryBuildFormation() {
        if (this.getWorld() == null) {
            return false;
        }
        if (!this.canBeFormation() || this.isActiveFormation()) {
            return false;
        }
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (!level.isClientSide) {
            Vec3 vec3 = this.getFormationCore();
            Level level2 = this.getWorld();
            Intrinsics.checkNotNull((Object)level2, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
            if (ServerFormationManager.INSTANCE.checkPosInFormationRange(vec3, (ServerLevel)level2)) {
                return false;
            }
            PacketS2CFormationCreate packet = new PacketS2CFormationCreate(BlockPosExtendsKt.ofFloored((Vec3)this.getFormationCore()));
            Level level3 = this.getWorld();
            Intrinsics.checkNotNull((Object)level3);
            List list = level3.players();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"players(...)");
            Iterable $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                Player it = (Player)element$iv;
                boolean bl = false;
                CustomPacketPayload customPacketPayload = packet;
                Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerPlayer");
                CooParticlesServices.SERVER_NETWORK.send(customPacketPayload, (ServerPlayer)it);
            }
        }
        FormationScale[] $i$f$forEach = new FormationScale[]{FormationScale.SMALL, FormationScale.MID, FormationScale.LARGE};
        Iterator iterator = CollectionsKt.arrayListOf((Object[])$i$f$forEach).iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator stack = iterator;
        FormationScale updateScale = this.scale;
        if (this.scale == FormationScale.NONE) {
            while (stack.hasNext()) {
                Object e = stack.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                FormationScale current = (FormationScale)((Object)e);
                boolean canBeFormation = this.canBeFormation(current);
                if (!canBeFormation) break;
                updateScale = current;
            }
            this.scale = updateScale;
        }
        this.resetFormationHealth();
        Iterable $this$forEach$iv = updateScale.getStructure();
        boolean $i$f$forEach2 = false;
        for (Object element$iv : $this$forEach$iv) {
            BlockPos it = (BlockPos)element$iv;
            boolean bl = false;
            Level level4 = this.getWorld();
            Intrinsics.checkNotNull((Object)level4);
            BlockEntity blockEntity = level4.getBlockEntity(it.offset((Vec3i)BlockPosExtendsKt.ofFloored((Vec3)this.getFormationCore())));
            FormationCrystal entity = blockEntity instanceof FormationCrystal ? (FormationCrystal)blockEntity : null;
            if (entity == null) {
                return false;
            }
            entity.onFormationActive(this);
            this.getActiveCrystals().add(entity);
            if (entity instanceof AttackCrystal) {
                this.hasAttack = true;
            }
            if (entity instanceof DefendCrystal) {
                this.hasDefend = true;
            }
            if (!(entity instanceof RecoverCrystalBlockEntity)) continue;
            this.hasRecover = true;
        }
        this.active = true;
        this.onBuild();
        return true;
    }

    public final void onBuild() {
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (level.isClientSide) {
            return;
        }
        ServerFormationManager.INSTANCE.onFormationActive(this);
        if (!this.settings.getDisplayParticleOnlyTrigger()) {
            Level level2 = this.getWorld();
            Intrinsics.checkNotNull((Object)level2);
            if (!level2.isClientSide) {
                this.createStyleOnBuild();
                this.displayStyleOnBuild();
            }
        }
        if (!this.settings.getDisplayDefendBallOnlyTrigger()) {
            Level level3 = this.getWorld();
            Intrinsics.checkNotNull((Object)level3);
            if (!level3.isClientSide && this.hasDefend) {
                this.createEntityOnBuild();
                this.displayEntityOnBuild();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createEntityOnBuild() {
        void it;
        DefendCrystalRenderEntity defendCrystalRenderEntity;
        DefendCrystalRenderEntity defendCrystalRenderEntity2 = defendCrystalRenderEntity = new DefendCrystalRenderEntity(this.getWorld(), this.getFormationCore(), this.getFormationTriggerRange());
        CrystalFormation crystalFormation = this;
        boolean bl = false;
        it.setFormationPos(this.getFormationCore());
        crystalFormation.defendEntity = defendCrystalRenderEntity;
    }

    private final void displayEntityOnBuild() {
        if (this.defendEntity == null) {
            return;
        }
        DefendCrystalRenderEntity defendCrystalRenderEntity = this.defendEntity;
        Intrinsics.checkNotNull((Object)((Object)defendCrystalRenderEntity));
        ServerRenderEntityManager.INSTANCE.spawn((RenderEntity)defendCrystalRenderEntity);
    }

    private final void displayStyleOnBuild() {
        block0: {
            FormationStyle formationStyle = this.style;
            if (formationStyle == null) break block0;
            FormationStyle it = formationStyle;
            boolean bl = false;
            it.setFormationPos(BlockPosExtendsKt.ofFloored((Vec3)this.getFormationCore()));
            Level level = this.getWorld();
            Intrinsics.checkNotNull((Object)level);
            Vec3 vec3 = this.getFormationCore().add(0.0, -0.4, 0.0);
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"add(...)");
            ParticleStyleManager.INSTANCE.spawnStyle(level, vec3, (ParticleGroupStyle)it);
        }
    }

    private final void createStyleOnBuild() {
        switch (WhenMappings.$EnumSwitchMapping$0[this.scale.ordinal()]) {
            case 2: {
                this.style = new SmallFormationStyle(null, 1, null);
                break;
            }
            case 3: {
                this.style = new MidFormationStyle(null, 1, null);
                break;
            }
            case 4: {
                this.style = new LargeFormationStyle(null, 1, null);
                break;
            }
            case 1: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    public final int getWorkTime() {
        return this.workTime;
    }

    public final void setWorkTime(int n) {
        this.workTime = n;
    }

    public final boolean getInTriggerRangeActive() {
        return this.inTriggerRangeActive;
    }

    public final void setInTriggerRangeActive(boolean bl) {
        this.inTriggerRangeActive = bl;
    }

    public final int getTriggerTime() {
        return this.triggerTime;
    }

    public final void setTriggerTime(int n) {
        this.triggerTime = n;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tick() {
        int n;
        boolean working;
        block36: {
            block37: {
                block35: {
                    block34: {
                        FormationCrystal crystal;
                        FormationTargetOption option;
                        void $this$forEach$iv;
                        Object element$iv2;
                        double range = this.getFormationTriggerRange();
                        if (!this.active) {
                            return;
                        }
                        if (this.getWorld() == null) {
                            return;
                        }
                        Level level = this.getWorld();
                        Intrinsics.checkNotNull((Object)level);
                        boolean isServer = !level.isClientSide;
                        Iterable $this$forEach$iv2 = this.getActiveCrystals();
                        boolean $i$f$forEach = false;
                        for (Object element$iv2 : $this$forEach$iv2) {
                            FormationCrystal p0 = (FormationCrystal)element$iv2;
                            boolean bl = false;
                            p0.tick();
                        }
                        AABB box = AABB.ofSize((Vec3)this.getFormationCore(), (double)(range * (double)2), (double)(range * (double)2), (double)(range * (double)2));
                        working = false;
                        Ref.DoubleRef triggerRange = new Ref.DoubleRef();
                        triggerRange.element = this.settings.getTriggerRange();
                        if (triggerRange.element < 0.0) {
                            triggerRange.element = range;
                        }
                        Level level2 = this.getWorld();
                        Intrinsics.checkNotNull((Object)level2);
                        List list = level2.getEntitiesOfClass(Entity.class, box, arg_0 -> CrystalFormation.tick$lambda$15(arg_0 -> CrystalFormation.tick$lambda$14(this, range, triggerRange, arg_0), arg_0));
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getEntitiesOfClass(...)");
                        element$iv2 = list;
                        boolean $i$f$forEach2 = false;
                        for (Object element$iv3 : $this$forEach$iv) {
                            FormationTargetOption formationTargetOption;
                            Entity it = (Entity)element$iv3;
                            boolean bl = false;
                            this.triggerTime = 120;
                            this.inTriggerRangeActive = true;
                            working = true;
                            option = null;
                            Entity entity = it;
                            if (entity instanceof Projectile) {
                                formationTargetOption = new ProjectileEntityTargetOption((Projectile)it);
                            } else if (entity instanceof LivingEntity) {
                                formationTargetOption = new LivingEntityTargetOption((LivingEntity)it, false, 2, null);
                            } else if (entity instanceof MeteoriteFallingBlockEntity) {
                                Meteorite m;
                                if (!isServer || MeteoriteManager.INSTANCE.getFromSingleEntity((MeteoriteFallingBlockEntity)it) == null) continue;
                                formationTargetOption = new MeteoriteEntityTargetOption(m);
                            } else {
                                formationTargetOption = null;
                            }
                            if ((option = formationTargetOption) == null) continue;
                            Iterable $this$forEach$iv3 = this.getActiveCrystals();
                            boolean $i$f$forEach3 = false;
                            for (Object element$iv4 : $this$forEach$iv3) {
                                crystal = (FormationCrystal)element$iv4;
                                boolean bl2 = false;
                                FormationTargetOption formationTargetOption2 = option;
                                Intrinsics.checkNotNull((Object)formationTargetOption2);
                                if (!formationTargetOption2.isValid()) continue;
                                option = crystal.handle(option);
                            }
                        }
                        if (isServer) {
                            void $this$filterTo$iv$iv;
                            Level level3 = this.getWorld();
                            Intrinsics.checkNotNull((Object)level3, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
                            ServerLevel serverLevel = (ServerLevel)level3;
                            Intrinsics.checkNotNull((Object)box);
                            Iterable $this$filter$iv = BarrageManager.INSTANCE.collectClipBarrages(serverLevel, box);
                            boolean $i$f$filter = false;
                            Iterable bl = $this$filter$iv;
                            Collection destination$iv$iv = new ArrayList();
                            boolean $i$f$filterTo = false;
                            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                                BarrageTargetOption option2;
                                Barrage it = (Barrage)element$iv$iv;
                                boolean bl3 = false;
                                if (!(it.getLoc().distanceTo(this.getFormationCore()) > range ? false : (it.getLoc().distanceTo(this.getFormationCore()) > triggerRange.element && !this.inTriggerRangeActive ? false : !this.isFriendly(option2 = new BarrageTargetOption(it))))) continue;
                                destination$iv$iv.add(element$iv$iv);
                            }
                            $this$filter$iv = (List)destination$iv$iv;
                            $i$f$forEach2 = false;
                            for (Object element$iv3 : $this$forEach$iv) {
                                Barrage it = (Barrage)element$iv3;
                                boolean bl4 = false;
                                working = true;
                                this.triggerTime = 120;
                                this.inTriggerRangeActive = true;
                                option = null;
                                option = new BarrageTargetOption(it);
                                Iterable $this$forEach$iv4 = this.getActiveCrystals();
                                boolean $i$f$forEach4 = false;
                                for (Object element$iv4 : $this$forEach$iv4) {
                                    crystal = (FormationCrystal)element$iv4;
                                    boolean bl5 = false;
                                    if (!option.isValid()) continue;
                                    option = crystal.handle(option);
                                }
                                boolean barrageStillAlive = option.isValid() && option.pos().distanceTo(this.getFormationCore()) <= 4.0 && option instanceof BarrageTargetOption && ((BarrageTargetOption)option).getTarget() instanceof DamagedBarrage;
                                if (!barrageStillAlive) continue;
                                this.attack((float)((DamagedBarrage)((BarrageTargetOption)option).getTarget()).getDamage(), option, ((BarrageTargetOption)option).pos());
                            }
                        }
                        if (!this.checkIntact()) {
                            this.breakFormation(Float.MAX_VALUE, null);
                        }
                        if (!isServer) {
                            return;
                        }
                        n = this.triggerTime;
                        this.triggerTime = n + -1;
                        if (n <= 0) {
                            this.triggerTime = 0;
                            this.inTriggerRangeActive = false;
                        }
                        n = this.displayTime;
                        this.displayTime = n + -1;
                        if (this.style == null) break block34;
                        FormationStyle formationStyle = this.style;
                        if (formationStyle != null ? formationStyle.getValid() : false) break block35;
                    }
                    if (this.inTriggerRangeActive || !this.settings.getDisplayParticleOnlyTrigger()) {
                        this.createStyleOnBuild();
                        this.displayStyleOnBuild();
                    }
                }
                if (!this.hasDefend) break block36;
                if (this.defendEntity == null) break block37;
                DefendCrystalRenderEntity defendCrystalRenderEntity = this.defendEntity;
                if (!(defendCrystalRenderEntity != null ? defendCrystalRenderEntity.getOver() : true)) break block36;
            }
            if (this.inTriggerRangeActive || !this.settings.getDisplayDefendBallOnlyTrigger()) {
                this.createEntityOnBuild();
                this.displayEntityOnBuild();
            }
        }
        if (this.style == null) {
            return;
        }
        FormationStyle formationStyle = this.style;
        Intrinsics.checkNotNull((Object)((Object)formationStyle));
        if (!formationStyle.getDisplayed()) {
            return;
        }
        if (working) {
            FormationStyle formationStyle2 = this.style;
            Intrinsics.checkNotNull((Object)((Object)formationStyle2));
            if (formationStyle2.getStatus() != FormationStyle.FormationStatus.WORKING) {
                FormationStyle formationStyle3 = this.style;
                Intrinsics.checkNotNull((Object)((Object)formationStyle3));
                formationStyle3.changeStatus(FormationStyle.FormationStatus.WORKING);
            }
            this.workTime = 60;
        } else {
            n = this.workTime;
            this.workTime = n + -1;
            if (n <= 0) {
                FormationStyle formationStyle4 = this.style;
                Intrinsics.checkNotNull((Object)((Object)formationStyle4));
                if (formationStyle4.getStatus() != FormationStyle.FormationStatus.IDLE) {
                    FormationStyle formationStyle5 = this.style;
                    Intrinsics.checkNotNull((Object)((Object)formationStyle5));
                    formationStyle5.changeStatus(FormationStyle.FormationStatus.IDLE);
                }
                this.workTime = 0;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean transformMana(@NotNull FormationCrystal requestCrystal, int count) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)requestCrystal, (String)"requestCrystal");
        if (this.getWorld() == null) {
            return false;
        }
        Level level = this.getWorld();
        Intrinsics.checkNotNull((Object)level);
        if (level.isClientSide) {
            return false;
        }
        int removed = count;
        Iterable $this$filter$iv = this.getActiveCrystals();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FormationCrystal it = (FormationCrystal)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof EnergyCrystalsBlockEntity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator iterator = ((List)destination$iv$iv).iterator();
        Object e = iterator.next();
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.blocks.entity.formation.EnergyCrystalsBlockEntity");
        EnergyCrystalsBlockEntity current = (EnergyCrystalsBlockEntity)e;
        ArrayList<EnergyCrystalsBlockEntity> response = new ArrayList<EnergyCrystalsBlockEntity>();
        boolean nextBreak = false;
        while (removed > 0) {
            if (current.getCurrentMana() < removed) {
                if (current.getCurrentMana() > 0) {
                    response.add(current);
                }
                removed -= current.getCurrentMana();
                current.decrease(current.getCurrentMana());
                Object e2 = iterator.next();
                Intrinsics.checkNotNull(e2, (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.blocks.entity.formation.EnergyCrystalsBlockEntity");
                current = (EnergyCrystalsBlockEntity)e2;
            } else {
                current.decrease(removed);
                removed = 0;
                response.add(current);
            }
            if (nextBreak) break;
            if (iterator.hasNext()) continue;
            nextBreak = true;
        }
        this.displayTransformManaParticle(requestCrystal, (List<EnergyCrystalsBlockEntity>)response);
        return true;
    }

    @Override
    public boolean attack(float damage, @Nullable FormationTargetOption who, @NotNull Vec3 attackedPos) {
        Object v3;
        block9: {
            Intrinsics.checkNotNullParameter((Object)attackedPos, (String)"attackedPos");
            if (who != null && this.isFriendly(who)) {
                return false;
            }
            if (!this.hasDefend) {
                if (!(who instanceof LivingEntityTargetOption)) {
                    FormationTargetOption formationTargetOption = who;
                    if (formationTargetOption != null) {
                        Level level = this.getWorld();
                        Intrinsics.checkNotNull((Object)level);
                        DamageSource damageSource = level.damageSources().magic();
                        Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"magic(...)");
                        formationTargetOption.damage(damage, damageSource);
                    }
                }
                this.breakFormation(damage, who);
                return true;
            }
            Iterable $this$firstOrNull$iv = this.getActiveCrystals();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                FormationCrystal it = (FormationCrystal)element$iv;
                boolean bl = false;
                if (!(it instanceof DefendCrystal)) continue;
                v3 = element$iv;
                break block9;
            }
            v3 = null;
        }
        FormationCrystal formationCrystal = v3;
        if (formationCrystal == null) {
            return false;
        }
        FormationCrystal defend = formationCrystal;
        int need = MathKt.roundToInt((float)(damage * (float)10));
        boolean hasMana = this.hasManaToTransform(need);
        if (!(who instanceof LivingEntityTargetOption)) {
            FormationTargetOption formationTargetOption = who;
            if (formationTargetOption != null) {
                Level level = this.getWorld();
                Intrinsics.checkNotNull((Object)level);
                DamageSource damageSource = level.damageSources().magic();
                Intrinsics.checkNotNullExpressionValue((Object)damageSource, (String)"magic(...)");
                formationTargetOption.damage(damage, damageSource);
            }
        }
        if (hasMana) {
            this.transformMana(defend, need);
            return true;
        }
        this.breakFormation(damage, who);
        return false;
    }

    private final void displayTransformManaParticle(FormationCrystal request, List<EnergyCrystalsBlockEntity> responseCrystals) {
        this.displayTime = 1;
        Iterable $this$forEach$iv = responseCrystals;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ControlableParticleData controlableParticleData;
            LightningParticleEmitters lightningParticleEmitters;
            EnergyCrystalsBlockEntity it = (EnergyCrystalsBlockEntity)element$iv;
            boolean bl = false;
            Vec3 start = it.getCrystalPos();
            Vec3 end = request.getCrystalPos();
            LightningParticleEmitters $this$displayTransformManaParticle_u24lambda_u2425_u24lambda_u2424 = lightningParticleEmitters = new LightningParticleEmitters(start, this.getWorld());
            boolean bl2 = false;
            $this$displayTransformManaParticle_u24lambda_u2425_u24lambda_u2424.setEndPos(RelativeLocation.Companion.of(Vec3ExtendsKt.relativize((Vec3)start, (Vec3)end)));
            ControlableParticleData it2 = controlableParticleData = $this$displayTransformManaParticle_u24lambda_u2425_u24lambda_u2424.getTemplateData();
            boolean bl3 = false;
            it2.setSpeed(0.0);
            it2.setColor(Math3DUtil.INSTANCE.colorOf(230, 130, 255));
            it2.setMaxAge(3);
            $this$displayTransformManaParticle_u24lambda_u2425_u24lambda_u2424.setMaxTick(1);
            LightningParticleEmitters line = lightningParticleEmitters;
            ParticleEmittersManager.INSTANCE.spawnEmitters((ParticleEmitters)line);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean hasManaToTransform(int count) {
        void $this$filterTo$iv$iv;
        if (this.getWorld() == null) {
            return false;
        }
        Iterable $this$filter$iv = this.getActiveCrystals();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            FormationCrystal it = (FormationCrystal)element$iv$iv;
            boolean bl = false;
            if (!(it instanceof EnergyCrystalsBlockEntity)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable iterable2 = (List)destination$iv$iv;
        int n = 0;
        for (Object e : iterable2) {
            void it;
            FormationCrystal $i$f$filterTo2 = (FormationCrystal)e;
            int n2 = n;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type cn.coostack.usefulmagic.blocks.entity.formation.EnergyCrystalsBlockEntity");
            EnergyCrystalsBlockEntity cfr_ignored_0 = (EnergyCrystalsBlockEntity)it;
            int n3 = ((EnergyCrystalsBlockEntity)it).getCurrentMana();
            n = n2 + n3;
        }
        int currentMana = n;
        return currentMana > count;
    }

    private final void resetFormationHealth() {
        this.formationHealth = switch (WhenMappings.$EnumSwitchMapping$0[this.scale.ordinal()]) {
            case 2 -> 100.0f;
            case 3 -> 500.0f;
            case 4 -> 100.0f;
            case 1 -> 0.0f;
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    private final boolean checkIntact() {
        boolean bl;
        block4: {
            if (this.getWorld() == null) {
                return false;
            }
            List<BlockPos> structure = this.scale.getStructure();
            Iterable $this$all$iv = structure;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    BlockPos it = (BlockPos)element$iv;
                    boolean bl2 = false;
                    Level level = this.getWorld();
                    Intrinsics.checkNotNull((Object)level);
                    BlockEntity entity = level.getBlockEntity(it.offset((Vec3i)BlockPosExtendsKt.ofFloored((Vec3)this.getFormationCore())));
                    if (entity instanceof FormationCrystal) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final boolean tick$lambda$14(CrystalFormation this$0, double $range, Ref.DoubleRef $triggerRange, Entity it) {
        boolean bl;
        if (it.position().distanceTo(this$0.getFormationCore()) > $range) {
            return false;
        }
        if (it.position().distanceTo(this$0.getFormationCore()) > $triggerRange.element && !this$0.inTriggerRangeActive) {
            return false;
        }
        Entity entity = it;
        if (entity instanceof Projectile) {
            bl = !this$0.isFriendly(new ProjectileEntityTargetOption((Projectile)it));
        } else if (entity instanceof LivingEntity) {
            bl = !this$0.isFriendly(new LivingEntityTargetOption((LivingEntity)it, false, 2, null));
        } else if (entity instanceof MeteoriteFallingBlockEntity) {
            Meteorite meteorite = MeteoriteManager.INSTANCE.getFromSingleEntity((MeteoriteFallingBlockEntity)it);
            if (meteorite == null) {
                return false;
            }
            Meteorite m = meteorite;
            bl = !this$0.isFriendly(new MeteoriteEntityTargetOption(m));
        } else {
            bl = false;
        }
        return bl;
    }

    private static final boolean tick$lambda$15(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FormationScale.values().length];
            try {
                nArray[FormationScale.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormationScale.SMALL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormationScale.MID.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FormationScale.LARGE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

